/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.deduction;

import java.util.ArrayList;
import java.util.Collection;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.utils.DeductionUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;

public class DealInputTableTask
implements Runnable {
    private RequestContext rc;
    private String batchNo;

    public DealInputTableTask(RequestContext rc, String batchNo) {
        this.rc = rc;
        this.batchNo = batchNo;
    }

    @Override
    public void run() {
        RequestContext.copyAndSet((RequestContext)this.rc);
        this.doTask();
    }

    private void doTask() {
        int result;
        int pageNo = 1;
        int pageSize = InvoiceDownloadConstant.getPageSizeFromConfig(1000, "input_table_handle_size");
        while ((result = this.handleInputTable(pageNo, pageSize)) >= pageSize) {
            ++pageNo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int handleInputTable(int pageNo, int pageSize) {
        QFilter filter = new QFilter("batch_no", "=", (Object)this.batchNo);
        ORM orm = ORM.create();
        ArrayList ids = Lists.newArrayList();
        try (DataSet ds = null;){
            int from = (pageNo - 1) * pageSize;
            ds = orm.queryDataSet("kd.imc.rim.common.invoice.deduction.DealInputTableTask", "rim_input_table", "id", filter.toArray(), "id", from, pageSize);
            while (ds.hasNext()) {
                Row row = ds.next();
                ids.add(row.getLong("id"));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)ids)) {
            DeductionUtils.handleInputTable(ids.toArray());
        }
        return ids.size();
    }
}

