/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.deduction;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.CollectTypeEnum;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.InvoiceSaveConstant;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.service.InvoiceLog;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DeductionUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.TenantUtils;
import org.apache.commons.lang3.tuple.Pair;

public class DeductionDownService {
    private static final Log LOGGER = LogFactory.getLog(DeductionDownService.class);

    public static Pair<Boolean, String> isUpdateDownInvoice(InvoiceSaveService saveService, Long invoiceType, JSONObject invoice) {
        String invoiceCode = invoice.getString("invoiceCode");
        String invoiceNo = invoice.getString("invoiceNo");
        String etaxInvoiceNo = invoice.getString("etaxInvoiceNo");
        QFilter invoiceTypeFilter = new QFilter("invoice_type", "=", (Object)invoiceType);
        String tenantNo = TenantUtils.getTenantNo();
        QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)tenantNo);
        QFilter invoiceNoFilter = new QFilter("invoice_no", "=", (Object)invoiceNo);
        QFilter invoiceCodeFilter = new QFilter("invoice_code", "=", (Object)StringUtils.trimToEmpty((String)invoiceCode));
        if (StringUtils.isNotEmpty((CharSequence)etaxInvoiceNo) && StringUtils.isEmpty((CharSequence)invoiceCode)) {
            invoiceCodeFilter = null;
            invoiceNoFilter = new QFilter("electronic_no", "=", (Object)etaxInvoiceNo);
        }
        QFilter invoiceDateFilter = null;
        Date invoiceDate = invoice.getDate("invoiceDate");
        if (InputInvoiceTypeEnum.WITHHOLDING.getCode().equals(invoiceType)) {
            if (invoiceDate == null) {
                return Pair.of((Object)Boolean.FALSE, (Object)"");
            }
            invoiceDate = DateUtils.trunc(invoiceDate);
            invoiceDateFilter = new QFilter("invoice_date", ">=", (Object)invoiceDate);
            invoiceDateFilter.and(new QFilter("invoice_date", "<", (Object)DateUtils.addDay(invoiceDate, 1)));
        }
        String entity = InputInvoiceTypeEnum.getEntity(invoiceType);
        DynamicObject serialObject = QueryServiceHelper.queryOne((String)"rim_invoice", (String)"id,serial_no,check_status,collect_type", (QFilter[])new QFilter[]{invoiceCodeFilter, invoiceNoFilter, invoiceTypeFilter, tenantFilter, invoiceDateFilter});
        DeductionUtils.deleteCheckCache(invoice, invoiceType);
        boolean updateFlag = false;
        String serialNo = "";
        JSONObject logInfo = new JSONObject();
        if (serialObject != null) {
            boolean bl = updateFlag = "1".equals(serialObject.getString("check_status")) || (InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceType) || InputInvoiceTypeEnum.WITHHOLDING.getCode().equals(invoiceType)) && CollectTypeEnum.PC_SHUIPAN.getCode().equals(serialObject.getString("collect_type"));
            if (updateFlag) {
                serialNo = serialObject.getString("serial_no");
                invoice.put("serialNo", (Object)serialNo);
                LOGGER.info("\u53d1\u7968:{}-{}-{} \u76f4\u63a5\u66f4\u65b0\u4e3b\u8868", new Object[]{invoiceCode, invoiceNo, etaxInvoiceNo});
                DynamicObject mainDynamicObject = BusinessDataServiceHelper.loadSingle((Object)serialObject.get("id"), (String)"rim_invoice");
                long orgId = DynamicObjectUtil.getDynamicObjectLongValue(mainDynamicObject.get("org"));
                DeductionDownService.setMainInvoiceValue(mainDynamicObject, saveService, invoice, invoiceType, logInfo, orgId);
                try (TXHandle h = TX.required();){
                    try {
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mainDynamicObject});
                        QFilter serialFilter = new QFilter("serial_no", "=", (Object)serialNo);
                        DynamicObject idObject = QueryServiceHelper.queryOne((String)entity, (String)"id,serial_no", (QFilter[])new QFilter[]{tenantFilter, serialFilter});
                        if (idObject != null) {
                            DynamicObject invoiceBody = BusinessDataServiceHelper.loadSingle((Object)idObject.get("id"), (String)entity);
                            DeductionDownService.setInvoiceBodyValue(invoiceBody, mainDynamicObject, saveService, invoice, invoiceType, orgId);
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invoiceBody});
                        }
                        DeductionDownService.saveLog(invoice, logInfo);
                    }
                    catch (Throwable e) {
                        LOGGER.error("\u7a0e\u76d8\u4e0b\u8f7d\u66f4\u65b0\u53d1\u7968\u62a5\u9519", e);
                        h.markRollback();
                        throw e;
                    }
                }
            }
        }
        return Pair.of((Object)updateFlag, (Object)serialNo);
    }

    private static void setMainInvoiceValue(DynamicObject mainDynamicObject, InvoiceSaveService saveService, JSONObject invoice, Long invoiceType, JSONObject logInfo, long orgId) {
        String specialTypeMark;
        if (invoice == null || mainDynamicObject == null || logInfo == null || saveService == null) {
            return;
        }
        mainDynamicObject.set("modifytime", (Object)new Date());
        if (!"inputHeader".equals(invoice.getString("downResource"))) {
            saveService.setDeductionFieldValue(invoiceType, mainDynamicObject, invoice);
            saveService.setDeductionFlag(invoice, mainDynamicObject);
            String billDeductionFlag = InvoiceSaveService.getBillDeductionFlag(mainDynamicObject, CollectTypeEnum.PC_SHUIPAN.getCode());
            if (StringUtils.isEmpty((CharSequence)billDeductionFlag)) {
                if ((InputInvoiceTypeEnum.canSelfproducedAgric(invoiceType) || InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(invoiceType)) && "1".equals(mainDynamicObject.getString("purchase_ticket"))) {
                    boolean isBlue;
                    String invoiceStatus = mainDynamicObject.getString("invoice_status");
                    boolean invoiceStatusFlag = "0".equals(invoiceStatus) || "7".equals(invoiceStatus);
                    boolean bl = isBlue = BigDecimalUtil.transDecimal(mainDynamicObject.get("invoice_amount")).compareTo(BigDecimal.ZERO) >= 0;
                    if (!invoiceStatusFlag || !isBlue) {
                        mainDynamicObject.set(InvoiceSaveConstant.FIELD_DEDUCTION_FLAG, (Object)"0");
                    } else {
                        mainDynamicObject.set(InvoiceSaveConstant.FIELD_DEDUCTION_FLAG, (Object)"1");
                        String authenticateFlag = mainDynamicObject.getString("authenticate_flag");
                        if (StringUtils.isEmpty((CharSequence)authenticateFlag)) {
                            mainDynamicObject.set("authenticate_flag", (Object)"0");
                        }
                    }
                }
                InvoiceSaveService.setExtInfo(mainDynamicObject, InvoiceSaveConstant.EXT_DEDUCTION_FLAG, mainDynamicObject.getString(InvoiceSaveConstant.FIELD_DEDUCTION_FLAG));
            }
            logInfo.put("deductionFlag", (Object)mainDynamicObject.getString(InvoiceSaveConstant.FIELD_DEDUCTION_FLAG));
        }
        String invoiceStatus = invoice.getString("invoiceStatus");
        mainDynamicObject.set("invoice_status", (Object)invoiceStatus);
        String etaxInvoiceNo = invoice.getString("etaxInvoiceNo");
        if (StringUtils.isNotEmpty((CharSequence)etaxInvoiceNo)) {
            mainDynamicObject.set("electronic_no", (Object)etaxInvoiceNo);
        }
        if (StringUtils.isNotEmpty((CharSequence)(specialTypeMark = invoice.getString("specialTypeMark")))) {
            mainDynamicObject.set("special_type_mark", (Object)specialTypeMark);
        }
        saveService.setMainInvoiceInfo(mainDynamicObject);
        saveService.setSourceAndRiskLevel(invoice, mainDynamicObject);
        DeductionDownService.updateOrg(mainDynamicObject, saveService, invoice, logInfo, orgId, mainDynamicObject.getString("buyer_tax_no"));
    }

    private static void updateOrg(DynamicObject dynamicObject, InvoiceSaveService saveService, JSONObject invoice, JSONObject logInfo, long orgId, String buyerTaxNo) {
        Date invoiceDate;
        if (orgId == 0L || "1".equals(invoice.getString("overrideOrg"))) {
            Long invoiceOrgId = saveService.getOrgId(invoice);
            String taxNo = invoice.getString("buyerTaxNo");
            if (StringUtils.isEmpty((CharSequence)taxNo)) {
                taxNo = buyerTaxNo;
            }
            Long invoiceTaxOrgId = TenantUtils.getTaxOrgId(null, taxNo);
            LOGGER.info("\u53d1\u7968:{}-{},\u539f\u7ec4\u7ec7id:{},\u66f4\u65b0\u540e\u7684\u7ec4\u7ec7id:{}", new Object[]{invoice.getString("invoiceCode"), invoice.getString("invoiceNo"), orgId, invoiceOrgId});
            if (logInfo != null) {
                logInfo.put("OrgId", (Object)invoiceOrgId);
                logInfo.put("tagOrgId", (Object)invoiceTaxOrgId);
            }
            dynamicObject.set("org", (Object)invoiceOrgId);
            dynamicObject.set("tax_org", (Object)invoiceTaxOrgId);
        } else if (DynamicObjectUtil.getDynamicObjectLongValue(dynamicObject.get("tax_org")) == 0L) {
            String taxNo = invoice.getString("buyerTaxNo");
            if (StringUtils.isEmpty((CharSequence)taxNo)) {
                taxNo = buyerTaxNo;
            }
            Long invoiceTaxOrgId = TenantUtils.getTaxOrgId(null, taxNo);
            dynamicObject.set("tax_org", (Object)invoiceTaxOrgId);
            if (logInfo != null) {
                logInfo.put("tagOrgId", (Object)invoiceTaxOrgId);
            }
        }
        String updateDelete = RimConfigUtils.getConfig("rim_deduction", "update_delete");
        if (!"0".equals(updateDelete)) {
            dynamicObject.set("delete", (Object)"1");
        }
        if ((invoiceDate = invoice.getDate("invoiceDate")) != null && !DateUtils.isTimeZero(invoiceDate)) {
            dynamicObject.set("invoice_date", (Object)invoiceDate);
        }
    }

    private static void setInvoiceBodyValue(DynamicObject invoiceBody, DynamicObject mainDynamicObject, InvoiceSaveService saveService, JSONObject invoice, Long invoiceType, long orgId) {
        if (invoice == null || invoiceBody == null || saveService == null) {
            return;
        }
        invoiceBody.set("modifytime", (Object)new Date());
        if (!"inputHeader".equals(invoice.getString("downResource"))) {
            saveService.setDeductionFieldValue(invoiceType, invoiceBody, invoice);
            saveService.setDeductionFlag(invoice, invoiceBody);
            String billDeductionFlag = InvoiceSaveService.getBillDeductionFlag(mainDynamicObject, CollectTypeEnum.PC_SHUIPAN.getCode());
            if (StringUtils.isEmpty((CharSequence)billDeductionFlag) && (InputInvoiceTypeEnum.canSelfproducedAgric(invoiceType) || InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(invoiceType)) && "1".equals(mainDynamicObject.getString("purchase_ticket"))) {
                boolean isBlue;
                String invoiceStatus = mainDynamicObject.getString("invoice_status");
                boolean invoiceStatusFlag = "0".equals(invoiceStatus) || "7".equals(invoiceStatus);
                boolean bl = isBlue = BigDecimalUtil.transDecimal(mainDynamicObject.get("invoice_amount")).compareTo(BigDecimal.ZERO) >= 0;
                if (!invoiceStatusFlag || !isBlue) {
                    invoiceBody.set(InvoiceSaveConstant.FIELD_DEDUCTION_FLAG, (Object)"0");
                } else {
                    invoiceBody.set(InvoiceSaveConstant.FIELD_DEDUCTION_FLAG, (Object)"1");
                    String authenticateFlag = invoiceBody.getString("authenticate_flag");
                    if (StringUtils.isEmpty((CharSequence)authenticateFlag)) {
                        invoiceBody.set("authenticate_flag", (Object)"0");
                    }
                }
            }
        }
        if (!InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceType) && !InputInvoiceTypeEnum.WITHHOLDING.getCode().equals(invoiceType)) {
            invoiceBody.set("invoice_status", (Object)invoice.getString("invoiceStatus"));
        }
        DeductionDownService.updateOrg(invoiceBody, saveService, invoice, null, orgId, mainDynamicObject.getString("buyer_tax_no"));
    }

    private static void saveLog(JSONObject invoice, JSONObject logInfo) {
        if (invoice == null || logInfo == null) {
            return;
        }
        logInfo.put("authenticateFlag", (Object)invoice.getString("authenticateFlag"));
        logInfo.put("invoiceStatus", (Object)invoice.getString("invoiceStatus"));
        logInfo.put("traceId", (Object)RequestContext.get().getTraceId());
        InvoiceLog.insert("deduct_authenticate", invoice.getString("serialNo"), logInfo.toJSONString(), invoice.getLong("org_id"), CollectTypeEnum.PC_SHUIPAN.getName(), CollectTypeEnum.PC_SHUIPAN.getCode());
    }

    public static String handleTaxFullInvoice(InvoiceSaveService service, JSONObject invoiceJson) {
        QFilter serialFilter;
        if (service == null || invoiceJson == null) {
            return null;
        }
        String checkFlag = RimConfigUtils.getConfig("rim_deduction", "not_check_status");
        if ("1".equals(checkFlag) || InputInvoiceTypeEnum.HGJKS.getCode().equals(service.getInvoiceType()) || InputInvoiceTypeEnum.WITHHOLDING.getCode().equals(service.getInvoiceType())) {
            return null;
        }
        DynamicObject invoiceObject = service.getInvoiceDynamicObject(invoiceJson);
        String serialNo = null;
        if (invoiceObject == null || service.checkIdIsNull(invoiceObject.getPkValue()).booleanValue()) {
            return serialNo;
        }
        String tenantNo = invoiceObject.getString("tenant_no");
        QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)tenantNo);
        DynamicObject queryMain = QueryServiceHelper.queryOne((String)"rim_invoice", (String)"id,check_status", (QFilter[])new QFilter[]{tenantFilter, serialFilter = new QFilter("serial_no", "=", (Object)invoiceObject.getString("serial_no"))});
        if (ObjectUtils.isEmpty((Object)queryMain)) {
            return serialNo;
        }
        String checkStatusPre = queryMain.getString("check_status");
        if ("1".equals(checkStatusPre)) {
            DynamicObject mainDynamicObject = BusinessDataServiceHelper.loadSingle((Object)queryMain.get("id"), (String)"rim_invoice");
            serialNo = invoiceObject.getString("serial_no");
            String invoiceCode = invoiceJson.getString("invoiceCode");
            String invoiceNo = CommonUtils.getJsonValue((Map<String, Object>)invoiceJson, String.class, "invoiceNo", "jkshm", "customDeclarationNo");
            String invoiceCodeNo = CommonUtils.getInvoiceCodeNoGroup(invoiceCode, invoiceNo);
            LOGGER.info("\u53d1\u7968\u5df2\u9a8c:{} \u76f4\u63a5\u66f4\u65b0\u5173\u952e\u6570\u636e", (Object)invoiceCodeNo);
            invoiceJson.put("serialNo", (Object)serialNo);
            JSONObject logInfo = new JSONObject();
            long orgId = DynamicObjectUtil.getDynamicObjectLongValue(mainDynamicObject.get("org"));
            Long invoiceType = service.getInvoiceType();
            DeductionDownService.setMainInvoiceValue(mainDynamicObject, service, invoiceJson, invoiceType, logInfo, orgId);
            DeductionDownService.setInvoiceBodyValue(invoiceObject, mainDynamicObject, service, invoiceJson, invoiceType, orgId);
            service.setInvoiceItemsValue(invoiceJson, invoiceObject);
            DeductionDownService.setInvoiceBodyValue(invoiceObject, mainDynamicObject, service, invoiceJson, invoiceType, orgId);
            JSONArray items = invoiceJson.getJSONArray("items");
            if (!CollectionUtils.isEmpty((Collection)items)) {
                service.setInvoiceItemsValue(invoiceJson, invoiceObject);
            }
            try (TXHandle h = TX.required();){
                try {
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mainDynamicObject});
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invoiceObject});
                    DeductionDownService.saveLog(invoiceJson, logInfo);
                }
                catch (Throwable e) {
                    LOGGER.error("\u7a0e\u76d8\u4e0b\u8f7d\u66f4\u65b0\u53d1\u7968\u62a5\u9519", e);
                    h.markRollback();
                    throw e;
                }
            }
        }
        return serialNo;
    }
}

