/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.deduction;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Date;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.rim.common.constant.CollectTypeEnum;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.invoice.check.UnCheckListCheckTask;
import kd.imc.rim.common.invoice.deduction.DeductionDownService;
import kd.imc.rim.common.invoice.save.InvoiceSaveResult;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.common.utils.UUID;

public class DeductionTableSaveTask
implements Callable<Boolean> {
    private static final Log LOGGER = LogFactory.getLog(DeductionTableSaveTask.class);
    private RequestContext ctx;
    private JSONObject invoice;
    private Long orgId;
    private String userId;

    public DeductionTableSaveTask(RequestContext ctx, JSONObject invoice, Long orgId, String userId) {
        this.ctx = ctx;
        this.invoice = invoice;
        this.orgId = orgId;
        this.userId = userId;
    }

    @Override
    public Boolean call() throws Exception {
        if (null == this.invoice) {
            return Boolean.FALSE;
        }
        Long invoiceType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(this.invoice.getString("invoiceType"));
        InvoiceSaveService saveService = InvoiceSaveService.newInstance(invoiceType + "");
        if (saveService == null) {
            LOGGER.info("\u8be5\u53d1\u7968\u7c7b\u578b:{} \u6ca1\u6709\u627e\u5230\u4fdd\u5b58\u5b9e\u73b0\u7c7b", (Object)this.invoice.getString("invoiceType"));
            return Boolean.FALSE;
        }
        String invoiceCode = this.invoice.getString("invoiceCode");
        String invoiceNo = this.invoice.getString("invoiceNo");
        if (ObjectUtils.isEmpty((Object)this.invoice.get((Object)"totalAmount"))) {
            BigDecimal totalAmount = BigDecimalUtil.transDecimal(this.invoice.get((Object)"invoiceAmount")).add(BigDecimalUtil.transDecimal(this.invoice.get((Object)"totalTaxAmount")));
            this.invoice.put("totalAmount", (Object)totalAmount);
        }
        if (!((Boolean)DeductionDownService.isUpdateDownInvoice(saveService, invoiceType, this.invoice).getLeft()).booleanValue()) {
            String invoiceCheck = RimConfigUtils.getConfig("rim_deduction", "down_invoice_check");
            if ("0".equals(invoiceCheck)) {
                return Boolean.FALSE;
            }
            if ("3".equals(invoiceCheck) || InputInvoiceTypeEnum.TOLL_ELECTRON.getCode().equals(invoiceType) || InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceType)) {
                LOGGER.info("\u53d1\u7968:{} \u4e3a\u901a\u884c\u8d39/\u6d77\u5173\u7f34\u6b3e\u4e66,\u6216\u8005\u914d\u7f6e\u76f4\u63a5\u5165\u5e93,\u4e0d\u67e5\u9a8c\u76f4\u63a5\u5165\u5e93", (Object)(invoiceCode + '-' + invoiceNo));
                this.invoice.put("invoiceType", (Object)invoiceType);
                this.invoice.put("checkStatus", (Object)"3");
                this.invoice.put("needUserRelation", (Object)"0");
                saveService.save(this.invoice);
            } else {
                this.check(this.invoice);
            }
        }
        return Boolean.TRUE;
    }

    private void check(JSONObject invoice) {
        String lockKey = "rim.invoice.down.check-" + invoice.getString("invoiceCode") + invoice.getString("invoiceNo");
        try (DLock lock = DLock.create((String)lockKey, (String)ResManager.loadKDString((String)"\u8fdb\u9879\u8868\u5934\u4e0b\u8f7d\u67e5\u9a8c", (String)"DeductInvoiceOperateService_0", (String)"imc-rim-common", (Object[])new Object[0]));){
            if (lock.tryLock()) {
                Long invoiceType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(invoice.getString("invoiceType"));
                InvoiceSaveService saveService = InvoiceSaveService.newInstance(invoiceType + "");
                invoice.put("invoiceType", (Object)invoiceType);
                if (saveService == null) {
                    LOGGER.info("\u8be5\u53d1\u7968\u7c7b\u578b:{} \u6ca1\u6709\u627e\u5230\u4fdd\u5b58\u5b9e\u73b0\u7c7b", (Object)invoice.getString("invoiceType"));
                    return;
                }
                String resource = invoice.get((Object)"resource") != null ? invoice.getString("resource") : "\u7a0e\u76d8";
                invoice.put("needUserRelation", (Object)"0");
                InvoiceSaveResult saveResult = saveService.saveUncheckInvoice(invoice, resource);
                Object unCheckId = null;
                if (saveResult != null) {
                    unCheckId = saveResult.getUnCheckId();
                }
                DynamicObject unCheckObject = this.getUncheckObject(unCheckId, invoice);
                UnCheckListCheckTask task = new UnCheckListCheckTask(this.ctx, unCheckObject);
                JSONObject result = task.call();
                LOGGER.info("\u4e0b\u8f7d\u53d1\u7968\u67e5\u9a8c\u7ed3\u679c:[{}]{}", (Object)result.getString("errcode"), (Object)result.getString("description"));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4e0b\u8f7d\u53d1\u7968\u67e5\u9a8c\u5931\u8d25" + lockKey, (Throwable)e);
        }
    }

    private DynamicObject getUncheckObject(Object uncheckId, JSONObject invoice) {
        DynamicObject unCheckObject = null;
        String authenticateFlag = invoice.getString("authenticateFlag");
        Date authenticateTime = null;
        Date selectTime = null;
        if ("2".equals(authenticateFlag)) {
            authenticateTime = invoice.getDate("selectAuthenticateTime");
        } else if ("3".equals(authenticateFlag)) {
            authenticateTime = invoice.getDate("scanAuthenticateTime");
        }
        String selectFlag = invoice.getString("checkFlag");
        if ("1".equals(selectFlag)) {
            selectTime = invoice.getDate("selectTime");
        }
        Date taxPeriod = null;
        if (StringUtils.isNotEmpty((CharSequence)invoice.getString("taxPeriod"))) {
            taxPeriod = DateUtils.stringToDate(invoice.getString("taxPeriod"), "yyyyMM");
        }
        if (uncheckId == null) {
            unCheckObject = BusinessDataServiceHelper.newDynamicObject((String)"rim_invoice_uncheck");
            unCheckObject.set("serial_no", (Object)UUID.randomUUIDZero());
            unCheckObject.set("create_time", (Object)new Date());
            unCheckObject.set("invoice_code", (Object)invoice.getString("invoiceCode"));
            unCheckObject.set("invoice_no", (Object)invoice.getString("invoiceNo"));
            unCheckObject.set("tenant_no", (Object)TenantUtils.getTenantNo());
        } else {
            unCheckObject = BusinessDataServiceHelper.loadSingle((Object)uncheckId, (String)"rim_invoice_uncheck");
        }
        unCheckObject.set("update_time", (Object)new Date());
        unCheckObject.set("org", (Object)this.orgId);
        unCheckObject.set("creater", (Object)this.userId);
        if (invoice.get((Object)"resource") != null && StringUtils.isNotBlank((Object)invoice.get((Object)"resource"))) {
            LOGGER.info("resource\u6765\u6e90\u5b58\u5728\uff0c{}", (Object)invoice.getString("resource"));
            unCheckObject.set("resource", (Object)invoice.getString("resource"));
        } else {
            LOGGER.info("resource\u6765\u6e90\u4e0d\u5b58\u5728");
            unCheckObject.set("resource", (Object)"\u7a0e\u76d8");
        }
        if (invoice.get((Object)"collect_type") != null && StringUtils.isNotBlank((Object)invoice.get((Object)"collect_type"))) {
            LOGGER.info("collect_type\u91c7\u96c6\u65b9\u5f0f\u5b58\u5728\uff0c{}", (Object)invoice.getString("collect_type"));
            unCheckObject.set("collect_type", (Object)invoice.getString("collect_type"));
        } else {
            LOGGER.info("collect_type\u91c7\u96c6\u65b9\u5f0f\u4e0d\u5b58\u5728");
            unCheckObject.set("collect_type", (Object)CollectTypeEnum.PC_SHUIPAN.getCode());
        }
        unCheckObject.set("invoice_type", (Object)InputInvoiceTypeEnum.getInvoiceTypeByAwsType(invoice.getString("invoiceType")));
        unCheckObject.set("invoice_date", (Object)invoice.getDate("invoiceDate"));
        unCheckObject.set("saler_name", (Object)invoice.getString("salerName"));
        unCheckObject.set("saler_tax_no", (Object)invoice.getString("salerTaxNo"));
        unCheckObject.set("invoice_amount", (Object)invoice.getBigDecimal("invoiceAmount"));
        unCheckObject.set("total_tax_amount", (Object)invoice.getBigDecimal("totalTaxAmount"));
        unCheckObject.set("total_amount", (Object)invoice.getBigDecimal("totalAmount"));
        unCheckObject.set("authenticate_flag", (Object)invoice.getString("authenticateFlag"));
        unCheckObject.set("authenticate_time", (Object)authenticateTime);
        unCheckObject.set("check_status", (Object)"3");
        unCheckObject.set("select_time", (Object)selectTime);
        unCheckObject.set("effective_tax_amount", (Object)invoice.getBigDecimal("effectiveTaxAmount"));
        unCheckObject.set("deduction_purpose", (Object)invoice.getString("deductionPurpose"));
        unCheckObject.set("not_deductible_type", (Object)invoice.getString("notDeductibleType"));
        unCheckObject.set("manage_status", (Object)invoice.getString("manageStatus"));
        unCheckObject.set("tax_period", (Object)taxPeriod);
        return unCheckObject;
    }
}

