/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.deduction;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.imc.rim.common.constant.CheckContant;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.deduction.DeductInvoiceOperateService;
import kd.imc.rim.common.invoice.deduction.DeductSelectService;
import kd.imc.rim.common.invoice.deduction.DeductServiceFactory;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.TenantUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.compress.utils.Sets;

public class ReadyDeductConfirmService {
    private static Log LOGGER = LogFactory.getLog(ReadyDeductConfirmService.class);
    private static final String[] AUTHENTICATE_FLAG_LIST = new String[]{"1", "2", "3"};

    public Map<String, Object> getDeductNumAndAmount(Long orgId, Long taxOrgId, String taxNo, Date taxPeriod) {
        if (ObjectUtils.isEmpty((Object)orgId) && ObjectUtils.isEmpty((Object)taxOrgId)) {
            return null;
        }
        Map<String, Object> deductSelected = this.queryDeductSelected(orgId, taxOrgId, taxNo, taxPeriod, null);
        Map<String, Object> deductReadySelect = this.queryDeductReadySelect(orgId, taxOrgId, taxNo, taxPeriod, null);
        Map<String, Object> customSelected = this.queryDeductSelected(orgId, taxOrgId, taxNo, taxPeriod, InputInvoiceTypeEnum.HGJKS.getCode());
        Map<String, Object> customReadySelect = this.queryDeductReadySelect(orgId, taxOrgId, taxNo, taxPeriod, InputInvoiceTypeEnum.HGJKS.getCode());
        HashMap result = Maps.newHashMap();
        int deductSelectedNum = (Integer)deductSelected.get("deduct_selected_num");
        int deductReadySelectNum = (Integer)deductReadySelect.get("deduct_ready_select_num");
        result.put("selected_deduct_num", deductReadySelectNum);
        result.put("selected_deduct_num1", deductSelectedNum);
        int customSelectedNum = (Integer)customSelected.get("deduct_selected_num");
        int customReadySelectedNum = (Integer)customReadySelect.get("deduct_ready_select_num");
        result.put("custom_selected_num", customReadySelectedNum);
        result.put("custom_selected_num1", customSelectedNum);
        BigDecimal deductSelectedAmount = (BigDecimal)deductSelected.get("deduct_selected_amount");
        BigDecimal deductReadySelectAmount = (BigDecimal)deductReadySelect.get("deduct_ready_select_amount");
        result.put("selected_deduct_amount", deductReadySelectAmount);
        result.put("selected_deduct_amount1", deductSelectedAmount);
        BigDecimal customSelectedAmount = (BigDecimal)customSelected.get("deduct_selected_amount");
        BigDecimal customReadySelectAmount = (BigDecimal)customReadySelect.get("deduct_ready_select_amount");
        result.put("custom_selected_amount", customReadySelectAmount);
        result.put("custom_selected_amount1", customSelectedAmount);
        result.put("selectIds", deductSelected.get("ids"));
        result.put("ids", deductReadySelect.get("ids"));
        result.put("customSelectIds", customSelected.get("ids"));
        result.put("customIds", customReadySelect.get("ids"));
        return result;
    }

    public Map<String, Object> queryDeductSelected(Long orgId, Long taxOrgId, String taxNo, Date taxPeriod, Long invoiceType) {
        QFilter orgfilter = null;
        if (!ObjectUtils.isEmpty((Object)orgId)) {
            orgfilter = new QFilter("org", "=", (Object)orgId);
        }
        if (taxPeriod == null) {
            String currentYearMonth = DateUtils.format(new Date(), "yyyyMM");
            taxPeriod = DateUtils.stringToDate(currentYearMonth, "yyyyMM");
        }
        QFilter taxOrgFilter = null;
        if (taxOrgId != null) {
            taxOrgFilter = new QFilter("tax_org", "=", (Object)taxOrgId);
        }
        QFilter periodfilter = new QFilter("tax_period", "=", (Object)taxPeriod);
        QFilter taxAmountFilter = new QFilter("total_tax_amount", ">", (Object)BigDecimal.ZERO);
        QFilter flagFilter = new QFilter("authenticate_flag", "in", (Object)AUTHENTICATE_FLAG_LIST);
        QFilter purposeFilter = new QFilter("deduction_purpose", "=", (Object)"1");
        QFilter dtflagFilter = new QFilter("deduction_flag", "=", (Object)"1");
        QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)TenantUtils.getTenantNo());
        QFilter delFilter = new QFilter("delete", "=", (Object)"1");
        QFilter checkFilter = null;
        String showUncheckConfig = RimConfigUtils.getConfig("show_uncheck");
        Boolean needShow = Boolean.TRUE;
        if (StringUtils.isBlank((String)showUncheckConfig) || "0".equals(showUncheckConfig)) {
            needShow = Boolean.FALSE;
        }
        if (!needShow.booleanValue()) {
            checkFilter = new QFilter("check_status", "in", (Object)CheckContant.getSuccessStatus());
        }
        QFilter typeFilter = new QFilter("invoice_type", "in", (Object)InputInvoiceTypeEnum.getVatDeductionTypes());
        if (invoiceType != null) {
            typeFilter = new QFilter("invoice_type", "=", (Object)invoiceType);
        }
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_invoice", (String)"id, effective_tax_amount", (QFilter[])new QFilter[]{orgfilter, taxAmountFilter, periodfilter, flagFilter, purposeFilter, dtflagFilter, taxOrgFilter, tenantFilter, delFilter, checkFilter, typeFilter});
        HashMap result = Maps.newHashMap();
        ArrayList ids = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)collection)) {
            result.put("deduct_selected_num", collection.size());
            BigDecimal amount = BigDecimal.ZERO;
            for (DynamicObject obj : collection) {
                ids.add(obj.getLong("id"));
                BigDecimal tax_amount = (BigDecimal)obj.get("effective_tax_amount");
                amount = amount.add(tax_amount);
            }
            result.put("deduct_selected_amount", amount);
        } else {
            result.put("deduct_selected_num", 0);
            result.put("deduct_selected_amount", BigDecimal.ZERO);
        }
        result.put("ids", ids);
        return result;
    }

    private Map<String, Object> queryDeductReadySelect(Long orgId, Long taxOrgId, String taxNo, Date taxPeriod, Long invoiceType) {
        ArrayList orgIds = Lists.newArrayList();
        ArrayList taxOrgIds = Lists.newArrayList();
        if (orgId != null) {
            orgIds.add(orgId);
        }
        if (taxOrgId != null) {
            taxOrgIds.add(taxOrgId);
        }
        Long[] invoiceTypes = null;
        if (invoiceType != null) {
            invoiceTypes = new Long[]{invoiceType};
        }
        return this.queryDeductReadySelect(orgIds, taxOrgIds, taxNo, taxPeriod, invoiceTypes);
    }

    public Map<String, Object> queryDeductReadySelect(List<Long> orgIds, List<Long> taxOrgIds, String taxNo, Date taxPeriod, Long[] invoiceTypes) {
        QFilter orgfilter = null;
        if (!ObjectUtils.isEmpty(orgIds)) {
            orgfilter = new QFilter("org", "in", orgIds);
        }
        if (taxPeriod == null) {
            String currentYearMonth = DateUtils.format(new Date(), "yyyyMM");
            taxPeriod = DateUtils.stringToDate(currentYearMonth, "yyyyMM");
        }
        QFilter taxOrgFilter = null;
        if (!ObjectUtils.isEmpty(taxOrgIds)) {
            taxOrgFilter = new QFilter("tax_org", "in", taxOrgIds);
        }
        QFilter periodfilter = new QFilter("tax_period", "=", (Object)taxPeriod);
        QFilter taxAmountFilter = new QFilter("total_tax_amount", ">", (Object)BigDecimal.ZERO);
        QFilter flagFilter = new QFilter("authenticate_flag", "=", (Object)"4");
        QFilter purposeFilter = new QFilter("deduction_purpose", "=", (Object)"1");
        QFilter dtflagFilter = new QFilter("deduction_flag", "=", (Object)"1");
        QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)TenantUtils.getTenantNo());
        QFilter delFilter = new QFilter("delete", "=", (Object)"1");
        QFilter checkFilter = null;
        String showUncheckConfig = RimConfigUtils.getConfig("show_uncheck");
        Boolean needShow = Boolean.TRUE;
        if (StringUtils.isBlank((String)showUncheckConfig) || "0".equals(showUncheckConfig)) {
            needShow = Boolean.FALSE;
        }
        if (!needShow.booleanValue()) {
            checkFilter = new QFilter("check_status", "in", (Object)CheckContant.getSuccessStatus());
        }
        QFilter typeFilter = new QFilter("invoice_type", "in", (Object)InputInvoiceTypeEnum.getVatDeductionTypes());
        if (!ObjectUtils.isEmpty((Object[])invoiceTypes)) {
            typeFilter = new QFilter("invoice_type", "in", (Object)invoiceTypes);
        }
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_invoice", (String)"id, effective_tax_amount", (QFilter[])new QFilter[]{orgfilter, taxAmountFilter, periodfilter, flagFilter, purposeFilter, dtflagFilter, taxOrgFilter, tenantFilter, delFilter, checkFilter, typeFilter});
        HashMap result = Maps.newHashMap();
        ArrayList ids = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)collection)) {
            result.put("deduct_ready_select_num", collection.size());
            BigDecimal amount = BigDecimal.ZERO;
            for (DynamicObject obj : collection) {
                ids.add((Long)obj.get("id"));
                BigDecimal tax_amount = (BigDecimal)obj.get("effective_tax_amount");
                amount = amount.add(tax_amount);
            }
            result.put("deduct_ready_select_amount", amount);
        } else {
            result.put("deduct_ready_select_num", 0);
            result.put("deduct_ready_select_amount", BigDecimal.ZERO);
        }
        result.put("ids", ids);
        return result;
    }

    public Map<String, Object> getUndeductNumAndAmount(Long orgId, Long taxOrgId, String taxNo, Date taxPeriod) {
        if (ObjectUtils.isEmpty((Object)orgId) && ObjectUtils.isEmpty((Object)taxOrgId)) {
            return null;
        }
        Map<String, Object> unDeductSelected = this.queryUnDeductSelected(orgId, taxOrgId, taxNo, taxPeriod, null);
        Map<String, Object> unDeductReadySelect = this.queryUnDeductReadySelect(orgId, taxOrgId, taxNo, taxPeriod, null);
        Map<String, Object> customUnDeductSelected = this.queryUnDeductSelected(orgId, taxOrgId, taxNo, taxPeriod, InputInvoiceTypeEnum.HGJKS.getCode());
        Map<String, Object> customUnDeductReadySelect = this.queryUnDeductReadySelect(orgId, taxOrgId, taxNo, taxPeriod, InputInvoiceTypeEnum.HGJKS.getCode());
        HashMap result = Maps.newHashMap();
        int undeductSelectedNum = (Integer)unDeductSelected.get("undeduct_selected_num");
        int undeductReadySelectNum = (Integer)unDeductReadySelect.get("undeduct_ready_select_num");
        result.put("selected_undeduct_num", undeductReadySelectNum);
        result.put("selected_undeduct_num1", undeductSelectedNum);
        int customSelectedNum = (Integer)customUnDeductSelected.get("undeduct_selected_num");
        int customReadySelectNum = (Integer)customUnDeductReadySelect.get("undeduct_ready_select_num");
        result.put("custom_undeduct_num", customReadySelectNum);
        result.put("custom_undeduct_num1", customSelectedNum);
        BigDecimal undeductSelectedAmount = (BigDecimal)unDeductSelected.get("undeduct_selected_amount");
        BigDecimal undeductReadySelectAmount = (BigDecimal)unDeductReadySelect.get("undeduct_ready_select_amount");
        result.put("selected_undeduct_amount", undeductReadySelectAmount);
        result.put("selected_undeduct_amount1", undeductSelectedAmount);
        BigDecimal customSelectedAmount = (BigDecimal)customUnDeductSelected.get("undeduct_selected_amount");
        BigDecimal customReadySelectAmount = (BigDecimal)customUnDeductReadySelect.get("undeduct_ready_select_amount");
        result.put("custom_undeduct_amount", customReadySelectAmount);
        result.put("custom_undeduct_amount1", customSelectedAmount);
        result.put("selectIds", unDeductSelected.get("ids"));
        result.put("ids", unDeductReadySelect.get("ids"));
        result.put("customSelectIds", customUnDeductSelected.get("ids"));
        result.put("customIds", customUnDeductReadySelect.get("ids"));
        return result;
    }

    public Map<String, Object> queryUnDeductSelected(Long orgId, Long taxOrgId, String taxNo, Date taxPeriod, Long invoiceType) {
        QFilter orgfilter = null;
        if (!ObjectUtils.isEmpty((Object)orgId)) {
            orgfilter = new QFilter("org", "=", (Object)orgId);
        }
        if (taxPeriod == null) {
            String currentYearMonth = DateUtils.format(new Date(), "yyyyMM");
            taxPeriod = DateUtils.stringToDate(currentYearMonth, "yyyyMM");
        }
        QFilter taxOrgFilter = null;
        if (taxOrgId != null) {
            taxOrgFilter = new QFilter("tax_org", "=", (Object)taxOrgId);
        }
        QFilter periodfilter = new QFilter("tax_period", "=", (Object)taxPeriod);
        QFilter taxAmountFilter = new QFilter("total_tax_amount", ">", (Object)BigDecimal.ZERO);
        QFilter flagFilter = new QFilter("authenticate_flag", "in", (Object)AUTHENTICATE_FLAG_LIST);
        QFilter purposeFilter = new QFilter("deduction_purpose", "=", (Object)"2");
        QFilter dtflagFilter = new QFilter("deduction_flag", "=", (Object)"1");
        QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)TenantUtils.getTenantNo());
        QFilter delFilter = new QFilter("delete", "=", (Object)"1");
        QFilter checkFilter = new QFilter("check_status", "in", (Object)CheckContant.getSuccessStatus());
        QFilter typeFilter = new QFilter("invoice_type", "in", (Object)InputInvoiceTypeEnum.getVatTypes());
        if (invoiceType != null) {
            typeFilter = new QFilter("invoice_type", "=", (Object)invoiceType);
        }
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_invoice", (String)"id, effective_tax_amount", (QFilter[])new QFilter[]{orgfilter, taxAmountFilter, periodfilter, flagFilter, purposeFilter, dtflagFilter, taxOrgFilter, tenantFilter, delFilter, checkFilter, typeFilter});
        HashMap result = Maps.newHashMap();
        ArrayList ids = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)collection)) {
            result.put("undeduct_selected_num", collection.size());
            BigDecimal amount = BigDecimal.ZERO;
            for (DynamicObject obj : collection) {
                ids.add(obj.getLong("id"));
                BigDecimal tax_amount = (BigDecimal)obj.get("effective_tax_amount");
                amount = amount.add(tax_amount);
            }
            result.put("undeduct_selected_amount", amount);
        } else {
            result.put("undeduct_selected_num", 0);
            result.put("undeduct_selected_amount", BigDecimal.ZERO);
        }
        result.put("ids", ids);
        return result;
    }

    private Map<String, Object> queryUnDeductReadySelect(Long orgId, Long taxOrgId, String taxNo, Date taxPeriod, Long invoiceType) {
        ArrayList orgIds = Lists.newArrayList();
        ArrayList taxOrgIds = Lists.newArrayList();
        if (orgId != null) {
            orgIds.add(orgId);
        }
        if (taxOrgId != null) {
            taxOrgIds.add(taxOrgId);
        }
        Long[] invoiceTypes = null;
        if (invoiceType != null) {
            invoiceTypes = new Long[]{invoiceType};
        }
        return this.queryUnDeductReadySelect(orgIds, taxOrgIds, taxNo, taxPeriod, invoiceTypes);
    }

    public Map<String, Object> queryUnDeductReadySelect(List<Long> orgIds, List<Long> taxOrgIds, String taxNo, Date taxPeriod, Long[] invoiceTypes) {
        QFilter orgfilter = null;
        if (!ObjectUtils.isEmpty(orgIds)) {
            orgfilter = new QFilter("org", "in", orgIds);
        }
        if (taxPeriod == null) {
            String currentYearMonth = DateUtils.format(new Date(), "yyyyMM");
            taxPeriod = DateUtils.stringToDate(currentYearMonth, "yyyyMM");
        }
        QFilter taxOrgFilter = null;
        if (!ObjectUtils.isEmpty(taxOrgIds)) {
            taxOrgFilter = new QFilter("tax_org", "in", taxOrgIds);
        }
        QFilter periodfilter = new QFilter("tax_period", "=", (Object)taxPeriod);
        QFilter taxAmountFilter = new QFilter("total_tax_amount", ">", (Object)BigDecimal.ZERO);
        QFilter flagFilter = new QFilter("authenticate_flag", "=", (Object)"4");
        QFilter purposeFilter = new QFilter("deduction_purpose", "=", (Object)"2");
        QFilter dtflagFilter = new QFilter("deduction_flag", "=", (Object)"1");
        QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)TenantUtils.getTenantNo());
        QFilter delFilter = new QFilter("delete", "=", (Object)"1");
        QFilter checkFilter = new QFilter("check_status", "in", (Object)CheckContant.getSuccessStatus());
        QFilter typeFilter = new QFilter("invoice_type", "in", (Object)InputInvoiceTypeEnum.getVatTypes());
        if (!ObjectUtils.isEmpty((Object[])invoiceTypes)) {
            typeFilter = new QFilter("invoice_type", "in", (Object)invoiceTypes);
        }
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_invoice", (String)"id, effective_tax_amount", (QFilter[])new QFilter[]{orgfilter, periodfilter, taxAmountFilter, flagFilter, purposeFilter, dtflagFilter, taxOrgFilter, tenantFilter, delFilter, checkFilter, typeFilter});
        HashMap result = Maps.newHashMap();
        ArrayList ids = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)collection)) {
            result.put("undeduct_ready_select_num", collection.size());
            BigDecimal amount = BigDecimal.ZERO;
            for (DynamicObject obj : collection) {
                ids.add((Long)obj.get("id"));
                BigDecimal tax_amount = (BigDecimal)obj.get("effective_tax_amount");
                amount = amount.add(tax_amount);
            }
            result.put("undeduct_ready_select_amount", amount);
        } else {
            result.put("undeduct_ready_select_num", 0);
            result.put("undeduct_ready_select_amount", BigDecimal.ZERO);
        }
        result.put("ids", ids);
        return result;
    }

    public Map<String, Object> queryVatDrawBackReadySelect(List<Long> orgIds, List<Long> taxOrgIds, String taxNo, Date taxPeriod, Long[] invoiceTypes) {
        QFilter orgfilter = null;
        if (!ObjectUtils.isEmpty(orgIds)) {
            orgfilter = new QFilter("org", "in", orgIds);
        }
        if (taxPeriod == null) {
            String currentYearMonth = DateUtils.format(new Date(), "yyyyMM");
            taxPeriod = DateUtils.stringToDate(currentYearMonth, "yyyyMM");
        }
        QFilter taxOrgFilter = null;
        if (!ObjectUtils.isEmpty(taxOrgIds)) {
            taxOrgFilter = new QFilter("tax_org", "in", taxOrgIds);
        }
        QFilter periodfilter = new QFilter("tax_period", "=", (Object)taxPeriod);
        QFilter taxAmountFilter = new QFilter("total_tax_amount", ">", (Object)BigDecimal.ZERO);
        QFilter flagFilter = new QFilter("authenticate_flag", "=", (Object)"4");
        QFilter purposeFilter = new QFilter("deduction_purpose", "=", (Object)"3");
        QFilter dtflagFilter = new QFilter("deduction_flag", "=", (Object)"1");
        QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)TenantUtils.getTenantNo());
        QFilter delFilter = new QFilter("delete", "=", (Object)"1");
        QFilter checkFilter = new QFilter("check_status", "in", (Object)CheckContant.getSuccessStatus());
        QFilter typeFilter = new QFilter("invoice_type", "in", (Object)InputInvoiceTypeEnum.getVatTypes());
        if (!ObjectUtils.isEmpty((Object[])invoiceTypes)) {
            typeFilter = new QFilter("invoice_type", "in", (Object)invoiceTypes);
        }
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_invoice", (String)"id, effective_tax_amount", (QFilter[])new QFilter[]{orgfilter, periodfilter, taxAmountFilter, flagFilter, purposeFilter, dtflagFilter, taxOrgFilter, tenantFilter, delFilter, checkFilter, typeFilter});
        HashMap result = Maps.newHashMap();
        ArrayList ids = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)collection)) {
            result.put("drawback_ready_select_num", collection.size());
            BigDecimal amount = BigDecimal.ZERO;
            for (DynamicObject obj : collection) {
                ids.add((Long)obj.get("id"));
                BigDecimal tax_amount = (BigDecimal)obj.get("effective_tax_amount");
                amount = amount.add(tax_amount);
            }
            result.put("drawback_ready_select_amount", amount);
        } else {
            result.put("drawback_ready_select_num", 0);
            result.put("drawback_ready_select_amount", BigDecimal.ZERO);
        }
        result.put("ids", ids);
        return result;
    }

    public Map<String, Object> getCalcNumAndAmount(Long orgId, Long taxOrgId, String taxNo, Date taxPeriod) {
        if (ObjectUtils.isEmpty((Object)orgId) && ObjectUtils.isEmpty((Object)taxOrgId)) {
            return null;
        }
        HashSet orgIds = Sets.newHashSet((Object[])new Long[0]);
        HashSet taxOrgIds = Sets.newHashSet((Object[])new Long[0]);
        if (orgId != null) {
            orgIds.add(orgId);
        }
        if (taxOrgId != null) {
            taxOrgIds.add(taxOrgId);
        }
        Map<String, Object> deductedCalcOrdinary = this.queryDeductCalcOrdinary(orgId, taxOrgId, taxNo, taxPeriod, "1");
        Map<String, Object> deductedCalcOthers = this.queryDedutCalcOthers(orgId, taxOrgId, taxPeriod, "1");
        Map<String, Object> readyDeductCalcOrdinary = this.queryDeductCalcOrdinary(orgId, taxOrgId, taxNo, taxPeriod, "2");
        Map<String, Object> readyDeductCalcOthers = this.queryDedutCalcOthers(orgId, taxOrgId, taxPeriod, "2");
        int calcOrdinaryDeductNum = (Integer)deductedCalcOrdinary.get("calc_ordinary_deduct_num");
        int calcOthersDeductNum = (Integer)deductedCalcOthers.get("calc_others_deduct_num");
        int rdcy = (Integer)readyDeductCalcOrdinary.get("calc_ordinary_deduct_num");
        int rdco = (Integer)readyDeductCalcOthers.get("calc_others_deduct_num");
        BigDecimal calcOrdinaryDeductAmount = (BigDecimal)deductedCalcOrdinary.get("calc_ordinary_deduct_amount");
        BigDecimal calcOthersDeductAmount = (BigDecimal)deductedCalcOthers.get("calc_others_deduct_amount");
        BigDecimal coda = (BigDecimal)readyDeductCalcOrdinary.get("calc_ordinary_deduct_amount");
        BigDecimal ctda = (BigDecimal)readyDeductCalcOthers.get("calc_others_deduct_amount");
        HashMap result = Maps.newHashMap();
        result.put("ready_calc_num", rdcy + rdco);
        result.put("ready_calc_num1", calcOrdinaryDeductNum + calcOthersDeductNum);
        result.put("ready_calc_amount", coda.add(ctda));
        result.put("ready_calc_amount1", calcOrdinaryDeductAmount.add(calcOthersDeductAmount));
        List rdcyIds = (List)readyDeductCalcOrdinary.get("ids");
        List rdcoIds = (List)readyDeductCalcOthers.get("ids");
        rdcyIds.addAll(rdcoIds);
        List ids = (List)deductedCalcOrdinary.get("ids");
        List sids = (List)deductedCalcOthers.get("ids");
        ids.addAll(sids);
        result.put("ids", rdcyIds);
        result.put("selectIds", ids);
        return result;
    }

    public Map<String, Object> queryDeductCalcOrdinary(Long orgId, Long taxOrgId, String taxNo, Date taxPeriod, String transportDeduction) {
        ArrayList orgIds = Lists.newArrayList();
        ArrayList taxOrgIds = Lists.newArrayList();
        if (orgId != null) {
            orgIds.add(orgId);
        }
        if (taxOrgId != null) {
            taxOrgIds.add(taxOrgId);
        }
        return this.queryDeductCalcOrdinary(orgIds, taxOrgIds, taxNo, taxPeriod, transportDeduction);
    }

    public Map<String, Object> queryDeductCalcOrdinary(List<Long> orgIds, List<Long> taxOrgIds, String taxNo, Date taxPeriod, String transportDeduction) {
        QFilter orgfilter = null;
        if (!ObjectUtils.isEmpty(orgIds)) {
            orgfilter = new QFilter("org", "in", orgIds);
        }
        if (taxPeriod == null) {
            String currentYearMonth = DateUtils.format(new Date(), "yyyyMM");
            taxPeriod = DateUtils.stringToDate(currentYearMonth, "yyyyMM");
        }
        QFilter taxOrgFilter = null;
        if (!ObjectUtils.isEmpty(taxOrgIds)) {
            taxOrgFilter = new QFilter("tax_org", "in", taxOrgIds);
        }
        QFilter periodfilter = new QFilter("tax_period", "=", (Object)taxPeriod);
        QFilter taxAmountFilter = new QFilter("total_tax_amount", ">", (Object)BigDecimal.ZERO);
        QFilter ordinaryFilter = new QFilter("invoice_type", "in", (Object)new Long[]{InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode(), InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode()});
        QFilter purposeFilter = new QFilter("transport_deduction", "=", (Object)transportDeduction);
        QFilter dtflagFilter = new QFilter("deduction_flag", "=", (Object)"1");
        QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)TenantUtils.getTenantNo());
        QFilter delFilter = new QFilter("delete", "=", (Object)"1");
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_invoice", (String)"id, effective_tax_amount", (QFilter[])new QFilter[]{orgfilter, taxOrgFilter, taxAmountFilter, periodfilter, ordinaryFilter, purposeFilter, dtflagFilter, tenantFilter, delFilter});
        HashMap result = Maps.newHashMap();
        ArrayList ids = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)collection)) {
            result.put("calc_ordinary_deduct_num", collection.size());
            BigDecimal amount = BigDecimal.ZERO;
            for (DynamicObject obj : collection) {
                if ("2".equals(transportDeduction)) {
                    ids.add((Long)obj.get("id"));
                }
                BigDecimal tax_amount = (BigDecimal)obj.get("effective_tax_amount");
                amount = amount.add(tax_amount);
            }
            result.put("calc_ordinary_deduct_amount", amount);
        } else {
            result.put("calc_ordinary_deduct_num", 0);
            result.put("calc_ordinary_deduct_amount", BigDecimal.ZERO);
        }
        result.put("ids", ids);
        return result;
    }

    public Map<String, Object> queryDedutCalcOthers(Long orgId, Long taxOrgId, Date taxPeriod, String transportDeduction) {
        ArrayList orgIds = Lists.newArrayList();
        ArrayList taxOrgIds = Lists.newArrayList();
        if (orgId != null) {
            orgIds.add(orgId);
        }
        if (taxOrgId != null) {
            taxOrgIds.add(taxOrgId);
        }
        return this.queryDedutCalcOthers(orgIds, taxOrgIds, taxPeriod, transportDeduction);
    }

    public Map<String, Object> queryDedutCalcOthers(List<Long> orgIds, List<Long> taxOrgIds, Date taxPeriod, String transportDeduction) {
        QFilter orgfilter = null;
        if (!ObjectUtils.isEmpty(orgIds)) {
            orgfilter = new QFilter("org", "in", orgIds);
        }
        if (taxPeriod == null) {
            String currentYearMonth = DateUtils.format(new Date(), "yyyyMM");
            taxPeriod = DateUtils.stringToDate(currentYearMonth, "yyyyMM");
        }
        QFilter taxOrgFilter = null;
        if (!ObjectUtils.isEmpty(taxOrgIds)) {
            taxOrgFilter = new QFilter("tax_org", "in", taxOrgIds);
        }
        QFilter periodfilter = new QFilter("tax_period", "=", (Object)taxPeriod);
        ArrayList invoiceTypeList = Lists.newArrayList();
        invoiceTypeList.add(InputInvoiceTypeEnum.TRAIN_INVOICE.getCode());
        invoiceTypeList.add(InputInvoiceTypeEnum.AIR_INVOICE.getCode());
        invoiceTypeList.add(InputInvoiceTypeEnum.TRANSPORT_INVOICE.getCode());
        invoiceTypeList.add(InputInvoiceTypeEnum.BOAT_INVOICE.getCode());
        QFilter othersFilter = new QFilter("invoice_type", "in", (Object)invoiceTypeList);
        QFilter taxAmountFilter = new QFilter("total_tax_amount", ">", (Object)BigDecimal.ZERO);
        QFilter purposeFilter = new QFilter("transport_deduction", "=", (Object)transportDeduction);
        QFilter dtflagFilter = new QFilter("deduction_flag", "=", (Object)"1");
        QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)TenantUtils.getTenantNo());
        QFilter delFilter = new QFilter("delete", "=", (Object)"1");
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_invoice", (String)"id, effective_tax_amount", (QFilter[])new QFilter[]{orgfilter, taxOrgFilter, taxAmountFilter, periodfilter, othersFilter, purposeFilter, dtflagFilter, tenantFilter, delFilter});
        HashMap result = Maps.newHashMap();
        ArrayList ids = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)collection)) {
            result.put("calc_others_deduct_num", collection.size());
            BigDecimal amount = BigDecimal.ZERO;
            for (DynamicObject obj : collection) {
                if ("2".equals(transportDeduction)) {
                    ids.add((Long)obj.get("id"));
                }
                BigDecimal tax_amount = (BigDecimal)obj.get("effective_tax_amount");
                amount = amount.add(tax_amount);
            }
            result.put("calc_others_deduct_amount", amount);
        } else {
            result.put("calc_others_deduct_num", 0);
            result.put("calc_others_deduct_amount", BigDecimal.ZERO);
        }
        result.put("ids", ids);
        return result;
    }

    public JSONObject getBatchSelectDeductAndPush(String taxNo, String deductIds, String deductibleMode, Long orgId, Long invoiceType) {
        String[] ids;
        if (StringUtils.isEmpty((String)deductIds) || StringUtils.isEmpty((String)deductibleMode)) {
            return ResultContant.createJSONObject("0001", ResManager.loadKDString((String)"\u52fe\u9009\u786e\u8ba4\u53c2\u6570\u4e3a\u7a7a...", (String)"ReadyDeductConfirmService_0", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        JSONObject result = new JSONObject();
        ArrayList idList = Lists.newArrayList();
        for (String id : ids = deductIds.split(",")) {
            idList.add(Long.valueOf(id));
        }
        QFilter filte = new QFilter("id", "in", (Object)idList);
        QFilter flagfilte = new QFilter("authenticate_flag", "=", (Object)"4");
        DynamicObjectCollection invoiceCollection = QueryServiceHelper.query((String)"rim_invoice", (String)"id,serial_no,invoice_type,invoice_code,invoice_no,invoice_date,invoice_amount,total_tax_amount,total_amount,authenticate_flag,effective_tax_amount,buyer_tax_no,org,isvoucher,invoice_status,deduction_flag,deduction_purpose,not_deductible_type,saler_name,saler_tax_no,output_type,remark,electronic_no,createtime,purchase_ticket,agric_handle_status,invoice_risk_level", (QFilter[])new QFilter[]{filte, flagfilte});
        JSONObject param = new JSONObject();
        JSONArray invoices = new JSONArray();
        param.put("deductibleMode", (Object)deductibleMode);
        param.put("taxNo", (Object)taxNo);
        param.put("orgId", (Object)orgId);
        String billType = "0";
        if (InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceType)) {
            billType = "1";
        }
        param.put("billType", (Object)billType);
        param.put("selectOperationType", (Object)"1");
        if (!CollectionUtils.isEmpty((Collection)invoiceCollection)) {
            for (DynamicObject object : invoiceCollection) {
                invoices.add((Object)DeductionConstant.createSelectJson(object));
            }
            String rpaSelectSyn = RimConfigUtils.getConfig("rpa_select_syn");
            if ("1".equals(rpaSelectSyn)) {
                param.put("rpa_select_syn", (Object)rpaSelectSyn);
            }
            param.put("invoices", (Object)invoices);
            String dkType = DeductionConstant.getDkType(taxNo);
            DeductSelectService invoiceDeductService = DeductServiceFactory.newInstanceForDeductSelect(dkType);
            if (invoiceDeductService == null) {
                result.put("errcode", (Object)"0010");
                result.put("description", (Object)ResManager.loadKDString((String)"\u7a0e\u5c40\u63a5\u53e3\u914d\u7f6e\u9519\u8bef", (String)"ReadyDeductConfirmService_1", (String)"imc-rim-common", (Object[])new Object[0]));
                return result;
            }
            result = invoiceDeductService.moreTaxNoInvoiceSelect(param);
        } else {
            result.put("errcode", (Object)"0010");
            result.put("description", (Object)ResManager.loadKDString((String)"\u672a\u627e\u5230\u9884\u52fe\u9009\u6570\u636e,\u8bf7\u5237\u65b0\u5217\u8868\u518d\u5c1d\u8bd5..", (String)"ReadyDeductConfirmService_2", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        return result;
    }

    public JSONObject transportDeduct(List<Long> idList, String transportDeduction, Date taxPeriod) {
        JSONObject result;
        QFilter idFilter = new QFilter("id", "in", idList);
        QFilter tranFilter = new QFilter("transport_deduction", "=", (Object)"2");
        DynamicObjectCollection mainCollection = QueryServiceHelper.query((String)"rim_invoice", (String)"serial_no,transport_deduction", (QFilter[])new QFilter[]{idFilter, tranFilter});
        if (!CollectionUtils.isEmpty((Collection)mainCollection)) {
            List<String> serialNoList = mainCollection.stream().map(s -> s.getString("serial_no")).collect(Collectors.toList());
            DeductInvoiceOperateService dios = new DeductInvoiceOperateService();
            result = dios.transportDeductBySerialNo(serialNoList, transportDeduction, taxPeriod, "6", "1");
        } else {
            result = ResultContant.createJSONObject("0010", ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u9884\u62b5\u6263\u7684\u53d1\u7968,\u8bf7\u5237\u65b0\u5217\u8868\u518d\u5c1d\u8bd5..", (String)"ReadyDeductConfirmService_3", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        return result;
    }
}

