/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.deduction;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.login.utils.StringUtils;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.SpecialTypeMarkEnum;
import kd.imc.rim.common.utils.BigDecimalUtil;

public class StatisticService {
    public static Map<String, JSONObject> initStatisticMap() {
        InputInvoiceTypeEnum[] types;
        LinkedHashMap<String, JSONObject> statisticMap = new LinkedHashMap<String, JSONObject>(8);
        for (InputInvoiceTypeEnum invoiceType : types = InputInvoiceTypeEnum.getDeductionTypeEnums()) {
            if (InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode().equals(invoiceType.getCode())) continue;
            statisticMap.put(invoiceType.getAwsType(), StatisticService.getStatistJson(invoiceType.getAwsType()));
        }
        statisticMap.put("41", StatisticService.getStatistJson("41"));
        statisticMap.put("42", StatisticService.getStatistJson("42"));
        return statisticMap;
    }

    public static JSONObject getStatistJson(String invoiceType) {
        JSONObject itemMap = new JSONObject();
        itemMap.put("invoiceType", (Object)invoiceType);
        itemMap.put("deductibleNum", (Object)0);
        itemMap.put("deductibleAmount", (Object)BigDecimal.ZERO);
        itemMap.put("deductibleTax", (Object)BigDecimal.ZERO);
        itemMap.put("unDeductibleNum", (Object)0);
        itemMap.put("unDeductibleAmount", (Object)BigDecimal.ZERO);
        itemMap.put("unDeductibleTax", (Object)BigDecimal.ZERO);
        return itemMap;
    }

    public static void getStatictMapData(Map<String, JSONObject> statisticMap, JSONObject item, String invoiceType) {
        boolean isAgriculturalProductsPurchase;
        String specialTypeMark = item.getString("specialTypeMark");
        if (SpecialTypeMarkEnum.SELFPRODUCED_AGRICULTURAL_PRODUCTS_SALES.getCode().equals(specialTypeMark) && (InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getAwsType().equals(invoiceType) || InputInvoiceTypeEnum.ORDINARY_PAPER.getAwsType().equals(invoiceType) && StringUtils.isNotBlank((String)item.getString("etaxInvoiceNo")))) {
            invoiceType = "42";
        }
        if ("1".equals(item.getString("purchaseTicket")) && "1".equals(item.getString("agricHandleStatus")) && (InputInvoiceTypeEnum.ORDINARY_ELECTRON.getAwsType().equals(invoiceType) || InputInvoiceTypeEnum.ORDINARY_PAPER.getAwsType().equals(invoiceType) && StringUtils.isBlank((String)item.getString("etaxInvoiceNo")))) {
            invoiceType = "42";
        }
        boolean bl = isAgriculturalProductsPurchase = SpecialTypeMarkEnum.AGRICULTURAL_PRODUCTS_PURCHASE.getCode().equals(specialTypeMark) && (InputInvoiceTypeEnum.ORDINARY_ELECTRON.getAwsType().equals(invoiceType) || InputInvoiceTypeEnum.ORDINARY_PAPER.getAwsType().equals(invoiceType) || InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getAwsType().equals(invoiceType));
        if (isAgriculturalProductsPurchase) {
            invoiceType = "41";
        }
        if (InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getAwsType().equals(invoiceType)) {
            invoiceType = InputInvoiceTypeEnum.SPECIAL_ELECTRON.getAwsType();
        }
        JSONObject itemMap = statisticMap.getOrDefault(invoiceType, StatisticService.getStatistJson(invoiceType));
        String deductionPurpose = item.getString("deductionPurpose");
        if ("1".equals(deductionPurpose)) {
            itemMap.put("deductibleNum", (Object)(itemMap.getInteger("deductibleNum") + 1));
            itemMap.put("deductibleAmount", (Object)itemMap.getBigDecimal("deductibleAmount").add(BigDecimalUtil.transDecimal(item.get((Object)"invoiceAmount"))));
            itemMap.put("deductibleTax", (Object)itemMap.getBigDecimal("deductibleTax").add(BigDecimalUtil.transDecimal(item.get((Object)"effectiveTaxAmount"))));
        } else {
            itemMap.put("unDeductibleNum", (Object)(itemMap.getInteger("unDeductibleNum") + 1));
            itemMap.put("unDeductibleAmount", (Object)itemMap.getBigDecimal("unDeductibleAmount").add(BigDecimalUtil.transDecimal(item.get((Object)"invoiceAmount"))));
            itemMap.put("unDeductibleTax", (Object)itemMap.getBigDecimal("unDeductibleTax").add(BigDecimalUtil.transDecimal(item.get((Object)"effectiveTaxAmount"))));
        }
    }
}

