/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.deduction.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.deduction.AsyncDeductQueryService;
import kd.imc.rim.common.invoice.deduction.AsyncDeductSelectService;
import kd.imc.rim.common.invoice.deduction.DeductServiceFactory;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.MetadataUtil;

public class AsyncSelectQueryServiceImpl
extends AsyncDeductQueryService {
    private static Log LOGGER = LogFactory.getLog(AsyncSelectQueryServiceImpl.class);

    @Override
    public JSONObject queryAsyncResult(JSONObject param) {
        this.checkParam(param);
        this.checkPageNo(param);
        this.checkPageSize(param);
        String taxNo = param.getString("taxNo");
        String taskNo = param.getString("taskNo");
        String lockKey = "rim.AsyncDeductQueryService-" + taxNo + taskNo;
        try (DLock lock = DLock.create((String)lockKey, (String)"AsyncSelectQueryServiceImpl1.lock");){
            if (lock.tryLock()) {
                JSONObject jSONObject = this.getSelectResult(param, taxNo, taskNo);
                return jSONObject;
            }
            LOGGER.info("{}\u4efb\u52a1\u53f7\u8bf7\u6c42\u9891\u7e41", (Object)taskNo);
            JSONObject jSONObject = this.getHandlingResult(ResManager.loadKDString((String)"\u4efb\u52a1\u53f7\u8bf7\u6c42\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"AsyncSelectQueryServiceImpl_0", (String)"imc-rim-common", (Object[])new Object[0]));
            return jSONObject;
        }
    }

    private JSONObject getSelectResult(JSONObject param, String taxNo, String taskNo) {
        QFilter qFilter = new QFilter("task_no", "=", (Object)taskNo).and("tax_no", "=", (Object)taxNo);
        Object[] selectLogs = BusinessDataServiceHelper.load((String)"rim_select_log", (String)"batch_no,tax_period,org,tax_no,total_num,success_num,fail_num,handle_status,create_time,update_time,bill_type,handle_num,description,task_no,async_flag,result_json,result_json_tag,operate_type,select_type,statistics_status", (QFilter[])qFilter.toArray(), (String)"create_time,id");
        if (ObjectUtils.isEmpty((Object[])selectLogs)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL.getCode(), ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u76f8\u5173\u4efb\u52a1\uff0c\u8bf7\u786e\u8ba4\u8bf7\u6c42\u7a0e\u53f7\u6216\u4efb\u52a1\u53f7\u662f\u5426\u6b63\u786e", (String)"AsyncSelectQueryServiceImpl_1", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        String operateType = selectLogs[0].getString("operate_type");
        this.checkOperateType(operateType);
        boolean isFinish = true;
        String description = null;
        ArrayList<DynamicObject> handling = new ArrayList<DynamicObject>(selectLogs.length);
        for (Object selectLog : selectLogs) {
            String handleStatus = selectLog.getString("handle_status");
            if ("1".equals(handleStatus) || "2".equals(handleStatus)) continue;
            isFinish = false;
            description = Optional.ofNullable(description).orElseGet(() -> AsyncSelectQueryServiceImpl.lambda$getSelectResult$0((DynamicObject)selectLog));
            handling.add((DynamicObject)selectLog);
        }
        if (isFinish) {
            return this.getSuccessResult((DynamicObject[])selectLogs, param.getIntValue("pageNo"), param.getIntValue("pageSize"));
        }
        this.handleSelect(handling, taxNo);
        return this.getHandlingResult(description);
    }

    private void handleSelect(List<DynamicObject> selectLogs, String taxNo) {
        String dkType = DeductionConstant.getDkType(taxNo);
        AsyncDeductSelectService selectService = DeductServiceFactory.newInstanceForAsyncDeductSelect(dkType);
        if (selectService == null) {
            LOGGER.info("{}\u7a0e\u5c40\u63a5\u53e3\u914d\u7f6e\u9519\u8bef", (Object)taxNo);
            return;
        }
        ThreadPools.executeOnceIncludeRequestContext((String)"AsyncSelectResultHandleRun", () -> selectLogs.forEach(selectService::querySelectResult));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject getSuccessResult(DynamicObject[] selectLogs, int pageNo, int pageSize) {
        JSONObject data = new JSONObject();
        data.put("pageNo", (Object)pageNo);
        data.put("pageSize", (Object)pageSize);
        JSONArray success = new JSONArray();
        JSONArray fail = new JSONArray();
        ArrayList<String> batchNos = new ArrayList<String>(8);
        int totalElement = 0;
        for (DynamicObject selectLog : selectLogs) {
            batchNos.add(selectLog.getString("batch_no"));
            totalElement += selectLog.getInt("total_num");
        }
        int totalPage = totalElement % pageSize == 0 ? totalElement / pageSize : totalElement / pageSize + 1;
        QFilter batchNoFilter = new QFilter("batch_no", "in", batchNos);
        ORM orm = ORM.create();
        try (DataSet ds = null;){
            int from = (pageNo - 1) * pageSize;
            ds = orm.queryDataSet("rim.common.AsyncSelectQueryServiceImpl", "rim_select_account", "", new QFilter[]{batchNoFilter}, "id", from, pageSize);
            DynamicObjectCollection collection = ORMUtil.toDynamicObjectCollection((DataSet)ds, (String)"rim_select_account");
            if (collection != null) {
                this.convertSelectAccount(success, fail, collection);
            }
        }
        data.put("success", (Object)success);
        data.put("fail", (Object)fail);
        data.put("currentElement", (Object)(success.size() + fail.size()));
        data.put("totalElement", (Object)totalElement);
        data.put("totalPage", (Object)totalPage);
        return ResultContant.createSuccessJSONObject(data);
    }

    private void convertSelectAccount(JSONArray success, JSONArray fail, DynamicObjectCollection selectAccounts) {
        if (!CollectionUtils.isEmpty((Collection)selectAccounts)) {
            for (DynamicObject selectAccount : selectAccounts) {
                String deductionPurpose;
                JSONObject invoice = new JSONObject();
                invoice.put("invoiceCode", (Object)DynamicObjectUtil.fieldToString(selectAccount.get("invoice_code")));
                invoice.put("invoiceNo", (Object)DynamicObjectUtil.fieldToString(selectAccount.get("invoice_no")));
                if (StringUtils.isNotEmpty((CharSequence)selectAccount.getString("electronic_no"))) {
                    invoice.put("etaxInvoiceNo", (Object)DynamicObjectUtil.fieldToString(selectAccount.get("electronic_no")));
                }
                switch (deductionPurpose = selectAccount.getString("deduction_purpose")) {
                    case "1": {
                        deductionPurpose = "1";
                        break;
                    }
                    case "4": {
                        deductionPurpose = "2";
                        break;
                    }
                    case "2": {
                        deductionPurpose = "3";
                        break;
                    }
                    default: {
                        deductionPurpose = "";
                    }
                }
                invoice.put("invoiceDate", (Object)DynamicObjectUtil.fieldToString(selectAccount.get("invoice_date")));
                String selectResult = DynamicObjectUtil.fieldToString(selectAccount.get("select_result"));
                invoice.put("selectResult", (Object)selectResult);
                String description = DynamicObjectUtil.fieldToString(selectAccount.get("description"));
                if (StringUtils.isEmpty((CharSequence)description)) {
                    description = MetadataUtil.getComboItemName("rim_select_account", "select_result", selectResult);
                }
                invoice.put("description", (Object)description);
                if ("1".equals(selectResult)) {
                    invoice.put("taxPeriod", (Object)DynamicObjectUtil.fieldToString(selectAccount.get("tax_period"), "yyyyMM"));
                    invoice.put("selectDate", (Object)DynamicObjectUtil.fieldToString(selectAccount.get("select_time")));
                    invoice.put("effectiveTaxAmount", (Object)DynamicObjectUtil.fieldToString(selectAccount.get("effective_tax_amount")));
                    invoice.put("deductionPurpose", (Object)deductionPurpose);
                    if ("2".equals(deductionPurpose)) {
                        invoice.put("notDeductibleType", (Object)DynamicObjectUtil.fieldToString(selectAccount.get("not_deductible_type")));
                    }
                    success.add((Object)invoice);
                    continue;
                }
                fail.add((Object)invoice);
            }
        }
    }

    @Override
    public void checkOperateType(String operateType) {
        boolean checkType;
        boolean bl = checkType = "1".equals(operateType) || "-1".equals(operateType) || "4".equals(operateType) || "-4".equals(operateType);
        if (!checkType) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u53d1\u7968\u52fe\u9009\u6216\u8005\u64a4\u9500\u52fe\u9009\u76f8\u5173\u4efb\u52a1\uff0c\u8bf7\u786e\u8ba4\u8bf7\u6c42\u4efb\u52a1\u53f7\u6216\u63a5\u53e3\u7c7b\u578b\u662f\u5426\u6b63\u786e", (String)"AsyncSelectQueryServiceImpl_2", (String)"imc-rim-common", (Object[])new Object[0]));
        }
    }

    @Override
    public JSONObject getResult(DynamicObject selectLog) {
        return null;
    }

    private static /* synthetic */ String lambda$getSelectResult$0(DynamicObject selectLog) {
        return selectLog.getString("description");
    }
}

