/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.deduction.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.invoice.deduction.AsyncDeductSelectService;
import kd.imc.rim.common.invoice.deduction.DeductInvoiceOperateService;
import kd.imc.rim.common.invoice.deduction.DeductService;
import kd.imc.rim.common.invoice.deduction.impl.BwDeductService;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import org.apache.commons.lang3.tuple.Pair;

public class BwAsyncDeductSelectService
extends AsyncDeductSelectService {
    private static Log LOGGER = LogFactory.getLog(BwAsyncDeductSelectService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void querySelectResult(DynamicObject selectLog) {
        JSONArray failArray;
        ArrayList<DynamicObject> updateAccountList;
        Map<String, DynamicObject> selectAccountMap;
        block32: {
            String deductionPurpose;
            JSONObject example;
            JSONObject success;
            JSONArray updateSelectInvoiceArray;
            JSONArray successArray;
            String taxNo;
            String taxPeriod;
            block33: {
                String batchNo = selectLog.getString("batch_no");
                LOGGER.info("\u5f00\u59cb\u67e5\u8be2\u5f02\u6b65\u52fe\u9009\u7ed3\u679c-\u767e\u671b:{}", (Object)batchNo);
                taxPeriod = DateUtils.format(selectLog.getDate("tax_period"), "yyyyMM");
                Long orgId = DynamicObjectUtil.getDynamicObjectLongValue(selectLog.get("org"));
                BwDeductService deductService = new BwDeductService(orgId);
                JSONObject param = new JSONObject();
                param.put("batchNo", (Object)batchNo);
                taxNo = selectLog.getString("tax_no");
                param.put("taxNo", (Object)taxNo);
                param.put("billType", (Object)selectLog.getString("bill_type"));
                param.put("operateType", (Object)selectLog.getString("operate_type"));
                String key = "rim.bwasyncdeduct-" + batchNo;
                try (DLock lock = DLock.create((String)key, (String)"BwAsyncDeductSelectService.lock");){
                    if (!lock.tryLock()) return;
                    try {
                        selectAccountMap = this.getSelectAccount(batchNo);
                        if (CollectionUtils.isEmpty(selectAccountMap)) {
                            LOGGER.info("\u6ca1\u6709\u67e5\u8be2\u5230\u52fe\u9009\u53f0\u8d26\u6570\u636e:{}-{}", (Object)taxNo, (Object)batchNo);
                            selectLog.set("description", (Object)ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u52fe\u9009\u53f0\u8d26\u6570\u636e", (String)"LqAsyncDeductSelectService_0", (String)"imc-rim-common", (Object[])new Object[0]));
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{selectLog});
                            return;
                        }
                        DynamicObject object = selectAccountMap.get(selectAccountMap.keySet().iterator().next());
                        String invoice_code = object.getString("invoice_code");
                        String invoice_no = object.getString("invoice_no");
                        param.put("invoiceCode", (Object)invoice_code);
                        param.put("invoiceNo", (Object)invoice_no);
                        param.put("electronicNo", (Object)object.getString("electronic_no"));
                        JSONObject queryResult = ((DeductService)deductService).gxInvoicesQuery(param);
                        updateAccountList = new ArrayList<DynamicObject>(8);
                        if (queryResult != null && "0000".equals(queryResult.getString("errcode"))) {
                            JSONObject data = queryResult.getJSONObject("data");
                            if (data == null) {
                                LOGGER.info("\u6ca1\u6709\u8fd4\u56dedata\u6570\u636e:{}-{}", (Object)taxNo, (Object)batchNo);
                                selectLog.set("description", (Object)ResManager.loadKDString((String)"\u6ca1\u6709\u8fd4\u56dedata\u6570\u636e", (String)"BwAsyncDeductSelectService_0", (String)"imc-rim-common", (Object[])new Object[0]));
                                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{selectLog});
                                return;
                            }
                            successArray = data.getJSONArray("success");
                            failArray = data.getJSONArray("fail");
                            JSONArray handlingArray = data.getJSONArray("handling");
                            selectLog.set("success_num", (Object)successArray.size());
                            selectLog.set("fail_num", (Object)failArray.size());
                            if (CollectionUtils.isEmpty((Collection)handlingArray)) {
                                selectLog.set("handle_status", (Object)"1");
                                selectLog.set("description", (Object)ResManager.loadKDString((String)"\u6210\u529f", (String)"BwAsyncDeductSelectService_1", (String)"imc-rim-common", (Object[])new Object[0]));
                            }
                            if (CollectionUtils.isEmpty((Collection)successArray)) {
                                if (CollectionUtils.isEmpty((Collection)failArray)) return;
                            }
                            updateSelectInvoiceArray = new JSONArray();
                            success = null;
                            example = null;
                            deductionPurpose = "";
                            if (CollectionUtils.isEmpty((Collection)successArray)) break block32;
                            break block33;
                        }
                        if (queryResult == null) return;
                        if ("6910".equals(queryResult.getString("errcode"))) return;
                        Map<String, String> serialNoStatusMap = this.getStatusMap(null, selectAccountMap, updateAccountList);
                        selectLog.set("success_num", (Object)0);
                        selectLog.set("fail_num", (Object)selectAccountMap.size());
                        selectLog.set("description", (Object)queryResult.getString("description"));
                        selectLog.set("handle_status", (Object)"2");
                        this.updateMainSaveLog(serialNoStatusMap, selectLog, updateAccountList);
                        return;
                    }
                    catch (Exception e) {
                        LOGGER.error("\u767e\u671b\u5f02\u6b65\u67e5\u8be2\u52fe\u9009\u7ed3\u679c\u5931\u8d25:" + batchNo, (Throwable)e);
                        return;
                    }
                    finally {
                        lock.unlock();
                    }
                }
            }
            for (int i = 0; i < successArray.size(); ++i) {
                String mapKey;
                DynamicObject updateAccount;
                success = successArray.getJSONObject(i);
                String invoiceCode = success.getString("invoiceCode");
                if (invoiceCode == null) {
                    invoiceCode = "";
                }
                if ((updateAccount = selectAccountMap.get(mapKey = CommonUtils.getInvoiceCodeNoGroup(invoiceCode.trim(), success.getString("invoiceNo")))) == null) continue;
                deductionPurpose = updateAccount.getString("deduction_purpose");
                Pair<String, String> deductionPurposeMap = DeductionConstant.getDeductionPurpose(deductionPurpose);
                updateAccount.set("handle_status", (Object)"1");
                updateAccount.set("select_result", (Object)success.getString("selectResult"));
                updateAccount.set("description", (Object)ResManager.loadKDString((String)"\u6210\u529f", (String)"BwAsyncDeductSelectService_1", (String)"imc-rim-common", (Object[])new Object[0]));
                updateAccount.set("update_time", (Object)new Date());
                updateAccount.set("select_time", (Object)success.getDate("selectDate"));
                updateAccountList.add(updateAccount);
                if (!StringUtils.isNotEmpty((CharSequence)updateAccount.getString("serial_no"))) continue;
                example = new JSONObject();
                example.put("serial_no", (Object)updateAccount.getString("serial_no"));
                example.put("invoice_type", (Object)DynamicObjectUtil.getDynamicObjectLongValue(updateAccount.get("invoice_type")));
                example.put("deduction_purpose", deductionPurposeMap.getRight());
                example.put("tax_period", (Object)taxPeriod);
                example.put("authenticate_flag", deductionPurposeMap.getLeft());
                example.put("select_time", (Object)success.getString("selectDate"));
                example.put("not_deductible_type", (Object)updateAccount.getString("not_deductible_type"));
                updateSelectInvoiceArray.add((Object)example);
            }
            DeductInvoiceOperateService deductInvoiceOperateService = new DeductInvoiceOperateService();
            deductInvoiceOperateService.updateBatchSelectedInvoice(updateSelectInvoiceArray, deductionPurpose, taxNo);
        }
        Map<String, String> serialNoStatusMap = this.getStatusMap(failArray, selectAccountMap, updateAccountList);
        selectLog.set("description", null);
        this.updateMainSaveLog(serialNoStatusMap, selectLog, updateAccountList);
    }

    private Map<String, String> getStatusMap(JSONArray failArray, Map<String, DynamicObject> selectAccountMap, List<DynamicObject> updateAccountList) {
        HashMap serialNoStatusMap;
        block5: {
            block4: {
                serialNoStatusMap = Maps.newHashMap();
                if (CollectionUtils.isEmpty((Collection)failArray)) break block4;
                for (int i = 0; i < failArray.size(); ++i) {
                    JSONObject fail = failArray.getJSONObject(i);
                    String mapKey = CommonUtils.getInvoiceCodeNoGroup(fail.getString("invoiceCode"), fail.getString("invoiceNo"));
                    DynamicObject updateAccount = selectAccountMap.get(mapKey);
                    if (updateAccount == null) continue;
                    updateAccount.set("handle_status", (Object)"1");
                    updateAccount.set("select_result", (Object)fail.getString("selectResult"));
                    updateAccount.set("description", (Object)this.getSelectMsg(fail));
                    updateAccount.set("update_time", (Object)new Date());
                    updateAccountList.add(updateAccount);
                    if (!StringUtils.isNotEmpty((CharSequence)updateAccount.getString("serial_no"))) continue;
                    String preAuthenticateFlag = updateAccount.getString("pre_authenticate_flag");
                    if (StringUtils.isEmpty((CharSequence)preAuthenticateFlag)) {
                        preAuthenticateFlag = "1".equals(updateAccount.getString("select_status")) ? "0" : "1";
                    }
                    serialNoStatusMap.put(updateAccount.getString("serial_no"), preAuthenticateFlag);
                }
                break block5;
            }
            if (!updateAccountList.isEmpty()) break block5;
            for (Map.Entry<String, DynamicObject> entry : selectAccountMap.entrySet()) {
                DynamicObject failAccount = entry.getValue();
                failAccount.set("handle_status", (Object)"1");
                failAccount.set("select_result", (Object)"31");
                failAccount.set("description", (Object)"");
                failAccount.set("update_time", (Object)new Date());
                updateAccountList.add(failAccount);
                if (!StringUtils.isNotEmpty((CharSequence)failAccount.getString("serial_no"))) continue;
                String preAuthenticateFlag = failAccount.getString("pre_authenticate_flag");
                if (StringUtils.isEmpty((CharSequence)preAuthenticateFlag)) {
                    preAuthenticateFlag = "1".equals(failAccount.getString("select_status")) ? "0" : "1";
                }
                serialNoStatusMap.put(failAccount.getString("serial_no"), preAuthenticateFlag);
            }
        }
        return serialNoStatusMap;
    }
}

