/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.deduction.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.constant.StatisticsStatusEnum;
import kd.imc.rim.common.invoice.deduction.DeductService;
import kd.imc.rim.common.utils.AisinoConvertUtil;
import kd.imc.rim.common.utils.BwService;
import kd.imc.rim.common.utils.DateUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class BwDeductService
extends DeductService {
    private static Log LOGGER = LogFactory.getLog(BwDeductService.class);

    public BwDeductService(Long orgId) {
        this.orgId = orgId;
    }

    @Override
    public JSONObject queryTaxperiod(String taxNo) {
        JSONObject param = new JSONObject();
        param.put("tax_no", (Object)taxNo);
        JSONObject result = this.postBwRequest("InputTaxperiodQuery", JSONObject.toJSONString((Object)param));
        if (result == null) {
            return ResultContant.createJSONObject("0206", ResManager.loadKDString((String)"\u63a5\u53e3\u8c03\u7528\u51fa\u9519", (String)"BwDeductService_0", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        if (result.getBoolean("success").booleanValue()) {
            JSONObject model = result.getJSONObject("model");
            String year = model.getString("period_year");
            String month = model.getString("period_month");
            String skssq = year + month;
            JSONObject data = new JSONObject();
            data.put("skssq", (Object)skssq);
            return ResultContant.createSuccessJSONObject(data);
        }
        return ResultContant.createJSONObject(result.getJSONObject("message").getString("error_code"), result.getJSONObject("message").getString("error_message"));
    }

    @Override
    public JSONObject queryInvoices(JSONObject bodyJson) {
        return ResultContant.createJSONObject("0001", ResManager.loadKDString((String)"\u767e\u671b\u6682\u4e0d\u652f\u6301\u8be5\u529f\u80fd\uff0c\u7531\u5b9a\u65f6\u4efb\u52a1\u5b9a\u65f6\u83b7\u53d6\u589e\u91cf\u6570\u636e", (String)"BwDeductService_1", (String)"imc-rim-common", (Object[])new Object[0]));
    }

    @Override
    public JSONObject getStatisticTable(JSONObject bodyJson) {
        String taxNo = bodyJson.getString("taxNo");
        if (StringUtils.isBlank((String)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        String period = this.syncGetTaxperiod(taxNo);
        if (StringUtils.isEmpty((String)period)) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u52fe\u9009\u5931\u8d25:\u83b7\u53d6\u5f53\u524d\u7a0e\u671f\u5931\u8d25", (String)"BwDeductService_2", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        JSONObject param = new JSONObject();
        param.put("period", (Object)period);
        param.put("buyer_tax_no", (Object)taxNo);
        JSONObject resultJson = this.postBwRequest("InputDeductionGetstatistatus", param.toJSONString());
        if (resultJson == null) {
            return ResultContant.createJSONObject("0206", ResManager.loadKDString((String)"\u63a5\u53e3\u8c03\u7528\u51fa\u9519", (String)"BwDeductService_0", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        LOGGER.info("\u767e\u671b\u67e5\u8be2\u7edf\u8ba1\u8868\u8fd4\u56de:{}-{}", (Object)taxNo, (Object)resultJson);
        if (resultJson.getBoolean("success").booleanValue()) {
            JSONObject data = resultJson.getJSONObject("model");
            String errcode = "0000";
            String description = ResManager.loadKDString((String)"\u7edf\u8ba1\u6210\u529f", (String)"BwDeductService_3", (String)"imc-rim-common", (Object[])new Object[0]);
            if (data != null) {
                JSONObject standardData = new JSONObject();
                String taxPeriod = data.getString("period");
                standardData.put("taxPeriod", (Object)taxPeriod);
                String createTjbbStatus = "";
                String updateTime = "";
                boolean isAllowQxTj = true;
                boolean isAllowQrtj = false;
                boolean isAllowGxInvoice = true;
                boolean allowChangeSsqBySeason = false;
                String tjbz = data.getString("statstatus");
                if ("0".equals(tjbz)) {
                    createTjbbStatus = "01";
                    isAllowQxTj = false;
                } else if ("1".equals(tjbz) || "4".equals(tjbz) || "9".equals(tjbz) || "10".equals(tjbz)) {
                    createTjbbStatus = "21";
                    isAllowQrtj = false;
                    isAllowGxInvoice = false;
                    isAllowQxTj = false;
                } else if ("2".equals(tjbz)) {
                    createTjbbStatus = "02";
                    isAllowQrtj = true;
                    isAllowGxInvoice = false;
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMM");
                    String format = dateFormat.format(new Date());
                    if (format.equals(taxPeriod)) {
                        createTjbbStatus = StatisticsStatusEnum.PRE_CREATED_AGAIN.getCode();
                        isAllowQrtj = false;
                        isAllowGxInvoice = false;
                    }
                } else if ("5".equals(tjbz)) {
                    createTjbbStatus = StatisticsStatusEnum.CONFIRMED.getCode();
                    isAllowQrtj = false;
                    isAllowGxInvoice = false;
                    isAllowQxTj = true;
                }
                standardData.put("allowChangeSsqBySeason", (Object)allowChangeSsqBySeason);
                standardData.put("createTjbbStatus", (Object)createTjbbStatus);
                standardData.put("isAllowQxTj", (Object)isAllowQxTj);
                standardData.put("isAllowQrtj", (Object)isAllowQrtj);
                standardData.put("isAllowGxInvoice", (Object)isAllowGxInvoice);
                standardData.put("updateTime", (Object)updateTime);
                JSONArray statList = data.getJSONArray("stat_list");
                if (statList != null) {
                    JSONArray tjInfoArr = new JSONArray();
                    for (int i = 0; i < statList.size(); ++i) {
                        JSONObject detail = statList.getJSONObject(i);
                        JSONObject obj = new JSONObject();
                        String invoiceType = BwDeductService.convertAwsType(detail.getString("invoice_type"));
                        if (StringUtils.isEmpty((String)invoiceType)) continue;
                        obj.put("invoiceType", (Object)invoiceType);
                        obj.put("deductibleNum", (Object)detail.getInteger("invoice_count"));
                        obj.put("deductibleAmount", (Object)detail.getBigDecimal("invoice_account"));
                        obj.put("deductibleTax", (Object)detail.getBigDecimal("invoice_tax_effective"));
                        obj.put("unDeductibleNum", (Object)detail.getInteger("invoice_count_nondeductible"));
                        obj.put("unDeductibleAmount", (Object)detail.getBigDecimal("invoice_account_nondeductible"));
                        obj.put("unDeductibleTax", (Object)detail.getBigDecimal("invoice_tax_effective_nondeductible"));
                        tjInfoArr.add((Object)obj);
                    }
                    standardData.put("tjxx", (Object)tjInfoArr);
                    standardData.put("tjInfoArr", (Object)tjInfoArr);
                }
                resultJson.put("errcode", (Object)errcode);
                resultJson.put("description", (Object)description);
                resultJson.put("data", (Object)standardData);
            }
            return resultJson;
        }
        return ResultContant.createJSONObject(resultJson.getJSONObject("message").getString("error_code"), resultJson.getJSONObject("message").getString("error_message"));
    }

    private static String convertAwsType(String invoice_type) {
        switch (invoice_type) {
            case "01": {
                return "4";
            }
            case "03": {
                return "12";
            }
            case "08": {
                return "2";
            }
            case "14": {
                return "15";
            }
            case "17": {
                return "21";
            }
            case "31": {
                return "27";
            }
        }
        return "";
    }

    @Override
    public JSONObject createStatisticTable(JSONObject bodyJson) {
        if (ObjectUtils.isEmpty((Object)bodyJson)) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL);
        }
        String taxNo = bodyJson.getString("taxNo");
        if (StringUtils.isBlank((String)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        String taxPeriod = this.syncGetTaxperiod(taxNo);
        if (StringUtils.isEmpty((String)taxPeriod)) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u52fe\u9009\u5931\u8d25:\u83b7\u53d6\u5f53\u524d\u7a0e\u671f\u5931\u8d25", (String)"BwDeductService_2", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        JSONObject param = new JSONObject();
        String task_type = bodyJson.getString("task_type");
        if (StringUtils.isEmpty((String)task_type)) {
            task_type = "1";
        }
        param.put("task_type", (Object)task_type);
        JSONArray taxNoInfos = new JSONArray();
        JSONObject info = new JSONObject();
        info.put("buyer_tax_no", (Object)taxNo);
        info.put("period", (Object)taxPeriod);
        taxNoInfos.add((Object)info);
        param.put("tax_no_infos", (Object)taxNoInfos);
        JSONObject resultJson = this.postBwRequest("InputDeductionRstatcreateorcancel", param.toJSONString());
        if (resultJson == null) {
            return ResultContant.createJSONObject("0206", ResManager.loadKDString((String)"\u63a5\u53e3\u8c03\u7528\u51fa\u9519", (String)"BwDeductService_0", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        LOGGER.info("\u767e\u671b\u751f\u6210/\u64a4\u9500(\u5b9e\u65f6)\u7edf\u8ba1\u8868\u8fd4\u56de:{}-{}", (Object)taxNo, (Object)resultJson);
        if (resultJson.getBoolean("success").booleanValue()) {
            JSONArray modelArray = resultJson.getJSONArray("model");
            if (modelArray != null) {
                JSONObject data = modelArray.getJSONObject(0);
                JSONObject standardData = new JSONObject();
                String period = data.getString("period");
                standardData.put("taxPeriod", (Object)period);
                String createTjbbStatus = "";
                String updateTime = "";
                boolean isAllowQxTj = true;
                boolean isAllowQrtj = false;
                boolean isAllowGxInvoice = true;
                boolean allowChangeSsqBySeason = false;
                String tjbz = data.getString("result_code");
                if ("0".equals(tjbz) || "2".equals(tjbz)) {
                    createTjbbStatus = "21";
                    isAllowQrtj = false;
                    isAllowGxInvoice = false;
                    isAllowQxTj = false;
                } else if ("1".equals(tjbz) || "3".equals(tjbz) || "4".equals(tjbz)) {
                    createTjbbStatus = "02";
                    isAllowQrtj = true;
                    isAllowGxInvoice = false;
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMM");
                    String format = dateFormat.format(new Date());
                    if (format.equals(taxPeriod)) {
                        createTjbbStatus = StatisticsStatusEnum.PRE_CREATED_AGAIN.getCode();
                        isAllowQrtj = false;
                        isAllowGxInvoice = false;
                    }
                } else {
                    createTjbbStatus = "01";
                    isAllowQxTj = false;
                }
                standardData.put("allowChangeSsqBySeason", (Object)allowChangeSsqBySeason);
                standardData.put("createTjbbStatus", (Object)createTjbbStatus);
                standardData.put("isAllowQxTj", (Object)isAllowQxTj);
                standardData.put("isAllowQrtj", (Object)isAllowQrtj);
                standardData.put("isAllowGxInvoice", (Object)isAllowGxInvoice);
                standardData.put("updateTime", (Object)updateTime);
                JSONObject param2 = new JSONObject();
                param2.put("taxNo", (Object)taxNo);
                JSONObject statisticTable = this.getStatisticTable(param2);
                JSONObject tabelData = statisticTable.getJSONObject("data");
                standardData.put("tjxx", tabelData.get((Object)"tjxx"));
                standardData.put("tjInfoArr", tabelData.get((Object)"tjInfoArr"));
                this.putErrCode(tjbz, resultJson);
                resultJson.put("data", (Object)standardData);
            }
            return resultJson;
        }
        return ResultContant.createJSONObject(resultJson.getJSONObject("message").getString("error_code"), resultJson.getJSONObject("message").getString("error_message"));
    }

    private void putErrCode(String tjbz, JSONObject resultJson) {
        String errcode = "0000";
        String description = ResManager.loadKDString((String)"\u7edf\u8ba1\u6210\u529f", (String)"BwDeductService_3", (String)"imc-rim-common", (Object[])new Object[0]);
        if ("5".equals(tjbz)) {
            errcode = "0200";
            description = ResManager.loadKDString((String)"\u7533\u8bf7\u7edf\u8ba1\u6708\u4efd\u4e0d\u7b26", (String)"BwDeductService_4", (String)"imc-rim-common", (Object[])new Object[0]);
        } else if ("6".equals(tjbz)) {
            errcode = "0201";
            description = ResManager.loadKDString((String)"\u4e0d\u7b26\u5408\u7533\u8bf7\u751f\u6210\u62b5\u6263\u7edf\u8ba1\u62a5\u8868\u6761\u4ef6", (String)"BwDeductService_5", (String)"imc-rim-common", (Object[])new Object[0]);
        } else if ("7".equals(tjbz)) {
            errcode = "0203";
            description = ResManager.loadKDString((String)"\u672a\u7edf\u8ba1\uff0c\u4e0d\u9700\u8981\u64a4\u9500", (String)"BwDeductService_6", (String)"imc-rim-common", (Object[])new Object[0]);
        } else if ("8".equals(tjbz)) {
            errcode = "0204";
            description = ResManager.loadKDString((String)"\u5176\u4ed6\u5f02\u5e38", (String)"BwDeductService_7", (String)"imc-rim-common", (Object[])new Object[0]);
        } else if ("9".equals(tjbz)) {
            errcode = "0205";
            description = ResManager.loadKDString((String)"\u4e0d\u7b26\u5408\u7edf\u8ba1\u65e5\u671f\u8303\u56f4\uff08\u6bcf\u65e5\u4e00\u53f7\u5230\u7533\u62a5\u524d\uff09", (String)"BwDeductService_8", (String)"imc-rim-common", (Object[])new Object[0]);
        } else if ("10".equals(tjbz)) {
            errcode = "0206";
            description = ResManager.loadKDString((String)"\u4e0d\u7b26\u5408\u64a4\u9500\u7533\u62a5\u6761\u4ef6\uff08\u5df2\u7533\u62a5\u7ed3\u675f\uff0c\u9700\u8981\u5148\u64a4\u9500\u7533\u62a5\uff09", (String)"BwDeductService_9", (String)"imc-rim-common", (Object[])new Object[0]);
        } else if ("13".equals(tjbz)) {
            errcode = "0207";
            description = ResManager.loadKDString((String)"\u767b\u5f55\u7a0e\u5c40\u5931\u8d25", (String)"BwDeductService_10", (String)"imc-rim-common", (Object[])new Object[0]);
        } else if ("41".equals(tjbz)) {
            errcode = "0208";
            description = ResManager.loadKDString((String)"\u52fe\u9009\u4efb\u52a1\u6267\u884c\u4e2d", (String)"BwDeductService_11", (String)"imc-rim-common", (Object[])new Object[0]);
        } else if ("43".equals(tjbz)) {
            errcode = "0209";
            description = ResManager.loadKDString((String)"\u786e\u8ba4\u4efb\u52a1\u4e2d", (String)"BwDeductService_12", (String)"imc-rim-common", (Object[])new Object[0]);
        }
        resultJson.put("errcode", (Object)errcode);
        resultJson.put("description", (Object)description);
    }

    @Override
    public JSONObject cancelStatisticTable(JSONObject bodyJson) {
        if (ObjectUtils.isEmpty((Object)bodyJson)) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL);
        }
        String taxNo = bodyJson.getString("taxNo");
        if (StringUtils.isBlank((String)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        String tjbbStatus = bodyJson.getString("tjbbStatus");
        bodyJson.put("task_type", (Object)"2");
        if (StatisticsStatusEnum.CONFIRMED.getCode().equals(tjbbStatus)) {
            return this.confirmStatisticTable(bodyJson);
        }
        return this.createStatisticTable(bodyJson);
    }

    @Override
    public JSONObject confirmStatisticTable(JSONObject paramJson) {
        if (ObjectUtils.isEmpty((Object)paramJson)) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL);
        }
        String taxNo = paramJson.getString("taxNo");
        if (StringUtils.isBlank((String)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        String taxPeriod = this.syncGetTaxperiod(taxNo);
        if (StringUtils.isEmpty((String)taxPeriod)) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u52fe\u9009\u5931\u8d25:\u83b7\u53d6\u5f53\u524d\u7a0e\u671f\u5931\u8d25", (String)"BwDeductService_2", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        JSONObject param = new JSONObject();
        String task_type = paramJson.getString("task_type");
        if (StringUtils.isEmpty((String)task_type)) {
            task_type = "1";
        }
        param.put("task_type", (Object)task_type);
        JSONArray taxNoInfos = new JSONArray();
        JSONObject info = new JSONObject();
        info.put("buyer_tax_no", (Object)taxNo);
        info.put("period", (Object)taxPeriod);
        taxNoInfos.add((Object)info);
        param.put("tax_no_infos", (Object)taxNoInfos);
        JSONObject result = this.postBwRequest("InputDeductionRstatconfirmorcancel", param.toJSONString());
        if (result == null) {
            return ResultContant.createJSONObject("0206", ResManager.loadKDString((String)"\u63a5\u53e3\u8c03\u7528\u51fa\u9519", (String)"BwDeductService_0", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        if (result.getBoolean("success").booleanValue()) {
            String resultCode = result.getString("result_code");
            boolean isFinish = false;
            String createTjbbStatus = "";
            if ("1".equals(resultCode) || "2".equals(resultCode) || "3".equals(resultCode)) {
                createTjbbStatus = "05";
                isFinish = true;
            } else if ("0".equals(resultCode)) {
                createTjbbStatus = "24";
            }
            JSONObject rtnData = new JSONObject();
            rtnData.put("createTjbbStatus", (Object)createTjbbStatus);
            rtnData.put("isFinish", (Object)isFinish);
            this.putErrCodeConfirm(resultCode, result);
            result.put("data", (Object)rtnData);
            return result;
        }
        return ResultContant.createJSONObject(result.getJSONObject("message").getString("error_code"), result.getJSONObject("message").getString("error_message"));
    }

    private void putErrCodeConfirm(String resultCode, JSONObject result) {
        String errcode = "0000";
        String desc = ResManager.loadKDString((String)"\u8ba4\u8bc1\u6210\u529f", (String)"BwDeductService_13", (String)"imc-rim-common", (Object[])new Object[0]);
        if ("4".equals(resultCode)) {
            errcode = "0203";
            desc = ResManager.loadKDString((String)"\u7533\u8bf7\u786e\u8ba4\u6708\u4efd\u4e0d\u7b26", (String)"BwDeductService_14", (String)"imc-rim-common", (Object[])new Object[0]);
        } else if ("5".equals(resultCode)) {
            errcode = "0204";
            desc = ResManager.loadKDString((String)"\u7a0e\u53f7\u4e0d\u5b58\u5728", (String)"BwDeductService_15", (String)"imc-rim-common", (Object[])new Object[0]);
        } else if ("6".equals(resultCode)) {
            errcode = "0205";
            desc = ResManager.loadKDString((String)"\u672a\u7533\u8bf7\u7edf\u8ba1", (String)"BwDeductService_16", (String)"imc-rim-common", (Object[])new Object[0]);
        } else if ("7".equals(resultCode)) {
            errcode = "0206";
            desc = ResManager.loadKDString((String)"\u7edf\u8ba1\u65f6\u95f4\u4e0d\u7b26", (String)"BwDeductService_17", (String)"imc-rim-common", (Object[])new Object[0]);
        } else if ("8".equals(resultCode)) {
            errcode = "0207";
            desc = ResManager.loadKDString((String)"\u5176\u4ed6\u5f02\u5e38", (String)"BwDeductService_7", (String)"imc-rim-common", (Object[])new Object[0]);
        } else if ("9".equals(resultCode)) {
            errcode = "0208";
            desc = ResManager.loadKDString((String)"\u4e0d\u7b26\u5408\u63d0\u4ea4\u786e\u8ba4\u7533\u62a5\u6761\u4ef6\uff08\u7edf\u8ba1\u65e5\u671f\u4e0d\u5728\u7533\u62a5\u671f\u5185\uff09", (String)"BwDeductService_18", (String)"imc-rim-common", (Object[])new Object[0]);
        } else if ("10".equals(resultCode)) {
            errcode = "0209";
            desc = ResManager.loadKDString((String)"\u672a\u7edf\u8ba1\u6216\u8005\u8d85\u671f\uff0c\u4e0d\u80fd\u64a4\u9500", (String)"BwDeductService_19", (String)"imc-rim-common", (Object[])new Object[0]);
        } else if ("11".equals(resultCode)) {
            errcode = "0210";
            desc = ResManager.loadKDString((String)"\u62b5\u6263\u7edf\u8ba1\u786e\u8ba4\u5bc6\u7801\u672a\u8bbe\u7f6e\u6216\u9519\u8bef", (String)"BwDeductService_20", (String)"imc-rim-common", (Object[])new Object[0]);
        } else if ("13".equals(resultCode)) {
            errcode = "0211";
            desc = ResManager.loadKDString((String)"\u767b\u5f55\u7a0e\u5c40\u5931\u8d25", (String)"BwDeductService_10", (String)"imc-rim-common", (Object[])new Object[0]);
        } else if ("41".equals(resultCode)) {
            errcode = "0212";
            desc = ResManager.loadKDString((String)"\u52fe\u9009\u4efb\u52a1\u6267\u884c\u4e2d", (String)"BwDeductService_11", (String)"imc-rim-common", (Object[])new Object[0]);
        } else if ("42".equals(resultCode)) {
            errcode = "0213";
            desc = ResManager.loadKDString((String)"\u7edf\u8ba1\u4efb\u52a1\u4e2d", (String)"BwDeductService_21", (String)"imc-rim-common", (Object[])new Object[0]);
        }
        result.put("errcode", (Object)errcode);
        result.put("description", (Object)desc);
    }

    @Override
    public JSONObject gxInvoices(JSONObject bodyJson) {
        Map<String, Map<String, Object>> methodCodeMap;
        String deductibleMode = bodyJson.getString("deductibleMode");
        if (!"1".equals(deductibleMode) && !"-1".equals(deductibleMode)) {
            return ResultContant.createJSONObject("0002", ResManager.loadKDString((String)"\u767e\u671b\u6682\u4e0d\u652f\u6301\u4e0d\u62b5\u6263\u52fe\u9009\u548c\u9000\u7a0e\u52fe\u9009", (String)"BwDeductService_22", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        String taxNo = bodyJson.getString("taxNo");
        if (StringUtils.isBlank((String)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        String taxPeriod = this.syncGetTaxperiod(taxNo);
        if (StringUtils.isEmpty((String)taxPeriod)) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u52fe\u9009\u5931\u8d25:\u83b7\u53d6\u5f53\u524d\u7a0e\u671f\u5931\u8d25", (String)"BwDeductService_2", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        bodyJson.put("taxPeriod", (Object)taxPeriod);
        JSONArray invoices = bodyJson.getJSONArray("invoices");
        if (CollectionUtils.isEmpty((Collection)invoices)) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"BwDeductService_23", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        HashMap param = Maps.newHashMap();
        param.put("tax_no", taxNo);
        param.put("period", taxPeriod);
        String billType = bodyJson.getString("billType");
        if ("1".equals(billType)) {
            methodCodeMap = this.getBwHgDeductMethod(invoices, deductibleMode, taxNo);
        } else {
            if ("2".equals(billType)) {
                return ResultContant.createJSONObject(ErrorType.DKDJ_NONSUPPORT);
            }
            methodCodeMap = this.getBwDeductMethod(invoices, deductibleMode, taxNo);
        }
        if (methodCodeMap == null) {
            return ResultContant.createJSONObject("0203", ResManager.loadKDString((String)"\u767e\u671b\u6682\u4e0d\u652f\u6301\u8be5\u529f\u80fd", (String)"BwDeductService_24", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        Set<String> keySet = methodCodeMap.keySet();
        String methodCode = keySet.iterator().next();
        Map<String, Object> businessMap = methodCodeMap.entrySet().iterator().next().getValue();
        param.putAll(businessMap);
        JSONObject result = this.postBwRequest(methodCode, JSONObject.toJSONString((Object)param));
        if (result == null) {
            return ResultContant.createJSONObject("0206", ResManager.loadKDString((String)"\u63a5\u53e3\u8c03\u7528\u51fa\u9519", (String)"BwDeductService_0", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        LOGGER.info("\u767e\u671b-\u6279\u91cf\u4e0a\u4f20\u62b5\u6263\uff1a{}-{}", (Object)taxNo, (Object)result);
        if (result.getBoolean("success").booleanValue()) {
            JSONObject model = result.getJSONObject("model");
            JSONArray taskList = model.getJSONArray("task_list");
            return ResultContant.createSuccessJSONObject(taskList);
        }
        return ResultContant.createJSONObject(result.getJSONObject("message").getString("error_code"), result.getJSONObject("message").getString("error_message"));
    }

    private Map<String, Map<String, Object>> getBwDeductMethod(JSONArray invoices, String deductibleMode, String taxNo) {
        HashMap param = Maps.newHashMap();
        Pair<String, String> deductionPurposeMap = DeductionConstant.getDeductionPurpose(deductibleMode);
        String yt = (String)deductionPurposeMap.getRight();
        switch (deductibleMode) {
            case "1": {
                Map<String, Object> applyParam = this.getApplyParam(invoices, Boolean.TRUE, taxNo);
                param.put("InputDeductionApply", applyParam);
                return param;
            }
            case "-1": {
                Map<String, Object> applyCancelParam = this.getApplyParam(invoices, Boolean.FALSE, taxNo);
                param.put("InputDeductionCancel", applyCancelParam);
                return param;
            }
            case "4": {
                param.put("InputDeductionApplyorcancelnon", this.getUnselectApplyParam(invoices, Boolean.TRUE, taxNo, yt));
                return param;
            }
            case "-4": {
                param.put("InputDeductionApplyorcancelnon", this.getUnselectApplyParam(invoices, Boolean.FALSE, taxNo, yt));
                return param;
            }
        }
        return null;
    }

    private Map<String, Object> getUnselectApplyParam(JSONArray invoices, Boolean applyOrCancel, String taxNo, String yt) {
        HashMap detail = Maps.newHashMap();
        JSONArray array = new JSONArray();
        for (int i = 0; i < invoices.size(); ++i) {
            JSONObject invoice = invoices.getJSONObject(i);
            JSONObject info = new JSONObject();
            info.put("purchaser_tax_no", (Object)taxNo);
            Long invoiceType = invoice.getLong("invoiceTypeLong");
            if (InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode().equals(invoiceType) || InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(invoiceType)) {
                info.put("e_invoice_number", (Object)invoice.getString("invoiceNo"));
            } else {
                info.put("invoice_code", (Object)invoice.getString("invoiceCode"));
                info.put("invoice_number", (Object)invoice.getString("invoiceNo"));
            }
            if (applyOrCancel.booleanValue()) {
                info.put("certification_type", (Object)"4");
            } else {
                info.put("certification_type", (Object)"6");
            }
            if ("2".equals(yt)) {
                String notDeductibleType = invoice.getString("notDeductibleType");
                info.put("reason", (Object)notDeductibleType);
                if ("5".equals(notDeductibleType)) {
                    info.put("reason_remark", (Object)ResManager.loadKDString((String)"\u5176\u4ed6", (String)"BwDeductService_25", (String)"imc-rim-common", (Object[])new Object[0]));
                }
            }
            array.add((Object)info);
        }
        detail.put("invoice_list", array);
        return detail;
    }

    private Map<String, Map<String, Object>> getBwHgDeductMethod(JSONArray invoices, String deductibleMode, String taxNo) {
        HashMap param = Maps.newHashMap();
        switch (deductibleMode) {
            case "1": {
                param.put("InputDeductionPoivapply", this.getHgApplyParam(invoices, taxNo));
                return param;
            }
            case "-1": {
                param.put("InputDeductionPoivapplycancel", this.getHgApplyParam(invoices, taxNo));
                return param;
            }
        }
        return null;
    }

    private Map<String, Object> getHgApplyParam(JSONArray invoices, String taxNo) {
        HashMap detail = Maps.newHashMap();
        JSONArray array = new JSONArray();
        for (int i = 0; i < invoices.size(); ++i) {
            JSONObject invoice = invoices.getJSONObject(i);
            JSONObject info = new JSONObject();
            info.put("buyer_taxno", (Object)taxNo);
            info.put("payment_certno", (Object)invoice.getString("invoiceNo"));
            array.add((Object)info);
        }
        detail.put("deduct_list", array);
        return detail;
    }

    private Map<String, Object> getApplyParam(JSONArray invoices, Boolean applyOrCancel, String taxNo) {
        HashMap detail = Maps.newHashMap();
        JSONArray array = new JSONArray();
        for (int i = 0; i < invoices.size(); ++i) {
            JSONObject invoice = invoices.getJSONObject(i);
            String awsInvoiceType = invoice.getString("invoiceType");
            Long invoiceType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(awsInvoiceType);
            JSONObject info = new JSONObject();
            info.put("purchaser_tax_no", (Object)taxNo);
            info.put("invoice_code", (Object)invoice.getString("invoiceCode"));
            info.put("invoice_number", (Object)invoice.getString("invoiceNo"));
            if (applyOrCancel.booleanValue()) {
                info.put("certification_type", (Object)"1");
            } else {
                info.put("certification_type", (Object)"5");
            }
            if (InputInvoiceTypeEnum.ORDINARY_PAPER.getCode().equals(invoiceType) || InputInvoiceTypeEnum.SPECIAL_PAPER.getCode().equals(invoiceType)) {
                info.put("e_invoice_number", (Object)invoice.getString("electronic_no"));
            }
            array.add((Object)info);
        }
        detail.put("invoice_list", array);
        return detail;
    }

    @Override
    public JSONObject gxInvoicesQuery(JSONObject bodyJson) {
        String taxNo = bodyJson.getString("taxNo");
        if (StringUtils.isBlank((String)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        String batchNo = bodyJson.getString("batchNo");
        String billType = bodyJson.getString("billType");
        String operateType = bodyJson.getString("operateType");
        JSONObject param = new JSONObject();
        param.put("tax_no", (Object)taxNo);
        param.put("task_no", (Object)batchNo);
        String methodCode = this.getMethodCode(operateType, billType);
        if (StringUtils.isEmpty((String)methodCode)) {
            return ResultContant.createJSONObject("0204", ResManager.loadKDString((String)"\u767e\u671b\u6682\u4e0d\u652f\u6301\u8be5\u529f\u80fd", (String)"BwDeductService_24", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        if ("1".equals(billType)) {
            param.put("payment_certno", (Object)bodyJson.getString("invoiceNo"));
        } else {
            String invoiceNo = bodyJson.getString("invoiceNo");
            param.put("invoice_code", (Object)bodyJson.getString("invoiceCode"));
            param.put("invoice_number", (Object)invoiceNo);
            param.put("e_invoice_number", (Object)bodyJson.getString("electronicNo"));
        }
        JSONObject bwResult = this.postBwRequest(methodCode, JSONObject.toJSONString((Object)param));
        if (bwResult == null) {
            return ResultContant.createJSONObject("0206", ResManager.loadKDString((String)"\u63a5\u53e3\u8c03\u7528\u51fa\u9519", (String)"BwDeductService_0", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        LOGGER.info("\u767e\u671b-\u67e5\u8be2\u62b5\u6263\u52fe\u9009\u5904\u7406\u7ed3\u679c\uff1a{}-{}", (Object)taxNo, (Object)bwResult);
        if (bwResult.getBoolean("success").booleanValue()) {
            JSONArray success = new JSONArray();
            JSONArray fail = new JSONArray();
            JSONArray handling = new JSONArray();
            JSONObject invoicesData = bwResult.getJSONObject("model");
            if (invoicesData == null) {
                return bwResult;
            }
            JSONObject invoiceParam = new JSONObject();
            invoiceParam.put("invoiceCode", invoicesData.get((Object)"invoice_code"));
            invoiceParam.put("invoiceNo", invoicesData.get((Object)"invoice_number"));
            invoiceParam.put("selectDate", invoicesData.get((Object)"deductible_date"));
            String selectResult = "";
            String cljg = invoicesData.getString("result_code");
            selectResult = "0".equals(cljg) ? "35" : ("15".equals(cljg) ? "16" : ("20".equals(cljg) ? "18" : ("21".equals(cljg) ? "20" : ("6".equals(cljg) || "9".equals(cljg) || "29".equals(cljg) || "41".equals(cljg) || "50".equals(cljg) || "51".equals(cljg) || "52".equals(cljg) || "8".equals(cljg) ? "34" : cljg))));
            invoiceParam.put("selectResult", (Object)selectResult);
            if ("1".equals(selectResult)) {
                success.add((Object)invoiceParam);
            } else if ("35".equals(selectResult)) {
                handling.add((Object)invoiceParam);
            } else {
                fail.add((Object)invoiceParam);
            }
            JSONObject data = new JSONObject();
            data.put("success", (Object)success);
            data.put("fail", (Object)fail);
            data.put("handling", (Object)handling);
            JSONObject result = ResultContant.createSuccessJSONObject(data);
            LOGGER.info("BW-gxInvoicesQuery result :{}-{}", (Object)taxNo, (Object)result);
            return result;
        }
        return ResultContant.createJSONObject(bwResult.getJSONObject("message").getString("error_code"), bwResult.getJSONObject("message").getString("error_message"));
    }

    private String getMethodCode(String operateType, String billType) {
        String methodCode = "";
        switch (operateType) {
            case "-1": {
                if ("1".equals(billType)) {
                    methodCode = "InputDeductionPoivresult";
                    break;
                }
                methodCode = "InputDeductionCancelresult";
                break;
            }
            case "1": {
                if ("1".equals(billType)) {
                    methodCode = "InputDeductionPoivcancelresult";
                    break;
                }
                methodCode = "InputDeductionApplyresult";
                break;
            }
            case "4": 
            case "-4": {
                if ("1".equals(billType)) break;
                methodCode = "InputDeductionApplyorcancelnonresult";
            }
        }
        return methodCode;
    }

    @Override
    public JSONObject queryHistoryStatistics(String taxNo, String taxPeriod, boolean queryStatistics) {
        if (StringUtils.isBlank((String)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        if (StringUtils.isBlank((String)taxPeriod)) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL);
        }
        JSONObject param = new JSONObject();
        param.put("buyer_taxno", (Object)taxNo);
        param.put("income_month", (Object)taxPeriod.replaceAll("-", ""));
        JSONArray invoices = new JSONArray();
        JSONObject vatInfo = this.postFunction("InputInvoiceVatdeductionlist", param, invoices);
        JSONArray customs = new JSONArray();
        JSONObject customInfo = this.postFunction("InputInvoicePoivdeductionlist", param, customs);
        JSONArray invoiceData = vatInfo.getJSONArray("data");
        JSONArray customData = customInfo.getJSONArray("data");
        JSONArray allData = new JSONArray();
        if (invoiceData != null) {
            allData.addAll((Collection)invoiceData);
        }
        if (customData != null) {
            allData.addAll((Collection)customData);
        }
        LOGGER.info("\u767e\u671b\u5386\u53f2\u5c5e\u671f\u6c47\u603b\u7ed3\u679c\uff1a{}", (Object)allData);
        for (int i = 0; i < allData.size(); ++i) {
            JSONObject jsonObject = allData.getJSONObject(i);
            jsonObject.put("taxPeriod", (Object)taxPeriod);
            JSONObject invoice = BwDeductService.convertInvoiceMainInfo(jsonObject);
            allData.set(i, (Object)invoice);
        }
        return ResultContant.createSuccessJSONObject(allData);
    }

    @Override
    public JSONObject queryHistoryStatistics(String taxNo, String taxPeriod) {
        return this.queryHistoryStatistics(taxNo, taxPeriod, false);
    }

    private JSONObject postFunction(String methodCode, JSONObject param, JSONArray invoices) {
        JSONObject result = this.postBwRequest(methodCode, JSONObject.toJSONString((Object)param));
        if (result == null) {
            return ResultContant.createJSONObject("0206", ResManager.loadKDString((String)"\u63a5\u53e3\u8c03\u7528\u51fa\u9519", (String)"BwDeductService_0", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        LOGGER.info("methodCode:{}, param:{},result:{}", new Object[]{methodCode, param, result});
        if (result.getBoolean("success").booleanValue()) {
            JSONObject model = result.getJSONObject("model");
            if (model == null) {
                return ResultContant.createSuccessJSONObject(invoices);
            }
            JSONArray invoice_list = model.getJSONArray("invoice_list");
            if (invoice_list == null) {
                return ResultContant.createSuccessJSONObject(invoices);
            }
            invoices.addAll((Collection)invoice_list);
            if (model.getBoolean("is_next").booleanValue()) {
                String taskNo = model.getString("task_no");
                param.put("task_no", (Object)taskNo);
                this.postFunction(methodCode, param, invoices);
            } else {
                return ResultContant.createSuccessJSONObject(invoices);
            }
        }
        return ResultContant.createJSONObject(result.getJSONObject("message").getString("error_code"), result.getJSONObject("message").getString("error_message"), invoices);
    }

    public static JSONObject convertInvoiceMainInfo(JSONObject invoice) {
        if (invoice == null) {
            return null;
        }
        LOGGER.info("Bw convertInvoiceMainInfo", (Object)invoice);
        JSONObject resultInvoice = new JSONObject();
        if (StringUtils.isNotEmpty((String)invoice.getString("payment_cert_no"))) {
            resultInvoice.put("invoiceNo", (Object)invoice.getString("payment_cert_no"));
            resultInvoice.put("invoiceType", (Object)InputInvoiceTypeEnum.HGJKS.getAwsType());
            resultInvoice.put("invoiceDate", (Object)invoice.getString("filling_date"));
            resultInvoice.put("buyerTaxNo", (Object)invoice.getString("trade_code_one"));
            resultInvoice.put("buyerName", (Object)invoice.getString("trade_name_one"));
        } else {
            resultInvoice.put("invoiceCode", (Object)invoice.getString("invoice_code"));
            String invoiceNo = invoice.getString("invoice_number");
            resultInvoice.put("invoiceNo", (Object)invoiceNo);
            String invoiceType = BwDeductService.convertAwsType(invoice.getString("invoice_type"));
            invoiceType = AisinoConvertUtil.getAlleleAwsInvoiceType(invoiceNo, invoiceType);
            if (InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getAwsType().equals(invoiceType) || InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getAwsType().equals(invoiceType)) {
                resultInvoice.put("invoiceCode", (Object)"");
            }
            resultInvoice.put("invoiceType", (Object)invoiceType);
            resultInvoice.put("invoiceDate", (Object)invoice.getString("billing_date"));
            resultInvoice.put("buyerTaxNo", (Object)invoice.getString("buyer_tax_no"));
            resultInvoice.put("salerTaxNo", (Object)invoice.getString("sales_tax_no"));
            resultInvoice.put("salerName", (Object)invoice.getString("sales_tax_name"));
            resultInvoice.put("buyerName", (Object)invoice.getString("buyer_name"));
            resultInvoice.put("taxAmount", invoice.get((Object)"amount_tax"));
            resultInvoice.put("totalTaxAmount", invoice.get((Object)"total_tax"));
            resultInvoice.put("invoiceStatus", invoice.get((Object)"state"));
        }
        resultInvoice.put("invoiceAmount", invoice.get((Object)"total_amount"));
        resultInvoice.put("effectiveTaxAmount", invoice.get((Object)"effective_tax"));
        String taxPeriod = invoice.getString("taxPeriod");
        if (StringUtils.isNotEmpty((String)taxPeriod)) {
            taxPeriod = taxPeriod.replace("-", "");
        }
        resultInvoice.put("taxPeriod", (Object)taxPeriod);
        String rzrq = invoice.getString("deductible_date");
        String selectAuthenticateTime = DateUtils.getStandardDate(rzrq);
        resultInvoice.put("selectAuthenticateTime", (Object)selectAuthenticateTime);
        resultInvoice.put("manageStatus", invoice.get((Object)"manage_state"));
        String deductionPurpose = AisinoConvertUtil.deductionPurposeConvert(invoice.getString("certification_type"));
        resultInvoice.put("deductionPurpose", (Object)deductionPurpose);
        String checkAuthenticateFlag = invoice.getString("inv_dedu_result");
        String authenticateFlag = "0";
        if (StringUtils.isEmpty((String)checkAuthenticateFlag)) {
            String certificationWay = invoice.getString("certification_way");
            String deductible = invoice.getString("deductible");
            if ("0".equals(certificationWay)) {
                resultInvoice.put("checkAuthenticateFlag", (Object)"0");
                if ("1".equals(deductible)) {
                    authenticateFlag = "2";
                    resultInvoice.put("checkAuthenticateFlag", (Object)"1");
                    resultInvoice.put("checkAuthenticateTime", (Object)invoice.getString("deductible_date"));
                }
            } else if ("1".equals(certificationWay)) {
                resultInvoice.put("scanAuthenticateFlag", (Object)"0");
                if ("1".equals(deductible)) {
                    authenticateFlag = "3";
                    resultInvoice.put("scanAuthenticateFlag", (Object)"1");
                    resultInvoice.put("scanAuthenticateTime", (Object)invoice.getString("deductible_date"));
                }
            }
        } else if ("1".equals(checkAuthenticateFlag)) {
            authenticateFlag = "2";
        }
        resultInvoice.put("authenticateFlag", (Object)authenticateFlag);
        return resultInvoice;
    }

    @Override
    public JSONObject getDrawbackStatisticTable(JSONObject paramJson) {
        return ResultContant.createJSONObject("0002", ResManager.loadKDString((String)"\u767e\u671b\u6682\u4e0d\u652f\u6301\u8be5\u529f\u80fd", (String)"BwDeductService_24", (String)"imc-rim-common", (Object[])new Object[0]));
    }

    @Override
    public JSONObject drawbackStatisticConfirm(JSONObject paramJson) {
        return ResultContant.createJSONObject("0002", ResManager.loadKDString((String)"\u767e\u671b\u6682\u4e0d\u652f\u6301\u8be5\u529f\u80fd", (String)"BwDeductService_24", (String)"imc-rim-common", (Object[])new Object[0]));
    }

    private JSONObject postBwRequest(String methodCode, String paramStr) {
        try {
            BwService bwService = BwService.newInstance();
            LOGGER.info("BwDeductService post paramStr:{}", (Object)paramStr);
            return bwService.postAppJson(methodCode, paramStr);
        }
        catch (Exception e) {
            LOGGER.info("BwDeductService post Exception:{}", (Object)e);
            return null;
        }
    }
}

