/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.deduction.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.invoice.deduction.AsyncDeductSelectService;
import kd.imc.rim.common.invoice.deduction.DeductInvoiceOperateService;
import kd.imc.rim.common.invoice.deduction.DeductService;
import kd.imc.rim.common.invoice.deduction.impl.HolytaxDeductService;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import org.apache.commons.lang3.tuple.Pair;

public class HolytaxAsyncDeductSelectService
extends AsyncDeductSelectService {
    private static Log LOGGER = LogFactory.getLog(HolytaxAsyncDeductSelectService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void querySelectResult(DynamicObject selectLog) {
        block44: {
            String taxNo = selectLog.getString("tax_no");
            String batchNo = selectLog.getString("batch_no");
            LOGGER.info("\u5f00\u59cb\u67e5\u8be2\u5f02\u6b65\u52fe\u9009\u7ed3\u679c:{}-{}", (Object)taxNo, (Object)batchNo);
            Date taxPeriod = selectLog.getDate("tax_period");
            Long orgId = DynamicObjectUtil.getDynamicObjectLongValue(selectLog.get("org"));
            JSONObject param = new JSONObject();
            param.put("batchNo", (Object)batchNo);
            param.put("taxNo", (Object)taxNo);
            int handleNum = selectLog.getInt("handle_num");
            String billType = selectLog.getString("bill_type");
            param.put("billType", (Object)Optional.ofNullable(billType).filter(StringUtils::isNotEmpty).orElse("0"));
            String key = "rim.holytaxasyncdeduct-" + taxNo;
            try (DLock lock = DLock.create((String)key, (String)"holytaxasyncdeduct.lock");){
                if (lock.tryLock()) {
                    selectLog.set("handle_num", (Object)(++handleNum));
                    Map<String, DynamicObject> selectAccountMap = this.getSelectAccount(batchNo);
                    if (CollectionUtils.isEmpty(selectAccountMap)) {
                        LOGGER.info("\u6ca1\u6709\u67e5\u8be2\u5230\u52fe\u9009\u53f0\u8d26\u6570\u636e:{}-{}", (Object)taxNo, (Object)batchNo);
                        selectLog.set("description", (Object)ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u52fe\u9009\u53f0\u8d26\u6570\u636e", (String)"HolytaxAsyncDeductSelectService_0", (String)"imc-rim-common", (Object[])new Object[0]));
                        selectLog.set("update_time", (Object)new Date());
                        selectLog.set("handle_status", (Object)"2");
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{selectLog});
                        return;
                    }
                    try {
                        JSONArray invoices = new JSONArray();
                        String deductibleMode = null;
                        Pair<String, String> deductionPurposePair = null;
                        for (DynamicObject account : selectAccountMap.values()) {
                            deductibleMode = Optional.ofNullable(deductibleMode).orElseGet(() -> account.getString("deduction_purpose"));
                            if (deductionPurposePair == null) {
                                deductionPurposePair = DeductionConstant.getDeductionPurpose(deductibleMode);
                            }
                            invoices.add((Object)DeductionConstant.createSelectJson(account, (String)deductionPurposePair.getRight()));
                        }
                        if (deductionPurposePair == null) {
                            deductionPurposePair = Pair.of((Object)"1", (Object)"1");
                        }
                        param.put("invoices", (Object)invoices);
                        param.put("deductibleMode", (Object)deductibleMode);
                        JSONObject queryResult = this.doSelect(orgId, param);
                        if (queryResult != null && queryResult.get((Object)"data") != null) {
                            JSONObject data = queryResult.getJSONObject("data");
                            JSONArray successArray = data.getJSONArray("success");
                            JSONArray failArray = data.getJSONArray("fail");
                            selectLog.set("success_num", (Object)successArray.size());
                            selectLog.set("fail_num", (Object)failArray.size());
                            selectLog.set("handle_status", (Object)"1");
                            selectLog.set("update_time", (Object)new Date());
                            selectLog.set("description", null);
                            if (!CollectionUtils.isEmpty((Collection)successArray) || !CollectionUtils.isEmpty((Collection)failArray)) {
                                ArrayList<DynamicObject> updateAccountList = new ArrayList<DynamicObject>(8);
                                JSONArray updateSelectInvoiceArray = new JSONArray();
                                JSONObject success = null;
                                JSONObject example = null;
                                if (!CollectionUtils.isEmpty((Collection)successArray)) {
                                    for (int i = 0; i < successArray.size(); ++i) {
                                        String mapKey;
                                        DynamicObject updateAccount;
                                        success = successArray.getJSONObject(i);
                                        if (StringUtils.isNotEmpty((CharSequence)success.getString("taxPeriod"))) {
                                            taxPeriod = DateUtils.stringToDate(success.getString("taxPeriod"), "yyyyMM");
                                        }
                                        if ((updateAccount = selectAccountMap.get(mapKey = CommonUtils.getInvoiceCodeNoGroup(success.getString("invoiceCode"), success.getString("invoiceNo")))) == null) continue;
                                        updateAccount.set("handle_status", (Object)"1");
                                        updateAccount.set("select_result", (Object)success.getString("selectResult"));
                                        updateAccount.set("select_time", (Object)success.getDate("selectDate"));
                                        updateAccount.set("effective_tax_amount", (Object)success.getBigDecimal("effectiveTaxAmount"));
                                        updateAccount.set("invoice_date", (Object)success.getDate("invoiceDate"));
                                        updateAccount.set("description", (Object)ResManager.loadKDString((String)"\u6210\u529f", (String)"HolytaxAsyncDeductSelectService_1", (String)"imc-rim-common", (Object[])new Object[0]));
                                        String notDeductibleType = success.getString("notDeductibleType");
                                        if (StringUtils.isNotEmpty((CharSequence)notDeductibleType)) {
                                            updateAccount.set("not_deductible_type", (Object)notDeductibleType);
                                        }
                                        if (StringUtils.isNotEmpty((CharSequence)success.getString("taxAmount"))) {
                                            updateAccount.set("total_tax_amount", (Object)success.getBigDecimal("taxAmount"));
                                        } else if (StringUtils.isNotEmpty((CharSequence)success.getString("totalTaxAmount"))) {
                                            updateAccount.set("total_tax_amount", (Object)success.getBigDecimal("totalTaxAmount"));
                                        }
                                        updateAccount.set("tax_period", (Object)taxPeriod);
                                        updateAccount.set("update_time", (Object)new Date());
                                        updateAccountList.add(updateAccount);
                                        if (!StringUtils.isNotEmpty((CharSequence)updateAccount.getString("serial_no"))) continue;
                                        example = new JSONObject();
                                        example.put("serial_no", (Object)updateAccount.getString("serial_no"));
                                        example.put("invoice_type", (Object)DynamicObjectUtil.getDynamicObjectLongValue(updateAccount.get("invoice_type")));
                                        if (StringUtils.isNotEmpty((CharSequence)success.getString("deductionPurpose"))) {
                                            example.put("deduction_purpose", (Object)success.getString("deductionPurpose"));
                                        } else {
                                            example.put("deduction_purpose", deductionPurposePair.getRight());
                                        }
                                        example.put("effective_tax_amount", (Object)success.getBigDecimal("effectiveTaxAmount"));
                                        example.put("tax_period", (Object)DateUtils.format(taxPeriod, "yyyyMM"));
                                        example.put("select_time", (Object)success.getString("selectDate"));
                                        example.put("authenticate_flag", deductionPurposePair.getLeft());
                                        if (StringUtils.isNotEmpty((CharSequence)success.getString("notDeductibleType"))) {
                                            example.put("not_deductible_type", (Object)success.getString("notDeductibleType"));
                                        } else {
                                            example.put("not_deductible_type", (Object)updateAccount.getString("not_deductible_type"));
                                        }
                                        updateSelectInvoiceArray.add((Object)example);
                                    }
                                    DeductInvoiceOperateService deductInvoiceOperateService = new DeductInvoiceOperateService();
                                    deductInvoiceOperateService.updateBatchSelectedInvoice(updateSelectInvoiceArray, deductibleMode, taxNo);
                                }
                                HashMap<String, String> serialNoStatusMap = new HashMap<String, String>(8);
                                if (!CollectionUtils.isEmpty((Collection)failArray)) {
                                    for (int i = 0; i < failArray.size(); ++i) {
                                        success = failArray.getJSONObject(i);
                                        String mapKey = CommonUtils.getInvoiceCodeNoGroup(success.getString("invoiceCode"), success.getString("invoiceNo"));
                                        DynamicObject updateAccount = selectAccountMap.get(mapKey);
                                        if (updateAccount == null) continue;
                                        updateAccount.set("handle_status", (Object)"1");
                                        String selectResult = success.getString("selectResult");
                                        if (StringUtils.isNotEmpty((CharSequence)selectResult) && selectResult.startsWith("8-")) {
                                            selectResult = "8";
                                        }
                                        updateAccount.set("select_result", (Object)selectResult);
                                        updateAccount.set("update_time", (Object)new Date());
                                        updateAccount.set("invoice_date", (Object)success.getDate("invoiceDate"));
                                        updateAccount.set("description", (Object)success.getString("description"));
                                        updateAccountList.add(updateAccount);
                                        String preAuthenticateFlag = updateAccount.getString("pre_authenticate_flag");
                                        if (StringUtils.isEmpty((CharSequence)preAuthenticateFlag)) {
                                            String string = preAuthenticateFlag = "1".equals(updateAccount.getString("select_status")) ? "0" : "1";
                                        }
                                        if (!StringUtils.isNotEmpty((CharSequence)updateAccount.getString("serial_no"))) continue;
                                        serialNoStatusMap.put(updateAccount.getString("serial_no"), preAuthenticateFlag);
                                    }
                                }
                                if (taxPeriod != null) {
                                    selectLog.set("tax_period", (Object)taxPeriod);
                                }
                                this.save(selectLog, updateAccountList, serialNoStatusMap);
                            }
                        } else {
                            this.saveFailResult(handleNum, selectLog, selectAccountMap, queryResult != null ? queryResult.getString("description") : ResManager.loadKDString((String)"\u8bf7\u6c42\u8d85\u65f6", (String)"HolytaxAsyncDeductSelectService_2", (String)"imc-rim-common", (Object[])new Object[0]));
                        }
                        break block44;
                    }
                    catch (Exception e) {
                        LOGGER.error("\u5408\u529b\u52fe\u9009\u5931\u8d25:" + batchNo, (Throwable)e);
                        this.saveFailResult(handleNum, selectLog, selectAccountMap, e.getMessage());
                        break block44;
                    }
                    finally {
                        lock.unlock();
                    }
                }
                LOGGER.info("\u67e5\u8be2\u5f02\u6b65\u52fe\u9009\u7ed3\u679c:{}-{},\u672a\u83b7\u53d6\u5230taxNo\u9501,\u7b49\u5f85\u4e0b\u4e00\u6b21\u6267\u884c", (Object)taxNo, (Object)batchNo);
            }
        }
    }

    protected void saveFailResult(int handleNum, DynamicObject selectLog, Map<String, DynamicObject> selectAccountMap, String description) {
        int num = InvoiceDownloadConstant.getPageSizeFromConfig(5, "async_handle_num");
        String handleStatus = "3";
        if (handleNum > num) {
            handleStatus = "2";
        }
        if (StringUtils.isNotEmpty((CharSequence)description) && description.length() > 100) {
            description = description.substring(0, 100);
        }
        selectLog.set("handle_status", (Object)handleStatus);
        selectLog.set("description", (Object)description);
        ArrayList<DynamicObject> updateAccountList = new ArrayList<DynamicObject>(selectAccountMap.size());
        HashMap<String, String> serialNoStatusMap = new HashMap<String, String>(8);
        for (DynamicObject account : selectAccountMap.values()) {
            account.set("select_result", (Object)"34");
            account.set("update_time", (Object)new Date());
            account.set("description", (Object)description);
            if ("2".equals(handleStatus)) {
                account.set("handle_status", (Object)"2");
                String preAuthenticateFlag = account.getString("pre_authenticate_flag");
                if (StringUtils.isEmpty((CharSequence)preAuthenticateFlag)) {
                    String string = preAuthenticateFlag = "1".equals(account.getString("select_status")) ? "0" : "1";
                }
                if (StringUtils.isNotEmpty((CharSequence)account.getString("serial_no"))) {
                    serialNoStatusMap.put(account.getString("serial_no"), preAuthenticateFlag);
                }
            }
            updateAccountList.add(account);
        }
        this.save(selectLog, updateAccountList, serialNoStatusMap);
    }

    @Override
    protected JSONObject doSelect(Long orgId, JSONObject param) {
        HolytaxDeductService deductService = new HolytaxDeductService(orgId);
        return ((DeductService)deductService).gxInvoices(param);
    }
}

