/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.deduction.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.deduction.AsyncDeductSelectService;
import kd.imc.rim.common.invoice.deduction.DeductService;
import kd.imc.rim.common.invoice.deduction.impl.LqDeductService;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import org.apache.commons.lang3.tuple.Pair;

public class LqAsyncDeductSelectService
extends AsyncDeductSelectService {
    private static Log LOGGER = LogFactory.getLog(LqAsyncDeductSelectService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void querySelectResult(DynamicObject selectLog) {
        JSONArray failArray;
        ArrayList<DynamicObject> updateAccountList;
        Map<String, DynamicObject> selectAccountMap;
        String billType;
        block39: {
            String deductionPurpose;
            JSONObject example;
            JSONObject success;
            JSONArray updateSelectInvoiceArray;
            JSONArray successArray;
            String taxNo;
            String taxPeriod;
            block40: {
                String batchNo = selectLog.getString("batch_no");
                LOGGER.info("\u5f00\u59cb\u67e5\u8be2\u5f02\u6b65\u52fe\u9009\u7ed3\u679c-\u4e50\u4f01:{}", (Object)batchNo);
                taxPeriod = "";
                if (selectLog.getDate("tax_period") != null) {
                    taxPeriod = DateUtils.format(selectLog.getDate("tax_period"), "yyyyMM");
                }
                Long orgId = DynamicObjectUtil.getDynamicObjectLongValue(selectLog.get("org"));
                JSONObject param = new JSONObject();
                param.put("batchNo", (Object)batchNo);
                taxNo = selectLog.getString("tax_no");
                param.put("taxNo", (Object)taxNo);
                billType = selectLog.getString("bill_type");
                param.put("billType", (Object)billType);
                String key = "rim.lqasyncdeduct-" + batchNo;
                try (DLock lock = DLock.create((String)key, (String)"LqAsyncDeductSelectService.lock");){
                    if (!lock.tryLock()) return;
                    try {
                        JSONObject queryResult = this.doSelect(orgId, param);
                        selectLog.set("update_time", (Object)new Date());
                        selectAccountMap = this.getSelectAccount(batchNo, billType);
                        if (CollectionUtils.isEmpty(selectAccountMap)) {
                            LOGGER.info("\u6ca1\u6709\u67e5\u8be2\u5230\u52fe\u9009\u53f0\u8d26\u6570\u636e:{}-{}", (Object)taxNo, (Object)batchNo);
                            selectLog.set("description", (Object)ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u52fe\u9009\u53f0\u8d26\u6570\u636e", (String)"LqAsyncDeductSelectService_0", (String)"imc-rim-common", (Object[])new Object[0]));
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{selectLog});
                            return;
                        }
                        updateAccountList = new ArrayList<DynamicObject>(8);
                        if (queryResult != null && ResultContant.isSuccess(queryResult).booleanValue()) {
                            JSONObject data = queryResult.getJSONObject("data");
                            if (data == null) {
                                LOGGER.info("\u6ca1\u6709\u8fd4\u56dedata\u6570\u636e:{}-{}", (Object)taxNo, (Object)batchNo);
                                selectLog.set("description", (Object)ResManager.loadKDString((String)"\u6ca1\u6709\u8fd4\u56dedata\u6570\u636e", (String)"LqAsyncDeductSelectService_1", (String)"imc-rim-common", (Object[])new Object[0]));
                                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{selectLog});
                                return;
                            }
                            successArray = data.getJSONArray("success");
                            failArray = data.getJSONArray("fail");
                            JSONArray handlingArray = data.getJSONArray("handling");
                            selectLog.set("success_num", (Object)successArray.size());
                            selectLog.set("fail_num", (Object)(selectLog.getInt("total_num") - successArray.size() - handlingArray.size()));
                            if (CollectionUtils.isEmpty((Collection)handlingArray)) {
                                selectLog.set("handle_status", (Object)"1");
                            }
                            if (CollectionUtils.isEmpty((Collection)successArray)) {
                                if (CollectionUtils.isEmpty((Collection)failArray)) return;
                            }
                            updateSelectInvoiceArray = new JSONArray();
                            success = null;
                            example = null;
                            deductionPurpose = "";
                            if (CollectionUtils.isEmpty((Collection)successArray)) break block39;
                            break block40;
                        }
                        if (queryResult != null && CommonUtils.isMatchErrcodes(queryResult, ErrorType.STATUS_HANDLING.getCode(), ErrorType.STATUS_TIMEOUT.getCode(), ErrorType.LQ_SERVICE_ERROR.getCode())) {
                            selectLog.set("description", (Object)queryResult.getString("description"));
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{selectLog});
                            return;
                        }
                        if (queryResult == null) return;
                        Map<String, String> serialNoStatusMap = this.getStatusMap(null, selectAccountMap, updateAccountList, queryResult.getString("description"), billType);
                        selectLog.set("success_num", (Object)0);
                        selectLog.set("fail_num", (Object)selectAccountMap.size());
                        selectLog.set("description", (Object)queryResult.getString("description"));
                        selectLog.set("handle_status", (Object)"2");
                        this.save(serialNoStatusMap, selectLog, updateAccountList);
                        return;
                    }
                    catch (Exception e) {
                        LOGGER.error("\u4e50\u4f01\u5f02\u6b65\u67e5\u8be2\u52fe\u9009\u7ed3\u679c\u5931\u8d25:" + batchNo, (Throwable)e);
                        return;
                    }
                    finally {
                        lock.unlock();
                    }
                }
            }
            for (int i = 0; i < successArray.size(); ++i) {
                String skssq;
                BigDecimal effectiveTaxAmount;
                success = successArray.getJSONObject(i);
                String invoiceCode = StringUtils.trimToEmpty((String)success.getString("invoiceCode"));
                String mapKey = this.getBillNo(invoiceCode, success.getString("invoiceNo"), billType, success.getDate("invoiceDate"));
                DynamicObject updateAccount = selectAccountMap.get(mapKey);
                if (updateAccount == null && (updateAccount = this.getAccountByElectronicNo(selectAccountMap, success.getString("invoiceNo"))) == null) continue;
                deductionPurpose = updateAccount.getString("deduction_purpose");
                Pair<String, String> deductionPurposeMap = DeductionConstant.getDeductionPurpose(deductionPurpose);
                updateAccount.set("handle_status", (Object)"1");
                updateAccount.set("select_result", (Object)success.getString("selectResult"));
                updateAccount.set("description", (Object)this.getSelectMsg(success));
                updateAccount.set("update_time", (Object)new Date());
                updateAccount.set("select_time", (Object)success.getDate("selectDate"));
                updateAccountList.add(updateAccount);
                if (!StringUtils.isNotEmpty((CharSequence)updateAccount.getString("serial_no"))) continue;
                example = new JSONObject();
                example.put("serial_no", (Object)updateAccount.getString("serial_no"));
                example.put("invoice_type", (Object)DynamicObjectUtil.getDynamicObjectLongValue(updateAccount.get("invoice_type")));
                if (StringUtils.isNotEmpty((CharSequence)success.getString("deductionPurpose"))) {
                    example.put("deduction_purpose", (Object)success.getString("deductionPurpose"));
                } else {
                    example.put("deduction_purpose", deductionPurposeMap.getRight());
                }
                if (("1".equals(billType) || "2".equals(billType)) && (effectiveTaxAmount = updateAccount.getBigDecimal("total_tax_amount")) != null && effectiveTaxAmount.compareTo(BigDecimal.ZERO) > 0) {
                    example.put("effective_tax_amount", (Object)effectiveTaxAmount);
                }
                if (StringUtils.isNotEmpty((CharSequence)(skssq = success.getString("taxPeriod")))) {
                    example.put("tax_period", (Object)skssq);
                } else {
                    example.put("tax_period", (Object)taxPeriod);
                }
                if (StringUtils.isEmpty((CharSequence)success.getString("selectDate"))) {
                    example.remove((Object)"tax_period");
                }
                example.put("authenticate_flag", deductionPurposeMap.getLeft());
                example.put("select_time", (Object)success.getString("selectDate"));
                example.put("cancel_select_type", (Object)updateAccount.getString("select_opera_type"));
                example.put("not_deductible_type", (Object)updateAccount.getString("not_deductible_type"));
                this.setUpdateInvoiceData(example, updateAccount, success, deductionPurpose);
                updateSelectInvoiceArray.add((Object)example);
            }
            this.updateInvoiceData(taxNo, updateSelectInvoiceArray, deductionPurpose);
        }
        Map<String, String> serialNoStatusMap = this.getStatusMap(failArray, selectAccountMap, updateAccountList, "", billType);
        selectLog.set("description", null);
        this.save(serialNoStatusMap, selectLog, updateAccountList);
    }

    public void save(Map<String, String> serialNoStatusMap, DynamicObject selectLog, List<DynamicObject> updateAccountList) {
        try (TXHandle h = TX.required();){
            try {
                this.recoverMainInvoiceStatus(serialNoStatusMap);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{selectLog});
                SaveServiceHelper.save((DynamicObject[])updateAccountList.toArray(new DynamicObject[updateAccountList.size()]));
            }
            catch (Throwable e) {
                LOGGER.error("\u52fe\u9009\u65e5\u5fd7/\u53f0\u8d26\u5931\u8d25", e);
                h.markRollback();
                throw e;
            }
        }
    }

    public Map<String, String> getStatusMap(JSONArray failArray, Map<String, DynamicObject> selectAccountMap, List<DynamicObject> updateAccountList, String description, String billType) {
        HashMap serialNoStatusMap;
        block3: {
            block2: {
                serialNoStatusMap = Maps.newHashMap();
                if (CollectionUtils.isEmpty((Collection)failArray)) break block2;
                for (int i = 0; i < failArray.size(); ++i) {
                    JSONObject fail = failArray.getJSONObject(i);
                    String mapKey = this.getBillNo(fail.getString("invoiceCode"), fail.getString("invoiceNo"), billType, fail.getDate("invoiceDate"));
                    DynamicObject updateAccount = selectAccountMap.get(mapKey);
                    if (updateAccount == null && (updateAccount = this.getAccountByElectronicNo(selectAccountMap, fail.getString("invoiceNo"))) == null) continue;
                    updateAccount.set("handle_status", (Object)"1");
                    updateAccount.set("select_result", (Object)fail.getString("selectResult"));
                    updateAccount.set("description", (Object)this.getSelectMsg(fail));
                    updateAccount.set("update_time", (Object)new Date());
                    updateAccountList.add(updateAccount);
                    this.setFailInvoiceStatus(serialNoStatusMap, updateAccount);
                }
                break block3;
            }
            if (!updateAccountList.isEmpty()) break block3;
            for (Map.Entry<String, DynamicObject> entry : selectAccountMap.entrySet()) {
                DynamicObject failAccount = entry.getValue();
                failAccount.set("handle_status", (Object)"1");
                failAccount.set("select_result", (Object)"31");
                failAccount.set("description", (Object)description);
                failAccount.set("update_time", (Object)new Date());
                updateAccountList.add(failAccount);
                this.setFailInvoiceStatus(serialNoStatusMap, failAccount);
            }
        }
        return serialNoStatusMap;
    }

    @Override
    protected JSONObject doSelect(Long orgId, JSONObject param) {
        LqDeductService deductService = new LqDeductService(orgId);
        return ((DeductService)deductService).gxInvoicesQuery(param);
    }
}

