/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.deduction.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.invoice.deduction.DeductSelectService;
import kd.imc.rim.common.invoice.deduction.DeductService;
import kd.imc.rim.common.invoice.deduction.impl.LqAsyncDeductSelectService;
import kd.imc.rim.common.invoice.deduction.impl.LqDeductService;

public class LqDeductSelectService
extends DeductSelectService {
    private static Log LOGGER = LogFactory.getLog(LqDeductSelectService.class);
    private static final int DEFAULT_SIZE = 1000;

    public LqDeductSelectService() {
        int size = InvoiceDownloadConstant.getPageSizeFromConfig(1000, "lq_select_size");
        if (size <= 0) {
            size = 1000;
        }
        this.selectSize = size;
    }

    @Override
    public DeductService getDeductServiceImpl(Long orgId) {
        return new LqDeductService(orgId);
    }

    @Override
    public Map<String, Object> selectedResult(DeductService service, JSONObject paramJson) {
        HashMap result = Maps.newHashMap();
        int successNum = 0;
        JSONArray invoices = paramJson.getJSONArray("invoices");
        int size = invoices.size();
        StringBuilder message = new StringBuilder();
        JSONObject gxInvoicesRtn = service.gxInvoices(paramJson);
        JSONObject data = gxInvoicesRtn.getJSONObject("data");
        String billType = paramJson.getString("billType");
        JSONArray fail = new JSONArray();
        if (data != null) {
            fail = data.getJSONArray("fail");
        }
        if (ErrorType.SUCCESS.getCode().equals(gxInvoicesRtn.get((Object)"errcode"))) {
            String batchNo = "";
            if (data != null) {
                batchNo = data.getString("batchNo");
            }
            result.put("batchNo", batchNo);
            if (!CollectionUtils.isEmpty((Collection)fail)) {
                this.handlePartialFail(fail, invoices, message, this.getTitle(), billType);
            }
            this.insertSelectAccount(paramJson, ErrorType.STATUS_HANDLING.getCode(), batchNo, "2", "3");
            HashMap<String, String> serialNoStatusMap = new HashMap<String, String>(8);
            for (int i = 0; i < invoices.size(); ++i) {
                JSONObject invoice1 = invoices.getJSONObject(i);
                if (!StringUtils.isBlank((CharSequence)invoice1.getString("selectResult"))) continue;
                ++successNum;
                serialNoStatusMap.put(invoice1.getString("serialNo"), "5");
            }
            this.updateInvoiceSelecting(serialNoStatusMap);
        } else if (!CollectionUtils.isEmpty((Collection)fail)) {
            this.handlePartialFail(fail, invoices, message, this.getTitle(), billType);
        } else {
            this.setFailMessage(paramJson, String.format(ResManager.loadKDString((String)"\u52fe\u9009\u5931\u8d25:%s", (String)"LqDeductSelectService_0", (String)"imc-rim-common", (Object[])new Object[0]), gxInvoicesRtn.getString("description")), message);
        }
        result.put("errcode", gxInvoicesRtn.getString("errcode"));
        result.put("successNum", successNum);
        result.put("failNum", size - successNum);
        result.put("message", message.toString());
        result.put("sync", "0");
        return result;
    }

    @Override
    public void queryAsyncSelectResult(List<String> batchNoList) {
        if (!CollectionUtils.isEmpty(batchNoList)) {
            LqAsyncDeductSelectService asyncDeductSelectService = new LqAsyncDeductSelectService();
            asyncDeductSelectService.queryAsyncSelectResultByBatchNo(batchNoList);
        }
    }
}

