/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.deduction.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.invoice.deduction.AgricInvoiceHandleService;
import kd.imc.rim.common.invoice.deduction.DeductService;
import kd.imc.rim.common.invoice.deduction.impl.NewAsyncAgrichandleService;
import kd.imc.rim.common.invoice.deduction.impl.NewEtaxDeductService;

public class NewAgricInvoiceHandleService
extends AgricInvoiceHandleService {
    private static Log LOGGER = LogFactory.getLog(NewAgricInvoiceHandleService.class);
    private static final int DEFAULT_SIZE = 500;

    public NewAgricInvoiceHandleService() {
        int size = InvoiceDownloadConstant.getPageSizeFromConfig(500, "agric_invoice_handle_size_4");
        if (size > 500 || size <= 0) {
            size = 500;
        }
        this.selectSize = size;
    }

    @Override
    public Map<String, Object> selectedResult(DeductService service, JSONObject paramJson) {
        HashMap result = Maps.newHashMap();
        int successNum = 0;
        JSONArray invoices = paramJson.getJSONArray("invoices");
        int size = invoices.size();
        StringBuilder message = new StringBuilder();
        JSONObject gxInvoicesRtn = service.agricInvoiceHandle(paramJson);
        JSONObject data = gxInvoicesRtn.getJSONObject("data");
        if (ErrorType.SUCCESS.getCode().equals(gxInvoicesRtn.get((Object)"errcode"))) {
            String batchNo = "";
            if (data != null) {
                batchNo = data.getString("batchNo");
            }
            result.put("batchNo", batchNo);
            HashMap<String, String> serialNoStatusMap = new HashMap<String, String>(8);
            for (int i = 0; i < invoices.size(); ++i) {
                JSONObject invoice1 = invoices.getJSONObject(i);
                ++successNum;
                serialNoStatusMap.put(invoice1.getString("serialNo"), "3");
            }
            this.insertSelectAccount(paramJson, ErrorType.STATUS_HANDLING.getCode(), batchNo, "8", "3");
            this.updateInvoiceSelecting(serialNoStatusMap);
        } else {
            this.setFailMessage(paramJson, String.format(ResManager.loadKDString((String)"\u519c\u4ea7\u54c1\u5904\u7406\u5931\u8d25\uff1a%s", (String)"LqAgricInvoiceHandleService_0", (String)"imc-rim-common", (Object[])new Object[0]), gxInvoicesRtn.getString("description")), message);
        }
        result.put("errcode", gxInvoicesRtn.getString("errcode"));
        result.put("successNum", successNum);
        result.put("failNum", size - successNum);
        result.put("message", message.toString());
        result.put("sync", "0");
        return result;
    }

    @Override
    public void queryAsyncSelectResult(List<String> batchNoList) {
        if (!CollectionUtils.isEmpty(batchNoList)) {
            NewAsyncAgrichandleService asyncDeductSelectService = new NewAsyncAgrichandleService();
            asyncDeductSelectService.queryAsyncSelectResultByBatchNo(batchNoList);
        }
    }

    @Override
    public DeductService getDeductServiceImpl(Long orgId) {
        return new NewEtaxDeductService(orgId);
    }
}

