/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.deduction.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.deduction.AsyncDeductSelectService;
import kd.imc.rim.common.invoice.deduction.DeductService;
import kd.imc.rim.common.invoice.deduction.impl.NewEtaxDeductService;
import kd.imc.rim.common.invoice.deduction.impl.NewHolytaxAsyncDeductSelectService;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.MetadataUtil;
import org.apache.commons.lang3.tuple.Pair;

public class NewEtaxAsyncDeductSelectService
extends AsyncDeductSelectService {
    private static Log LOGGER = LogFactory.getLog(NewEtaxAsyncDeductSelectService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void querySelectResult(DynamicObject selectLog) {
        JSONArray failArray;
        ArrayList<DynamicObject> updateAccountList;
        Map<String, DynamicObject> selectAccountMap;
        String billType;
        block39: {
            String deductionPurpose;
            JSONObject example;
            JSONObject success;
            JSONArray updateSelectInvoiceArray;
            JSONArray successArray;
            String taxPeriodResult;
            String taxNo;
            String taxPeriod;
            block40: {
                String batchNo = selectLog.getString("batch_no");
                LOGGER.info("\u5f00\u59cb\u67e5\u8be2\u5f02\u6b65\u52fe\u9009\u7ed3\u679c-rpa:{}", (Object)batchNo);
                taxPeriod = "";
                if (selectLog.getDate("tax_period") != null) {
                    taxPeriod = DateUtils.format(selectLog.getDate("tax_period"), "yyyyMM");
                }
                Long orgId = DynamicObjectUtil.getDynamicObjectLongValue(selectLog.get("org"));
                JSONObject param = new JSONObject();
                param.put("batchNo", (Object)batchNo);
                taxNo = selectLog.getString("tax_no");
                param.put("taxNo", (Object)taxNo);
                if (StringUtils.isNotBlank((CharSequence)taxNo) && StringUtils.isNotBlank((CharSequence)batchNo) && batchNo.startsWith(taxNo)) {
                    NewHolytaxAsyncDeductSelectService holytaxAsyncDeductSelectService = new NewHolytaxAsyncDeductSelectService();
                    holytaxAsyncDeductSelectService.querySelectResult(selectLog);
                    return;
                }
                billType = selectLog.getString("bill_type");
                param.put("billType", (Object)billType);
                String key = "rim.rpaasyncdeduct-" + batchNo;
                try (DLock lock = DLock.create((String)key, (String)"rpaasyncdeduct.lock");){
                    if (!lock.tryLock()) return;
                    try {
                        selectAccountMap = this.getSelectAccount(batchNo, billType);
                        if (CollectionUtils.isEmpty(selectAccountMap)) {
                            LOGGER.info("\u6ca1\u6709\u67e5\u8be2\u5230\u52fe\u9009\u53f0\u8d26\u6570\u636e:{}-{}", (Object)taxNo, (Object)batchNo);
                            selectLog.set("description", (Object)ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u52fe\u9009\u53f0\u8d26\u6570\u636e", (String)"LqAsyncDeductSelectService_0", (String)"imc-rim-common", (Object[])new Object[0]));
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{selectLog});
                            return;
                        }
                        JSONObject queryResult = this.doSelect(orgId, param);
                        updateAccountList = new ArrayList<DynamicObject>(8);
                        if (queryResult != null && ResultContant.isSuccess(queryResult).booleanValue()) {
                            JSONObject data = queryResult.getJSONObject("data");
                            if (data == null) {
                                LOGGER.info("\u6ca1\u6709\u8fd4\u56dedata\u6570\u636e:{}-{}", (Object)taxNo, (Object)batchNo);
                                selectLog.set("description", (Object)ResManager.loadKDString((String)"\u6ca1\u6709\u8fd4\u56dedata\u6570\u636e", (String)"LqAsyncDeductSelectService_1", (String)"imc-rim-common", (Object[])new Object[0]));
                                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{selectLog});
                                return;
                            }
                            taxPeriodResult = data.getString("taxPeriod");
                            successArray = data.getJSONArray("success");
                            failArray = data.getJSONArray("fail");
                            selectLog.set("success_num", (Object)(!CollectionUtils.isEmpty((Collection)successArray) ? successArray.size() : 0));
                            selectLog.set("fail_num", (Object)(!CollectionUtils.isEmpty((Collection)failArray) ? failArray.size() : 0));
                            if (CollectionUtils.isEmpty((Collection)successArray)) {
                                if (CollectionUtils.isEmpty((Collection)failArray)) return;
                            }
                            selectLog.set("handle_status", (Object)"1");
                            updateSelectInvoiceArray = new JSONArray();
                            success = null;
                            example = null;
                            deductionPurpose = "";
                            if (CollectionUtils.isEmpty((Collection)successArray)) break block39;
                            break block40;
                        }
                        if (queryResult != null && CommonUtils.isMatchErrcodes(queryResult, ErrorType.ETAX_HANDLING.getCode(), ErrorType.ETAX_HANDLING_1.getCode())) {
                            selectLog.set("description", (Object)queryResult.getString("description"));
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{selectLog});
                            return;
                        }
                        if (queryResult == null) return;
                        Map<String, String> serialNoStatusMap = this.getFailStatusMap(null, selectAccountMap, updateAccountList, queryResult.getString("description"), billType);
                        selectLog.set("success_num", (Object)0);
                        selectLog.set("fail_num", (Object)selectAccountMap.size());
                        selectLog.set("description", (Object)queryResult.getString("description"));
                        selectLog.set("handle_status", (Object)"2");
                        this.updateMainSaveLog(serialNoStatusMap, selectLog, updateAccountList);
                        return;
                    }
                    catch (Exception e) {
                        LOGGER.error("rpa\u5f02\u6b65\u67e5\u8be2\u52fe\u9009\u7ed3\u679c\u5931\u8d25:" + batchNo, (Throwable)e);
                        return;
                    }
                    finally {
                        lock.unlock();
                    }
                }
            }
            for (int i = 0; i < successArray.size(); ++i) {
                BigDecimal effectiveTaxAmount;
                String mapKey;
                DynamicObject updateAccount;
                success = successArray.getJSONObject(i);
                String invoiceCode = success.getString("invoiceCode");
                if (invoiceCode == null) {
                    invoiceCode = "";
                }
                if ((updateAccount = selectAccountMap.get(mapKey = this.getBillNo(invoiceCode.trim(), success.getString("invoiceNo"), billType, success.getDate("invoiceDate")))) == null && (updateAccount = this.getAccountByElectronicNo(selectAccountMap, success.getString("invoiceNo"))) == null) continue;
                deductionPurpose = updateAccount.getString("deduction_purpose");
                Pair<String, String> deductionPurposeMap = DeductionConstant.getDeductionPurpose(deductionPurpose);
                updateAccount.set("handle_status", (Object)"1");
                updateAccount.set("select_result", (Object)success.getString("selectResult"));
                updateAccount.set("description", (Object)this.getSelectMsg(success));
                updateAccount.set("update_time", (Object)new Date());
                updateAccount.set("select_time", (Object)success.getDate("selectDate"));
                updateAccountList.add(updateAccount);
                if (!StringUtils.isNotEmpty((CharSequence)updateAccount.getString("serial_no"))) continue;
                example = new JSONObject();
                example.put("serial_no", (Object)updateAccount.getString("serial_no"));
                example.put("invoice_type", (Object)DynamicObjectUtil.getDynamicObjectLongValue(updateAccount.get("invoice_type")));
                if (StringUtils.isNotEmpty((CharSequence)success.getString("deductionPurpose"))) {
                    example.put("deduction_purpose", (Object)success.getString("deductionPurpose"));
                } else {
                    example.put("deduction_purpose", deductionPurposeMap.getRight());
                }
                if ("1".equals(billType) && (effectiveTaxAmount = updateAccount.getBigDecimal("total_tax_amount")) != null && effectiveTaxAmount.compareTo(BigDecimal.ZERO) > 0) {
                    example.put("effective_tax_amount", (Object)effectiveTaxAmount);
                }
                if (StringUtils.isNotBlank((CharSequence)success.getString("taxPeriod"))) {
                    example.put("tax_period", (Object)success.getString("taxPeriod"));
                } else {
                    example.put("tax_period", (Object)(StringUtils.isNotBlank((CharSequence)taxPeriodResult) ? taxPeriodResult : taxPeriod));
                }
                example.put("authenticate_flag", deductionPurposeMap.getLeft());
                example.put("select_time", (Object)success.getString("selectDate"));
                example.put("cancel_select_type", (Object)updateAccount.getString("select_opera_type"));
                example.put("not_deductible_type", (Object)updateAccount.getString("not_deductible_type"));
                this.setUpdateInvoiceData(example, updateAccount, success, deductionPurpose);
                updateSelectInvoiceArray.add((Object)example);
            }
            this.updateInvoiceData(taxNo, updateSelectInvoiceArray, deductionPurpose);
        }
        Map<String, String> serialNoStatusMap = this.getFailStatusMap(failArray, selectAccountMap, updateAccountList, "", billType);
        selectLog.set("description", null);
        this.updateMainSaveLog(serialNoStatusMap, selectLog, updateAccountList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void queryRecordedCommitResult(DynamicObject selectLog) {
        JSONArray failArray;
        JSONArray successArray;
        ArrayList<JSONObject> updateInvoiceList;
        ArrayList<DynamicObject> updateAccountList;
        Map<String, DynamicObject> selectAccountMap;
        String billType;
        block33: {
            String deductionPurpose;
            JSONObject success;
            block34: {
                Long orgId = DynamicObjectUtil.getDynamicObjectLongValue(selectLog.get("org"));
                NewEtaxDeductService deductService = new NewEtaxDeductService(orgId);
                String batchNo = selectLog.getString("batch_no");
                String taxNo = selectLog.getString("tax_no");
                billType = selectLog.getString("bill_type");
                String key = "rim.etax-recorded-commit-" + batchNo;
                try (DLock lock = DLock.create((String)key, (String)"queryRecordedCommitResult.lock");){
                    if (!lock.tryLock()) return;
                    try {
                        Map<String, Object> selectLogMap = DynamicObjectUtil.dynamicObject2Map(selectLog);
                        JSONObject queryResult = ((DeductService)deductService).queryRecordedCommitResult(selectLogMap);
                        selectAccountMap = this.getSelectAccount(batchNo, billType);
                        if (CollectionUtils.isEmpty(selectAccountMap)) {
                            LOGGER.info("\u6ca1\u6709\u67e5\u8be2\u5230\u52fe\u9009\u53f0\u8d26\u6570\u636e:{}-{}", (Object)taxNo, (Object)batchNo);
                            selectLog.set("description", (Object)ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u52fe\u9009\u53f0\u8d26\u6570\u636e", (String)"LqAsyncDeductSelectService_0", (String)"imc-rim-common", (Object[])new Object[0]));
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{selectLog});
                            return;
                        }
                        updateAccountList = new ArrayList<DynamicObject>(8);
                        updateInvoiceList = new ArrayList<JSONObject>(8);
                        if (queryResult != null && ResultContant.isSuccess(queryResult).booleanValue()) {
                            JSONObject data = queryResult.getJSONObject("data");
                            if (data == null) {
                                LOGGER.info("\u6ca1\u6709\u8fd4\u56dedata\u6570\u636e:{}-{}", (Object)taxNo, (Object)batchNo);
                                selectLog.set("description", (Object)ResManager.loadKDString((String)"\u6ca1\u6709\u8fd4\u56dedata\u6570\u636e", (String)"LqAsyncDeductSelectService_1", (String)"imc-rim-common", (Object[])new Object[0]));
                                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{selectLog});
                                return;
                            }
                            successArray = data.getJSONArray("success");
                            failArray = data.getJSONArray("fail");
                            selectLog.set("success_num", (Object)(!CollectionUtils.isEmpty((Collection)successArray) ? successArray.size() : 0));
                            selectLog.set("fail_num", !CollectionUtils.isEmpty((Collection)failArray) ? Integer.valueOf(failArray.size()) : "0");
                            if (CollectionUtils.isEmpty((Collection)successArray)) {
                                if (CollectionUtils.isEmpty((Collection)failArray)) return;
                            }
                            JSONArray updateSelectInvoiceArray = new JSONArray();
                            success = null;
                            deductionPurpose = "";
                            if (CollectionUtils.isEmpty((Collection)successArray)) break block33;
                            LOGGER.info("\u7a0e\u5c40\u5165\u8d26\uff0c\u5b58\u5728\u6210\u529f\u6570\u636e\uff0csize: {}", (Object)successArray.size());
                            break block34;
                        }
                        if (queryResult != null && CommonUtils.isMatchErrcodes(queryResult, ErrorType.STATUS_HANDLING.getCode(), ErrorType.STATUS_TIMEOUT.getCode(), ErrorType.ETAX_HANDLING.getCode(), ErrorType.ETAX_HANDLING_1.getCode())) {
                            selectLog.set("description", (Object)queryResult.getString("description"));
                            selectLog.set("update_time", (Object)new Date());
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{selectLog});
                            return;
                        }
                        if (queryResult == null) return;
                        this.getFailSelectAccount(null, selectAccountMap, updateAccountList, queryResult.getString("description"), billType);
                        selectLog.set("success_num", (Object)0);
                        selectLog.set("fail_num", (Object)selectAccountMap.size());
                        selectLog.set("description", (Object)queryResult.getString("description"));
                        selectLog.set("handle_status", (Object)"2");
                        selectLog.set("update_time", (Object)new Date());
                        this.save(null, selectLog, updateAccountList);
                        return;
                    }
                    catch (Exception e) {
                        LOGGER.error("\u67e5\u8be2\u53d1\u7968\u5165\u8d26\u63d0\u4ea4\u7ed3\u679c,\u7ed3\u679c\u5931\u8d25:" + batchNo, (Throwable)e);
                        return;
                    }
                    finally {
                        lock.unlock();
                    }
                }
            }
            for (int i = 0; i < successArray.size(); ++i) {
                String mapKey;
                DynamicObject updateAccount;
                success = successArray.getJSONObject(i);
                String invoiceCode = success.getString("invoiceCode");
                if (invoiceCode == null) {
                    invoiceCode = "";
                }
                if ((updateAccount = selectAccountMap.get(mapKey = this.getBillNo(invoiceCode.trim(), success.getString("invoiceNo"), billType, success.getDate("invoiceDate")))) == null && (updateAccount = this.getAccountByElectronicNo(selectAccountMap, success.getString("invoiceNo"))) == null) continue;
                deductionPurpose = updateAccount.getString("deduction_purpose");
                updateAccount.set("handle_status", (Object)"1");
                updateAccount.set("description", (Object)success.getString("description"));
                updateAccount.set("update_time", (Object)new Date());
                updateAccountList.add(updateAccount);
                String mxuuid = success.getString("mxuuid");
                String rzuuid = success.getString("rzuuid");
                if (!StringUtils.isNotEmpty((CharSequence)updateAccount.getString("serial_no"))) continue;
                JSONObject example = new JSONObject();
                example.put("serial_no", (Object)updateAccount.getString("serial_no"));
                example.put("tax_recorded_status", (Object)deductionPurpose);
                example.put("mxuuid", (Object)mxuuid);
                example.put("rzuuid", (Object)rzuuid);
                updateInvoiceList.add(example);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)failArray)) {
            LOGGER.info("\u7a0e\u5c40\u5165\u8d26\uff0c\u5b58\u5728\u5931\u8d25\u6570\u636e\uff0csize: {}", (Object)failArray.size());
            this.getFailSelectAccount(failArray, selectAccountMap, updateAccountList, "", billType);
        }
        selectLog.set("description", null);
        selectLog.set("update_time", (Object)new Date());
        selectLog.set("handle_status", (Object)(!CollectionUtils.isEmpty((Collection)successArray) ? "1" : "2"));
        LOGGER.info("handle_status {}", (Object)selectLog.getString("handle_status"));
        this.save(updateInvoiceList, selectLog, updateAccountList);
    }

    private void getFailSelectAccount(JSONArray failArray, Map<String, DynamicObject> selectAccountMap, List<DynamicObject> updateAccountList, String description, String billType) {
        block3: {
            block2: {
                if (CollectionUtils.isEmpty((Collection)failArray)) break block2;
                for (int i = 0; i < failArray.size(); ++i) {
                    JSONObject fail = failArray.getJSONObject(i);
                    String mapKey = this.getBillNo(fail.getString("invoiceCode"), fail.getString("invoiceNo"), billType, fail.getDate("invoiceDate"));
                    DynamicObject updateAccount = selectAccountMap.get(mapKey);
                    if (updateAccount == null && (updateAccount = this.getAccountByElectronicNo(selectAccountMap, fail.getString("invoiceNo"))) == null) continue;
                    updateAccount.set("handle_status", (Object)"1");
                    updateAccount.set("description", (Object)fail.getString("description"));
                    updateAccount.set("update_time", (Object)new Date());
                    updateAccountList.add(updateAccount);
                }
                break block3;
            }
            if (!updateAccountList.isEmpty()) break block3;
            for (Map.Entry<String, DynamicObject> entry : selectAccountMap.entrySet()) {
                DynamicObject failAccount = entry.getValue();
                failAccount.set("handle_status", (Object)"1");
                failAccount.set("description", (Object)description);
                failAccount.set("update_time", (Object)new Date());
                updateAccountList.add(failAccount);
            }
        }
    }

    private void save(List<JSONObject> updateInvoiceList, DynamicObject selectLog, List<DynamicObject> updateAccountList) {
        try (TXHandle h = TX.required();){
            try {
                if (null != updateInvoiceList && updateInvoiceList.size() > 0) {
                    Map<String, JSONObject> serialNoMap = updateInvoiceList.stream().collect(Collectors.toMap(t -> t.getString("serial_no"), t -> t, (k1, k2) -> k1));
                    QFilter invoiceFilter = new QFilter("serial_no", "in", serialNoMap.keySet());
                    DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"rim_invoice", (String)MetadataUtil.getFields("rim_invoice"), (QFilter[])new QFilter[]{invoiceFilter});
                    HashMap invoiceDynamicObjectMap = new HashMap(8);
                    if (dynamicObjects != null && dynamicObjects.length > 0) {
                        for (DynamicObject dynamicObject : dynamicObjects) {
                            ArrayList<DynamicObject> dynamicObjects1;
                            QFilter serialNOFilter;
                            JSONObject jsonObject = serialNoMap.get(dynamicObject.getString("serial_no"));
                            String taxRecordedStatus = jsonObject.getString("tax_recorded_status");
                            dynamicObject.set("tax_recorded_status", (Object)taxRecordedStatus);
                            if ("06".equals(taxRecordedStatus)) {
                                dynamicObject.set("tax_recorded_purpose", (Object)"");
                                dynamicObject.set("tax_recorded_time", null);
                            }
                            Long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue(dynamicObject.get("invoice_type"));
                            String serialNo = dynamicObject.getString("serial_no");
                            String entityId = InputInvoiceTypeEnum.getEntity(invoiceType);
                            DynamicObject idObject = QueryServiceHelper.queryOne((String)entityId, (String)"id", (QFilter[])new QFilter[]{serialNOFilter = new QFilter("serial_no", "=", (Object)serialNo)});
                            if (idObject == null) {
                                LOGGER.info(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801\uff1a%1$s\uff0c\u5bf9\u5e94\u7684\u4e1a\u52a1\u5b50\u8868\u4e0d\u5b58\u5728\u6570\u636e", (String)"NewEtaxAsyncDeductSelectService_0", (String)"imc-rim-common", (Object[])new Object[0]), dynamicObject.getString("invoice_no")));
                                continue;
                            }
                            DynamicObject invoiceDynamicObject = BusinessDataServiceHelper.loadSingle((Object)idObject.get("id"), (String)entityId);
                            invoiceDynamicObject.set("tax_recorded_status", (Object)taxRecordedStatus);
                            if ("06".equals(taxRecordedStatus)) {
                                invoiceDynamicObject.set("tax_recorded_purpose", (Object)"");
                                invoiceDynamicObject.set("tax_recorded_time", null);
                            }
                            String recordedMxUuid = invoiceDynamicObject.getString("recorded_mxuuid");
                            String recordedRzUuid = invoiceDynamicObject.getString("recorded_rzuuid");
                            if (StringUtils.isBlank((CharSequence)recordedMxUuid) || StringUtils.isBlank((CharSequence)recordedRzUuid)) {
                                invoiceDynamicObject.set("recorded_mxuuid", (Object)jsonObject.getString("mxuuid"));
                                invoiceDynamicObject.set("recorded_rzuuid", (Object)jsonObject.getString("rzuuid"));
                            }
                            if (invoiceDynamicObjectMap.containsKey(invoiceType)) {
                                dynamicObjects1 = (ArrayList<DynamicObject>)invoiceDynamicObjectMap.get(invoiceType);
                                dynamicObjects1.add(invoiceDynamicObject);
                                continue;
                            }
                            dynamicObjects1 = new ArrayList<DynamicObject>(1);
                            dynamicObjects1.add(invoiceDynamicObject);
                            invoiceDynamicObjectMap.put(invoiceType, dynamicObjects1);
                        }
                        for (List dynamicObjectList : invoiceDynamicObjectMap.values()) {
                            SaveServiceHelper.save((DynamicObject[])dynamicObjectList.toArray(new DynamicObject[dynamicObjectList.size()]));
                        }
                        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
                    }
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{selectLog});
                SaveServiceHelper.save((DynamicObject[])updateAccountList.toArray(new DynamicObject[updateAccountList.size()]));
            }
            catch (Throwable e) {
                LOGGER.error("\u52fe\u9009\u65e5\u5fd7/\u53f0\u8d26\u5931\u8d25", e);
                h.markRollback();
                throw e;
            }
        }
    }

    @Override
    protected JSONObject doSelect(Long orgId, JSONObject param) {
        NewEtaxDeductService deductService = new NewEtaxDeductService(orgId);
        return ((DeductService)deductService).gxInvoicesQuery(param);
    }
}

