/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.deduction.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.deduction.DeductService;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.AwsFpyService;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DeductionUtils;
import kd.imc.rim.common.utils.ImcConfigUtil;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.RimRetryPostUtil;
import kd.imc.rim.common.utils.UUID;
import org.apache.commons.lang3.tuple.Pair;

public class NewEtaxDeductService
extends DeductService {
    private static Log LOGGER = LogFactory.getLog(NewEtaxDeductService.class);
    private static final String SYNC_TYPE_03 = "03";
    private static final String SYNC_TYPE_04 = "04";
    private static final String SYNC_TYPE_08 = "08";
    private static final String SYNC_TYPE_09 = "09";
    private static Set<String> NOT_CUSTOM_FILEDS = Sets.newHashSet((Object[])new String[]{"invoiceType", "invoiceDate", "invoiceAmount", "effectiveTaxAmount", "totalTaxAmount"});
    private static Set<String> CUSTOM_FILEDS = Sets.newHashSet((Object[])new String[]{"customDeclarationNo", "invoiceDate", "effectiveTaxAmount", "totalTaxAmount"});
    private static Set<String> NOT_DEDUCTIBLE_TYPE = Sets.newHashSet((Object[])new String[]{"1", "2", "3", "4", "5"});
    protected static final Set<String> COLLECT_ERRCODE = new HashSet<String>(8);

    public NewEtaxDeductService(Long orgId) {
        this.orgId = orgId;
        COLLECT_ERRCODE.addAll(DeductionUtils.getEtaxRetryErrcodes());
    }

    @Override
    public JSONObject login(String taxNo) {
        JSONObject param = new JSONObject();
        param.put("taxNo", (Object)taxNo);
        return this.login(param);
    }

    @Override
    public JSONObject login(String taxNo, String operationKey, AbstractFormPlugin plugin) {
        JSONObject param = new JSONObject();
        param.put("taxNo", (Object)taxNo);
        param.put("fpdkType", (Object)"4");
        JSONObject loginResult = this.login(param);
        if (!ResultContant.isSuccess(loginResult).booleanValue()) {
            return loginResult;
        }
        JSONObject data = loginResult.getJSONObject("data");
        if (this.needOpenLoginPage(data)) {
            data.put("taxNo", (Object)taxNo);
            data.put("account", (Object)param.getString("account"));
            this.showLoginPage(data, plugin, "loginAfter" + operationKey);
            loginResult.put("errcode", (Object)ErrorType.NEED_LOGIN.getCode());
            loginResult.put("description", (Object)ErrorType.NEED_LOGIN.getName());
        }
        return loginResult;
    }

    @Override
    public void showLoginPage(JSONObject param, AbstractFormPlugin plugin, String actionId) {
        AwsFpyService service;
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bdm_tax_login");
        String taxNo = param.getString("taxNo");
        showParameter.setCustomParam("taxNo", (Object)taxNo);
        String allEaccount = param.getString("account");
        if (StringUtils.isEmpty((CharSequence)allEaccount) && StringUtils.isEmpty((CharSequence)(allEaccount = (service = AwsFpyService.newInstance()).getAllEaccount(taxNo)))) {
            throw new MsgException(ErrorType.NEED_LOGIN.getCode(), String.format(ResManager.loadKDString((String)"\u7a0e\u53f7:[%s]\u672a\u67e5\u8be2\u5230\u8d26\u53f7\u4fe1\u606f\uff0c\u8bf7\u524d\u5f80\u57fa\u7840\u8d44\u6599-\u4f01\u4e1a\u7ba1\u7406-\u6570\u7535\u914d\u7f6e\u8fdb\u884c\u76f8\u5173\u914d\u7f6e", (String)"NewEtaxDeductService_0", (String)"imc-rim-common", (Object[])new Object[0]), taxNo));
        }
        String checkAuth = RimConfigUtils.getConfig("rim_deduction", "e_tax_check_auth");
        checkAuth = Optional.ofNullable(checkAuth).filter(StringUtils::isNotEmpty).orElse("0");
        showParameter.setCustomParam("checkAuth", (Object)checkAuth);
        showParameter.setCustomParam("operationType", (Object)"2");
        showParameter.setCustomParam("loginWebUrls", (Object)param.getString("loginWebUrl"));
        showParameter.setCustomParam("longLinkName", (Object)param.getString("longLinkName"));
        showParameter.setCustomParam("account", (Object)allEaccount);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)plugin, actionId);
        showParameter.setCloseCallBack(closeCallBack);
        plugin.getView().showForm(showParameter);
    }

    @Override
    public void clearLoginState(String taxNo) {
        CacheHelper.remove("e_down_login_" + taxNo);
    }

    @Override
    public JSONObject login(JSONObject param) {
        if (param == null) {
            return ResultContant.createJSONObject("0103", ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"NewEtaxDeductService_1", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        String taxNo = param.getString("taxNo");
        if (StringUtils.isEmpty((CharSequence)taxNo)) {
            return ResultContant.createJSONObject("0103", ResManager.loadKDString((String)"\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"NewEtaxDeductService_2", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        String unitTestResult = CommonUtils.getUnitTestResult("Aws-", "newtax_login");
        if (StringUtils.isNotEmpty((CharSequence)unitTestResult)) {
            return JSONObject.parseObject((String)unitTestResult);
        }
        String allEaccount = param.getString("account");
        if (StringUtils.isEmpty((CharSequence)allEaccount)) {
            AwsFpyService service = AwsFpyService.newInstance();
            allEaccount = service.getAllEaccount(taxNo);
        }
        if (StringUtils.isEmpty((CharSequence)allEaccount)) {
            return ResultContant.createJSONObject(ErrorType.NEED_LOGIN.getCode(), String.format(ResManager.loadKDString((String)"\u7a0e\u53f7:[%s]\u672a\u67e5\u8be2\u5230\u8d26\u53f7\u4fe1\u606f\uff0c\u8bf7\u524d\u5f80\u57fa\u7840\u8d44\u6599-\u4f01\u4e1a\u7ba1\u7406-\u6570\u7535\u914d\u7f6e\u8fdb\u884c\u76f8\u5173\u914d\u7f6e", (String)"NewEtaxDeductService_0", (String)"imc-rim-common", (Object[])new Object[0]), taxNo));
        }
        param.put("account", (Object)allEaccount);
        String checkAuth = RimConfigUtils.getConfig("rim_deduction", "e_tax_check_auth");
        checkAuth = Optional.ofNullable(checkAuth).filter(StringUtils::isNotEmpty).orElse("0");
        param.put("checkAuth", (Object)checkAuth);
        param.put("operationType", (Object)"2");
        String result = (String)DispatchServiceHelper.invokeBizService((String)"imc", (String)"bdm", (String)"AllEInvoiceInputHelper", (String)"checkLogin", (Object[])new Object[]{param});
        LOGGER.info("\u767b\u5f55\u7ed3\u679c:{},{}", (Object)taxNo, (Object)JSONObject.toJSONString((Object)result));
        if (StringUtils.isBlank((CharSequence)result)) {
            return ResultContant.createJSONObject("0204", ResManager.loadKDString((String)"\u767b\u5f55\u5931\u8d25", (String)"NewEtaxDeductService_3", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        JSONObject resultJson = JSONObject.parseObject((String)result);
        if (ResultContant.isSuccess(resultJson).booleanValue()) {
            JSONObject data = resultJson.getJSONObject("data");
            if (data != null) {
                if (StringUtils.isNotEmpty((CharSequence)data.getString("skssq"))) {
                    DeductionConstant.cacheSkssq(taxNo, data.getString("skssq"));
                }
            } else {
                resultJson.put("errcode", (Object)ErrorType.FAIL.getCode());
                resultJson.put("description", (Object)ResManager.loadKDString((String)"\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a", (String)"NewEtaxDeductService_4", (String)"imc-rim-common", (Object[])new Object[0]));
            }
        }
        if (ResultContant.isSuccess(resultJson).booleanValue()) {
            this.clearLoginState(taxNo);
        }
        return resultJson;
    }

    @Override
    public JSONObject queryTaxperiod(String taxNo) {
        try {
            AwsFpyService service = AwsFpyService.newInstance();
            JSONObject param = new JSONObject();
            DeductionConstant.setUnittestFlag((Map<String, Object>)param);
            param.put("request_path", (Object)"/fpdk/getSkssq");
            param.put("taxNo", (Object)taxNo);
            LOGGER.info("\u540c\u6b65\u83b7\u53d6\u7a0e\u671f\u53c2\u6570:{}", (Object)param);
            JSONObject resultJson = this.allEPostAppJson(service, this.orgId, taxNo, param);
            if (null == resultJson) {
                return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u83b7\u53d6\u62b5\u6263\u7a0e\u671f\u5931\u8d25", (String)"NewEtaxDeductService_5", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            LOGGER.info("\u540c\u6b65\u83b7\u53d6\u7a0e\u671f\u7ed3\u679c\u8fd4\u56de:{}-{}", (Object)taxNo, (Object)resultJson);
            return resultJson;
        }
        catch (Exception e) {
            LOGGER.error("\u540c\u6b65\u83b7\u53d6\u7a0e\u671f\u5931\u8d25:" + taxNo, (Throwable)e);
            return null;
        }
    }

    @Override
    public JSONObject changeTaxperiod(JSONObject bodyJson) {
        String taxNo = bodyJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        String taxPeriod = bodyJson.getString("taxPeriod");
        if (StringUtils.isBlank((CharSequence)taxPeriod)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL.getCode(), ResManager.loadKDString((String)"\u53d8\u66f4\u540e\u7684\u6240\u5c5e\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"NewEtaxDeductService_6", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        bodyJson.put("Bghskssq", (Object)taxPeriod);
        bodyJson.remove((Object)"taxPeriod");
        DeductionConstant.setUnittestFlag((Map<String, Object>)bodyJson);
        bodyJson.put("request_path", (Object)"/fpdk/taxPeriod");
        AwsFpyService service = AwsFpyService.newInstance();
        JSONObject resultJson = this.allEPostAppJson(service, this.orgId, taxNo, bodyJson);
        if (null == resultJson) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u53d8\u66f4\u7a0e\u671f\u5931\u8d25", (String)"NewEtaxDeductService_7", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        if (ResultContant.isSuccess(resultJson).booleanValue()) {
            CacheHelper.remove("rim_skssq" + taxNo);
        }
        LOGGER.info("\u53d8\u66f4\u7a0e\u671f\u7ed3\u679c\u8fd4\u56de:{}-{}", (Object)taxNo, (Object)resultJson);
        return resultJson;
    }

    @Override
    public JSONObject queryInvoices(JSONObject bodyJson) {
        boolean queryDrawback;
        String taxNo = bodyJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        DeductionConstant.setUnittestFlag((Map<String, Object>)bodyJson);
        JSONObject searchOpt = bodyJson.getJSONObject("searchOpt");
        if (searchOpt == null) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL);
        }
        String asyncFlag = bodyJson.getString("asyncFlag");
        String batchNo = UUID.getBatchNoByTaxNo(taxNo);
        if ("1".equals(asyncFlag)) {
            JSONObject resultJson = ResultContant.createSuccessJSONObject();
            return DeductionUtils.setBatchNo2Result(resultJson, asyncFlag, batchNo);
        }
        String dkType = bodyJson.getString("dkType");
        String billType = bodyJson.getString("billType");
        searchOpt.put("filterByInvoiceDate", (Object)true);
        String invoiceType = searchOpt.getString("invoiceType");
        String authenticateFlags = searchOpt.getString("authenticateFlags");
        String syncType = bodyJson.getString("synctype");
        boolean bl = queryDrawback = !"1".equals(dkType) && (StringUtils.isEmpty((CharSequence)authenticateFlags) || authenticateFlags.contains("1") || authenticateFlags.contains("2"));
        if (StringUtils.isNotEmpty((CharSequence)invoiceType)) {
            JSONObject result = this.queryInvoicesByType(bodyJson, invoiceType, syncType);
            if (!ResultContant.isSuccess(result).booleanValue()) {
                return result;
            }
            if (SYNC_TYPE_04.equals(syncType) && queryDrawback && InputInvoiceTypeEnum.allowDrawbackType(invoiceType)) {
                JSONObject resultDrawback = this.queryInvoicesByType(bodyJson, invoiceType, SYNC_TYPE_08);
                this.addExtInvoice(result, resultDrawback);
            }
            return result;
        }
        JSONObject result = this.queryInvoicesByType(bodyJson, invoiceType, syncType);
        if (!ResultContant.isSuccess(result).booleanValue()) {
            return result;
        }
        if (SYNC_TYPE_04.equals(syncType) && queryDrawback) {
            JSONObject resultDrawback = this.queryInvoicesByType(bodyJson, invoiceType, SYNC_TYPE_08);
            this.addExtInvoice(result, resultDrawback);
        }
        if (!"0".equals(billType)) {
            invoiceType = "21";
            searchOpt.put("invoiceType", (Object)invoiceType);
            searchOpt.put("customDeclarationNo", (Object)"");
            bodyJson.put("searchOpt", (Object)searchOpt);
            JSONObject resultHgjks = this.queryInvoicesByType(bodyJson, invoiceType, syncType);
            this.addExtInvoice(result, resultHgjks);
        }
        return result;
    }

    private void addExtInvoice(JSONObject result, JSONObject extResult) {
        if (result == null) {
            return;
        }
        if (ResultContant.isSuccess(extResult).booleanValue()) {
            JSONArray dataHg = extResult.getJSONArray("data");
            JSONArray data = result.getJSONArray("data");
            if (data == null) {
                data = new JSONArray();
            }
            if (!CollectionUtils.isEmpty((Collection)dataHg)) {
                data.addAll((Collection)dataHg);
            }
            result.put("data", (Object)data);
        }
    }

    private JSONObject queryInvoicesByType(JSONObject bodyJson, String invoiceType, String syncType) {
        boolean isFilter;
        JSONObject resultJson;
        JSONArray invoices;
        String taxNo;
        block24: {
            block23: {
                taxNo = bodyJson.getString("taxNo");
                if (StringUtils.isBlank((CharSequence)taxNo)) {
                    return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
                }
                DeductionConstant.setUnittestFlag((Map<String, Object>)bodyJson);
                bodyJson.put("requestId", (Object)UUID.randomUUID());
                String disableCache = RimConfigUtils.getConfig("rim_deduction", "new_disable_cache");
                if ("1".equals(disableCache)) {
                    bodyJson.put("disableCache", (Object)true);
                }
                boolean isNotQueryPage = "1".equals(bodyJson.getString("notQueryPage"));
                String serialNo = "";
                int dataFromIndex = 0;
                int dataIndex = 0;
                if (isNotQueryPage) {
                    if (StringUtils.isNotBlank((CharSequence)bodyJson.getString("serialNo"))) {
                        serialNo = bodyJson.getString("serialNo");
                    }
                    if (StringUtils.isNotBlank((CharSequence)bodyJson.getString("dataFromIndex"))) {
                        dataFromIndex = bodyJson.getInteger("dataFromIndex");
                    }
                    if (StringUtils.isNotBlank((CharSequence)bodyJson.getString("dataIndex"))) {
                        dataIndex = bodyJson.getInteger("dataIndex");
                    }
                }
                bodyJson.put("serialNo", (Object)serialNo);
                bodyJson.put("dataFromIndex", (Object)dataFromIndex);
                bodyJson.put("dataIndex", (Object)dataIndex);
                bodyJson.put("clientType", (Object)"4");
                bodyJson.put("versionNo", (Object)"");
                bodyJson.put("continueFlag", (Object)Boolean.TRUE);
                AwsFpyService service = AwsFpyService.newInstance();
                invoices = new JSONArray();
                resultJson = null;
                String requestPath = "/fpdk/queryInvoice";
                if ("21".equals(invoiceType)) {
                    requestPath = "/fpdk/customBill/query";
                    if (SYNC_TYPE_03.equals(syncType)) {
                        requestPath = "/fpdk/query/ygxCustomBill";
                    } else if (SYNC_TYPE_08.equals(syncType) || SYNC_TYPE_09.equals(syncType)) {
                        return ResultContant.createSuccessJSONObject(new JSONArray());
                    }
                } else if (SYNC_TYPE_03.equals(syncType)) {
                    requestPath = "/fpdk/query/ygxInvoices";
                } else if (SYNC_TYPE_08.equals(syncType)) {
                    requestPath = "/fpdk/tsgx/queryInvoices";
                } else if (SYNC_TYPE_09.equals(syncType)) {
                    requestPath = "/fpdk/tsyt/ygxInvoices";
                }
                bodyJson.put("request_path", (Object)requestPath);
                while (true) {
                    LOGGER.info("\u4e0b\u8f7d\u53d1\u7968\u53c2\u6570:{}", (Object)bodyJson);
                    resultJson = this.allEPostAppJson(service, this.orgId, taxNo, bodyJson);
                    if (!ResultContant.isSuccess(resultJson).booleanValue()) break block23;
                    JSONArray invoiceArray = resultJson.getJSONArray("data");
                    invoices.addAll((Collection)invoiceArray);
                    String endFlag = resultJson.getString("endFlag");
                    if (!"false".equals(endFlag)) break;
                    resultJson.put("continueFlag", (Object)true);
                    if (!isNotQueryPage) {
                        bodyJson.put("requestId", (Object)UUID.randomUUID());
                        bodyJson.put("serialNo", (Object)resultJson.getString("serialNo"));
                        bodyJson.put("dataFromIndex", resultJson.get((Object)"nextDataFromIndex"));
                        bodyJson.put("dataIndex", resultJson.get((Object)"nextDataIndex"));
                        continue;
                    }
                    break block24;
                    break;
                }
                resultJson.put("continueFlag", (Object)false);
                break block24;
            }
            if (resultJson == null) {
                resultJson = ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u4e0b\u8f7d\u5931\u8d25", (String)"NewEtaxDeductService_8", (String)"imc-rim-common", (Object[])new Object[0]));
            }
        }
        if (null == resultJson) {
            resultJson = ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u83b7\u53d6\u53d1\u7968\u5931\u8d25", (String)"NewEtaxDeductService_9", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        if ("21".equals(invoiceType) && !CollectionUtils.isEmpty((Collection)invoices)) {
            for (int i = 0; i < invoices.size(); ++i) {
                JSONObject obj = invoices.getJSONObject(i);
                obj.put("invoiceNo", obj.get((Object)"customDeclarationNo"));
            }
        }
        boolean bl = isFilter = !CollectionUtils.isEmpty((Collection)invoices) && (SYNC_TYPE_03.equals(syncType) || SYNC_TYPE_09.equals(syncType)) && StringUtils.isNotEmpty((CharSequence)invoiceType) && !"21".equals(invoiceType);
        if (isFilter) {
            invoices.removeIf(s -> {
                JSONObject invoice = JSONObject.parseObject((String)JSONObject.toJSONString((Object)s));
                return !StringUtils.equals((CharSequence)invoiceType, (CharSequence)invoice.getString("invoiceType"));
            });
        }
        resultJson.put("data", (Object)invoices);
        LOGGER.info("\u4e0b\u8f7d\u53d1\u7968\u8fd4\u56de\u7ed3\u679c:{}-{}", (Object)taxNo, (Object)resultJson);
        LOGGER.info("\u4e0b\u8f7d\u53d1\u7968\u8fd4\u56de\u7ed3\u679c:[{}]{},\u4e0b\u8f7d\u6570\u91cf:{}", new Object[]{resultJson.get((Object)"errcode"), resultJson.get((Object)"description"), invoices.size()});
        return resultJson;
    }

    @Override
    public JSONObject getStatisticTable(JSONObject bodyJson) {
        String taxNo = bodyJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        String requestId = DeductionConstant.getRequestId(bodyJson);
        bodyJson.put("requestId", (Object)requestId);
        bodyJson.put("request_path", (Object)"/fpdk/dkgx/dqtjcx");
        DeductionConstant.setUnittestFlag((Map<String, Object>)bodyJson);
        String config = RimConfigUtils.getConfig("rim_deduction", "all_tjbb");
        String allTjbb = Optional.ofNullable(config).orElse("1");
        bodyJson.put("allTjbb", (Object)allTjbb);
        LOGGER.info("\u67e5\u8be2\u7edf\u8ba1\u8868\u53c2\u6570:{}", (Object)bodyJson);
        AwsFpyService service = AwsFpyService.newInstance();
        JSONObject resultJson = this.allEPostAppJson(service, this.orgId, taxNo, bodyJson);
        if (null == resultJson) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u83b7\u53d6\u7edf\u8ba1\u8868\u5931\u8d25", (String)"NewEtaxDeductService_10", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        JSONObject data = resultJson.getJSONObject("data");
        if (data != null) {
            data.put("tjxx", data.get((Object)"tjInfoArr"));
            this.updateCacheTaxperiod(taxNo, resultJson);
        }
        LOGGER.info("\u67e5\u8be2\u7edf\u8ba1\u8868\u8fd4\u56de\u7ed3\u679c:{}-{}", (Object)taxNo, (Object)resultJson);
        return resultJson;
    }

    @Override
    public JSONObject createStatisticTable(JSONObject bodyJson) {
        if (ObjectUtils.isEmpty((Object)bodyJson)) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL);
        }
        String taxNo = bodyJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        String requestId = DeductionConstant.getRequestId(bodyJson);
        bodyJson.put("requestId", (Object)requestId);
        bodyJson.put("request_path", (Object)"/fpdk/dkgx/scdktjbb");
        DeductionConstant.setUnittestFlag((Map<String, Object>)bodyJson);
        String config = RimConfigUtils.getConfig("rim_deduction", "all_tjbb");
        String allTjbb = Optional.ofNullable(config).orElse("1");
        bodyJson.put("allTjbb", (Object)allTjbb);
        LOGGER.info("\u751f\u6210\u7edf\u8ba1\u8868\u53c2\u6570:{}", (Object)bodyJson);
        String batchNo = UUID.getBatchNoByTaxNo(taxNo);
        String asyncFlag = bodyJson.getString("asyncFlag");
        if ("1".equals(asyncFlag)) {
            JSONObject resultJson = ResultContant.createSuccessJSONObject();
            return DeductionUtils.setBatchNo2Result(resultJson, asyncFlag, batchNo);
        }
        AwsFpyService service = AwsFpyService.newInstance();
        JSONObject resultJson = this.allEPostAppJson(service, this.orgId, taxNo, bodyJson);
        if (null == resultJson) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u751f\u6210\u7edf\u8ba1\u8868\u5931\u8d25,\u8bf7\u91cd\u65b0\u67e5\u8be2\u7edf\u8ba1\u8868", (String)"NewEtaxDeductService_11", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        JSONObject data = resultJson.getJSONObject("data");
        if (data != null) {
            data.put("tjxx", data.get((Object)"tjInfoArr"));
            this.updateCacheTaxperiod(taxNo, resultJson);
        }
        LOGGER.info("\u751f\u6210\u7edf\u8ba1\u8868\u8fd4\u56de\u7ed3\u679c:{}-{}", (Object)taxNo, (Object)resultJson);
        return DeductionUtils.setBatchNo2Result(resultJson, asyncFlag, batchNo);
    }

    @Override
    public JSONObject cancelStatisticTable(JSONObject bodyJson) {
        if (ObjectUtils.isEmpty((Object)bodyJson)) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL);
        }
        String taxNo = bodyJson.getString("taxNo");
        JSONObject resultJson = ResultContant.createSuccessJSONObject();
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        String requestId = DeductionConstant.getRequestId(bodyJson);
        bodyJson.put("requestId", (Object)requestId);
        bodyJson.put("request_path", (Object)"/fpdk/dkgx/qxdktjbb");
        DeductionConstant.setUnittestFlag((Map<String, Object>)bodyJson);
        LOGGER.info("\u53d6\u6d88\u7edf\u8ba1\u8868\u53c2\u6570:{}", (Object)bodyJson);
        String batchNo = UUID.getBatchNoByTaxNo(taxNo);
        String asyncFlag = bodyJson.getString("asyncFlag");
        if ("1".equals(asyncFlag)) {
            return DeductionUtils.setBatchNo2Result(resultJson, asyncFlag, batchNo);
        }
        AwsFpyService service = AwsFpyService.newInstance();
        resultJson = this.allEPostAppJson(service, this.orgId, taxNo, bodyJson);
        if (null == resultJson) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u64a4\u9500\u7edf\u8ba1\u8868\u5931\u8d25", (String)"NewEtaxDeductService_12", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        LOGGER.info("\u64a4\u9500\u7edf\u8ba1\u8868\u8fd4\u56de\u7ed3\u679c:{}-{}", (Object)taxNo, (Object)resultJson);
        return DeductionUtils.setBatchNo2Result(resultJson, asyncFlag, batchNo);
    }

    @Override
    public JSONObject confirmStatisticTable(JSONObject paramJson) {
        String taxNo = paramJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        JSONObject resultJson = ResultContant.createSuccessJSONObject();
        if (StringUtils.isBlank((Object)paramJson)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        String requestId = DeductionConstant.getRequestId(paramJson);
        paramJson.put("requestId", (Object)requestId);
        paramJson.put("request_path", (Object)"/fpdk/dkgx/gxConfirm");
        DeductionConstant.setUnittestFlag((Map<String, Object>)paramJson);
        LOGGER.info("\u786e\u8ba4\u7b7e\u540d\u53c2\u6570:{}", (Object)paramJson);
        String batchNo = UUID.getBatchNoByTaxNo(taxNo);
        String asyncFlag = paramJson.getString("asyncFlag");
        if ("1".equals(asyncFlag)) {
            return DeductionUtils.setBatchNo2Result(resultJson, asyncFlag, batchNo);
        }
        AwsFpyService service = AwsFpyService.newInstance();
        resultJson = this.allEPostAppJson(service, this.orgId, taxNo, paramJson);
        if (null == resultJson) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u786e\u8ba4\u7edf\u8ba1\u8868\u5931\u8d25", (String)"NewEtaxDeductService_13", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        LOGGER.info("\u7edf\u8ba1\u8868\u786e\u8ba4\u7b7e\u540d\u8fd4\u56de\u7ed3\u679c{}-{}", (Object)taxNo, (Object)resultJson);
        this.updateCacheTaxperiod(taxNo, resultJson);
        return DeductionUtils.setBatchNo2Result(resultJson, asyncFlag, batchNo);
    }

    @Override
    public JSONObject gxInvoices(JSONObject bodyJson) {
        JSONObject data;
        if (null == bodyJson) {
            return ResultContant.createJSONObject("0201", ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"NewEtaxDeductService_1", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        String taxNo = bodyJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        JSONArray invoices = bodyJson.getJSONArray("invoices");
        if (StringUtils.isBlank((Object)invoices)) {
            return ResultContant.createJSONObject("0201", ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"NewEtaxDeductService_1", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        String requestId = DeductionConstant.getRequestId(bodyJson);
        bodyJson.put("requestId", (Object)requestId);
        DeductionConstant.setUnittestFlag((Map<String, Object>)bodyJson);
        LOGGER.info("\u52fe\u9009\u53d1\u7968\u8bf7\u6c42\u53c2\u6570:{}", (Object)bodyJson);
        String asyncFlag = bodyJson.getString("asyncFlag");
        if ("1".equals(asyncFlag)) {
            return this.gxInvoicesAsyn(bodyJson);
        }
        AwsFpyService service = AwsFpyService.newInstance();
        String requestPath = "/fpdk/dkgx/gxInvoices";
        String deductibleMode = bodyJson.getString("deductibleMode");
        Pair<String, String> deductionPurposePair = DeductionConstant.getDeductionPurpose(deductibleMode);
        String authenticateFlag = (String)deductionPurposePair.getLeft();
        String deductionPurpose = (String)deductionPurposePair.getRight();
        if ("2".equals(deductionPurpose)) {
            requestPath = "/fpdk/bdkgx/gxInvoices";
        } else if ("3".equals(deductionPurpose)) {
            requestPath = "/fpdk/tsgx/gxInvoices";
        }
        String billType = bodyJson.getString("billType");
        if ("1".equals(billType)) {
            requestPath = "/fpdk/customBill/dkgx";
            if ("2".equals(deductionPurpose)) {
                requestPath = "/fpdk/customBill/bdkgx";
            } else if ("3".equals(deductionPurpose)) {
                return ResultContant.createJSONObject("0201", ResManager.loadKDString((String)"RPA\u4e0d\u652f\u6301\u6d77\u5173\u7f34\u6b3e\u4e66\u9000\u7a0e\u52fe\u9009", (String)"NewEtaxDeductService_14", (String)"imc-rim-common", (Object[])new Object[0]));
            }
        } else if ("2".equals(billType)) {
            return ResultContant.createJSONObject(ErrorType.DKDJ_NONSUPPORT);
        }
        bodyJson.put("authenticateFlag", (Object)Integer.parseInt(authenticateFlag));
        bodyJson.put("request_path", (Object)requestPath);
        JSONObject resultJson = this.allEPostAppJson(service, this.orgId, taxNo, bodyJson);
        if (null == resultJson) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u52fe\u9009\u53d1\u7968\u5931\u8d25", (String)"NewEtaxDeductService_15", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        LOGGER.info("\u52fe\u9009\u53d1\u7968\u8fd4\u56de\u7ed3\u679c:{}-{}", (Object)taxNo, (Object)resultJson);
        if ("91300".equals(resultJson.getString("errcode"))) {
            resultJson.remove((Object)"data");
        }
        if ("1".equals(billType) && !ObjectUtils.isEmpty((Object)(data = resultJson.getJSONObject("data")))) {
            this.handleInvoiceNo(data.getJSONArray("success"));
            this.handleInvoiceNo(data.getJSONArray("fail"));
        }
        if (!"3".equals(deductionPurpose)) {
            this.updateCacheTaxperiod(taxNo, resultJson);
        }
        return resultJson;
    }

    @Override
    public JSONObject gxInvoicesAsyn(JSONObject paramJson) {
        JSONObject resultJson;
        JSONObject jsonInvoiceParam;
        JSONObject jsonObject;
        int i;
        if (StringUtils.isBlank((Object)paramJson)) {
            return ResultContant.createJSONObject("0201", ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"NewEtaxDeductService_1", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        JSONArray invoices = paramJson.getJSONArray("invoices");
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)invoices)) {
            return ResultContant.createJSONObject("0201", ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"NewEtaxDeductService_1", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        String taxNo = paramJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        String deductibleMode = paramJson.getString("deductibleMode");
        Pair<String, String> deductionPurposePair = DeductionConstant.getDeductionPurpose(deductibleMode);
        String authenticateFlag = (String)deductionPurposePair.getLeft();
        String deductionPurpose = (String)deductionPurposePair.getRight();
        String billType = paramJson.getString("billType");
        ArrayList<JSONObject> invoiceList = new ArrayList<JSONObject>(1);
        if ("1".equals(billType)) {
            for (i = 0; i < invoices.size(); ++i) {
                jsonObject = invoices.getJSONObject(i);
                jsonInvoiceParam = new JSONObject();
                String customDeclarationNo = jsonObject.getString("customDeclarationNo");
                if (NewEtaxDeductService.checkHaveNullRpa(CUSTOM_FILEDS, jsonObject) || !this.checkNotDeductReason(deductibleMode, jsonObject, jsonInvoiceParam, customDeclarationNo)) continue;
                jsonInvoiceParam.put("customDeclarationNo", (Object)customDeclarationNo);
                jsonInvoiceParam.put("invoiceDate", (Object)jsonObject.getString("invoiceDate"));
                jsonInvoiceParam.put("effectiveTaxAmount", (Object)jsonObject.getString("effectiveTaxAmount"));
                jsonInvoiceParam.put("totalTaxAmount", (Object)jsonObject.getString("totalTaxAmount"));
                invoiceList.add(jsonInvoiceParam);
            }
        } else {
            for (i = 0; i < invoices.size(); ++i) {
                jsonObject = invoices.getJSONObject(i);
                jsonInvoiceParam = new JSONObject();
                String invoiceCode = jsonObject.getString("invoiceCode");
                String invoiceNo = jsonObject.getString("invoiceNo");
                if (NewEtaxDeductService.checkHaveNullRpa(NOT_CUSTOM_FILEDS, jsonObject) || !this.checkNotDeductReason(deductibleMode, jsonObject, jsonInvoiceParam, CommonUtils.getInvoiceCodeNoGroup(invoiceCode, invoiceNo))) continue;
                jsonInvoiceParam.put("salerName", (Object)jsonObject.getString("salerName"));
                jsonInvoiceParam.put("salerTaxNo", (Object)jsonObject.getString("salerTaxNo"));
                jsonInvoiceParam.put("invoiceType", (Object)Integer.valueOf(jsonObject.getString("invoiceType")));
                jsonInvoiceParam.put("invoiceCode", (Object)invoiceCode);
                jsonInvoiceParam.put("etaxInvoiceNo", (Object)jsonObject.getString("etaxInvoiceNo"));
                jsonInvoiceParam.put("invoiceNo", (Object)invoiceNo);
                jsonInvoiceParam.put("invoiceDate", (Object)jsonObject.getString("invoiceDate"));
                jsonInvoiceParam.put("invoiceAmount", (Object)jsonObject.getString("invoiceAmount"));
                jsonInvoiceParam.put("effectiveTaxAmount", (Object)jsonObject.getString("effectiveTaxAmount"));
                jsonInvoiceParam.put("totalTaxAmount", (Object)jsonObject.getString("totalTaxAmount"));
                invoiceList.add(jsonInvoiceParam);
            }
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty(invoiceList)) {
            LOGGER.info("\u4e0d\u5b58\u5728\u6ee1\u8db3\u6761\u4ef6\u8c03\u7528rpa\u5f02\u6b65\u5165\u8d26\u7684\u53d1\u7968\u6570\u636e");
            return ResultContant.createJSONObject("0201", ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u6ee1\u8db3\u6761\u4ef6\u8c03\u7528rpa\u5f02\u6b65\u5165\u8d26\u7684\u53d1\u7968\u6570\u636e", (String)"NewEtaxDeductService_42", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        LOGGER.info("rpa\u5f02\u6b65\u52fe\u9009\u63d0\u4ea4\uff0c\u7533\u8bf7\u53c2\u6570:{}", (Object)paramJson);
        AwsFpyService service = AwsFpyService.newInstance();
        String allEaccount = service.getAllEaccount(taxNo);
        if (StringUtils.isEmpty((CharSequence)allEaccount)) {
            return ResultContant.createJSONObject(ErrorType.NEED_LOGIN.getCode(), String.format(ResManager.loadKDString((String)"\u7a0e\u53f7:[%s]\u672a\u67e5\u8be2\u5230\u8d26\u53f7\u4fe1\u606f\uff0c\u8bf7\u524d\u5f80\u57fa\u7840\u8d44\u6599-\u4f01\u4e1a\u7ba1\u7406-\u6570\u7535\u914d\u7f6e\u8fdb\u884c\u76f8\u5173\u914d\u7f6e", (String)"NewEtaxDeductService_0", (String)"imc-rim-common", (Object[])new Object[0]), taxNo));
        }
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("reqid", UUID.getReqid());
        params.put("taxNo", taxNo);
        JSONObject body = new JSONObject();
        body.put("account", (Object)allEaccount);
        body.put("authenticateFlag", (Object)Integer.valueOf(authenticateFlag));
        body.put("deductionPurpose", (Object)deductionPurpose);
        body.put("invoices", invoiceList);
        body.put("body_encrypt", (Object)"1");
        String msgType = "msg_etax_duduct_apply";
        if ("1".equals(billType)) {
            msgType = "msg_etax_customs_duduct_apply";
        }
        if (null == (resultJson = service.postAppJsonByTenant(msgType, this.orgId, (Map<String, Object>)body, params, taxNo, true))) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"rpa\u5f02\u6b65\u52fe\u9009\u63d0\u4ea4\uff0c\u8bf7\u6c42\u5931\u8d25", (String)"NewEtaxDeductService_40", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        LOGGER.info("rpa\u5f02\u6b65\u52fe\u9009\u63d0\u4ea4\uff0c\u8fd4\u56de\u7ed3\u679c:{}-{}", (Object)taxNo, (Object)resultJson);
        return resultJson;
    }

    @Override
    public JSONObject gxInvoicesQuery(JSONObject bodyJson) {
        JSONObject data;
        JSONObject resultJson;
        String taxNo = bodyJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        String batchNo = bodyJson.getString("batchNo");
        if (StringUtils.isBlank((CharSequence)batchNo)) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL);
        }
        String billType = bodyJson.getString("billType");
        if (StringUtils.isBlank((CharSequence)billType)) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL);
        }
        LOGGER.info("\u5f00\u59cb\u67e5\u8be2rpa\u5f02\u6b65\u52fe\u9009\u7ed3\u679c-\u7533\u8bf7\u53c2\u6570:\u6279\u6b21\u53f7{}\uff0c\u7a0e\u53f7\uff0c{}\uff0cbillType\uff1a{}", new Object[]{batchNo, taxNo, billType});
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("taxNo", taxNo);
        params.put("reqid", UUID.getReqid());
        JSONObject body = new JSONObject();
        body.put("batchNo", (Object)batchNo);
        body.put("body_encrypt", (Object)"1");
        AwsFpyService service = AwsFpyService.newInstance();
        String msgType = "msg_etax_duduct_query";
        if ("1".equals(billType)) {
            msgType = "msg_etax_customs_duduct_query";
        }
        if (null == (resultJson = service.postAppJsonByTenant(msgType, this.orgId, (Map<String, Object>)body, params, taxNo, true))) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u67e5\u8be2rpa\u5f02\u6b65\u52fe\u9009\u7ed3\u679c\uff0c\u8bf7\u6c42\u5931\u8d25", (String)"NewEtaxDeductService_41", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        if (resultJson != null && ResultContant.isSuccess(resultJson).booleanValue() && !ObjectUtils.isEmpty((Object)(data = resultJson.getJSONObject("data")))) {
            this.handleTaxPeriod(data.getJSONArray("success"), data.getString("taxPeriod"));
        }
        LOGGER.info("\u67e5\u8be2rpa\u5f02\u6b65\u52fe\u9009\u7ed3\u679c\uff0c\u53d1\u7968\u7c7b\u578b\uff1a{}\uff0c \u8fd4\u56de\u7ed3\u679c:{}-{}", new Object[]{billType, taxNo, resultJson});
        return resultJson;
    }

    private void handleTaxPeriod(JSONArray invoices, String taxPeriod) {
        if (!CollectionUtils.isEmpty((Collection)invoices) && StringUtils.isNotBlank((CharSequence)"taxPeriod")) {
            for (int i = 0; i < invoices.size(); ++i) {
                JSONObject invoice = invoices.getJSONObject(i);
                if (invoice == null) continue;
                invoice.put("taxPeriod", (Object)taxPeriod);
            }
        }
    }

    private void handleInvoiceNo(JSONArray invoices) {
        if (!CollectionUtils.isEmpty((Collection)invoices)) {
            for (int i = 0; i < invoices.size(); ++i) {
                String invoiceNo;
                JSONObject invoice = invoices.getJSONObject(i);
                if (invoice == null || !StringUtils.isEmpty((CharSequence)(invoiceNo = invoice.getString("invoiceNo")))) continue;
                invoice.put("invoiceNo", (Object)invoice.getString("customDeclarationNo"));
            }
        }
    }

    @Override
    public JSONObject queryHistoryStatistics(String taxNo, String taxPeriod, String invoiceType) {
        return this.queryHistoryStatistics(taxNo, taxPeriod, invoiceType, SYNC_TYPE_03);
    }

    @Override
    public JSONObject queryHistoryStatistics(String taxNo, String taxPeriod, String invoiceType, String synctype) {
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        JSONObject bodyJson = new JSONObject();
        bodyJson.put("taxNo", (Object)taxNo);
        bodyJson.put("synccondition", (Object)taxPeriod);
        bodyJson.put("currentOrgId", (Object)0);
        bodyJson.put("jksbz", (Object)1);
        bodyJson.put("synctype", (Object)synctype);
        JSONObject searchOpt = new JSONObject();
        Date startTime = DateUtils.stringToDate(taxPeriod, "yyyy-MM");
        searchOpt.put("invoiceType", (Object)invoiceType);
        searchOpt.put("taxPeriod", (Object)DateUtils.format(startTime, "yyyyMM"));
        bodyJson.put("searchOpt", (Object)searchOpt);
        return this.queryInvoices(bodyJson);
    }

    @Override
    public JSONObject queryHistoryStatistics(String taxNo, String taxPeriod, boolean queryStatistics) {
        JSONObject resultJson = null;
        if (queryStatistics && !ResultContant.isSuccess(resultJson = this.queryHistoryStatisticsTable(taxNo, taxPeriod)).booleanValue()) {
            return resultJson;
        }
        JSONObject invoiceResult = this.queryHistoryStatistics(taxNo, taxPeriod);
        if (!ResultContant.isSuccess(invoiceResult).booleanValue()) {
            return invoiceResult;
        }
        if (resultJson != null && invoiceResult != null) {
            JSONObject data = resultJson.getJSONObject("data");
            JSONArray statistics = data.getJSONArray("tjxx");
            if (CollectionUtils.isEmpty((Collection)statistics)) {
                statistics = data.getJSONArray("tjInfoArr");
            }
            invoiceResult.put("tjxx", (Object)statistics);
            invoiceResult.put("tjInfoArr", (Object)statistics);
            invoiceResult.put("tjInfo", data.get((Object)"tjInfo"));
        }
        return invoiceResult;
    }

    @Override
    public JSONObject queryHistoryStatisticsTable(String taxNo, String taxPeriod) {
        JSONObject param = new JSONObject();
        param.put("taxNo", (Object)taxNo);
        param.put("request_path", (Object)"/fpdk/dkgx/wqtjcx");
        param.put("taxPeriod", (Object)taxPeriod.replace("-", ""));
        String config = RimConfigUtils.getConfig("rim_deduction", "all_tjbb");
        String allTjbb = Optional.ofNullable(config).orElse("1");
        param.put("allTjbb", (Object)allTjbb);
        LOGGER.info("\u67e5\u8be2\u5386\u53f2\u7edf\u8ba1\u8868\u53c2\u6570{}", (Object)param);
        AwsFpyService service = AwsFpyService.newInstance();
        JSONObject resultJson = this.allEPostAppJson(service, this.orgId, taxNo, param);
        if (null == resultJson) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u67e5\u8be2\u5386\u53f2\u7edf\u8ba1\u8868\u5931\u8d25", (String)"NewEtaxDeductService_16", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        LOGGER.info("\u67e5\u8be2\u5386\u53f2\u7edf\u8ba1\u8868\u8fd4\u56de\u7ed3\u679c{}-{}", (Object)taxNo, (Object)resultJson);
        return resultJson;
    }

    @Override
    public JSONObject applyFullInvoice(JSONObject paramJson) {
        String taxNo = paramJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject("0201", ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u5f53\u524d\u4f01\u4e1a\u7a0e\u53f7\u8f6f\u8bc1\u4e66\u914d\u7f6e\u662f\u5426\u6b63\u786e", (String)"NewEtaxDeductService_17", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        LOGGER.info("\u7533\u8bf7\u4e0b\u8f7d\u8fdb\u9500\u9879\u53d1\u7968\u53c2\u6570:{}", (Object)paramJson);
        AwsFpyService service = AwsFpyService.newInstance();
        String account = service.getAllEaccount(taxNo);
        paramJson.put("account", (Object)account);
        if (StringUtils.isEmpty((CharSequence)paramJson.getString("checkAuthenticateFlag"))) {
            paramJson.put("checkAuthenticateFlag", (Object)"0");
        }
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("taxNo", taxNo);
        params.put("reqid", UUID.getReqid());
        String nameConfig = ImcConfigUtil.getValue("websocket_config_name", taxNo);
        if (StringUtils.isNotEmpty((CharSequence)nameConfig)) {
            params.put("name", nameConfig);
        }
        int retryTime = InvoiceDownloadConstant.getPageSizeFromConfig(3, "all_e_retry_times");
        int sleepTime = InvoiceDownloadConstant.getPageSizeFromConfig(3000, "all_e_sleep_times");
        JSONObject resultJson = RimRetryPostUtil.retryPost(() -> service.postAppJsonByTenant("new_fpdk_fullInvoiceDownloadApply", this.orgId, (Map<String, Object>)paramJson, params, taxNo), COLLECT_ERRCODE, retryTime, sleepTime);
        LOGGER.info("\u7533\u8bf7\u4e0b\u8f7d\u8fdb\u9500\u9879\u53d1\u7968\u8fd4\u56de\u7ed3\u679c:{}-{}", (Object)taxNo, (Object)resultJson);
        return resultJson;
    }

    @Override
    public JSONObject downFullInvoice(JSONObject paramJson) {
        int sleepTime;
        int retryTime;
        AwsFpyService service;
        JSONObject resultJson;
        String taxNo = paramJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject("0201", ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u5f53\u524d\u4f01\u4e1a\u7a0e\u53f7\u8f6f\u8bc1\u4e66\u914d\u7f6e\u662f\u5426\u6b63\u786e", (String)"NewEtaxDeductService_17", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        String batchNo = paramJson.getString("batchNo");
        if (StringUtils.isBlank((CharSequence)batchNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL.getCode(), ResManager.loadKDString((String)"\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"NewEtaxDeductService_23", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        paramJson.put("requestId", (Object)UUID.randomUUID());
        LOGGER.info("\u4e0b\u8f7d\u8fdb\u9500\u9879\u53d1\u7968\u53c2\u6570-\u5f02\u6b65:{}", (Object)paramJson);
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("taxNo", taxNo);
        params.put("reqid", UUID.getReqid());
        String nameConfig = ImcConfigUtil.getValue("websocket_config_name", taxNo);
        if (StringUtils.isNotEmpty((CharSequence)nameConfig)) {
            params.put("name", nameConfig);
        }
        if (null == (resultJson = RimRetryPostUtil.retryPost(() -> this.lambda$downFullInvoice$2(service = AwsFpyService.newInstance(), paramJson, params, taxNo), COLLECT_ERRCODE, retryTime = InvoiceDownloadConstant.getPageSizeFromConfig(3, "all_e_retry_times"), sleepTime = InvoiceDownloadConstant.getPageSizeFromConfig(3000, "all_e_sleep_times")))) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u83b7\u53d6\u5168\u91cf\u53d1\u7968\u5931\u8d25", (String)"NewEtaxDeductService_19", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        LOGGER.info("\u65b0\u7535\u5b50\u5e73\u53f0\u5168\u91cf\u53d1\u7968\u4e0b\u8f7d\u7ed3\u679c\u8fd4\u56de-\u5f02\u6b65:{}-{}", (Object)taxNo, (Object)resultJson);
        return resultJson;
    }

    public JSONObject downFullInvoiceSync(JSONObject bodyParam) {
        String taxNo = bodyParam.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject("0201", ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u5f53\u524d\u4f01\u4e1a\u7a0e\u53f7\u8f6f\u8bc1\u4e66\u914d\u7f6e\u662f\u5426\u6b63\u786e", (String)"NewEtaxDeductService_17", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        boolean isCut = "1".equals(RimConfigUtils.getConfig("rim_deduction", "newetax_cut_flag"));
        AwsFpyService service = AwsFpyService.newInstance();
        bodyParam.put("request_path", (Object)"/fpdk/queryFullInvoices");
        bodyParam.put("requestId", (Object)UUID.randomUUID());
        JSONObject searchOpt = bodyParam.getJSONObject("searchOpt");
        if (ObjectUtils.isEmpty((Object)searchOpt)) {
            return ResultContant.createJSONObject("0201", ResManager.loadKDString((String)"\u67e5\u8be2\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"NewEtaxDeductService_18", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        Date startDate = searchOpt.getDate("startTime");
        Date endDate = searchOpt.getDate("endTime");
        String invoiceType = searchOpt.getString("invoiceType");
        if (InputInvoiceTypeEnum.HGJKS.getAwsType().equals(invoiceType)) {
            bodyParam.put("request_path", (Object)"/fpdk/customBill/queryFull");
        }
        int maxDays = InvoiceDownloadConstant.getPageSizeFromConfig(20, "newetax_cut_days");
        int cutNum = InvoiceDownloadConstant.getPageSizeFromConfig(3, "newetax_cut_num");
        if (cutNum > maxDays) {
            cutNum = maxDays;
        }
        long between = DateUtils.daysBetween(endDate, startDate);
        JSONObject resultJson = null;
        if (isCut && between >= (long)maxDays) {
            JSONArray invoices = new JSONArray();
            Map<Date, Date> dateDateMap = DateUtils.cutTimeRange(startDate, endDate, cutNum);
            for (Map.Entry<Date, Date> dateDateEntry : dateDateMap.entrySet()) {
                bodyParam.put("requestId", (Object)UUID.randomUUID());
                searchOpt.put("startTime", (Object)DateUtils.format(dateDateEntry.getKey()));
                searchOpt.put("endTime", (Object)DateUtils.format(dateDateEntry.getValue()));
                bodyParam.put("searchOpt", (Object)searchOpt);
                resultJson = this.allEPostAppJson(service, this.orgId, taxNo, bodyParam);
                LOGGER.info("\u65b0\u7535\u5b50\u5e73\u53f0\u5168\u91cf\u53d1\u7968\u4e0b\u8f7d\u7ed3\u679c\u8fd4\u56de:{}-{}", (Object)taxNo, (Object)resultJson);
                if (!ResultContant.isSuccess(resultJson).booleanValue()) break;
                JSONArray invoiceArray = resultJson.getJSONArray("data");
                if (CollectionUtils.isEmpty((Collection)invoiceArray)) continue;
                invoices.addAll((Collection)invoiceArray);
            }
            if (resultJson != null) {
                resultJson.put("data", (Object)invoices);
            }
        } else {
            resultJson = this.allEPostAppJson(service, this.orgId, taxNo, bodyParam);
            LOGGER.info("\u65b0\u7535\u5b50\u5e73\u53f0\u5168\u91cf\u53d1\u7968\u4e0b\u8f7d\u7ed3\u679c\u8fd4\u56de:{}-{}", (Object)taxNo, (Object)resultJson);
        }
        if (null == resultJson) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u83b7\u53d6\u5168\u91cf\u53d1\u7968\u5931\u8d25", (String)"NewEtaxDeductService_19", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        return resultJson;
    }

    @Override
    public JSONObject getDrawbackStatisticTable(JSONObject paramJson) {
        String taxNo = paramJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        String requestId = DeductionConstant.getRequestId(paramJson);
        paramJson.put("requestId", (Object)requestId);
        paramJson.put("isComfirm", (Object)"2");
        paramJson.put("request_path", (Object)"/fpdk/tsgx/querytsytb");
        paramJson.put("taxPeriod", (Object)DateUtils.format(new Date(), "yyyyMM"));
        DeductionConstant.setUnittestFlag((Map<String, Object>)paramJson);
        LOGGER.info("\u67e5\u8be2\u9000\u7a0e\u7edf\u8ba1\u8868\u53c2\u6570:{}", (Object)paramJson);
        AwsFpyService service = AwsFpyService.newInstance();
        JSONObject resultJson = this.allEPostAppJson(service, this.orgId, taxNo, paramJson);
        if (null == resultJson) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u83b7\u53d6\u9000\u7a0e\u7edf\u8ba1\u8868\u5931\u8d25", (String)"NewEtaxDeductService_20", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        LOGGER.info("\u67e5\u8be2\u9000\u7a0e\u7edf\u8ba1\u8868\u8fd4\u56de\u7ed3\u679c:{}-{}", (Object)taxNo, (Object)resultJson);
        return resultJson;
    }

    @Override
    public JSONObject drawbackStatisticConfirm(JSONObject paramJson) {
        String taxNo = paramJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        String requestId = DeductionConstant.getRequestId(paramJson);
        paramJson.put("requestId", (Object)requestId);
        paramJson.put("request_path", (Object)"/fpdk/tsgx/tsytComfirm");
        DeductionConstant.setUnittestFlag((Map<String, Object>)paramJson);
        LOGGER.info("\u786e\u8ba4\u9000\u7a0e\u7edf\u8ba1\u8868\u53c2\u6570:{}", (Object)paramJson);
        AwsFpyService service = AwsFpyService.newInstance();
        JSONObject resultJson = this.allEPostAppJson(service, this.orgId, taxNo, paramJson);
        if (null == resultJson) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u786e\u8ba4\u9000\u7a0e\u7edf\u8ba1\u8868\u5931\u8d25", (String)"NewEtaxDeductService_21", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        LOGGER.info("\u786e\u8ba4\u9000\u7a0e\u7edf\u8ba1\u8868\u8fd4\u56de\u7ed3\u679c:{}-{}", (Object)taxNo, (Object)resultJson);
        return resultJson;
    }

    @Override
    public JSONObject applyInvoiceFile(JSONObject paramJson) {
        AwsFpyService service;
        String allEaccount;
        String taxNo = paramJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        JSONArray invoices = paramJson.getJSONArray("invoices");
        if (StringUtils.isBlank((Object)invoices)) {
            return ResultContant.createJSONObject("0201", ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"NewEtaxDeductService_1", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        LOGGER.info("\u6587\u4ef6\u4e0b\u8f7d\u7533\u8bf7\u53c2\u6570:{}", (Object)paramJson);
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("taxNo", taxNo);
        params.put("reqid", UUID.getReqid());
        String nameConfig = ImcConfigUtil.getValue("websocket_config_name", taxNo);
        if (StringUtils.isNotEmpty((CharSequence)nameConfig)) {
            params.put("name", nameConfig);
        }
        if (StringUtils.isEmpty((CharSequence)(allEaccount = (service = AwsFpyService.newInstance()).getAllEaccount(taxNo)))) {
            return ResultContant.createJSONObject(ErrorType.NEED_LOGIN.getCode(), String.format(ResManager.loadKDString((String)"\u7a0e\u53f7:[%s]\u672a\u67e5\u8be2\u5230\u8d26\u53f7\u4fe1\u606f\uff0c\u8bf7\u524d\u5f80\u57fa\u7840\u8d44\u6599-\u4f01\u4e1a\u7ba1\u7406-\u6570\u7535\u914d\u7f6e\u8fdb\u884c\u76f8\u5173\u914d\u7f6e", (String)"NewEtaxDeductService_0", (String)"imc-rim-common", (Object[])new Object[0]), taxNo));
        }
        params.put("account", allEaccount);
        JSONObject resultJson = service.postAppJsonByTenant("new_fpdk_inputDownloadFileApply", this.orgId, JSON.toJSONString((Object)invoices), params, taxNo, false);
        if (null == resultJson) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u6587\u4ef6\u4e0b\u8f7d\u7533\u8bf7\u5931\u8d25", (String)"NewEtaxDeductService_22", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        LOGGER.info("\u7533\u8bf7\u6587\u4ef6\u4e0b\u8f7d\u8fd4\u56de\u7ed3\u679c:{}-{}", (Object)taxNo, (Object)resultJson);
        return resultJson;
    }

    @Override
    public JSONObject downInvoiceFile(JSONObject paramJson) {
        AwsFpyService service;
        JSONObject resultJson;
        String taxNo = paramJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        String batchNo = paramJson.getString("batchNo");
        if (StringUtils.isBlank((CharSequence)batchNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL.getCode(), ResManager.loadKDString((String)"\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"NewEtaxDeductService_23", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        LOGGER.info("\u6587\u4ef6\u4e0b\u8f7d\u53c2\u6570:{}", (Object)paramJson);
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("taxNo", taxNo);
        params.put("reqid", UUID.getReqid());
        String nameConfig = ImcConfigUtil.getValue("websocket_config_name", taxNo);
        if (StringUtils.isNotEmpty((CharSequence)nameConfig)) {
            params.put("name", nameConfig);
        }
        if (null == (resultJson = (service = AwsFpyService.newInstance()).postAppJsonByTenant("new_fpdk_inputDownloadFileQuery", this.orgId, (Map<String, Object>)paramJson, params, taxNo))) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25", (String)"NewEtaxDeductService_24", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        LOGGER.info("\u6587\u4ef6\u4e0b\u8f7d\u8fd4\u56de\u7ed3\u679c:{}-{}", (Object)taxNo, (Object)resultJson);
        return resultJson;
    }

    private void updateCacheTaxperiod(String taxNo, JSONObject reslut) {
        if (!ResultContant.isSuccess(reslut).booleanValue() || StringUtils.isEmpty((CharSequence)taxNo)) {
            return;
        }
        JSONObject data = reslut.getJSONObject("data");
        if (data == null) {
            return;
        }
        String skssq = CommonUtils.getJsonValue((Map<String, Object>)data, String.class, true, "taxPeriod", "skssq");
        if (StringUtils.isNotEmpty((CharSequence)skssq) && DeductionConstant.updateSkssq(taxNo).booleanValue()) {
            DeductionConstant.cacheSkssq(taxNo, skssq);
        }
    }

    @Override
    public JSONObject recordedCommit(JSONObject paramJson) {
        JSONObject resultJson;
        String taxNo = paramJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        String nextEntryMarkStatus = paramJson.getString("nextEntryMarkStatus");
        if (StringUtils.isBlank((CharSequence)nextEntryMarkStatus)) {
            return ResultContant.createJSONObject("0201", ResManager.loadKDString((String)"\u5165\u8d26\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (String)"NewEtaxDeductService_25", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        JSONArray invoices = paramJson.getJSONArray("invoices");
        if (StringUtils.isBlank((Object)invoices)) {
            return ResultContant.createJSONObject("0201", ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"NewEtaxDeductService_1", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        LOGGER.info("\u53d1\u7968\u5165\u8d26\u72b6\u6001\u63d0\u4ea4\uff0c\u7533\u8bf7\u53c2\u6570:{}", (Object)paramJson);
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("taxNo", taxNo);
        params.put("reqid", UUID.getReqid());
        AwsFpyService service = AwsFpyService.newInstance();
        String allEaccount = service.getAllEaccount(taxNo);
        if (StringUtils.isEmpty((CharSequence)allEaccount)) {
            return ResultContant.createJSONObject(ErrorType.NEED_LOGIN.getCode(), String.format(ResManager.loadKDString((String)"\u7a0e\u53f7:[%s]\u672a\u67e5\u8be2\u5230\u8d26\u53f7\u4fe1\u606f\uff0c\u8bf7\u524d\u5f80\u57fa\u7840\u8d44\u6599-\u4f01\u4e1a\u7ba1\u7406-\u6570\u7535\u914d\u7f6e\u8fdb\u884c\u76f8\u5173\u914d\u7f6e", (String)"NewEtaxDeductService_0", (String)"imc-rim-common", (Object[])new Object[0]), taxNo));
        }
        JSONObject body = new JSONObject();
        body.put("account", (Object)allEaccount);
        body.put("nextEntryMarkStatus", (Object)nextEntryMarkStatus);
        body.put("invoices", (Object)invoices);
        body.put("body_encrypt", (Object)"1");
        String msgType = "msg_new_fprz_recorded_commit";
        if ("06".equals(nextEntryMarkStatus)) {
            msgType = "msg_new_fprz_recorded_update";
        }
        if (null == (resultJson = service.postAppJsonByTenant(msgType, this.orgId, (Map<String, Object>)body, params, taxNo, true))) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u53d1\u7968\u5165\u8d26\u72b6\u6001\u63d0\u4ea4\uff0c\u8bf7\u6c42\u5931\u8d25", (String)"NewEtaxDeductService_26", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        LOGGER.info("\u53d1\u7968\u5165\u8d26\u72b6\u6001\u63d0\u4ea4\uff0c\u8fd4\u56de\u7ed3\u679c:{}-{}", (Object)taxNo, (Object)resultJson);
        return resultJson;
    }

    @Override
    public JSONObject queryRecordedCommitResult(Map<String, Object> selectLog) {
        JSONObject resultJson;
        String taxNo = (String)selectLog.get("tax_no");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        String batchNo = (String)selectLog.get("batch_no");
        if (StringUtils.isBlank((CharSequence)batchNo)) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL);
        }
        String operateType = (String)selectLog.get("operate_type");
        LOGGER.info("\u5f00\u59cb\u67e5\u8be2\u53d1\u7968\u5165\u8d26\u63d0\u4ea4/\u8c03\u6574\u7ed3\u679c-\u7533\u8bf7\u53c2\u6570:\u6279\u6b21\u53f7{}\uff0c\u7a0e\u53f7\uff0c{}\uff0c\u64cd\u4f5c\u7c7b\u578b\uff1a{}", new Object[]{batchNo, taxNo, operateType});
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("taxNo", taxNo);
        params.put("reqid", UUID.getReqid());
        JSONObject body = new JSONObject();
        body.put("batchNo", (Object)batchNo);
        body.put("body_encrypt", (Object)"1");
        AwsFpyService service = AwsFpyService.newInstance();
        String msgType = "msg_new_fprz_recorded_commit_query";
        if ("06".equals(operateType)) {
            msgType = "msg_new_fprz_recorded_update_query";
        }
        if (null == (resultJson = service.postAppJsonByTenant(msgType, this.orgId, (Map<String, Object>)body, params, taxNo, true))) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u67e5\u8be2\u53d1\u7968\u5165\u8d26\u63d0\u4ea4\u7ed3\u679c\uff0c\u8bf7\u6c42\u5931\u8d25", (String)"NewEtaxDeductService_27", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        LOGGER.info("\u67e5\u8be2\u53d1\u7968\u5165\u8d26\u63d0\u4ea4\u7ed3\u679c\uff0c\u64cd\u4f5c\u7c7b\u578b\uff1a{}\uff0c \u8fd4\u56de\u7ed3\u679c:{}-{}", new Object[]{operateType, taxNo, resultJson});
        return resultJson;
    }

    private boolean checkNotDeductReason(String deductibleMode, JSONObject jsonObject, JSONObject jsonInvoiceParam, String invoiceNo) {
        if ("4".equals(deductibleMode) || "-4".equals(deductibleMode)) {
            String notDeductibleType = jsonObject.getString("notDeductibleType");
            if (StringUtils.isBlank((CharSequence)notDeductibleType)) {
                return false;
            }
            if (!NOT_DEDUCTIBLE_TYPE.contains(notDeductibleType)) {
                return false;
            }
            if ("5".equals(notDeductibleType)) {
                if (StringUtils.isBlank((CharSequence)jsonObject.getString("notDeductibleText"))) {
                    jsonInvoiceParam.put("notDeductibleText", (Object)"\u5176\u4ed6");
                } else {
                    jsonInvoiceParam.put("notDeductibleText", (Object)jsonObject.getString("notDeductibleText"));
                }
            }
            jsonInvoiceParam.put("notDeductibleType", (Object)Integer.valueOf(notDeductibleType));
        }
        return true;
    }

    private static boolean checkHaveNullRpa(Set<String> fields, JSONObject data) {
        for (String field : fields) {
            Object value = data.get((Object)field);
            if (Objects.isNull(value)) {
                return true;
            }
            if (!(value instanceof String) || !org.apache.commons.lang.StringUtils.isBlank((String)((String)value))) continue;
            return true;
        }
        return false;
    }

    @Override
    public JSONObject applyDownAgricInvoice(JSONObject paramJson) {
        String taxNo = paramJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("taxNo", taxNo);
        params.put("reqid", UUID.getReqid());
        AwsFpyService service = AwsFpyService.newInstance();
        String allEaccount = service.getAllEaccount(taxNo);
        if (StringUtils.isEmpty((CharSequence)allEaccount)) {
            return ResultContant.createJSONObject(ErrorType.NEED_LOGIN.getCode(), String.format(ResManager.loadKDString((String)"\u7a0e\u53f7:[%s]\u672a\u67e5\u8be2\u5230\u8d26\u53f7\u4fe1\u606f\uff0c\u8bf7\u524d\u5f80\u57fa\u7840\u8d44\u6599-\u4f01\u4e1a\u7ba1\u7406-\u6570\u7535\u914d\u7f6e\u8fdb\u884c\u76f8\u5173\u914d\u7f6e", (String)"NewEtaxDeductService_0", (String)"imc-rim-common", (Object[])new Object[0]), taxNo));
        }
        paramJson.put("account", (Object)allEaccount);
        JSONObject resultJson = service.postAppJsonByTenant("msg_new_agric_invoice_down_apply", this.orgId, (Map<String, Object>)paramJson, params, taxNo, true);
        if (resultJson == null) {
            resultJson = ResultContant.createJSONObject("2002", ResManager.loadKDString((String)"\u519c\u4ea7\u54c1\u53d1\u7968\u7533\u8bf7\u4e0b\u8f7d\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"NewEtaxDeductService_28", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        LOGGER.info("\u7533\u8bf7\u5f85\u5904\u7406\u519c\u4ea7\u54c1\u53d1\u7968\u8fd4\u56de\u7ed3\u679c:{},{}", (Object)taxNo, (Object)resultJson);
        return resultJson;
    }

    @Override
    public JSONObject downAgricInvoice(JSONObject paramJson) {
        String taxNo = paramJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        String batchNo = paramJson.getString("batchNo");
        if (StringUtils.isBlank((CharSequence)batchNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL.getCode(), ResManager.loadKDString((String)"\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"NewEtaxDeductService_23", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("taxNo", taxNo);
        params.put("reqid", UUID.getReqid());
        AwsFpyService service = AwsFpyService.newInstance();
        JSONObject resultJson = service.postAppJsonByTenant("msg_new_agric_invoice_down_query", this.orgId, (Map<String, Object>)paramJson, params, taxNo, true);
        if (resultJson == null) {
            resultJson = ResultContant.createJSONObject("2002", ResManager.loadKDString((String)"\u519c\u4ea7\u54c1\u53d1\u7968\u67e5\u8be2\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"NewEtaxDeductService_29", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        LOGGER.info("\u4e0b\u8f7d\u5f85\u5904\u7406\u519c\u4ea7\u54c1\u53d1\u7968\u8fd4\u56de\u7ed3\u679c:{},{}", (Object)taxNo, (Object)resultJson);
        return resultJson;
    }

    @Override
    public JSONObject agricInvoiceHandle(JSONObject param) {
        String taxNo = param.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        JSONArray invoices = param.getJSONArray("invoices");
        if (CollectionUtils.isEmpty((Collection)invoices)) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"LqDeductService_27", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        AwsFpyService service = AwsFpyService.newInstance();
        JSONObject newParam = new JSONObject();
        String allEaccount = service.getAllEaccount(taxNo);
        if (StringUtils.isEmpty((CharSequence)allEaccount)) {
            return ResultContant.createJSONObject(ErrorType.NEED_LOGIN.getCode(), String.format(ResManager.loadKDString((String)"\u7a0e\u53f7:[%s]\u672a\u67e5\u8be2\u5230\u8d26\u53f7\u4fe1\u606f\uff0c\u8bf7\u524d\u5f80\u57fa\u7840\u8d44\u6599-\u4f01\u4e1a\u7ba1\u7406-\u6570\u7535\u914d\u7f6e\u8fdb\u884c\u76f8\u5173\u914d\u7f6e", (String)"NewEtaxDeductService_0", (String)"imc-rim-common", (Object[])new Object[0]), taxNo));
        }
        newParam.put("taxNo", (Object)taxNo);
        newParam.put("account", (Object)allEaccount);
        String deductibleMode = param.getString("deductibleMode");
        String processType = DeductionUtils.convertAgricPrehandleType(deductibleMode);
        String farmProductType = "1";
        if ("16".equals(deductibleMode) || "17".equals(deductibleMode)) {
            farmProductType = "2";
        }
        newParam.put("farmProductType", (Object)farmProductType);
        JSONArray fpmx = new JSONArray();
        for (int i = 0; i < invoices.size(); ++i) {
            JSONObject invoice = invoices.getJSONObject(i);
            String processingStatus = invoice.getString("agricHandleStatus");
            if (StringUtils.isEmpty((CharSequence)processingStatus)) {
                processingStatus = "0";
            }
            invoice.put("processingStatus", (Object)processingStatus);
            invoice.put("processType", (Object)processType);
            invoice.put("invoiceRiskLevel", (Object)DeductionUtils.convertInvoiceRiskLevelToAws(invoice.getString("invoiceRiskLevel")));
            if (!"15".equals(deductibleMode)) continue;
            invoice.put("farmProductAmount", invoice.get((Object)"agricPartialAmount"));
        }
        newParam.put("invoices", (Object)invoices);
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("taxNo", taxNo);
        params.put("reqid", UUID.getReqid());
        JSONObject result = service.postAppJsonByTenant("msg_new_agric_invoice_handle_apply", this.orgId, (Map<String, Object>)newParam, params, taxNo, true);
        LOGGER.info("RPA-\u6279\u91cf\u4e0a\u4f20\u519c\u4ea7\u54c1\u5904\u7406\u8fd4\u56de\u7ed3\u679c\uff1a{}-{}", (Object)taxNo, (Object)result);
        if (result == null) {
            result = ResultContant.createJSONObject(ErrorType.FAIL);
        }
        return result;
    }

    @Override
    public JSONObject agricInvoiceHandleQuery(JSONObject paramJson) {
        String taxNo = paramJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        String batchNo = paramJson.getString("batchNo");
        if (StringUtils.isBlank((CharSequence)batchNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL.getCode(), ResManager.loadKDString((String)"\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"NewEtaxDeductService_23", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("taxNo", taxNo);
        params.put("reqid", UUID.getReqid());
        AwsFpyService service = AwsFpyService.newInstance();
        JSONObject resultJson = service.postAppJsonByTenant("msg_new_agric_invoice_handle_query", this.orgId, (Map<String, Object>)paramJson, params, taxNo, true);
        if (resultJson == null) {
            resultJson = ResultContant.createJSONObject("2002", ResManager.loadKDString((String)"\u519c\u4ea7\u54c1\u53d1\u7968\u67e5\u8be2\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"NewEtaxDeductService_29", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        LOGGER.info("\u5904\u7406\u519c\u4ea7\u54c1\u53d1\u7968\u8fd4\u56de\u7ed3\u679c:{},{}", (Object)taxNo, (Object)resultJson);
        return resultJson;
    }

    public JSONObject allEPostAppJson(AwsFpyService service, Long orgId, String taxNo, JSONObject bodyJson) {
        int retryTime = InvoiceDownloadConstant.getPageSizeFromConfig(3, "all_e_retry_times");
        int sleepTime = InvoiceDownloadConstant.getPageSizeFromConfig(3000, "all_e_sleep_times");
        return RimRetryPostUtil.retryPost(() -> service.allEPostAppJson(orgId, taxNo, bodyJson), COLLECT_ERRCODE, retryTime, sleepTime);
    }

    private /* synthetic */ JSONObject lambda$downFullInvoice$2(AwsFpyService service, JSONObject paramJson, Map params, String taxNo) {
        return service.postAppJsonByTenant("new_fpdk_fullInvoiceDownloadQuery", this.orgId, (Map<String, Object>)paramJson, params, taxNo);
    }
}

