/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.download;

import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.invoice.download.InputOutInvoiceApplyService;
import kd.imc.rim.common.invoice.download.InvoiceDownServiceFactory;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.LockUtils;
import org.apache.commons.collections.CollectionUtils;

public class InvoiceApplyLogService {
    public void saveInitApplyLog(Long orgId, String taxNo, String outputDownload, String invoiceType, List<Map<String, Date>> initDateListt) {
        if (!CollectionUtils.isEmpty(initDateListt)) {
            for (Map<String, Date> stringDateMap : initDateListt) {
                Long invoiceTypeLong = InvoiceDownloadConstant.getInvoiceTypeByAwsType(invoiceType);
                DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"rim_down_apply_log");
                object.set("org", (Object)orgId);
                object.set("tax_no", (Object)taxNo);
                object.set("org", (Object)orgId);
                object.set("invoice_type", (Object)invoiceTypeLong);
                object.set("aws_invoice_type", (Object)invoiceType);
                object.set("inout", (Object)outputDownload);
                object.set("status", (Object)"2");
                object.set("invoice_startdate", (Object)stringDateMap.get("begin"));
                object.set("invoice_enddate", (Object)stringDateMap.get("end"));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
            }
        }
    }

    public void asyncExecuteApply() {
        ThreadPools.executeOnceIncludeRequestContext((String)"InvoiceApplyLogService.asyncExecuteApply", () -> this.executeApply());
    }

    public void executeApply() {
        try (DLock lock = DLock.create((String)"rim.executeApply", (String)"executeApply");){
            if (lock.tryLock()) {
                int pageSize = InvoiceDownloadConstant.getPageSizeFromConfig(20000, "execute_apply_size");
                QFilter filter = new QFilter("status", "=", (Object)"2");
                List logList = QueryServiceHelper.queryPrimaryKeys((String)"rim_down_apply_log", (QFilter[])new QFilter[]{filter}, null, (int)pageSize);
                this.dealApply(logList);
            }
        }
    }

    public void dealApply(List<Object> applyLogIds) {
        if (!CollectionUtils.isEmpty(applyLogIds)) {
            DynamicObject[] applyLogs;
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"rim_down_apply_log");
            for (DynamicObject applyLog : applyLogs = BusinessDataServiceHelper.load((Object[])applyLogIds.toArray(), (DynamicObjectType)mainEntityType)) {
                String taxNo = applyLog.getString("tax_no");
                if ("1".equals(applyLog.getString("status"))) continue;
                String lockKey = "InvoiceDownApplyLock-" + taxNo;
                try (DLock dLock = LockUtils.createDLockByMd5(lockKey, "rim.execute.apply.init");){
                    String invoiceType;
                    String inout;
                    InputOutInvoiceApplyService applyService;
                    Long orgId;
                    block20: {
                        if (!dLock.tryLock()) continue;
                        orgId = DynamicObjectUtil.getDynamicObjectLongValue(applyLog.get("org"));
                        applyService = InvoiceDownServiceFactory.newInstanceForApply(taxNo);
                        inout = applyLog.getString("inout");
                        invoiceType = applyLog.getString("aws_invoice_type");
                        if (applyService.checkDownCustom(inout, invoiceType, taxNo)) break block20;
                        applyLog.set("status", (Object)"0");
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{applyLog});
                    }
                    try {
                        applyService.applyHistoryData(null, invoiceType, inout, orgId, taxNo, applyLog.getDate("invoice_startdate"), applyLog.getDate("invoice_enddate"));
                        applyLog.set("status", (Object)"1");
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{applyLog});
                    }
                    catch (Exception e) {
                        applyLog.set("status", (Object)"0");
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{applyLog});
                    }
                }
            }
        }
    }
}

