/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.download;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.Callable;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.rim.common.invoice.download.InputOutInvoiceApplyService;
import kd.imc.rim.common.invoice.download.InvoiceDownServiceFactory;
import kd.imc.rim.common.utils.DateUtils;
import org.apache.commons.compress.utils.Lists;

public class InvoiceApplyServiceTask
implements Callable<Boolean> {
    private static Log LOGGER = LogFactory.getLog(InvoiceApplyServiceTask.class);
    private JSONObject taxJson;

    public InvoiceApplyServiceTask(JSONObject taxJson) {
        this.taxJson = taxJson;
    }

    @Override
    public Boolean call() throws Exception {
        InputOutInvoiceApplyService applyService;
        if (ObjectUtils.isEmpty((Object)this.taxJson)) {
            return Boolean.FALSE;
        }
        DynamicObject downInit = BusinessDataServiceHelper.loadSingle((Object)this.taxJson.get((Object)"configId"), (String)"rim_down_init");
        if (ObjectUtils.isEmpty((Object)downInit)) {
            return Boolean.FALSE;
        }
        String outputDownload = downInit.getString("output_download");
        if (StringUtils.isEmpty((CharSequence)outputDownload)) {
            return Boolean.FALSE;
        }
        Long orgId = this.taxJson.getLong("orgId");
        String taxNo = this.taxJson.getString("taxNo");
        Date begin = this.taxJson.getDate("begin");
        ArrayList initDateList = Lists.newArrayList();
        if (begin != null) {
            DateUtils.getMonthGroup(begin, initDateList);
        }
        if (StringUtils.contains((CharSequence)outputDownload, (CharSequence)"1") || StringUtils.contains((CharSequence)outputDownload, (CharSequence)"2")) {
            applyService = InvoiceDownServiceFactory.newInstanceForApply(taxNo);
            applyService.divideObject(downInit, orgId, taxNo, initDateList);
        }
        if (StringUtils.contains((CharSequence)outputDownload, (CharSequence)"6")) {
            applyService = InvoiceDownServiceFactory.newInstanceForInitApply(taxNo);
            if (applyService == null) {
                return Boolean.TRUE;
            }
            applyService.divideObject(downInit, orgId, taxNo, initDateList);
        }
        return Boolean.TRUE;
    }
}

