/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.download;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.utils.CacheHelper;
import org.apache.commons.lang3.tuple.Pair;

public abstract class InvoiceDealService {
    private static final Log LOGGER = LogFactory.getLog(InvoiceDealService.class);
    protected static final int CONFIG_MINS = 15;

    public void deal(RequestContext requestContext, List<Object> idList) {
        if (!CollectionUtils.isEmpty(idList)) {
            DynamicObject[] datalist;
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"rim_down_input");
            for (DynamicObject data : datalist = BusinessDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)mainEntityType)) {
                this.dealSingle(requestContext, data);
            }
        } else {
            LOGGER.info("InputInvoiceDownDealTask-\u6ca1\u6709\u9700\u8981\u5904\u7406\u7684\u6570\u636e");
        }
    }

    public abstract void dealSingle(RequestContext var1, DynamicObject var2);

    public void updateDownAccount(String syncStatus, String serialNo, String fpySerialNo, String dataType, Long invoiceType) {
        Object[] idList;
        QFilter invoiceTypeFilter;
        QFilter dataTypeFilter;
        QFilter serialNoFilter;
        DynamicObjectCollection collection;
        if ("1".equals(syncStatus) && !CollectionUtils.isEmpty((Collection)(collection = QueryServiceHelper.query((String)"rim_down_account", (String)"id,status", (QFilter[])new QFilter[]{serialNoFilter = new QFilter("serial_no", "=", (Object)serialNo), dataTypeFilter = new QFilter("data_type_tb", "=", (Object)dataType), invoiceTypeFilter = new QFilter("invoice_type", "=", (Object)invoiceType)}))) && !ObjectUtils.isEmpty((Object[])(idList = collection.stream().filter(s -> !"1".equals(s.getString("status"))).map(s -> s.get("id")).toArray()))) {
            DynamicObject[] dynamicObjects;
            QFilter idFilter = new QFilter("id", "in", (Object)idList);
            for (DynamicObject object : dynamicObjects = BusinessDataServiceHelper.load((String)"rim_down_account", (String)"id,status,fpy_serial_no,modifytime", (QFilter[])idFilter.toArray())) {
                object.set("status", (Object)"1");
                object.set("fpy_serial_no", (Object)fpySerialNo);
                object.set("modifytime", (Object)new Date());
            }
            SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        }
    }

    protected Long getOrgIdByTaxNo(String taxNo) {
        if (StringUtils.isEmpty((String)taxNo)) {
            return null;
        }
        String cache = CacheHelper.get("down_org_taxno_key" + taxNo);
        if (!StringUtils.isEmpty((String)cache)) {
            return Long.parseLong(cache);
        }
        Pair<Long, String> config = this.cacheConfig(taxNo, null);
        return (Long)config.getLeft();
    }

    protected Pair<Long, String> cacheConfig(String taxNo, Long orgId) {
        QFilter qFilter = StringUtils.isNotEmpty((String)taxNo) ? new QFilter("userorg.taxpayer_tax_no", "=", (Object)taxNo) : new QFilter("userorg.taxpayer_org", "=", (Object)orgId);
        DynamicObject downInitObj = QueryServiceHelper.queryOne((String)"rim_down_init", (String)"is_check,userorg.taxpayer_tax_no,userorg.taxpayer_org.id", (QFilter[])qFilter.toArray());
        String isCheck = "";
        Long configOrgId = null;
        if (downInitObj != null) {
            isCheck = Optional.ofNullable(downInitObj.getString("is_check")).filter(StringUtils::isNotEmpty).orElse("1");
            configOrgId = downInitObj.getLong("userorg.taxpayer_org.id");
            String configTaxNo = downInitObj.getString("userorg.taxpayer_tax_no");
            int hours = InvoiceDownloadConstant.getPageSizeFromConfig(15, "check_config_mins");
            CacheHelper.put("down_check_config_key" + configOrgId, isCheck, hours * 60);
            CacheHelper.put("down_org_taxno_key" + configTaxNo, String.valueOf(configOrgId), hours * 60);
        }
        return Pair.of(configOrgId, (Object)isCheck);
    }
}

