/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.download;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.download.InvoiceDealService;
import kd.imc.rim.common.invoice.download.InvoiceDownService;
import kd.imc.rim.common.invoice.download.InvoiceDownServiceFactory;
import kd.imc.rim.common.invoice.download.LqIncrementDownResultDealTask;
import kd.imc.rim.common.invoice.download.impl.InputInvoiceDealService;
import kd.imc.rim.common.invoice.download.impl.InvoiceTableDownServiceImpl;
import kd.imc.rim.common.invoice.download.impl.OutputInvoiceDealService;

public class InvoiceDownHelper {
    private static Log LOGGER = LogFactory.getLog(InvoiceDownHelper.class);

    public static JSONObject downInvoice(DynamicObject logObject, InvoiceDownService downService, RequestContext rc) {
        return InvoiceDownHelper.downInvoice(logObject, downService, rc, false);
    }

    public static JSONObject downInvoice(DynamicObject logObject, RequestContext rc) {
        return InvoiceDownHelper.downInvoice(logObject, null, rc, false);
    }

    public static JSONObject downInvoice(DynamicObject logObject, InvoiceDownService downService, RequestContext rc, boolean login) {
        if (logObject == null) {
            return ResultContant.createJSONObject("0203", ResManager.loadKDString((String)"\u6570\u636e\u4e3a\u7a7a", (String)"InvoiceDownHelper_0", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        long start = System.currentTimeMillis();
        String inout = logObject.getString("inout");
        String taxNo = logObject.getString("tax_no");
        JSONObject result = null;
        if ("4".equals(inout) || "5".equals(inout)) {
            LqIncrementDownResultDealTask dealTask = new LqIncrementDownResultDealTask();
            String dkType = DeductionConstant.getDkType(taxNo);
            if (!"5".equals(dkType = InvoiceDownloadConstant.convertLqCollect(taxNo, dkType))) {
                result = ResultContant.createJSONObject("0203", String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u53f7[%1$s]\u672a\u914d\u7f6e\u4e50\u4f01\u5f52\u96c6\u529f\u80fd", (String)"InvoiceDownHelper_4", (String)"imc-rim-common", (Object[])new Object[0]), taxNo));
                logObject.set("gov_status", (Object)"7");
                dealTask.setDescription(logObject, result);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{logObject});
                return result;
            }
            try {
                result = dealTask.invoiceDown(logObject, rc);
            }
            catch (Exception e) {
                result = ResultContant.createJSONObject("0203", String.format(ResManager.loadKDString((String)"\u589e\u91cf\u4e0b\u8f7d\u5931\u8d25:%1$s", (String)"InvoiceDownHelper_1", (String)"imc-rim-common", (Object[])new Object[0]), e.getMessage()));
                LOGGER.error("\u4e0b\u8f7d\u589e\u91cf\u53d1\u7968\u5931\u8d25:" + logObject.get("batch_no"), (Throwable)e);
            }
        } else if ("6".equals(inout)) {
            InvoiceDownService downServiceInit = InvoiceDownServiceFactory.newInstanceForDown("input_init_down", taxNo);
            if (downServiceInit == null) {
                return ResultContant.createJSONObject("0203", String.format(ResManager.loadKDString((String)"\u7a0e\u53f7[%s]\u4e0d\u652f\u6301\u521d\u59cb\u5316\u4e0b\u8f7d", (String)"InvoiceDownHelper_2", (String)"imc-rim-common", (Object[])new Object[0]), taxNo));
            }
            result = downServiceInit.invoiceDown(logObject, rc);
        } else if ("3".equals(inout)) {
            InvoiceTableDownServiceImpl downTable = new InvoiceTableDownServiceImpl(login);
            result = downTable.invoiceDown(logObject, rc);
        } else if ("7".equals(inout) || "8".equals(inout)) {
            InvoiceDownService downFileService = InvoiceDownServiceFactory.newInstanceForDown("invoice_file_down", taxNo, login);
            if (downFileService == null) {
                return ResultContant.createJSONObject("0203", String.format(ResManager.loadKDString((String)"\u7a0e\u53f7[%s]\u4e0d\u652f\u6301\u6587\u4ef6\u4e0b\u8f7d", (String)"InvoiceDownHelper_3", (String)"imc-rim-common", (Object[])new Object[0]), taxNo));
            }
            result = downFileService.invoiceDown(logObject, rc);
        } else if ("9".equals(inout)) {
            InvoiceDownService downAgricService = InvoiceDownServiceFactory.newInstanceForDown("agric_invoice_down", taxNo, login);
            if (downAgricService == null) {
                return ResultContant.createJSONObject("0203", String.format(ResManager.loadKDString((String)"\u7a0e\u53f7[%s]\u4e0d\u652f\u6301\u519c\u4ea7\u54c1\u4e0b\u8f7d", (String)"InvoiceDownHelper_5", (String)"imc-rim-common", (Object[])new Object[0]), taxNo));
            }
            result = downAgricService.invoiceDown(logObject, rc);
        } else {
            if (downService == null) {
                downService = InvoiceDownServiceFactory.newInstanceForDown("in_output", taxNo, login);
            }
            result = downService.invoiceDown(logObject, rc);
        }
        LOGGER.info("{}-{}\u4e0b\u8f7d\u8017\u65f6:{}", new Object[]{logObject.getString("tax_no"), logObject.get("batch_no"), System.currentTimeMillis() - start});
        return result;
    }

    public static void updateSuccessStatus(DynamicObject[] downLogs) {
        if (ObjectUtils.isEmpty((Object[])downLogs)) {
            return;
        }
        List<String> list = Arrays.asList(InvoiceDownloadConstant.UPDATE_STATUS);
        for (DynamicObject log : downLogs) {
            if (!list.contains(log.getString("gov_status"))) continue;
            int flag = 0;
            String batchNo = log.getString("batch_no");
            QFilter qFilterNo = new QFilter("batch_no", "=", (Object)batchNo);
            DynamicObjectCollection account = QueryServiceHelper.query((String)"rim_down_account", (String)"status", (QFilter[])new QFilter[]{qFilterNo});
            for (DynamicObject dynamicObject : account) {
                String status = dynamicObject.getString("status");
                if (!"1".equals(status) && !"3".equals(status)) continue;
                ++flag;
            }
            log.set("success_num", (Object)flag);
            log.set("modifytime", (Object)new Date());
            if (flag == account.size()) {
                log.set("gov_status", (Object)"1");
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
        }
    }

    public static void dealInvoice(Set<String> batchNos) {
        if (CollectionUtils.isEmpty(batchNos)) {
            return;
        }
        for (String batchNo : batchNos) {
            QFilter infilter;
            QFilter filter = new QFilter("batch_no", "=", (Object)batchNo);
            DynamicObjectCollection accountCollection = QueryServiceHelper.query((String)"rim_down_account", (String)"id,status,serial_no,data_type_tb", (QFilter[])new QFilter[]{filter});
            if (CollectionUtils.isEmpty((Collection)accountCollection)) continue;
            accountCollection.removeIf(s -> "1".equals(s.getString("status")));
            if (CollectionUtils.isEmpty((Collection)accountCollection)) continue;
            String dataType = ((DynamicObject)accountCollection.get(0)).getString("data_type_tb");
            List serialNoList = accountCollection.stream().map(s -> s.get("serial_no")).collect(Collectors.toList());
            QFilter serialNoFilter = new QFilter("serial_no", "in", serialNoList);
            DynamicObjectCollection inputCollection = QueryServiceHelper.query((String)"rim_down_input", (String)"id", (QFilter[])new QFilter[]{serialNoFilter, infilter = new QFilter("inout", "=", (Object)dataType)});
            if (CollectionUtils.isEmpty((Collection)inputCollection)) continue;
            List<Object> idList = inputCollection.stream().map(s -> s.get("id")).collect(Collectors.toList());
            InvoiceDealService dealService = null;
            dealService = "1".equals(dataType) || "7".equals(dataType) ? new InputInvoiceDealService(RequestContext.get(), idList) : new OutputInvoiceDealService(RequestContext.get(), idList);
            dealService.deal(RequestContext.get(), idList);
        }
    }

    public static void updateDescription(List<DynamicObject> downLogs, String description) {
        if (CollectionUtils.isEmpty(downLogs) || StringUtils.isEmpty((CharSequence)description)) {
            return;
        }
        InvoiceDownService service = InvoiceDownServiceFactory.newInstanceForDownByDkType("in_output", "2", "1");
        ArrayList<DynamicObject> updateLogs = new ArrayList<DynamicObject>(8);
        for (DynamicObject dynamicObject : downLogs) {
            String govStatus = dynamicObject.getString("gov_status");
            if (!"2".equals(govStatus) && !"6".equals(govStatus)) continue;
            service.setDescription(dynamicObject, description);
            dynamicObject.set("modifytime", (Object)new Date());
            updateLogs.add(dynamicObject);
        }
        if (!CollectionUtils.isEmpty(updateLogs)) {
            SaveServiceHelper.save((DynamicObject[])updateLogs.toArray(new DynamicObject[0]));
        }
    }

    public static Set<String> getDownloadedTaxFileNos(Object[] serialNos) {
        HashSet existSerialNos = Sets.newHashSet();
        if (ObjectUtils.isEmpty((Object[])serialNos)) {
            return existSerialNos;
        }
        QFilter serialNosFilter = new QFilter("serial_no", "in", (Object)serialNos);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_invoice_file", (String)"serial_no,tax_pdf_url,tax_xml_url,tax_ofd_url", (QFilter[])serialNosFilter.toArray());
        if (!CollectionUtils.isEmpty((Collection)collection)) {
            for (DynamicObject file : collection) {
                if (!StringUtils.isNotEmpty((CharSequence)file.getString("tax_pdf_url")) || !StringUtils.isNotEmpty((CharSequence)file.getString("tax_ofd_url")) || !StringUtils.isNotEmpty((CharSequence)file.getString("tax_xml_url"))) continue;
                existSerialNos.add(file.getString("serial_no"));
            }
        }
        return existSerialNos;
    }
}

