/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.download;

import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.invoice.download.InputOutInvoiceApplyService;
import kd.imc.rim.common.invoice.download.InvoiceDownService;
import kd.imc.rim.common.invoice.download.impl.AisinoHeaderInvoiceDownServiceImpl;
import kd.imc.rim.common.invoice.download.impl.AisinoInOutInvoiceDownServiceImpl;
import kd.imc.rim.common.invoice.download.impl.AisinoInputOutInvoiceApplyServiceImpl;
import kd.imc.rim.common.invoice.download.impl.BwHeaderInvoiceDownServiceImpl;
import kd.imc.rim.common.invoice.download.impl.HeaderInvoiceDownServiceImpl;
import kd.imc.rim.common.invoice.download.impl.HolytaxInputOutInvoiceApplyServiceImpl;
import kd.imc.rim.common.invoice.download.impl.InOutputInvoiceDownServiceImpl;
import kd.imc.rim.common.invoice.download.impl.LqHeaderInvoiceDownServiceImpl;
import kd.imc.rim.common.invoice.download.impl.LqInOutInvoiceDownServiceImpl;
import kd.imc.rim.common.invoice.download.impl.LqInputInvoiceInitApplyServiceImpl;
import kd.imc.rim.common.invoice.download.impl.LqInputInvoiceInitDownServiceImpl;
import kd.imc.rim.common.invoice.download.impl.LqInputOutInvoiceApplyServiceImpl;
import kd.imc.rim.common.invoice.download.impl.NewAgricInvoiceTableDownServiceImpl;
import kd.imc.rim.common.invoice.download.impl.NewEtaxInOutInvoiceDownServiceImpl;
import kd.imc.rim.common.invoice.download.impl.NewEtaxInOutInvoiceSyncDownServiceImpl;
import kd.imc.rim.common.invoice.download.impl.NewEtaxInputOutInvoiceApplyServiceImpl;
import kd.imc.rim.common.invoice.download.impl.NewEtaxInvoiceFileDownServiceImpl;
import kd.imc.rim.common.invoice.download.impl.NewEtaxTaxperiodInvoiceDownServiceImpl;
import kd.imc.rim.common.invoice.download.impl.ShuipanNewInOutInvoiceDownServiceImpl;
import kd.imc.rim.common.invoice.download.impl.ShuipanNewInputOutInvoiceApplyServiceImpl;
import kd.imc.rim.common.invoice.download.impl.ShuipanNewTaxperiodInvoiceDownServiceImpl;
import kd.imc.rim.common.invoice.download.impl.TaxperiodInvoiceDownServiceImpl;

public class InvoiceDownServiceFactory {
    public static InputOutInvoiceApplyService newInstanceForApply(String taxNo) {
        String type = DeductionConstant.getDkType(taxNo);
        if ("2".equals(type = InvoiceDownloadConstant.convertLqCollect(taxNo, type))) {
            return new HolytaxInputOutInvoiceApplyServiceImpl();
        }
        if ("3".equals(type)) {
            return new AisinoInputOutInvoiceApplyServiceImpl();
        }
        if ("1".equals(type)) {
            return new ShuipanNewInputOutInvoiceApplyServiceImpl();
        }
        if ("4".equals(type)) {
            return new NewEtaxInputOutInvoiceApplyServiceImpl();
        }
        if ("5".equals(type)) {
            return new LqInputOutInvoiceApplyServiceImpl();
        }
        return new HolytaxInputOutInvoiceApplyServiceImpl();
    }

    public static InputOutInvoiceApplyService newInstanceForInitApply(String taxNo) {
        String dkType = DeductionConstant.getDkType(taxNo);
        if ("5".equals(dkType)) {
            return new LqInputInvoiceInitApplyServiceImpl();
        }
        return null;
    }

    public static InvoiceDownService newInstanceForDown(String downType, String taxNo) {
        return InvoiceDownServiceFactory.newInstanceForDown(downType, taxNo, false);
    }

    public static InvoiceDownService newInstanceForDown(String downType, String taxNo, boolean login) {
        String dkType = DeductionConstant.getDkType(taxNo);
        return InvoiceDownServiceFactory.newInstanceForDownByDkType(downType, dkType, login, taxNo);
    }

    public static InvoiceDownService newInstanceForDownByDkType(String downType, String dkType, String taxNo) {
        return InvoiceDownServiceFactory.newInstanceForDownByDkType(downType, dkType, false, taxNo);
    }

    private static InvoiceDownService newInstanceForDownByDkType(String downType, String dkType, boolean login, String taxNo) {
        if ("head".equals(downType)) {
            if ("2".equals(dkType = InvoiceDownloadConstant.convertLqCollect(taxNo, dkType))) {
                return new HeaderInvoiceDownServiceImpl();
            }
            if ("3".equals(dkType)) {
                return new AisinoHeaderInvoiceDownServiceImpl();
            }
            if ("5".equals(dkType)) {
                return new LqHeaderInvoiceDownServiceImpl();
            }
            if ("6".equals(dkType)) {
                return new BwHeaderInvoiceDownServiceImpl();
            }
        } else if ("taxperiod".equals(downType)) {
            if ("1".equals(dkType = InvoiceDownloadConstant.convertLqCollect(taxNo, dkType))) {
                return new ShuipanNewTaxperiodInvoiceDownServiceImpl();
            }
            if ("2".equals(dkType)) {
                return new TaxperiodInvoiceDownServiceImpl();
            }
            if ("4".equals(dkType)) {
                return new NewEtaxTaxperiodInvoiceDownServiceImpl();
            }
        } else if ("input_init_down".equals(downType)) {
            if ("5".equals(dkType)) {
                return new LqInputInvoiceInitDownServiceImpl();
            }
        } else if ("invoice_file_down".equals(downType)) {
            if ("4".equals(dkType)) {
                return new NewEtaxInvoiceFileDownServiceImpl();
            }
        } else if ("agric_invoice_down".equals(downType)) {
            if ("4".equals(dkType)) {
                return new NewAgricInvoiceTableDownServiceImpl();
            }
        } else {
            if ("1".equals(dkType = InvoiceDownloadConstant.convertLqCollect(taxNo, dkType))) {
                return new ShuipanNewInOutInvoiceDownServiceImpl(login);
            }
            if ("2".equals(dkType)) {
                return new InOutputInvoiceDownServiceImpl();
            }
            if ("3".equals(dkType)) {
                return new AisinoInOutInvoiceDownServiceImpl();
            }
            if ("4".equals(dkType)) {
                if (!InvoiceDownloadConstant.isAsyncDown(taxNo)) {
                    return new NewEtaxInOutInvoiceSyncDownServiceImpl(login);
                }
                return new NewEtaxInOutInvoiceDownServiceImpl(login);
            }
            if ("5".equals(dkType)) {
                return new LqInOutInvoiceDownServiceImpl();
            }
        }
        return null;
    }
}

