/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.download;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.download.InvoiceDownService;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.LqConvertUtil;
import kd.imc.rim.file.utils.CompressHelper;
import org.apache.commons.collections.CollectionUtils;

public class LqIncrementDownResultDealTask
extends InvoiceDownService
implements Callable<JSONObject> {
    private static final Log LOGGER = LogFactory.getLog(LqIncrementDownResultDealTask.class);
    private RequestContext rc;
    private String taxNoOrg;
    private List<String> invoiceTypes;
    private Map<String, List<String>> inoutMap;

    public LqIncrementDownResultDealTask() {
    }

    public LqIncrementDownResultDealTask(RequestContext rc, String taxNoOrg, List<String> invoiceTypes, Map<String, List<String>> inoutMap) {
        this.rc = rc;
        this.taxNoOrg = taxNoOrg;
        this.invoiceTypes = invoiceTypes;
        this.inoutMap = inoutMap;
        this.dkType = "5";
    }

    @Override
    public JSONObject call() throws Exception {
        RequestContext.copyAndSet((RequestContext)this.rc);
        if (StringUtils.isEmpty((CharSequence)this.taxNoOrg)) {
            return new JSONObject();
        }
        Date nowDate = new Date();
        int days = InvoiceDownloadConstant.getPageSizeFromConfig(4, "lq_increment_down_days");
        if (days < 1) {
            days = 4;
        }
        ArrayList<String> dateRange = new ArrayList<String>(days);
        for (int i = 1; i <= days; ++i) {
            String date = DateUtils.format(DateUtils.addDay(nowDate, -i), "yyyyMMdd");
            dateRange.add(date);
        }
        String taxNo = this.taxNoOrg.split("-")[0];
        String org = this.taxNoOrg.split("-")[1];
        List<String> inoutList = this.inoutMap.get(taxNo);
        for (String type : this.invoiceTypes) {
            JSONObject param = new JSONObject();
            param.put("nsrsbh", (Object)taxNo);
            Long invoiceTypeByAwsType = InvoiceDownloadConstant.getInvoiceTypeByAwsType(type);
            if (InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceTypeByAwsType)) {
                param.put("api_type", (Object)"CXZLXZHGJKSXX");
            } else if (InputInvoiceTypeEnum.WITHHOLDING.getCode().equals(invoiceTypeByAwsType)) {
                param.put("api_type", (Object)"CXZLXZZZSDKDJWSPZXX");
                param.put("kjywrsbh", (Object)taxNo);
            } else {
                String lqType = InvoiceDownloadConstant.getLqTypeByAwsType(type);
                if (StringUtils.isEmpty((CharSequence)lqType)) continue;
                param.put("fplx", (Object)lqType);
                param.put("api_type", (Object)"CXZLXZFPXX");
            }
            List collect = inoutList.stream().filter(f -> f.equals("4")).collect(Collectors.toList());
            for (String inout : collect) {
                param.put("packageno", (Object)"");
                this.sendDateList(param, org, invoiceTypeByAwsType, type, inout, dateRange);
            }
        }
        return ResultContant.createSuccessJSONObject();
    }

    private void sendDateList(JSONObject param, String org, Long invoiceType, String awsType, String inout, List<String> dateRange) {
        if (CollectionUtils.isNotEmpty(dateRange)) {
            for (String date : dateRange) {
                param.put("gjrq", (Object)date);
                this.send(param, org, invoiceType, awsType, inout, null);
            }
        }
    }

    private JSONObject send(JSONObject param, String org, Long invoiceType, String awsType, String inout, DynamicObject dynamicObject) {
        if ("5".equals(inout)) {
            return ResultContant.createSuccessJSONObject();
        }
        param.put("sjlx", (Object)("4".equals(inout) ? "1" : "2"));
        if (dynamicObject == null) {
            QFilter qFilter = new QFilter("inout", "=", (Object)inout).and("tax_no", "=", (Object)param.getString("nsrsbh")).and("aws_invoice_type", "=", (Object)awsType).and("invoice_startdate", "=", (Object)param.getDate("gjrq")).and("invoice_type", "=", (Object)invoiceType);
            DynamicObjectCollection downLogs = QueryServiceHelper.query((String)"rim_down_log", (String)"id,gov_status,createtime", (QFilter[])qFilter.toArray());
            boolean isExist = false;
            if (CollectionUtils.isNotEmpty((Collection)downLogs)) {
                for (DynamicObject downLog : downLogs) {
                    if ("6".equals(downLog.getString("gov_status"))) {
                        isExist = true;
                        break;
                    }
                    Date createTime = downLog.getDate("createtime");
                    if (!DateUtils.format(new Date()).equals(DateUtils.format(createTime))) continue;
                    isExist = true;
                    break;
                }
            }
            if (isExist) {
                return ResultContant.createSuccessJSONObject();
            }
        }
        LOGGER.info("\u4e50\u4f01-\u67e5\u8be2\u589e\u91cf\u53d1\u7968\u53c2\u6570\uff1a{}", (Object)param);
        JSONObject result = this.invokeService(param);
        LOGGER.info("\u4e50\u4f01-\u67e5\u8be2\u589e\u91cf\u53d1\u7968\u7ed3\u679c\uff1a{}", (Object)result);
        return this.saveResult(result, param, invoiceType, awsType, org, inout, dynamicObject);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JSONObject saveResult(JSONObject result, JSONObject param, Long invoiceType, String awsType, String org, String inout, DynamicObject downLog) {
        boolean newFlag = false;
        if (downLog == null) {
            newFlag = true;
            String batchNo = this.getDownBatchNo();
            downLog = BusinessDataServiceHelper.newDynamicObject((String)"rim_down_log");
            downLog.set("batch_no", (Object)batchNo);
            downLog.set("createtime", (Object)new Date());
            downLog.set("invoice_type", (Object)invoiceType);
            downLog.set("aws_invoice_type", (Object)awsType);
            downLog.set("apply_date", (Object)param.getDate("gjrq"));
            downLog.set("gov_status", (Object)"6");
            downLog.set("apply_step", (Object)1);
            downLog.set("inout", (Object)inout);
            downLog.set("tax_no", (Object)param.getString("nsrsbh"));
            downLog.set("org", (Object)Long.parseLong(org));
            downLog.set("download_errcode", (Object)"");
            downLog.set("sync_type", (Object)"2");
            downLog.set("invoice_startdate", (Object)param.getDate("gjrq"));
            downLog.set("invoice_enddate", (Object)param.getDate("gjrq"));
            downLog.set("total_num", (Object)0);
        }
        downLog.set("modifytime", (Object)new Date());
        if (ErrorType.SUCCESS.getCode().equals(result.get((Object)"errcode"))) {
            JSONObject data = result.getJSONObject("data");
            int totalPages = data.getInteger("packagecount");
            String sjl = data.getString("sjl");
            this.setDescription(downLog, "");
            String dataResult = "";
            try {
                dataResult = CompressHelper.decodeBase64AndGZip((String)sjl);
            }
            catch (Exception exception) {
                // empty catch block
            }
            LOGGER.info("\u89e3\u5bc6\u6570\u636e\u6d41\uff1a{}", (Object)dataResult);
            if (!StringUtils.isNotEmpty((CharSequence)dataResult)) {
                downLog.set("gov_status", (Object)"9");
                downLog.set("download_errcode", (Object)"4");
                this.setDescription(downLog, "");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{downLog});
                return result;
            }
            JSONArray invoiceArray = JSONArray.parseArray((String)dataResult);
            if (!InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceType) && !InputInvoiceTypeEnum.WITHHOLDING.getCode().equals(invoiceType)) {
                this.supUseDataResult(invoiceArray, awsType, param.getString("nsrsbh"));
            }
            JSONArray downData = this.convertLqInvoice(invoiceType, awsType, invoiceArray);
            try {
                DynamicObject dynamicObject = this.insertInputOutDataSyncLog(downData, downLog, downLog.getString("batch_no"), org, inout);
                this.downSurplusInvoice(dynamicObject, param, totalPages, invoiceType, inout, org);
                return ResultContant.createSuccessJSONObject();
            }
            catch (Throwable t) {
                LOGGER.info("insertInputOutDataSyncLog error: ", (Object)t);
                this.setDescription(downLog, t.getMessage());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{downLog});
                return ResultContant.createSuccessJSONObject();
            }
        }
        if ("6901".equals(result.get((Object)"errcode")) || "6904".equals(result.get((Object)"errcode"))) {
            if (newFlag) {
                return result;
            }
            downLog.set("gov_status", (Object)"9");
        }
        this.setDescription(downLog, result);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{downLog});
        return result;
    }

    public void supUseDataResult(JSONArray invoiceArray, String invoiceType, String nsrsbh) {
        for (int i = 0; i < invoiceArray.size(); ++i) {
            JSONObject invoice = invoiceArray.getJSONObject(i);
            String fpztbz = invoice.getString("fpztbz");
            if ("1".equals(fpztbz)) {
                invoice.put("invoiceStatus", (Object)"0");
                continue;
            }
            if ("2".equals(fpztbz) || "3".equals(fpztbz) || "4".equals(fpztbz)) {
                invoice.put("invoiceStatus", (Object)"2");
                continue;
            }
            invoice.put("invoiceStatus", (Object)"0");
        }
    }

    private void downSurplusInvoice(DynamicObject dynamicObject, JSONObject paramJson, int page, Long invoiceType, String inout, String org) {
        if (page <= 1) {
            return;
        }
        String awsType = dynamicObject.getString("aws_invoice_type");
        for (int currentPage = 2; currentPage <= page; ++currentPage) {
            JSONObject data;
            paramJson.put("packageno", (Object)currentPage);
            JSONObject result = this.invokeService(paramJson);
            if (!ResultContant.isSuccess(result).booleanValue() || ObjectUtils.isEmpty((Object)(data = result.getJSONObject("data")))) continue;
            String sjl = data.getString("sjl");
            String dataResult = "";
            try {
                dataResult = CompressHelper.decodeBase64AndGZip((String)sjl);
            }
            catch (Exception exception) {
                // empty catch block
            }
            LOGGER.info("\u89e3\u5bc6\u6570\u636e\u6d41\uff1a{}", (Object)dataResult);
            if (!StringUtils.isNotEmpty((CharSequence)dataResult)) continue;
            JSONArray invoiceArray = JSONArray.parseArray((String)dataResult);
            if (!InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceType)) {
                this.supUseDataResult(invoiceArray, awsType, paramJson.getString("nsrsbh"));
            }
            JSONObject resultJson = ResultContant.createSuccessJSONObject();
            JSONArray downData = this.convertLqInvoice(invoiceType, awsType, invoiceArray);
            resultJson.put("data", (Object)downData);
            inout = this.convertDownDataType(inout);
            this.insertInputOutDataSyncLog(dynamicObject, resultJson, inout);
        }
    }

    private JSONObject invokeService(JSONObject paramJson) {
        return LqConvertUtil.invokeService(paramJson);
    }

    private String convertDownDataType(String inout) {
        if ("4".equals(inout)) {
            inout = "1";
        } else if ("5".equals(inout)) {
            inout = "2";
        }
        return inout;
    }

    private DynamicObject insertInputOutDataSyncLog(JSONArray downData, DynamicObject downLog, String batchNo, String org, String inout) {
        int totalNum = downLog.getInt("total_num");
        if (!CollectionUtils.isEmpty((Collection)downData)) {
            totalNum += downData.size();
            inout = this.convertDownDataType(inout);
            this.insertSyncInputOutDataAccount(downData, batchNo, "5", "3", Long.parseLong(org), inout, downLog);
        }
        downLog.set("gov_status", (Object)"8");
        downLog.set("total_num", (Object)totalNum);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{downLog});
        return downLog;
    }

    @Override
    public JSONObject invoiceDown(DynamicObject dynamicObject, RequestContext requestContext, Long orgId, String taxNo) {
        String awsType;
        Date downDate = dynamicObject.getDate("invoice_startdate");
        long between = DateUtils.daysBetween(new Date(), downDate);
        if (between >= 7L) {
            JSONObject result = ResultContant.createJSONObject("6904", ResManager.loadKDString((String)"\u7533\u8bf7\u65f6\u95f4\u8ddd\u79bb\u4eca\u5929\u5927\u4e8e7\u5929", (String)"LqIncrementDownResultDealTask_0", (String)"imc-rim-common", (Object[])new Object[0]));
            dynamicObject.set("gov_status", (Object)"9");
            this.setDescription(dynamicObject, result);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            return result;
        }
        String date = DateUtils.format(downDate, "yyyyMMdd");
        DynamicObject orgObject = dynamicObject.getDynamicObject("org");
        long org = 0L;
        if (orgObject != null) {
            org = orgObject.getLong("id");
        }
        String inout = dynamicObject.getString("inout");
        JSONObject param = new JSONObject();
        param.put("gjrq", (Object)date);
        param.put("nsrsbh", (Object)taxNo);
        DynamicObject typeObject = dynamicObject.getDynamicObject("invoice_type");
        long invoiceType = 0L;
        if (typeObject != null) {
            invoiceType = typeObject.getLong("id");
        }
        if (StringUtils.isEmpty((CharSequence)(awsType = dynamicObject.getString("aws_invoice_type")))) {
            awsType = InputInvoiceTypeEnum.getAwsType(invoiceType);
        }
        if (InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceType)) {
            param.put("api_type", (Object)"CXZLXZHGJKSXX");
        } else if (InputInvoiceTypeEnum.WITHHOLDING.getCode().equals(invoiceType)) {
            param.put("api_type", (Object)"CXZLXZZZSDKDJWSPZXX");
            param.put("kjywrsbh", (Object)taxNo);
        } else {
            String lqType = InvoiceDownloadConstant.getLqTypeByAwsType(awsType);
            param.put("fplx", (Object)lqType);
            param.put("api_type", (Object)"CXZLXZFPXX");
        }
        return this.send(param, String.valueOf(org), invoiceType, awsType, inout, dynamicObject);
    }
}

