/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.download.excel;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.common.invoice.download.excel.HolytaxInputOutputInvoiceResolver;
import kd.imc.rim.common.invoice.download.excel.InputOutputInvoiceResolver;
import kd.imc.rim.common.utils.FileUtils;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class DownExcelUtils {
    private static final Log LOGGER = LogFactory.getLog(DownExcelUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<String, JSONObject> analyzeExcel(String url, String fileName) {
        Map<Object, Object> invoiceMap;
        XSSFWorkbook wb;
        InputStream fileInputStream;
        block8: {
            FileService service = FileServiceFactory.getAttachmentFileService();
            fileInputStream = service.getInputStream(url);
            wb = null;
            invoiceMap = Maps.newHashMap();
            try {
                if (FileUtils.checkFileType(fileName, "xlsx")) {
                    wb = new XSSFWorkbook(fileInputStream);
                } else if (FileUtils.checkFileType(fileName, "xls")) {
                    wb = new HSSFWorkbook(fileInputStream);
                }
                if (wb == null) break block8;
                HolytaxInputOutputInvoiceResolver resolver = new HolytaxInputOutputInvoiceResolver();
                invoiceMap = DownExcelUtils.analyzeInvoiceSheet(wb.getSheetAt(0), resolver);
                Map<Object, Object> itemMap = new HashMap(8);
                if (wb.getNumberOfSheets() == 2) {
                    itemMap = DownExcelUtils.analyzeItemSheet(wb.getSheetAt(1), resolver);
                }
                HashMap finalItemMap = itemMap;
                invoiceMap.forEach((k, v) -> v.put(resolver.itemField(), finalItemMap.get(k)));
                resolver.lastDeal(invoiceMap);
            }
            catch (IOException e) {
                try {
                    LOGGER.error(fileName + "\u89e3\u6790\u5931\u8d25", (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(wb);
                    IOUtils.closeQuietly((Closeable)fileInputStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((Closeable)wb);
                IOUtils.closeQuietly((Closeable)fileInputStream);
            }
        }
        IOUtils.closeQuietly((Closeable)wb);
        IOUtils.closeQuietly((Closeable)fileInputStream);
        return invoiceMap;
    }

    private static Map<String, JSONObject> analyzeInvoiceSheet(Sheet invoiceSheet, InputOutputInvoiceResolver resolver) {
        Row titleRow = invoiceSheet.getRow(invoiceSheet.getFirstRowNum());
        Cell titleRowCell = titleRow.getCell((int)titleRow.getFirstCellNum());
        String invoiceType = resolver.titleCell2Type(titleRowCell.getStringCellValue());
        int fieldRowNum = invoiceSheet.getFirstRowNum() + 1;
        Row fieldRow = invoiceSheet.getRow(fieldRowNum);
        int invoiceStart = fieldRowNum + 1;
        int invoiceLast = DownExcelUtils.findLastRow(invoiceSheet, invoiceStart, fieldRow.getFirstCellNum());
        JSONObject[] invoiceArray = new JSONObject[invoiceLast - invoiceStart + 1];
        for (int cIndex = fieldRow.getFirstCellNum(); cIndex < fieldRow.getLastCellNum(); ++cIndex) {
            Cell fieldCell = fieldRow.getCell(cIndex);
            String fieldName = resolver.invoiceCell2Name(fieldCell.getStringCellValue(), invoiceType);
            if (StringUtils.isEmpty((CharSequence)fieldName)) continue;
            for (int rIndex = invoiceStart; rIndex <= invoiceLast; ++rIndex) {
                int invoiceIndex = rIndex - invoiceStart;
                if (invoiceArray[invoiceIndex] == null) {
                    invoiceArray[invoiceIndex] = new JSONObject();
                    invoiceArray[invoiceIndex].put(resolver.typeField(), (Object)invoiceType);
                }
                invoiceArray[invoiceIndex].put(fieldName, (Object)invoiceSheet.getRow(rIndex).getCell(cIndex).getStringCellValue());
            }
        }
        LinkedHashMap<String, JSONObject> invoiceMap = new LinkedHashMap<String, JSONObject>(8);
        for (JSONObject invoice : invoiceArray) {
            invoiceMap.put(resolver.getSheetRowKey((Map)invoice), invoice);
        }
        return invoiceMap;
    }

    private static Map<String, List<JSONObject>> analyzeItemSheet(Sheet itemSheet, InputOutputInvoiceResolver resolver) {
        Row titleRow = itemSheet.getRow(itemSheet.getFirstRowNum());
        Cell titleRowCell = titleRow.getCell((int)titleRow.getFirstCellNum());
        String invoiceType = resolver.titleCell2Type(titleRowCell.getStringCellValue());
        int fieldRowNum = itemSheet.getFirstRowNum() + 1;
        Row fieldRow = itemSheet.getRow(fieldRowNum);
        int invoiceStart = fieldRowNum + 1;
        int invoiceLast = DownExcelUtils.findLastRow(itemSheet, invoiceStart, fieldRow.getFirstCellNum());
        JSONObject[] invoiceArray = new JSONObject[invoiceLast - invoiceStart + 1];
        for (int cIndex = fieldRow.getFirstCellNum(); cIndex < fieldRow.getLastCellNum(); ++cIndex) {
            Cell fieldCell = fieldRow.getCell(cIndex);
            String fieldName = resolver.itemCell2Name(fieldCell.getStringCellValue(), invoiceType);
            if (StringUtils.isEmpty((CharSequence)fieldName)) continue;
            for (int rIndex = invoiceStart; rIndex <= invoiceLast; ++rIndex) {
                int invoiceIndex = rIndex - invoiceStart;
                if (invoiceArray[invoiceIndex] == null) {
                    invoiceArray[invoiceIndex] = new JSONObject();
                }
                invoiceArray[invoiceIndex].put(fieldName, (Object)itemSheet.getRow(rIndex).getCell(cIndex).getStringCellValue());
            }
        }
        LinkedHashMap<String, List<JSONObject>> itemsMap = new LinkedHashMap<String, List<JSONObject>>();
        for (JSONObject it : invoiceArray) {
            String key = resolver.getSheetRowKey((Map)it);
            List itemArray = itemsMap.computeIfAbsent(key, k -> new LinkedList());
            itemArray.add(it);
        }
        return itemsMap;
    }

    private static int findLastRow(Sheet invoiceSheet, int rStart, int cIndex) {
        int sheetLastRowNum = invoiceSheet.getLastRowNum();
        for (int rowIndex = rStart; rowIndex <= sheetLastRowNum; ++rowIndex) {
            if (invoiceSheet.getRow(rowIndex) != null && invoiceSheet.getRow(rowIndex).getCell(cIndex) != null && !StringUtils.isBlank((CharSequence)invoiceSheet.getRow(rowIndex).getCell(cIndex).getStringCellValue())) continue;
            return rowIndex - 1;
        }
        return sheetLastRowNum;
    }
}

