/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.download.excel;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.imc.rim.common.constant.HolytaxInvoiceTypeEnum;

class HolytaxResolverConstant {
    static final String INVOICE_ITEMS = "mxs";
    static final String INVOICE_TYPE = "fplx";
    static final String INVOICE_NO = "fphm";
    static final String INVOICE_CODE = "fpdm";
    private static final Map<String, String> VAT_ELE_ORDINARY_MAPPING = new HashMap<String, String>(8);
    private static final Map<String, String> VAT_HGJKS_MAPPING = new HashMap<String, String>(8);
    private static final Map<String, String> VAT_ELE_ORDINARY_ITEM_MAPPING = new HashMap<String, String>(8);
    private static final Map<String, String> VAT_HGJKS_ITEM_MAPPING = new HashMap<String, String>(8);

    HolytaxResolverConstant() {
    }

    public static String getInvoiceTypeByName(String fileName) {
        String invoiceType = "";
        if (StringUtils.isNotEmpty((CharSequence)fileName)) {
            if (fileName.contains("\u4e8c\u624b\u8f66")) {
                invoiceType = HolytaxInvoiceTypeEnum.USEDCAR_INVOICE.getCode();
            } else if (fileName.contains("\u901a\u884c\u8d39")) {
                invoiceType = HolytaxInvoiceTypeEnum.TOLL_ELECTRON.getCode();
            } else if (fileName.contains("\u6d77\u5173")) {
                invoiceType = HolytaxInvoiceTypeEnum.HGJKS.getCode();
            } else if (fileName.contains("\u673a\u52a8\u8f66")) {
                invoiceType = HolytaxInvoiceTypeEnum.MOTOR_INVOICE.getCode();
            } else if (fileName.contains("\u4e13\u7528\u53d1\u7968")) {
                invoiceType = HolytaxInvoiceTypeEnum.SPECIAL_PAPER.getCode();
                if (fileName.contains("\u7535\u5b50")) {
                    invoiceType = HolytaxInvoiceTypeEnum.SPECIAL_ELECTRON.getCode();
                }
            } else if (fileName.contains("\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968")) {
                invoiceType = HolytaxInvoiceTypeEnum.ORDINARY_PAPER.getCode();
                if (fileName.contains("\u7535\u5b50")) {
                    invoiceType = HolytaxInvoiceTypeEnum.ORDINARY_ELECTRON.getCode();
                } else if (fileName.contains("\u5377\u7968")) {
                    invoiceType = HolytaxInvoiceTypeEnum.ORDINARY_ROLL.getCode();
                }
            }
        }
        return invoiceType;
    }

    public static Map<String, String> getInvoiceResolver(String invoiceType) {
        if (HolytaxInvoiceTypeEnum.HGJKS.getCode().equals(invoiceType)) {
            return VAT_HGJKS_MAPPING;
        }
        Set<String> allHolytaxTypes = HolytaxInvoiceTypeEnum.getAllHolytaxTypes();
        if (allHolytaxTypes.contains(invoiceType)) {
            return VAT_ELE_ORDINARY_MAPPING;
        }
        return null;
    }

    public static Map<String, String> getInvoiceResolverItem(String invoiceType) {
        if (HolytaxInvoiceTypeEnum.HGJKS.getCode().equals(invoiceType)) {
            return VAT_HGJKS_ITEM_MAPPING;
        }
        Set<String> allHolytaxTypes = HolytaxInvoiceTypeEnum.getAllHolytaxTypes();
        if (allHolytaxTypes.contains(invoiceType)) {
            return VAT_ELE_ORDINARY_ITEM_MAPPING;
        }
        return null;
    }

    static {
        VAT_ELE_ORDINARY_MAPPING.put("\u5e8f\u53f7", "");
        VAT_ELE_ORDINARY_MAPPING.put("\u53d1\u7968\u4ee3\u7801", INVOICE_CODE);
        VAT_ELE_ORDINARY_MAPPING.put("\u53d1\u7968\u53f7\u7801", INVOICE_NO);
        VAT_ELE_ORDINARY_MAPPING.put("\u5f00\u7968\u65e5\u671f", "kprq");
        VAT_ELE_ORDINARY_MAPPING.put("\u53d1\u7968\u72b6\u6001", "fpzt");
        VAT_ELE_ORDINARY_MAPPING.put("\u9500\u552e\u65b9\u7a0e\u53f7", "xfsh");
        VAT_ELE_ORDINARY_MAPPING.put("\u9500\u552e\u65b9\u540d\u79f0", "xfmc");
        VAT_ELE_ORDINARY_MAPPING.put("\u8d2d\u4e70\u65b9\u7a0e\u53f7", "gfsh");
        VAT_ELE_ORDINARY_MAPPING.put("\u8d2d\u4e70\u65b9\u540d\u79f0", "gfmc");
        VAT_ELE_ORDINARY_MAPPING.put("\u91d1\u989d", "hjje");
        VAT_ELE_ORDINARY_MAPPING.put("\u7a0e\u989d", "hjse");
        VAT_ELE_ORDINARY_MAPPING.put("\u4ef7\u7a0e\u5408\u8ba1", "jshj");
        VAT_ELE_ORDINARY_MAPPING.put("\u6821\u9a8c\u7801", "jym");
        VAT_ELE_ORDINARY_MAPPING.put("\u9500\u552e\u65b9\u5730\u5740\u3001\u7535\u8bdd", "xfdzdh");
        VAT_ELE_ORDINARY_MAPPING.put("\u9500\u552e\u65b9\u5f00\u6237\u884c\u53ca\u8d26\u53f7", "xfyhzh");
        VAT_ELE_ORDINARY_MAPPING.put("\u8d2d\u4e70\u65b9\u5730\u5740\u3001\u7535\u8bdd", "gfdzdh");
        VAT_ELE_ORDINARY_MAPPING.put("\u8d2d\u4e70\u65b9\u5f00\u6237\u884c\u53ca\u8d26\u53f7", "gfyhzh");
        VAT_ELE_ORDINARY_MAPPING.put("\u5bc6\u7801\u533a", "mmq");
        VAT_ELE_ORDINARY_MAPPING.put("\u5907\u6ce8", "bz");
        VAT_ELE_ORDINARY_MAPPING.put("\u673a\u5668\u7f16\u53f7", "jqbh");
        VAT_ELE_ORDINARY_MAPPING.put("\u5f00\u7968\u4eba", "kpr");
        VAT_ELE_ORDINARY_MAPPING.put("\u6536\u6b3e\u4eba", "skr");
        VAT_ELE_ORDINARY_MAPPING.put("\u590d\u6838\u4eba", "fhr");
        VAT_ELE_ORDINARY_MAPPING.put("\u8d2d\u4e70\u65b9\u5355\u4f4d", "gfmc");
        VAT_ELE_ORDINARY_MAPPING.put("\u673a\u6253\u53f7\u7801", "jdhm");
        VAT_ELE_ORDINARY_MAPPING.put("\u673a\u5668\u7f16\u7801", "jqbh");
        VAT_ELE_ORDINARY_MAPPING.put("\u6536\u6b3e\u5458", "skr");
        VAT_ELE_ORDINARY_MAPPING.put("\u8eab\u4efd\u8bc1\u53f7\u7801/\u7ec4\u7ec7\u673a\u6784\u4ee3\u7801", "sfzhm");
        VAT_ELE_ORDINARY_MAPPING.put("\u4ea7\u5730", "cd");
        VAT_ELE_ORDINARY_MAPPING.put("\u5408\u683c\u8bc1\u53f7", "hgzh");
        VAT_ELE_ORDINARY_MAPPING.put("\u8fdb\u53e3\u8bc1\u660e\u4e66\u53f7", "jkzmsh");
        VAT_ELE_ORDINARY_MAPPING.put("\u5546\u68c0\u5355\u53f7", "sjdh");
        VAT_ELE_ORDINARY_MAPPING.put("\u53d1\u52a8\u673a\u53f7\u7801", "fdjhm");
        VAT_ELE_ORDINARY_MAPPING.put("\u8f66\u8f86\u8bc6\u522b\u4ee3\u53f7/\u8f66\u67b6\u53f7\u7801", "clsbdh");
        VAT_ELE_ORDINARY_MAPPING.put("\u9500\u8d27\u5355\u4f4d\u540d\u79f0", "xfmc");
        VAT_ELE_ORDINARY_MAPPING.put("\u7535\u8bdd", "dh");
        VAT_ELE_ORDINARY_MAPPING.put("\u9500\u552e\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7", "xfsh");
        VAT_ELE_ORDINARY_MAPPING.put("\u8d26\u53f7", "zh");
        VAT_ELE_ORDINARY_MAPPING.put("\u5730\u5740", "dz");
        VAT_ELE_ORDINARY_MAPPING.put("\u5f00\u6237\u94f6\u884c", "khyh");
        VAT_ELE_ORDINARY_MAPPING.put("\u589e\u503c\u7a0e\u7a0e\u7387\u6216\u5f81\u6536\u7387", "slv");
        VAT_ELE_ORDINARY_MAPPING.put("\u589e\u503c\u7a0e\u7a0e\u989d", "hjse");
        VAT_ELE_ORDINARY_MAPPING.put("\u4e3b\u7ba1\u7a0e\u52a1\u673a\u5173", "zgswjg");
        VAT_ELE_ORDINARY_MAPPING.put("\u4e3b\u7ba1\u7a0e\u52a1\u673a\u5173\u4ee3\u7801", "zgswjgdm");
        VAT_ELE_ORDINARY_MAPPING.put("\u4e0d\u542b\u7a0e\u4ef7", "hjje");
        VAT_ELE_ORDINARY_MAPPING.put("\u5b8c\u7a0e\u51ed\u8bc1\u53f7\u7801", "wspzhm");
        VAT_ELE_ORDINARY_MAPPING.put("\u5428\u4f4d", "dw");
        VAT_ELE_ORDINARY_MAPPING.put("\u9650\u4e58\u4eba\u6570", "xcrs");
        VAT_ELE_ORDINARY_MAPPING.put("\u8d2d\u4e70\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7", "gfsh");
        VAT_ELE_ORDINARY_MAPPING.put("\u4e70\u65b9\u5355\u4f4d/\u4e2a\u4eba", "gfdw");
        VAT_ELE_ORDINARY_MAPPING.put("\u4e70\u65b9\u5355\u4f4d\u4ee3\u7801/\u8eab\u4efd\u8bc1\u53f7", "gfdwdm");
        VAT_ELE_ORDINARY_MAPPING.put("\u4e70\u65b9\u5355\u4f4d/\u4e2a\u4eba\u4f4f\u5740", "gfdwdz");
        VAT_ELE_ORDINARY_MAPPING.put("\u4e70\u65b9\u7535\u8bdd", "gfdwdh");
        VAT_ELE_ORDINARY_MAPPING.put("\u5356\u65b9\u5355\u4f4d/\u4e2a\u4eba", "mfdw");
        VAT_ELE_ORDINARY_MAPPING.put("\u5356\u65b9\u5355\u4f4d\u4ee3\u7801/\u8eab\u4efd\u8bc1\u53f7", "mfdwdm");
        VAT_ELE_ORDINARY_MAPPING.put("\u5356\u65b9\u5355\u4f4d/\u4e2a\u4eba\u4f4f\u5740", "mfdwdz");
        VAT_ELE_ORDINARY_MAPPING.put("\u5356\u65b9\u7535\u8bdd", "mfdwdh");
        VAT_ELE_ORDINARY_MAPPING.put("\u8f66\u724c\u7167\u53f7", "cpzh");
        VAT_ELE_ORDINARY_MAPPING.put("\u767b\u8bb0\u8bc1\u53f7", "djzh");
        VAT_ELE_ORDINARY_MAPPING.put("\u8f66\u8f86\u7c7b\u578b", "cllx");
        VAT_ELE_ORDINARY_MAPPING.put("\u8f66\u67b6\u53f7/\u8f66\u8f86\u8bc6\u522b\u4ee3\u7801", "clsbdh");
        VAT_ELE_ORDINARY_MAPPING.put("\u5382\u724c\u578b\u53f7", "cpxh");
        VAT_ELE_ORDINARY_MAPPING.put("\u8f6c\u5165\u5730\u8f66\u8f86\u7ba1\u7406\u6240\u540d\u79f0", "zrdclglsmc");
        VAT_ELE_ORDINARY_MAPPING.put("\u8f66\u4ef7\u5408\u8ba1", "cjhj");
        VAT_ELE_ORDINARY_MAPPING.put("\u7ecf\u8425\u3001\u62cd\u5356\u5355\u4f4d", "jydw");
        VAT_ELE_ORDINARY_MAPPING.put("\u7ecf\u8425\u3001\u62cd\u5356\u5355\u4f4d\u5730\u5740", "jydwdz");
        VAT_ELE_ORDINARY_MAPPING.put("\u7ecf\u8425\u3001\u62cd\u5356\u5355\u4f4d\u7a0e\u53f7", "jydwnsrsbh");
        VAT_ELE_ORDINARY_MAPPING.put("\u7ecf\u8425\u3001\u62cd\u5356\u5355\u4f4d\u5f00\u6237\u94f6\u884c\u3001\u8d26\u53f7", "jydwkhyhzh");
        VAT_ELE_ORDINARY_MAPPING.put("\u7ecf\u8425\u3001\u62cd\u5356\u5355\u4f4d\u7535\u8bdd", "jydwdh");
        VAT_ELE_ORDINARY_MAPPING.put("\u4e8c\u624b\u8f66\u5e02\u573a", "escsc");
        VAT_ELE_ORDINARY_MAPPING.put("\u4e8c\u624b\u8f66\u5e02\u573a\u5730\u5740", "escdz");
        VAT_ELE_ORDINARY_MAPPING.put("\u4e8c\u624b\u8f66\u5e02\u573a\u7a0e\u53f7", "escnsrsbh");
        VAT_ELE_ORDINARY_MAPPING.put("\u4e8c\u624b\u8f66\u5e02\u573a\u5f00\u6237\u94f6\u884c\u3001\u8d26\u53f7", "esckhyhzh");
        VAT_ELE_ORDINARY_MAPPING.put("\u4e8c\u624b\u8f66\u5e02\u573a\u7535\u8bdd", "escdh");
        VAT_HGJKS_MAPPING.put("\u7f34\u6b3e\u4e66\u53f7\u7801", "jkshm");
        VAT_HGJKS_MAPPING.put("\u586b\u53d1\u65e5\u671f", "tfrq");
        VAT_HGJKS_MAPPING.put("\u7f34\u6b3e\u5355\u4f4d\u4e00\u540d\u79f0", "jkdwmc1");
        VAT_HGJKS_MAPPING.put("\u7f34\u6b3e\u5355\u4f4d\u4e00\u7a0e\u53f7", "jkdwsh1");
        VAT_HGJKS_MAPPING.put("\u7f34\u6b3e\u5355\u4f4d\u4e8c\u540d\u79f0", "jkdwmc2");
        VAT_HGJKS_MAPPING.put("\u7f34\u6b3e\u5355\u4f4d\u4e8c\u7a0e\u53f7", "jkdwsh2");
        VAT_HGJKS_MAPPING.put("\u8fdb\u53e3\u53e3\u5cb8\u4ee3\u7801", "jkkadm");
        VAT_HGJKS_MAPPING.put("\u7a0e\u6b3e\u91d1\u989d", "skje");
        VAT_HGJKS_MAPPING.put("\u6536\u5165\u673a\u5173", "srjg");
        VAT_HGJKS_MAPPING.put("\u7533\u8bf7\u5355\u4f4d\u7f16\u7801", "sqdwbm");
        VAT_HGJKS_MAPPING.put("\u62a5\u5173\u5355\u7f16\u53f7", "bgdbh");
        VAT_HGJKS_MAPPING.put("\u8d38\u6613\u65b9\u5f0f", "myfs");
        VAT_HGJKS_MAPPING.put("\u9884\u7b97\u79d1\u76ee\u4ee3\u7801", "yskmdm");
        VAT_HGJKS_MAPPING.put("\u6536\u6b3e\u56fd\u5e93\u4ee3\u7801", "skgkdm");
        VAT_HGJKS_MAPPING.put("\u5408\u540c\u53f7", "hth");
        VAT_HGJKS_MAPPING.put("\u8fd0\u8f93\u5de5\u5177", "ysgj");
        VAT_HGJKS_MAPPING.put("\u7f34\u6b3e\u671f\u9650", "jkqx");
        VAT_HGJKS_MAPPING.put("\u63d0\u8fd0\u5355\u53f7", "tydh");
        VAT_HGJKS_MAPPING.put("\u6570\u636e\u6765\u6e90", "sjly");
        VAT_ELE_ORDINARY_ITEM_MAPPING.put("\u5e8f\u53f7", "xh");
        VAT_ELE_ORDINARY_ITEM_MAPPING.put("\u53d1\u7968\u4ee3\u7801", INVOICE_CODE);
        VAT_ELE_ORDINARY_ITEM_MAPPING.put("\u53d1\u7968\u53f7\u7801", INVOICE_NO);
        VAT_ELE_ORDINARY_ITEM_MAPPING.put("\u7a0e\u6536\u5206\u7c7b\u7f16\u7801", "ssflbm");
        VAT_ELE_ORDINARY_ITEM_MAPPING.put("\u8d27\u7269\u6216\u5e94\u7a0e\u52b3\u52a1\u3001\u670d\u52a1\u540d\u79f0", "xmmc");
        VAT_ELE_ORDINARY_ITEM_MAPPING.put("\u89c4\u683c\u578b\u53f7", "ggxh");
        VAT_ELE_ORDINARY_ITEM_MAPPING.put("\u5355\u4f4d", "dw");
        VAT_ELE_ORDINARY_ITEM_MAPPING.put("\u6570\u91cf", "sl");
        VAT_ELE_ORDINARY_ITEM_MAPPING.put("\u5355\u4ef7", "dj");
        VAT_ELE_ORDINARY_ITEM_MAPPING.put("\u91d1\u989d", "je");
        VAT_ELE_ORDINARY_ITEM_MAPPING.put("\u7a0e\u7387", "slv");
        VAT_ELE_ORDINARY_ITEM_MAPPING.put("\u7a0e\u989d", "se");
        VAT_ELE_ORDINARY_ITEM_MAPPING.put("\u9879\u76ee", "xmmc");
        VAT_ELE_ORDINARY_ITEM_MAPPING.put("\u8d27\u7269\u6216\u5e94\u7a0e\u52b3\u52a1\u540d\u79f0", "xmmc");
        VAT_HGJKS_ITEM_MAPPING.put("\u5e8f\u53f7", "xh");
        VAT_HGJKS_ITEM_MAPPING.put("\u7f34\u6b3e\u4e66\u53f7\u7801", "jkshm");
        VAT_HGJKS_ITEM_MAPPING.put("\u7a0e\u53f7\u4fe1\u606f", "shxx");
        VAT_HGJKS_ITEM_MAPPING.put("\u8d27\u7269\u540d\u79f0", "hwmc");
        VAT_HGJKS_ITEM_MAPPING.put("\u5b8c\u7a0e\u4ef7\u683c", "wsjg");
        VAT_HGJKS_ITEM_MAPPING.put("\u6570\u91cf", "sl");
        VAT_HGJKS_ITEM_MAPPING.put("\u5355\u4f4d", "dw");
        VAT_HGJKS_ITEM_MAPPING.put("\u7a0e\u7387", "slv");
        VAT_HGJKS_ITEM_MAPPING.put("\u7a0e\u6b3e\u91d1\u989d", "skje");
        VAT_HGJKS_ITEM_MAPPING.put("\u6570\u636e\u6765\u6e90", "sjly");
    }
}

