/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.download.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.invoice.download.InputOutInvoiceApplyService;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.ImcConfigUtil;
import kd.imc.rim.common.utils.UUID;
import org.apache.commons.lang3.tuple.Pair;

public class AisinoInputOutInvoiceApplyServiceImpl
extends InputOutInvoiceApplyService {
    private static final Log LOGGER = LogFactory.getLog(AisinoInputOutInvoiceApplyServiceImpl.class);

    @Override
    public void applyCurrentData(DynamicObject initDynamicObject, String invoiceType, String dataType, Long orgId, String taxNo) {
        int days = InvoiceDownloadConstant.getPageSizeFromConfig(1, "aisino_inputout_days");
        Date firstDay = DateUtils.addDay(new Date(), -days);
        Pair<DynamicObject, Integer> logDynamicObjectPair = this.getLogDynamicObject(taxNo, invoiceType, dataType, "2", firstDay = DateUtils.getDayStart(firstDay), firstDay);
        DynamicObject logDynamicObject = (DynamicObject)logDynamicObjectPair.getLeft();
        if (logDynamicObject != null) {
            Date downEndDate = logDynamicObject.getDate("invoice_enddate");
            if (downEndDate.before(firstDay)) {
                this.applyInputOutDownInvoice(null, initDynamicObject, invoiceType, dataType, orgId, taxNo, firstDay, firstDay);
            }
        } else {
            this.applyInputOutDownInvoice(null, initDynamicObject, invoiceType, dataType, orgId, taxNo, firstDay, firstDay);
        }
    }

    @Override
    public void applyInitHistoryData(DynamicObject initDynamicObject, String invoiceType, String dataType, Long orgId, String taxNo, List<Map<String, Date>> initDateList) {
        if (!CollectionUtils.isEmpty(initDateList)) {
            super.applyInitHistoryData(initDynamicObject, invoiceType, dataType, orgId, taxNo, initDateList);
            this.applyHistoryData(initDynamicObject, invoiceType, dataType, orgId, taxNo, DateUtils.getFirstDateOfMonth(new Date()), new Date());
        }
    }

    @Override
    public JSONObject applyInputOutDownInvoice(Long logId, DynamicObject initDynamicObject, String invoiceType, String dataType, Long orgId, String taxNo, Date begin, Date end) {
        String rwh = UUID.getBatchNoByTaxNo(taxNo);
        JSONObject resultJson = this.convertApplyResult(rwh, dataType, invoiceType, begin, end);
        this.dealResult(resultJson, initDynamicObject, logId, orgId, taxNo);
        return resultJson;
    }

    @Override
    public boolean checkDownCustom(String inout, String invoiceType, String taxNo) {
        String config;
        if (StringUtils.isEmpty((String)invoiceType)) {
            return false;
        }
        if (!"1".equals(inout)) {
            return false;
        }
        if (InvoiceDownloadConstant.isElectricPaper(invoiceType) || InputInvoiceTypeEnum.WITHHOLDING.getAwsType().equals(invoiceType)) {
            return false;
        }
        if ((InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getAwsType().equals(invoiceType) || InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getAwsType().equals(invoiceType)) && !"1".equals(config = ImcConfigUtil.getValue("rim_hx_e_invoice", taxNo))) {
            return false;
        }
        Long invoiceTypeLong = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(invoiceType);
        return InputInvoiceTypeEnum.canDeduction(invoiceTypeLong);
    }
}

