/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.download.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.deduction.impl.BwDeductService;
import kd.imc.rim.common.invoice.download.InvoiceDownService;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.BwService;
import kd.imc.rim.common.utils.UUID;

public class BwHeaderInvoiceDownServiceImpl
extends InvoiceDownService {
    private static Log LOGGER = LogFactory.getLog(BwHeaderInvoiceDownServiceImpl.class);

    @Override
    public JSONObject invoiceDown(DynamicObject dynamicObject, RequestContext requestContext, Long orgId, String taxNo) {
        LOGGER.info("\u5f00\u59cb\u4e0b\u8f7d\u589e\u91cf\u53d1\u7968{}", (Object)taxNo);
        Date beginDate = dynamicObject.getDate("begin");
        JSONObject param = new JSONObject();
        param.put("taxNo", (Object)taxNo);
        BwService bwService = BwService.newInstance();
        String batchNo = this.getDownBatchNo();
        JSONArray invoiceArray = new JSONArray();
        String taskNo = UUID.getBatchNoByTaxNo(taxNo);
        this.postFunction(bwService, invoiceArray, param);
        for (int i = 0; i < invoiceArray.size(); ++i) {
            JSONObject jsonObject = invoiceArray.getJSONObject(i);
            JSONObject invoice = BwDeductService.convertInvoiceMainInfo(jsonObject);
            invoiceArray.set(i, (Object)invoice);
        }
        if (!CollectionUtils.isEmpty((Collection)invoiceArray)) {
            DynamicObject syncLog = this.getDownLogDynamicObject(batchNo, taskNo, orgId, taxNo, 0, "1");
            this.saveAccount(syncLog, invoiceArray, beginDate);
        }
        return null;
    }

    private JSONObject postFunction(BwService bwService, JSONArray invoiceArray, JSONObject param) {
        try {
            JSONObject result = bwService.postAppJson("InputInvoicedataSync", param.toJSONString());
            LOGGER.info("BwHeaderInvoiceDownServiceImpl INPUT_INVOICE_DATASYNC result :{}", (Object)result);
            if (result == null) {
                return ResultContant.createJSONObject("0206", ResManager.loadKDString((String)"\u63a5\u53e3\u8c03\u7528\u51fa\u9519", (String)"BwHeaderInvoiceDownServiceImpl_0", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            if (result.get((Object)"success") != null && result.getBoolean("success").booleanValue()) {
                JSONObject model = result.getJSONObject("model");
                String taskNo = model.getString("task_no");
                int invoiceNum = model.getInteger("invoice_quantity");
                invoiceArray.addAll((Collection)model.getJSONArray("invoice_list"));
                param.put("task_no", (Object)taskNo);
                JSONObject feedback = bwService.postAppJson("InputInvoicedataSyncresult", param.toJSONString());
                LOGGER.info("BwHeaderInvoiceDownServiceImpl INPUT_INVOICE_DATASYNC_RESULT result :{}", (Object)feedback);
                if (feedback == null || invoiceNum < 1000) {
                    return result;
                }
            } else {
                return ResultContant.createJSONObject(result.getJSONObject("message").getString("error_code"), result.getJSONObject("message").getString("error_message"));
            }
            this.postFunction(bwService, invoiceArray, param);
        }
        catch (Exception e) {
            LOGGER.info("BwDeductService post Exception:{}", (Object)e);
            if (e instanceof MsgException) {
                return ResultContant.createJSONObject(((MsgException)e).getErrorCode(), ((MsgException)e).getErrorMsg());
            }
            return ResultContant.createJSONObject("0206", ResManager.loadKDString((String)"\u63a5\u53e3\u8c03\u7528\u51fa\u9519", (String)"BwHeaderInvoiceDownServiceImpl_0", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        return null;
    }

    private void saveAccount(DynamicObject syncLog, JSONArray dataArray, Date beginDate) {
        int totalNum = syncLog.getInt("total_num");
        this.insertHeaderSyncAccount(syncLog, beginDate, dataArray);
        syncLog.set("total_num", (Object)(totalNum += dataArray.size()));
        syncLog.set("modifytime", (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{syncLog});
    }
}

