/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.download.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.CollectTypeEnum;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.helper.RecognitionCheckHelper;
import kd.imc.rim.common.invoice.checknew.model.CheckParam;
import kd.imc.rim.common.invoice.checknew.model.CheckResult;
import kd.imc.rim.common.invoice.deduction.DeductionDownService;
import kd.imc.rim.common.invoice.download.InvoiceDealService;
import kd.imc.rim.common.invoice.download.impl.InOutputInvoiceDownServiceImpl;
import kd.imc.rim.common.invoice.model.ConvertFieldUtil;
import kd.imc.rim.common.invoice.save.InvoiceSaveResult;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.service.InvoiceLog;
import kd.imc.rim.common.service.SimplyCheckService;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.DeductionUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.FileUploadUtils;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.common.utils.InvoiceConvertUtils;
import kd.imc.rim.common.utils.LockUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.SysParamUtil;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.common.utils.extract.ZipExtractUtil;
import org.apache.commons.lang3.tuple.Pair;

public class InputInvoiceDealService
extends InvoiceDealService
implements Callable<Boolean> {
    private RequestContext rc;
    private Object id;
    private static final Log LOGGER = LogFactory.getLog(InputInvoiceDealService.class);

    public InputInvoiceDealService(RequestContext rc, Object id) {
        this.rc = rc;
        this.id = id;
    }

    @Override
    public void dealSingle(RequestContext requestContext, DynamicObject data) {
        Integer handleNum;
        Integer n = handleNum = Integer.valueOf(data.getInt("handle_num"));
        Integer n2 = handleNum = Integer.valueOf(handleNum + 1);
        data.set("handle_num", (Object)handleNum);
        String serialNo = data.getString("serial_no");
        String key = "rim.dealinputinvoice-" + serialNo;
        try (DLock lock = LockUtils.createDLockByMd5(key, ResManager.loadKDString((String)"\u5904\u7406\u8fdb\u9879\u53d1\u7968", (String)"InputInvoiceDealService_0", (String)"imc-rim-common", (Object[])new Object[0]));){
            if (lock.tryLock()) {
                String dataType = data.getString("data_type");
                String invoiceJsonStr = data.getString("invoice_json_tag");
                Long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue(data.get("invoice_type"));
                JSONObject invoiceJson = JSONObject.parseObject((String)invoiceJsonStr);
                invoiceJson.put("invoiceType", (Object)invoiceType);
                String buyerTaxNo = invoiceJson.getString("buyerTaxNo");
                Long configOrg = this.getOrgIdByTaxNo(buyerTaxNo);
                invoiceJson.put("taxNo", (Object)buyerTaxNo);
                DeductionUtils.setTaxDownCollectInfo(invoiceJson);
                InvoiceSaveService service = InvoiceSaveService.newInstance(invoiceType.toString());
                Long orgId = DynamicObjectUtil.getDynamicObjectLongValue(data.get("org"));
                if (configOrg != null && configOrg > 0L) {
                    orgId = configOrg;
                } else if (orgId <= 0L) {
                    orgId = requestContext.getOrgId();
                }
                invoiceJson.put("org_id", (Object)orgId);
                invoiceJson.put("rim_user", (Object)requestContext.getUserId());
                if ("3".equals(dataType) || "2".equals(dataType)) {
                    if ("2".equals(dataType)) {
                        invoiceJson.put("allowDeduction", (Object)"0");
                    }
                    this.handleCompleteInvoice(data, dataType, invoiceType, invoiceJson, service);
                } else if ("1".equals(dataType)) {
                    this.handleHeaderInvoice(requestContext, data, invoiceType, orgId, invoiceJson, service);
                } else if ("4".equals(dataType)) {
                    this.handleInvoiceFile(data, invoiceType, invoiceJson, service);
                } else if ("9".equals(dataType)) {
                    this.handleAgricInvoice(data, invoiceType, invoiceJson, service);
                } else {
                    data.set("sync_status", (Object)"0");
                }
                data.set("modifytime", (Object)new Date());
                if (!"1".equals(data.getString("sync_status")) && !"4".equals(dataType) && handleNum > 3) {
                    data.set("sync_status", (Object)"0");
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{data});
                String syncStatus = data.getString("sync_status");
                if ((InputInvoiceTypeEnum.TOLL_ELECTRON.getCode().equals(invoiceType) || InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceType)) && !"4".equals(dataType)) {
                    syncStatus = "1";
                }
                this.updateDownAccount(syncStatus, serialNo, data.getString("fpy_serial_no"), data.getString("inout"), invoiceType);
            }
        }
        catch (Throwable e) {
            data.set("modifytime", (Object)new Date());
            if (!"1".equals(data.getString("sync_status")) && handleNum > 3) {
                data.set("sync_status", (Object)"0");
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{data});
            LOGGER.error("InputInvoiceDownDealTask-error:" + serialNo, e);
        }
    }

    private void handleAgricInvoice(DynamicObject data, Long invoiceType, JSONObject invoiceJson, InvoiceSaveService service) {
        String serialNo;
        block17: {
            invoiceJson.put("downResource", (Object)"agricDown");
            String invoiceCode = invoiceJson.getString("invoiceCode");
            String invoiceNo = invoiceJson.getString("invoiceNo");
            QFilter invoiceTypeFilter = new QFilter("invoice_type", "=", (Object)invoiceType);
            String tenantNo = TenantUtils.getTenantNo();
            QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)tenantNo);
            QFilter invoiceCodeFilter = new QFilter("invoice_code", "=", (Object)kd.imc.rim.common.utils.StringUtils.trimToEmpty((String)invoiceCode));
            QFilter invoiceNoFilter = new QFilter("invoice_no", "=", (Object)invoiceNo);
            DynamicObject serialObject = BusinessDataServiceHelper.loadSingle((String)"rim_invoice", (String)"id,serial_no", (QFilter[])new QFilter[]{invoiceCodeFilter, invoiceNoFilter, invoiceTypeFilter, tenantFilter});
            serialNo = "";
            if (serialObject != null) {
                serialNo = serialObject.getString("serial_no");
                DynamicObject mainDynamicObject = BusinessDataServiceHelper.loadSingle((Object)serialObject.get("id"), (String)"rim_invoice");
                service.setDownAgricData(invoiceType, mainDynamicObject, invoiceJson);
                String invoiceStatus = invoiceJson.getString("invoiceStatus");
                mainDynamicObject.set("invoice_status", (Object)invoiceStatus);
                String etaxInvoiceNo = invoiceJson.getString("etaxInvoiceNo");
                if (kd.imc.rim.common.utils.StringUtils.isNotEmpty((CharSequence)etaxInvoiceNo)) {
                    mainDynamicObject.set("electronic_no", (Object)etaxInvoiceNo);
                }
                service.setSourceAndRiskLevel(invoiceJson, mainDynamicObject);
                service.setMainInvoiceInfo(mainDynamicObject);
                try (TXHandle h = TX.required();){
                    try {
                        String entity = InputInvoiceTypeEnum.getEntity(invoiceType);
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mainDynamicObject});
                        QFilter serialFilter = new QFilter("serial_no", "=", (Object)serialNo);
                        DynamicObject idObject = QueryServiceHelper.queryOne((String)entity, (String)"id,serial_no", (QFilter[])new QFilter[]{tenantFilter, serialFilter});
                        if (idObject != null) {
                            DynamicObject invoiceBody = BusinessDataServiceHelper.loadSingle((Object)idObject.get("id"), (String)entity);
                            service.setDownAgricData(invoiceType, invoiceBody, invoiceJson);
                            invoiceBody.set("invoice_status", (Object)invoiceStatus);
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invoiceBody});
                        }
                        InputInvoiceDealService.saveLog(invoiceJson, serialNo);
                        break block17;
                    }
                    catch (Throwable e) {
                        LOGGER.error("\u7a0e\u76d8\u4e0b\u8f7d\u66f4\u65b0\u53d1\u7968\u62a5\u9519", e);
                        h.markRollback();
                        throw e;
                    }
                }
            }
            InvoiceSaveResult saveResult = service.save(invoiceJson);
            serialNo = saveResult.getSerialNo();
            InputInvoiceDealService.saveLog(invoiceJson, serialNo);
        }
        data.set("sync_status", (Object)"1");
        data.set("fpy_serial_no", (Object)serialNo);
    }

    private static void saveLog(JSONObject invoice, String serialNo) {
        if (invoice == null) {
            return;
        }
        JSONObject logInfo = new JSONObject();
        logInfo.put("processingStatus", (Object)invoice.getString("processingStatus"));
        logInfo.put("farmProductType", (Object)invoice.getString("farmProductType"));
        logInfo.put("processType", (Object)invoice.getString("processType"));
        logInfo.put("selfProducedAmount", (Object)invoice.getString("selfProducedAmount"));
        logInfo.put("invoiceStatus", (Object)invoice.getString("invoiceStatus"));
        logInfo.put("traceId", (Object)RequestContext.get().getTraceId());
        InvoiceLog.insert("deduct_authenticate", serialNo, logInfo.toJSONString(), invoice.getLong("org_id"), CollectTypeEnum.PC_SHUIPAN.getName(), CollectTypeEnum.PC_SHUIPAN.getCode());
    }

    private void handleInvoiceFile(DynamicObject data, Long invoiceType, JSONObject invoiceJson, InvoiceSaveService service) {
        long orgId;
        QFilter invoiceNoFilter;
        String invoiceCode = invoiceJson.getString("invoiceCode");
        String invoiceNo = invoiceJson.getString("invoiceNo");
        QFilter invoiceTypeFilter = new QFilter("invoice_type", "=", (Object)invoiceType);
        String tenantNo = TenantUtils.getTenantNo();
        QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)tenantNo);
        QFilter invoiceCodeFilter = null;
        invoiceCodeFilter = !InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceType) && !InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode().equals(invoiceType) && !InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(invoiceType) ? new QFilter("invoice_code", "=", (Object)invoiceCode) : new QFilter("invoice_code", "=", (Object)"");
        DynamicObject serialObject = BusinessDataServiceHelper.loadSingle((String)"rim_invoice", (String)"id,serial_no,original_state, org", (QFilter[])new QFilter[]{invoiceCodeFilter, invoiceNoFilter = new QFilter("invoice_no", "=", (Object)invoiceNo), invoiceTypeFilter, tenantFilter});
        if (serialObject == null) {
            return;
        }
        String serialNo = serialObject.getString("serial_no");
        boolean electricFlag = InputInvoiceTypeEnum.isEleInvoice(invoiceType);
        String originalStateElectric = "0";
        if ("1".equals(serialObject.getString("original_state"))) {
            if (!electricFlag) {
                data.set("fpy_serial_no", (Object)serialNo);
                data.set("sync_status", (Object)"1");
                return;
            }
            originalStateElectric = "1";
        }
        QFilter serialFilter = new QFilter("serial_no", "=", (Object)serialNo);
        DynamicObject fileIdDynamicObject = QueryServiceHelper.queryOne((String)"rim_invoice_file", (String)"id", (QFilter[])new QFilter[]{tenantFilter, serialFilter});
        boolean genFlag = false;
        if (fileIdDynamicObject == null) {
            fileIdDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"rim_invoice_file");
            fileIdDynamicObject.set("tenant_no", (Object)tenantNo);
            fileIdDynamicObject.set("serial_no", (Object)serialNo);
            fileIdDynamicObject.set("create_time", (Object)new Date());
            fileIdDynamicObject.set("original_filename", (Object)invoiceNo);
        } else {
            fileIdDynamicObject = BusinessDataServiceHelper.loadSingle((Object)fileIdDynamicObject.get("id"), (String)"rim_invoice_file");
            genFlag = "2".equals(fileIdDynamicObject.getString("original_state"));
        }
        fileIdDynamicObject.set("update_time", (Object)new Date());
        String ofdFile = invoiceJson.getString("ofdFile");
        String xmlFile = invoiceJson.getString("xmlFile");
        String pdfFile = invoiceJson.getString("pdfFile");
        String snapshotUrl = invoiceJson.getString("snapshotUrl");
        String originalState = kd.imc.rim.common.utils.StringUtils.isNotEmpty((CharSequence)ofdFile) || kd.imc.rim.common.utils.StringUtils.isNotEmpty((CharSequence)pdfFile) || kd.imc.rim.common.utils.StringUtils.isNotEmpty((CharSequence)xmlFile) ? "1" : "0";
        String fileType = "2";
        if (kd.imc.rim.common.utils.StringUtils.isNotEmpty((CharSequence)xmlFile)) {
            Pair<String, byte[]> fileBytePair = FileUtils.downLoadFileToByte(xmlFile, serialNo + "_zip");
            if (fileBytePair == null || fileBytePair.getRight() == null) {
                data.set("sync_status", (Object)"0");
                return;
            }
            Map<String, String> zipFileMap = ZipExtractUtil.extractFileForXml((byte[])fileBytePair.getRight());
            if (CollectionUtils.isEmpty(zipFileMap)) {
                LOGGER.info("{}-zip\u4e3a\u7a7a", (Object)xmlFile);
                data.set("sync_status", (Object)"0");
                return;
            }
            String xmlUrl = "";
            String fileName = serialNo + "_xml" + '.' + "xml";
            for (Map.Entry<String, String> entry : zipFileMap.entrySet()) {
                String xmlStr = entry.getValue();
                if (kd.imc.rim.common.utils.StringUtils.isEmpty((CharSequence)xmlStr)) continue;
                try (ByteArrayInputStream xbrlStream = new ByteArrayInputStream(xmlStr.getBytes("utf-8"));){
                    xmlUrl = FileUploadUtils.upload(FileUploadUtils.getInvoiceDir("invoice") + fileName, fileName, xbrlStream);
                    break;
                }
                catch (Exception e) {
                    LOGGER.error("\u5904\u7406xml\u6587\u4ef6\u8bc6\u522b:" + xmlFile, (Throwable)e);
                }
            }
            if (kd.imc.rim.common.utils.StringUtils.isEmpty((CharSequence)xmlUrl)) {
                data.set("sync_status", (Object)"0");
                return;
            }
            if (electricFlag) {
                fileIdDynamicObject.set("tax_xml_url", (Object)xmlUrl);
                if ("0".equals(originalStateElectric)) {
                    this.setElecPersonFile(xmlUrl, fileIdDynamicObject, "xml_url", genFlag);
                }
            } else {
                fileIdDynamicObject.set("xml_url", (Object)xmlUrl);
            }
            fileType = "9";
        }
        if (kd.imc.rim.common.utils.StringUtils.isNotEmpty((CharSequence)snapshotUrl)) {
            if (kd.imc.rim.common.utils.StringUtils.isEmpty((CharSequence)(snapshotUrl = FileUtils.downLoadAndUpload(snapshotUrl, serialNo + "_snap")))) {
                data.set("sync_status", (Object)"0");
                return;
            }
            if (electricFlag) {
                if ("0".equals(originalStateElectric)) {
                    this.setElecPersonFile(snapshotUrl, fileIdDynamicObject, "snapshot_url", genFlag);
                }
            } else {
                fileIdDynamicObject.set("snapshot_url", (Object)snapshotUrl);
            }
        }
        if (kd.imc.rim.common.utils.StringUtils.isNotEmpty((CharSequence)pdfFile)) {
            if (kd.imc.rim.common.utils.StringUtils.isEmpty((CharSequence)(pdfFile = FileUtils.downLoadAndUpload(pdfFile, serialNo + "_pdf")))) {
                data.set("sync_status", (Object)"0");
                return;
            }
            if (electricFlag) {
                fileIdDynamicObject.set("tax_pdf_url", (Object)pdfFile);
                if ("0".equals(originalStateElectric)) {
                    this.setElecPersonFile(pdfFile, fileIdDynamicObject, "pdf_url", genFlag);
                }
            } else {
                fileIdDynamicObject.set("pdf_url", (Object)pdfFile);
            }
            fileType = "1";
        }
        if (kd.imc.rim.common.utils.StringUtils.isNotEmpty((CharSequence)ofdFile)) {
            if (kd.imc.rim.common.utils.StringUtils.isEmpty((CharSequence)(ofdFile = FileUtils.downLoadAndUpload(ofdFile, serialNo + "_ofd")))) {
                data.set("sync_status", (Object)"0");
                return;
            }
            if (electricFlag) {
                fileIdDynamicObject.set("tax_ofd_url", (Object)ofdFile);
                if ("0".equals(originalStateElectric)) {
                    this.setElecPersonFile(ofdFile, fileIdDynamicObject, "ofd_url", genFlag);
                }
            } else {
                fileIdDynamicObject.set("ofd_url", (Object)ofdFile);
            }
            fileType = "4";
        }
        fileIdDynamicObject.set("original_state", (Object)originalState);
        if ("1".equals(originalState)) {
            fileIdDynamicObject.set("original_type", (Object)fileType);
        } else if (kd.imc.rim.common.utils.StringUtils.isEmpty((CharSequence)fileIdDynamicObject.getString("original_type"))) {
            fileIdDynamicObject.set("original_type", (Object)fileType);
        }
        fileIdDynamicObject.set("rotation_angle", null);
        fileIdDynamicObject.set("region", null);
        fileIdDynamicObject.set("pixel", null);
        String needSign = "0";
        if ("0".equals(originalStateElectric) && electricFlag && (orgId = DynamicObjectUtil.getDynamicObjectLongValue(serialObject.get("org"))) > 0L) {
            needSign = SysParamUtil.getSysParamByOrgId(orgId, "tax_file_auto_sign") ? "1" : "0";
        }
        try (TXHandle h = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{fileIdDynamicObject});
                String string = originalState = electricFlag ? needSign : originalState;
                if ("1".equals(originalState)) {
                    DynamicObject mainDynamicObject = BusinessDataServiceHelper.loadSingle((Object)serialObject.get("id"), (String)"rim_invoice");
                    mainDynamicObject.set("original_state", (Object)originalState);
                    mainDynamicObject.set("original_time", (Object)new Date());
                    mainDynamicObject.set("modifytime", (Object)new Date());
                    service.setMainInvoiceInfo(mainDynamicObject);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mainDynamicObject});
                }
                data.set("fpy_serial_no", (Object)serialNo);
                data.set("sync_status", (Object)"1");
            }
            catch (Throwable e) {
                LOGGER.error("\u4fdd\u5b58\u53d1\u7968\u6587\u4ef6\u62a5\u9519", e);
                h.markRollback();
                throw e;
            }
        }
    }

    private void setElecPersonFile(String filePath, DynamicObject fileIdDynamicObject, String propertyName, boolean genFlag) {
        if ((kd.imc.rim.common.utils.StringUtils.isBlank((CharSequence)fileIdDynamicObject.getString(propertyName)) || genFlag) && !kd.imc.rim.common.utils.StringUtils.isBlank((CharSequence)filePath)) {
            fileIdDynamicObject.set(propertyName, (Object)filePath);
        }
    }

    private void handleCompleteInvoice(DynamicObject data, String dataType, Long invoiceType, JSONObject invoiceJson, InvoiceSaveService service) {
        String serialNo;
        String checkStatus = invoiceJson.getString("checkStatus");
        if (kd.imc.rim.common.utils.StringUtils.isEmpty((CharSequence)checkStatus)) {
            checkStatus = "1";
        }
        invoiceJson.put("checkStatus", (Object)checkStatus);
        DeductionUtils.deleteCheckCache(invoiceJson, invoiceType);
        if (InvoiceConvertUtils.isSaleListInvoiceType(invoiceType)) {
            RecognitionCheckHelper.markSaleListByCheckResult(invoiceJson);
        }
        if (kd.imc.rim.common.utils.StringUtils.isEmpty((CharSequence)(serialNo = DeductionDownService.handleTaxFullInvoice(service, invoiceJson)))) {
            service.notOverrideOrg(invoiceJson);
            invoiceJson.put("needUserRelation", (Object)"0");
            InvoiceSaveResult saveResult = service.save(invoiceJson);
            serialNo = saveResult.getSerialNo();
        }
        invoiceJson.put("serialNo", (Object)serialNo);
        String isSaleListInvoice = invoiceJson.getString("isSaleListInvoice");
        if ("1".equals(isSaleListInvoice)) {
            RecognitionCheckHelper recognitionCheckHelper = new RecognitionCheckHelper();
            recognitionCheckHelper.dealInvoiceAttachRelation(invoiceJson);
        }
        data.set("fpy_serial_no", (Object)serialNo);
        if ("3".equals(dataType)) {
            data.set("sync_status", (Object)"1");
        } else {
            data.set("sync_status", (Object)"0");
        }
    }

    private void handleHeaderInvoice(RequestContext requestContext, DynamicObject data, Long invoiceType, Long orgId, JSONObject invoiceJson, InvoiceSaveService service) {
        Pair<Boolean, String> updatePair = DeductionDownService.isUpdateDownInvoice(service, invoiceType, invoiceJson);
        String downResource = invoiceJson.getString("downResource");
        if ("inputHeader".equals(downResource) || "inputInit".equals(downResource)) {
            if (((Boolean)updatePair.getLeft()).booleanValue()) {
                data.set("fpy_serial_no", updatePair.getRight());
            } else {
                invoiceJson.put("delete", (Object)"2");
                InvoiceSaveResult saveResult = service.save(invoiceJson);
                data.set("fpy_serial_no", (Object)saveResult.getSerialNo());
            }
            data.set("sync_status", (Object)"1");
            return;
        }
        if (((Boolean)updatePair.getLeft()).booleanValue()) {
            data.set("sync_status", (Object)"1");
            data.set("fpy_serial_no", updatePair.getRight());
        } else {
            this.checkInvoice(requestContext, data, invoiceType, orgId, invoiceJson, service);
        }
    }

    private void checkInvoice(RequestContext requestContext, DynamicObject data, Long invoiceType, Long orgId, JSONObject invoiceJson, InvoiceSaveService service) {
        Pair<Long, String> configPair;
        String cacheKey = "down_check_config_key" + orgId;
        String isCheck = CacheHelper.get(cacheKey);
        if (kd.imc.rim.common.utils.StringUtils.isEmpty((CharSequence)isCheck) && kd.imc.rim.common.utils.StringUtils.isEmpty((CharSequence)(isCheck = (String)(configPair = this.cacheConfig(null, orgId)).getRight()))) {
            String invoiceCheck = RimConfigUtils.getConfig("rim_deduction", "down_invoice_check");
            isCheck = Optional.ofNullable(invoiceCheck).filter(org.apache.commons.lang3.StringUtils::isNotEmpty).orElse("1");
            int hours = InvoiceDownloadConstant.getPageSizeFromConfig(15, "check_config_mins");
            CacheHelper.put(cacheKey, isCheck, hours * 60);
        }
        String isNotSave = RimConfigUtils.getConfig("rim_deduction", "not_down_uncheck_save");
        if ("1".equals(isCheck) || "2".equals(isCheck)) {
            String invoiceCode = invoiceJson.getString("invoiceCode");
            String invoiceNo = invoiceJson.getString("invoiceNo");
            if (InputInvoiceTypeEnum.TOLL_ELECTRON.getCode().equals(invoiceType) || InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceType)) {
                if (!"1".equals(isNotSave)) {
                    invoiceJson.put("checkStatus", (Object)"3");
                    InvoiceSaveResult saveTollResult = service.save(invoiceJson);
                    data.set("fpy_serial_no", (Object)saveTollResult.getSerialNo());
                }
                data.set("sync_status", (Object)"0");
            } else {
                Date invoiceDate = invoiceJson.getDate("invoiceDate");
                BigDecimal invoiceAmount = invoiceJson.getBigDecimal("invoiceAmount");
                if (InputInvoiceTypeEnum.needReplaceAmountType(invoiceType)) {
                    invoiceAmount = invoiceJson.getBigDecimal("totalAmount");
                }
                String checkCode = invoiceJson.getString("checkCode");
                CheckParam checkParam = new CheckParam(invoiceCode, invoiceNo, invoiceType, invoiceDate, invoiceAmount, checkCode, null);
                HashMap extMap = Maps.newHashMap();
                extMap.put("orgId", orgId);
                String taxNo = TenantUtils.getTaxNoByOrgId(orgId);
                extMap.put("taxNo", taxNo);
                extMap.put("eid", requestContext.getUserId());
                checkParam.setExtMap(extMap);
                CheckResult checkResult = SimplyCheckService.checkInvoice(checkParam, orgId, taxNo);
                if ("0000".equals(checkResult.getErrcode())) {
                    Object invoiceEntity = checkResult.getData();
                    String invoiceCheckStr = JSONObject.toJSONString((Object)invoiceEntity);
                    JSONObject invoiceData = JSON.parseObject((String)invoiceCheckStr);
                    String checkStatus = invoiceData.getString("checkStatus");
                    if (StringUtils.isEmpty((CharSequence)checkStatus)) {
                        invoiceData.put("checkStatus", (Object)"1");
                    }
                    ConvertFieldUtil.getStandardInvoice(invoiceData);
                    InOutputInvoiceDownServiceImpl downService = new InOutputInvoiceDownServiceImpl();
                    downService.updateNewDeductData(invoiceData, invoiceJson);
                    if (service != null) {
                        invoiceData.put("org_id", (Object)orgId);
                        invoiceData.put("taxNo", (Object)TenantUtils.getTaxNoByOrgId(orgId));
                        invoiceData.put("rim_user", (Object)requestContext.getUserId());
                        DeductionUtils.setTaxDownCollectInfo(invoiceData);
                        if ("1".equals(isCheck)) {
                            invoiceData.put("needUserRelation", (Object)"0");
                            InvoiceSaveResult saveResult = service.save(invoiceData);
                            invoiceData.put("serialNo", (Object)saveResult.getSerialNo());
                            String isSaleListInvoice = invoiceData.getString("isSaleListInvoice");
                            if ("1".equals(isSaleListInvoice)) {
                                RecognitionCheckHelper recognitionCheckHelper = new RecognitionCheckHelper();
                                recognitionCheckHelper.dealInvoiceAttachRelation(invoiceData);
                            }
                            data.set("fpy_serial_no", (Object)saveResult.getSerialNo());
                        }
                    }
                    data.set("sync_status", (Object)"1");
                } else if (!"1".equals(isNotSave)) {
                    invoiceJson.put("checkStatus", (Object)"2");
                    invoiceJson.put("needUserRelation", (Object)"0");
                    InvoiceSaveResult saveResult3 = service.save(invoiceJson);
                    data.set("fpy_serial_no", (Object)saveResult3.getSerialNo());
                }
                if ("2".equals(isCheck)) {
                    data.set("sync_status", (Object)"1");
                }
            }
        } else {
            invoiceJson.put("checkStatus", (Object)"3");
            if (!"1".equals(isNotSave)) {
                if (InvoiceConvertUtils.isSaleListInvoiceType(invoiceType)) {
                    RecognitionCheckHelper.markSaleListByCheckResult(invoiceJson);
                }
                invoiceJson.put("needUserRelation", (Object)"0");
                InvoiceSaveResult saveResult2 = service.save(invoiceJson);
                invoiceJson.put("serialNo", (Object)saveResult2.getSerialNo());
                String isSaleListInvoice = invoiceJson.getString("isSaleListInvoice");
                if ("1".equals(isSaleListInvoice)) {
                    RecognitionCheckHelper recognitionCheckHelper = new RecognitionCheckHelper();
                    recognitionCheckHelper.dealInvoiceAttachRelation(invoiceJson);
                }
                data.set("fpy_serial_no", (Object)saveResult2.getSerialNo());
            }
            data.set("sync_status", (Object)"1");
        }
    }

    @Override
    public Boolean call() throws Exception {
        RequestContext.copyAndSet((RequestContext)this.rc);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"rim_down_input");
        DynamicObject data = BusinessDataServiceHelper.loadSingle((Object)this.id, (DynamicObjectType)mainEntityType);
        this.dealSingle(this.rc, data);
        return Boolean.TRUE;
    }
}

