/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.download.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.deduction.DeductService;
import kd.imc.rim.common.invoice.deduction.DeductServiceFactory;
import kd.imc.rim.common.invoice.download.InvoiceDownService;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DeductionUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.LockUtils;
import kd.imc.rim.common.utils.RimConfigUtils;

public class InvoiceTableDownServiceImpl
extends InvoiceDownService {
    private static Log LOGGER = LogFactory.getLog(InvoiceTableDownServiceImpl.class);

    public InvoiceTableDownServiceImpl(boolean login) {
        this.login = login;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JSONObject invoiceDown(DynamicObject downLog, RequestContext requestContext, Long orgId, String taxNo) {
        LOGGER.info("\u5f00\u59cb\u4e0b\u8f7d\u8fdb\u9879\u5173\u952e\u8981\u7d20{}-{}", (Object)taxNo, downLog.get("batch_no"));
        String taskNo = Optional.ofNullable(downLog.getString("sync_task_no")).orElseGet(() -> downLog.getString("taskno"));
        Long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue(downLog.get("invoice_type"));
        if (orgId == 0L) {
            orgId = requestContext.getOrgId();
        }
        boolean outApi = false;
        String json = downLog.getString("json_tag");
        JSONObject paramJson = new JSONObject();
        if (StringUtils.isNotEmpty((CharSequence)json)) {
            try {
                paramJson = JSONObject.parseObject((String)json);
                if (StringUtils.isBlank((CharSequence)paramJson.getString("synctype"))) {
                    paramJson.put("synctype", (Object)"04");
                }
                outApi = true;
            }
            catch (Exception e) {
                LOGGER.error("json\u6570\u636e\u9519\u8bef" + taxNo, (Throwable)e);
                return ResultContant.createJSONObject(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"json\u6570\u636e\u9519\u8bef", (String)"InvoiceTableDownServiceImpl_0", (String)"imc-rim-common", (Object[])new Object[0]));
            }
        } else {
            String awsType = InputInvoiceTypeEnum.getAwsType(invoiceType);
            Date startDate = downLog.getDate("invoice_startdate");
            Date endDate = downLog.getDate("invoice_enddate");
            String startDateStr = DateUtils.format(startDate);
            String endDateStr = DateUtils.format(endDate);
            if (StringUtils.isEmpty((CharSequence)awsType) || InputInvoiceTypeEnum.HGJKS.getAwsType().equals(awsType)) {
                paramJson.put("jksbz", (Object)"1");
            } else {
                paramJson.put("jksbz", (Object)0);
            }
            paramJson.put("invoiceType", (Object)awsType);
            paramJson.put("synctype", (Object)"04");
            paramJson.put("versionNo", (Object)"");
            paramJson.put("synccondition", (Object)(startDateStr + "," + endDateStr));
            JSONObject searchOpt = new JSONObject();
            searchOpt.put("startTime", (Object)startDateStr);
            searchOpt.put("endTime", (Object)endDateStr);
            searchOpt.put("invoiceNo", (Object)Optional.ofNullable(searchOpt.getString("invoiceNo")).orElse(""));
            searchOpt.put("invoiceCode", (Object)Optional.ofNullable(searchOpt.getString("invoiceCode")).orElse(""));
            searchOpt.put("authenticateFlags", (Object)"");
            searchOpt.put("invoiceType", (Object)awsType);
            if ("4".equals(downLog.getString("sync_type"))) {
                paramJson.put("synctype", (Object)"03");
                paramJson.put("synccondition", (Object)DateUtils.format(startDate, "yyyy-MM"));
                searchOpt.clear();
                searchOpt.put("invoiceType", (Object)awsType);
                searchOpt.put("taxPeriod", (Object)DateUtils.format(startDate, "yyyyMM"));
            }
            paramJson.put("searchOpt", (Object)searchOpt);
        }
        paramJson.put("taxNo", (Object)taxNo);
        paramJson.put("batchNo", (Object)taskNo);
        paramJson.remove((Object)"asyncFlag");
        String key = "rim.InvoiceTableDownServiceImpl-" + taxNo;
        String preGovStatus = downLog.getString("gov_status");
        JSONObject resultJson = ResultContant.createSuccessJSONObject();
        try (DLock lock = LockUtils.createDLockByMd5(key, "InvoiceTableDownServiceImpl.lock");){
            if (!lock.tryLock()) return resultJson;
            resultJson = this.downLoadInvoices(paramJson, orgId);
            if (ResultContant.isSuccess(resultJson).booleanValue()) {
                String isCurrentPeriod;
                downLog.set("total_num", (Object)0);
                downLog.set("modifytime", (Object)new Date());
                this.setDescription(downLog, "");
                downLog.set("download_errcode", (Object)"3");
                JSONArray invoices = resultJson.getJSONArray("data");
                if (invoices == null) {
                    invoices = new JSONArray();
                }
                if ("4".equals(downLog.getString("sync_type"))) {
                    JSONArray invoicesTs;
                    JSONObject resultJsonTs;
                    paramJson.put("synctype", (Object)"09");
                    isCurrentPeriod = RimConfigUtils.getConfig("rim_deduction", "drawback_period");
                    if (!"1".equals(isCurrentPeriod)) {
                        paramJson.getJSONObject("searchOpt").put("taxPeriod", (Object)DateUtils.format(new Date(), "yyyyMM"));
                    }
                    if (ResultContant.isSuccess(resultJsonTs = this.downLoadInvoices(paramJson, orgId)).booleanValue() && !CollectionUtils.isEmpty((Collection)(invoicesTs = resultJsonTs.getJSONArray("data")))) {
                        invoices.addAll((Collection)invoicesTs);
                    }
                }
                if (CollectionUtils.isEmpty((Collection)invoices)) {
                    downLog.set("download_errcode", (Object)"4");
                    downLog.set("gov_status", (Object)"9");
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{downLog});
                    isCurrentPeriod = resultJson;
                    return isCurrentPeriod;
                }
                downLog.set("gov_status", (Object)"3");
                this.insertHeaderSyncAccount(downLog, null, invoices);
                return resultJson;
            }
            Set<String> collectErrcodes = DeductionUtils.getEtaxRetryErrcodes();
            if (outApi && resultJson != null && !collectErrcodes.contains(resultJson.getString("errcode"))) {
                downLog.set("gov_status", (Object)"5");
            }
            if (resultJson != null && ErrorType.LQ_NONSUPPORT.getCode().equals(resultJson.getString("errcode")) && ErrorType.LQ_NONSUPPORT.getName().equals(resultJson.getString("description"))) {
                downLog.set("gov_status", (Object)"5");
            }
            downLog.set("download_errcode", (Object)(resultJson != null ? resultJson.getString("errcode") : "99"));
            this.setDescription(downLog, resultJson);
            String dkType = DeductionConstant.getDkType(taxNo);
            if (this.checkTaskStop(dkType, resultJson)) {
                downLog.set("gov_status", (Object)"5");
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{downLog});
            return resultJson;
        }
        catch (Exception e) {
            LOGGER.error("\u4e0b\u8f7d\u5168\u91cf\u53d1\u7968\u5931\u8d25" + taxNo, (Throwable)e);
            this.setDescription(downLog, e.getMessage());
            downLog.set("gov_status", (Object)preGovStatus);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{downLog});
            return ResultContant.createJSONObject(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u4e0b\u8f7d\u5168\u91cf\u53d1\u7968\u5931\u8d25", (String)"InvoiceTableDownServiceImpl_1", (String)"imc-rim-common", (Object[])new Object[0]));
        }
    }

    @Override
    public JSONObject downLoadInvoices(JSONObject bodyParam, Long orgId) {
        JSONObject login;
        String taxNo = bodyParam.getString("taxNo");
        String dkType = DeductionConstant.getDkType(taxNo);
        if (!this.login && "4".equals(dkType) && !ResultContant.isSuccess(login = DeductionUtils.eTaxClientLogin(orgId, taxNo)).booleanValue()) {
            return login;
        }
        DeductService deductService = DeductServiceFactory.newInstanceForDeduct(dkType, orgId);
        return deductService.queryInvoices(bodyParam);
    }
}

