/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.download.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.download.InvoiceDownService;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.LockUtils;
import kd.imc.rim.common.utils.LqConvertUtil;
import kd.imc.rim.common.utils.RimConfigUtils;
import org.apache.commons.lang.StringUtils;

public class LqHeaderInvoiceDownServiceImpl
extends InvoiceDownService {
    private static Log LOGGER = LogFactory.getLog(LqHeaderInvoiceDownServiceImpl.class);

    @Override
    public JSONObject invoiceDown(DynamicObject downInit, RequestContext requestContext, Long orgId, String taxNo) {
        LOGGER.info("\u5f00\u59cb\u4e0b\u8f7d\u4e50\u4f01\u98ce\u9669\u53d1\u7968{}", (Object)taxNo);
        Date beginDate = downInit.getDate("begin");
        if (orgId == 0L) {
            orgId = requestContext.getOrgId();
        }
        if (this.checkOffFlag("5", taxNo)) {
            return ResultContant.createJSONObject(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u4e0b\u8f7d\u5df2\u914d\u7f6e\u5173\u95ed,\u8bf7\u91cd\u65b0\u914d\u7f6e", (String)"LqHeaderInvoiceDownServiceImpl_0", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        List<String> invoiceTypes = CommonUtils.getMultiValues(downInit.getString("invoice_type"));
        Date endDate = DateUtils.addDay(new Date(), -1);
        String dayConfig = RimConfigUtils.getConfig("rim_deduction", "lq_header_days");
        Date startDate = null;
        if (StringUtils.isNotEmpty((String)dayConfig)) {
            try {
                int days = Integer.parseInt(dayConfig.trim());
                startDate = DateUtils.addDay(endDate, -days);
            }
            catch (NumberFormatException days) {
                // empty catch block
            }
        }
        if (startDate == null) {
            startDate = DateUtils.getFirstDateOfMonth(endDate);
        } else if (!DateUtils.isMonth(endDate, startDate)) {
            endDate = DateUtils.getLastDateOfMonth(startDate);
        }
        JSONObject param = new JSONObject();
        param.put("nsrsbh", (Object)taxNo);
        param.put("api_type", (Object)"FPTSTXXXCX");
        int pagesize = InvoiceDownloadConstant.getPageSizeFromConfig(1000, "lq_header_down_size");
        param.put("pagesize", (Object)pagesize);
        param.put("qsrq", (Object)DateUtils.format(startDate, "yyyyMMdd"));
        param.put("zzrq", (Object)DateUtils.format(endDate, "yyyyMMdd"));
        JSONObject resultJson = ResultContant.createSuccessJSONObject();
        for (String invoiceType : invoiceTypes) {
            param.put("currpage", (Object)"1");
            resultJson = this.downHeaderInvoice(invoiceType, orgId, taxNo, beginDate, param);
        }
        return resultJson;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JSONObject downHeaderInvoice(String invoiceType, Long orgId, String taxNo, Date beginDate, JSONObject param) {
        Long longType = InvoiceDownloadConstant.getInvoiceTypeByAwsType(invoiceType);
        if (InputInvoiceTypeEnum.HGJKS.getCode().equals(longType)) return ResultContant.createJSONObject(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u6d77\u5173\u7f34\u6b3e\u4e66\u4e0d\u652f\u6301", (String)"LqHeaderInvoiceDownServiceImpl_1", (String)"imc-rim-common", (Object[])new Object[0]));
        if (InputInvoiceTypeEnum.WITHHOLDING.getCode().equals(longType)) {
            return ResultContant.createJSONObject(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u6d77\u5173\u7f34\u6b3e\u4e66\u4e0d\u652f\u6301", (String)"LqHeaderInvoiceDownServiceImpl_1", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        JSONObject resultJson = ResultContant.createSuccessJSONObject();
        String fplx = InvoiceDownloadConstant.getLqTypeByAwsType(invoiceType);
        if (StringUtils.isEmpty((String)fplx)) {
            return resultJson;
        }
        param.put("fplx", (Object)fplx);
        String batchNo = this.getDownBatchNo();
        String key = "rim.lqHeadercollectinvoicedata-" + taxNo;
        try (DLock lock = LockUtils.createDLockByMd5(key, "LqHeaderInvoiceDownServiceImpl.lock");){
            int pagesize;
            if (!lock.tryLock()) return resultJson;
            resultJson = this.downLoadInvoices(param, orgId);
            if (ResultContant.isSuccess(resultJson) == false) return resultJson;
            JSONObject data = resultJson.getJSONObject("data");
            if (data == null) {
                JSONObject jSONObject = resultJson;
                return jSONObject;
            }
            int count = data.getIntValue("count");
            int totalPages = count % (pagesize = param.getInteger("pagesize").intValue()) == 0 ? count / pagesize : count / pagesize + 1;
            JSONArray invoices = CommonUtils.getJsonValue((Map<String, Object>)data, JSONArray.class, "fptxxxmx", "fpfxxxmx");
            if (CollectionUtils.isEmpty((Collection)invoices)) return resultJson;
            DynamicObject syncLog = this.getDownLogDynamicObject(batchNo, batchNo, orgId, taxNo, 0, "1", longType);
            Date startDate = DateUtils.stringToDate(param.getString("qsrq"), "yyyyMMdd");
            Date endDate = DateUtils.stringToDate(param.getString("zzrq"), "yyyyMMdd");
            syncLog.set("invoice_startdate", (Object)startDate);
            syncLog.set("invoice_enddate", (Object)endDate);
            syncLog.set("aws_invoice_type", (Object)invoiceType);
            this.insertHeaderSyncLog(syncLog, taxNo, data, beginDate, invoiceType);
            this.downSurplusInvoice(syncLog, param, totalPages, orgId, beginDate, invoiceType, data.getString("scrollId"));
            return resultJson;
        }
        catch (Exception e) {
            LOGGER.error("\u4e0b\u8f7d\u8868\u5934\u6570\u636e\u5931\u8d25" + taxNo, (Throwable)e);
            return ResultContant.createJSONObject(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u4e0b\u8f7d\u8868\u5934\u6570\u636e\u5931\u8d25", (String)"LqHeaderInvoiceDownServiceImpl_2", (String)"imc-rim-common", (Object[])new Object[0]));
        }
    }

    private void downSurplusInvoice(DynamicObject syncLog, JSONObject paramJson, int page, Long orgId, Date beginDate, String invoiceType, String scrollId) {
        if (page <= 1 || StringUtils.isBlank((String)scrollId)) {
            return;
        }
        JSONObject result = null;
        for (int currentPage = 2; currentPage <= page; ++currentPage) {
            paramJson.put("currpage", (Object)String.valueOf(currentPage));
            paramJson.put("scrollId", (Object)scrollId);
            result = this.downLoadInvoices(paramJson, orgId);
            if (!ResultContant.isSuccess(result).booleanValue()) continue;
            JSONObject data = result.getJSONObject("data");
            this.insertHeaderSyncLog(syncLog, syncLog.getString("tax_no"), data, beginDate, invoiceType);
            scrollId = data.getString("scrollId");
            if (StringUtils.isBlank((String)scrollId)) break;
        }
    }

    private void insertHeaderSyncLog(DynamicObject syncLog, String taxNo, JSONObject dataJson, Date beginDate, String invoiceType) {
        JSONArray dataArray = CommonUtils.getJsonValue((Map<String, Object>)dataJson, JSONArray.class, "fptxxxmx", "fpfxxxmx");
        if (CollectionUtils.isEmpty((Collection)dataArray)) {
            return;
        }
        LOGGER.info("\u8868\u5934\u4e0b\u8f7d\u5165\u540c\u6b65\u53f0\u8d26\u65e5\u5fd7\u8868:{},\u53d1\u7968\u6570\u91cf:{}", (Object)taxNo, (Object)dataArray.size());
        JSONObject newInvoice = null;
        JSONArray newDataArray = new JSONArray();
        for (int i = 0; i < dataArray.size(); ++i) {
            JSONObject invoice = dataArray.getJSONObject(i);
            newInvoice = LqConvertUtil.convertInvoiceMainInfo(invoice, invoiceType);
            newInvoice.put("downResource", (Object)"inputHeader");
            newDataArray.add((Object)newInvoice);
        }
        int totalNum = syncLog.getInt("total_num");
        this.insertHeaderSyncAccount(syncLog, beginDate, newDataArray);
        syncLog.set("total_num", (Object)(totalNum += dataArray.size()));
        syncLog.set("modifytime", (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{syncLog});
    }

    @Override
    public JSONObject downLoadInvoices(JSONObject bodyParam, Long orgId) {
        return LqConvertUtil.invokeService(bodyParam);
    }
}

