/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.download.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.download.InvoiceDownService;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.LockUtils;
import kd.imc.rim.common.utils.LqConvertUtil;
import kd.imc.rim.file.utils.CompressHelper;
import org.apache.commons.lang.StringUtils;

public class LqInputInvoiceInitDownServiceImpl
extends InvoiceDownService {
    private static Log LOGGER = LogFactory.getLog(LqInputInvoiceInitDownServiceImpl.class);

    public LqInputInvoiceInitDownServiceImpl() {
        this.dkType = "5";
    }

    @Override
    public JSONObject invoiceDown(DynamicObject downLog, RequestContext requestContext, Long orgId, String taxNo) {
        LOGGER.info("\u4e0b\u8f7d\u4e50\u4f01\u8fdb\u9879\u62b5\u6263\u53d1\u7968\u8868\u5934{}-{}", (Object)taxNo, downLog.get("batch_no"));
        if (this.checkOffFlag(this.dkType, taxNo)) {
            return ResultContant.createJSONObject(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u4e0b\u8f7d\u5df2\u914d\u7f6e\u5173\u95ed,\u8bf7\u91cd\u65b0\u914d\u7f6e", (String)"LqInputInvoiceInitDownServiceImpl_0", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        JSONObject param = new JSONObject();
        String key = "rim.lqInputInitdowncollectinvoicedata-" + taxNo;
        param.put("pclsh", (Object)downLog.getString("taskno"));
        param.put("nsrsbh", (Object)taxNo);
        param.put("kjywrsbh", (Object)taxNo);
        param.put("api_type", (Object)"WGXSJCSHQDXZSQFKDKGX");
        param.put("packageno", (Object)"1");
        JSONObject resultJson = ResultContant.createSuccessJSONObject();
        try (DLock lock = LockUtils.createDLockByMd5(key, "LqInputInvoiceInitDownServiceImpl.lock");){
            if (lock.tryLock()) {
                resultJson = this.downLoadInvoices(param, orgId);
                if (ResultContant.isSuccess(resultJson).booleanValue()) {
                    JSONObject data = resultJson.getJSONObject("data");
                    int packagecount = data.getIntValue("packagecount");
                    String status = data.getString("cljg");
                    if ("1".equals(status)) {
                        downLog.set("total_num", (Object)0);
                        downLog.set("gov_status", (Object)"8");
                        downLog.set("download_errcode", (Object)"3");
                        this.insertInputOutDataSyncLog(downLog, data, "1");
                        this.downSurplusInvoice(downLog, param, packagecount, orgId);
                        this.setDescription(downLog, "");
                    } else if ("2".equals(status)) {
                        downLog.set("gov_status", (Object)"9");
                        downLog.set("download_errcode", (Object)"4");
                        this.setDescription(downLog, "");
                    } else {
                        downLog.set("gov_status", (Object)"7");
                        downLog.set("download_errcode", (Object)"7");
                        resultJson = ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u5904\u7406\u5931\u8d25", (String)"LqInputInvoiceInitDownServiceImpl_1", (String)"imc-rim-common", (Object[])new Object[0]));
                        this.setDescription(downLog, resultJson);
                    }
                } else if (resultJson == null || "6910".equals(resultJson.getString("errcode")) || ErrorType.STATUS_TIMEOUT.getCode().equals(resultJson.getString("errcode")) || "6999".equals(resultJson.getString("errcode"))) {
                    downLog.set("download_errcode", (Object)"5");
                    this.setDescription(downLog, resultJson);
                } else {
                    downLog.set("gov_status", (Object)"7");
                    downLog.set("download_errcode", (Object)"7");
                    this.setDescription(downLog, resultJson);
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{downLog});
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4e0b\u8f7d\u521d\u59cb\u5316\u53d1\u7968\u6570\u636e\u5931\u8d25" + taxNo, (Throwable)e);
            this.setDescription(downLog, e.getMessage());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{downLog});
            return ResultContant.createJSONObject(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u4e0b\u8f7d\u521d\u59cb\u5316\u53d1\u7968\u6570\u636e\u5931\u8d25", (String)"LqInputInvoiceInitDownServiceImpl_2", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        return resultJson;
    }

    private void downSurplusInvoice(DynamicObject syncLog, JSONObject paramJson, int page, Long orgId) {
        if (page <= 1) {
            return;
        }
        JSONObject result = null;
        for (int currentPage = 2; currentPage <= page; ++currentPage) {
            paramJson.put("packageno", (Object)currentPage);
            result = this.downLoadInvoices(paramJson, orgId);
            if (!ResultContant.isSuccess(result).booleanValue()) continue;
            JSONObject data = result.getJSONObject("data");
            this.insertInputOutDataSyncLog(syncLog, data, "1");
        }
    }

    @Override
    public void insertInputOutDataSyncLog(DynamicObject downLog, JSONObject dataJson, String downDataType) {
        String sjl = dataJson.getString("sjl");
        String dataResult = "";
        try {
            dataResult = CompressHelper.decodeBase64AndGZip((String)sjl);
        }
        catch (Exception exception) {
            // empty catch block
        }
        LOGGER.info("\u89e3\u5bc6\u6570\u636e\u6d41\uff1a{}", (Object)dataResult);
        String batchNo = downLog.getString("batch_no");
        JSONArray dataArray = null;
        if (!StringUtils.isNotEmpty((String)dataResult)) {
            LOGGER.info("{}-{}\u89e3\u6790\u6570\u636e\u6d41\u5931\u8d25", (Object)batchNo, downLog.get("taskno"));
            return;
        }
        dataArray = JSONArray.parseArray((String)dataResult);
        Long orgId = DynamicObjectUtil.getDynamicObjectLongValue(downLog.get("org"));
        Long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue(downLog.get("invoice_type"));
        int totalNum = downLog.getInt("total_num");
        if (!CollectionUtils.isEmpty((Collection)dataArray)) {
            dataArray = this.convertInvoiceList(dataArray, invoiceType);
            totalNum += dataArray.size();
            this.insertSyncInputOutDataAccount(dataArray, batchNo, "2", "1", orgId, downDataType);
        }
        downLog.set("total_num", (Object)totalNum);
    }

    private JSONArray convertInvoiceList(JSONArray dataArray, Long invoiceType) {
        JSONArray invoiceList = new JSONArray();
        JSONObject invoice = null;
        JSONObject newJson = null;
        for (int i = 0; i < dataArray.size(); ++i) {
            String fplx;
            invoice = dataArray.getJSONObject(i);
            String invoiceTypeAws = "";
            invoiceTypeAws = InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceType) ? InputInvoiceTypeEnum.HGJKS.getAwsType() : (InputInvoiceTypeEnum.WITHHOLDING.getCode().equals(invoiceType) ? InputInvoiceTypeEnum.WITHHOLDING.getAwsType() : (InvoiceDownloadConstant.isElectricPaper(fplx = invoice.getString("fplx")) ? fplx : InputInvoiceTypeEnum.getAwsTypeByLqType(fplx)));
            if (!StringUtils.isNotEmpty((String)invoiceTypeAws)) continue;
            newJson = LqConvertUtil.convertInvoiceMainInfo(invoice, invoiceTypeAws);
            newJson.put("authenticateFlag", (Object)"0");
            newJson.put("downResource", (Object)"inputInit");
            invoiceList.add((Object)newJson);
        }
        return invoiceList;
    }

    @Override
    public JSONObject downLoadInvoices(JSONObject bodyParam, Long orgId) {
        return LqConvertUtil.invokeService(bodyParam, "DeductApiService");
    }
}

