/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.download.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.download.InputOutInvoiceApplyService;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.LqConvertUtil;

public class LqInputOutInvoiceApplyServiceImpl
extends InputOutInvoiceApplyService {
    private static final Log LOGGER = LogFactory.getLog(LqInputOutInvoiceApplyServiceImpl.class);

    @Override
    public JSONObject applyInputOutDownInvoice(Long logId, DynamicObject initDynamicObject, String invoiceType, String dataType, Long orgId, String taxNo, Date begin, Date end) {
        JSONObject dataInfo;
        JSONObject result;
        JSONObject param = new JSONObject();
        LOGGER.info("applyInputOutDownInvoice invoiceType:{}", (Object)invoiceType);
        Long type = InvoiceDownloadConstant.getInvoiceTypeByAwsType(invoiceType);
        param.put("nsrsbh", (Object)taxNo);
        if (InputInvoiceTypeEnum.HGJKS.getCode().equals(type)) {
            param.put("tfrqq", (Object)DateUtils.format(begin, "yyyyMMdd"));
            param.put("tfrqz", (Object)DateUtils.format(end, "yyyyMMdd"));
            param.put("api_type", (Object)"PLHGJKSXZSQ");
        } else if (InputInvoiceTypeEnum.WITHHOLDING.getCode().equals(type)) {
            param.put("kjywrsbh", (Object)taxNo);
            param.put("tfrqq", (Object)DateUtils.format(begin, "yyyyMMdd"));
            param.put("tfrqz", (Object)DateUtils.format(end, "yyyyMMdd"));
            param.put("api_type", (Object)"PLZZSDKDJWSPZXZSQ");
        } else {
            String lqType = InvoiceDownloadConstant.getLqTypeByAwsType(invoiceType);
            param.put("kprqq", (Object)DateUtils.format(begin, "yyyyMMdd"));
            param.put("kprqz", (Object)DateUtils.format(end, "yyyyMMdd"));
            param.put("fplx", (Object)lqType);
            param.put("sjlx", (Object)dataType);
            param.put("api_type", (Object)"PLFPXZSQ");
        }
        try {
            result = LqConvertUtil.invokeService(param);
        }
        catch (MsgException e1) {
            result = ResultContant.createJSONObject(e1.getErrorCode(), e1.getErrorMsg());
            LOGGER.info("\u4e50\u4f01\u8fdb\u9500\u9879\u7533\u8bf7\u5931\u8d25:{},{}", (Object)taxNo, (Object)result);
        }
        catch (Exception e2) {
            result = ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u8fdb\u9500\u9879\u7533\u8bf7\u5931\u8d25", (String)"LqInputOutInvoiceApplyServiceImpl_0", (String)"imc-rim-common", (Object[])new Object[0]));
            LOGGER.error("\u4e50\u4f01\u8fdb\u9500\u9879\u7533\u8bf7\u5931\u8d25:" + taxNo, (Throwable)e2);
        }
        LOGGER.info("\u4e50\u4f01\u8fdb\u9500\u9879\u7533\u8bf7\u7ed3\u679c:{},{}", (Object)taxNo, (Object)result);
        if (ResultContant.isSuccess(result).booleanValue() && (dataInfo = result.getJSONObject("data")) != null) {
            String lsh = CommonUtils.getJsonValue((Map<String, Object>)dataInfo, String.class, "lsh", "pclsh");
            if (StringUtils.isEmpty((CharSequence)lsh)) {
                LOGGER.info("\u4e50\u4f01\u8fdb\u9500\u9879\u7533\u8bf7\u5931\u8d25:{},{}", (Object)taxNo, (Object)"\u6d41\u6c34\u53f7\u4e3a\u7a7a!");
                result = ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u8fdb\u9500\u9879\u7533\u8bf7\u5931\u8d25", (String)"LqInputOutInvoiceApplyServiceImpl_0", (String)"imc-rim-common", (Object[])new Object[0]));
                return result;
            }
            result = this.convertApplyResult(lsh, dataType, InputInvoiceTypeEnum.getAwsType(type), begin, end);
            this.dealResult(result, initDynamicObject, logId, orgId, taxNo, invoiceType, null);
        }
        return result;
    }
}

