/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.download.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.download.InvoiceDownService;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.LockUtils;

public class NewEtaxDownServiceImpl
extends InvoiceDownService {
    private static Log LOGGER = LogFactory.getLog(NewEtaxDownServiceImpl.class);

    public NewEtaxDownServiceImpl() {
        this.dkType = "4";
    }

    @Override
    public JSONObject invoiceDown(DynamicObject downLog, RequestContext requestContext, Long orgId, String taxNo) {
        JSONObject resultJson;
        block30: {
            LOGGER.info("\u5f00\u59cb\u4e0b\u8f7dRPA\u53d1\u7968\u6216\u8005\u6587\u4ef6{}-{}", (Object)taxNo, downLog.get("batch_no"));
            if (orgId == 0L) {
                orgId = requestContext.getOrgId();
            }
            if (this.checkOffFlag(this.dkType, taxNo)) {
                return ResultContant.createJSONObject(ErrorType.NEED_LOGIN.getCode(), ResManager.loadKDString((String)"\u4e0b\u8f7d\u5df2\u914d\u7f6e\u5173\u95ed,\u8bf7\u91cd\u65b0\u914d\u7f6e", (String)"NewEtaxDownServiceImpl_0", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            int applyStep = downLog.getInt("apply_step");
            JSONObject param = new JSONObject();
            param.put("taxNo", (Object)taxNo);
            param.put("batchNo", (Object)downLog.getString("taskno"));
            int pageSize = InvoiceDownloadConstant.getPageSizeFromConfig(500, "all_e_inout_down_pagesize");
            param.put("currentPage", (Object)1);
            if (applyStep > 0) {
                param.put("currentPage", (Object)applyStep);
            }
            param.put("pageSize", (Object)pageSize);
            String inout = downLog.getString("inout");
            resultJson = null;
            String preGovStatus = downLog.getString("gov_status");
            String key = this.getLockKey(downLog.get("id"));
            try (DLock lock = LockUtils.createDLockByMd5(key, "NewEtaxDownServiceImpl.Lock");){
                if (lock.tryLock()) {
                    try {
                        resultJson = this.downLoadInvoices(param, orgId);
                        if (resultJson != null && ResultContant.isSuccess(resultJson).booleanValue()) {
                            if (applyStep < 2) {
                                downLog.set("total_num", (Object)0);
                            }
                            int totalPage = resultJson.getIntValue("totalPage");
                            downLog.set("gov_status", (Object)"8");
                            downLog.set("download_errcode", (Object)"3");
                            if (!CollectionUtils.isEmpty((Collection)resultJson.getJSONArray("data"))) {
                                this.insertInputOutDataToTmp(downLog, resultJson, inout, 0, "7", "4");
                                boolean downSurplusInvoice = this.downSurplusInvoice(downLog, param, param.getIntValue("currentPage") + 1, totalPage, orgId, inout);
                                if (downSurplusInvoice) {
                                    downLog.set("apply_step", (Object)1);
                                    this.setDescription(downLog, "");
                                } else {
                                    downLog.set("gov_status", (Object)"6");
                                }
                            } else {
                                downLog.set("gov_status", (Object)"9");
                                downLog.set("download_errcode", (Object)"4");
                                this.setDescription(downLog, "");
                            }
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{downLog});
                        } else if (resultJson != null) {
                            this.setDescription(downLog, resultJson);
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{downLog});
                        }
                        break block30;
                    }
                    catch (Exception e) {
                        LOGGER.error(downLog.get("batch_no") + "\u4e0b\u8f7d\u5931\u8d25", (Throwable)e);
                        if (e instanceof MsgException) {
                            resultJson = ResultContant.createJSONObject(((MsgException)e).getErrorCode(), ((MsgException)e).getErrorMsg());
                        } else if (e instanceof KDException) {
                            KDException kdException = (KDException)e;
                            resultJson = ResultContant.createJSONObject(kdException.getErrorCode().getCode(), kdException.getErrorCode().getMessage());
                        } else {
                            resultJson = ResultContant.createJSONObject(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u4e0b\u8f7d\u5931\u8d25", (String)"NewEtaxDownServiceImpl_1", (String)"imc-rim-common", (Object[])new Object[0]));
                        }
                        this.setDescription(downLog, e.getMessage());
                        downLog.set("gov_status", (Object)preGovStatus);
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{downLog});
                    }
                    break block30;
                }
                resultJson = ResultContant.createJSONObject(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u8be5\u6279\u6b21\u6b63\u5728\u5728\u4e0b\u8f7d\u4e2d,\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"NewEtaxDownServiceImpl_2", (String)"imc-rim-common", (Object[])new Object[0]));
            }
        }
        return resultJson;
    }

    public boolean downSurplusInvoice(DynamicObject downLog, JSONObject param, int startPage, int totalPage, Long orgId, String inout) {
        if (totalPage <= 1) {
            return true;
        }
        JSONObject resultJson = null;
        for (int currentPage = startPage; currentPage <= totalPage; ++currentPage) {
            param.put("currentPage", (Object)currentPage);
            resultJson = this.downLoadInvoices(param, orgId);
            if (resultJson == null || !ResultContant.isSuccess(resultJson).booleanValue()) {
                downLog.set("apply_step", (Object)currentPage);
                this.setDescription(downLog, resultJson);
                return false;
            }
            int totalNum = downLog.getInt("total_num");
            this.insertInputOutDataToTmp(downLog, resultJson, inout, totalNum, "7", "4");
        }
        return true;
    }
}

