/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.download.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.helper.ImcSaveServiceHelper;
import kd.imc.rim.common.invoice.deduction.DeductService;
import kd.imc.rim.common.invoice.deduction.impl.NewEtaxDeductService;
import kd.imc.rim.common.invoice.download.InvoiceDownService;
import kd.imc.rim.common.invoice.download.impl.NewEtaxInputOutInvoiceApplyServiceImpl;
import kd.imc.rim.common.invoice.download.impl.NewEtaxTaxperiodInvoiceDownServiceImpl;
import kd.imc.rim.common.invoice.model.ConvertFieldUtil;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.LockUtils;

public class NewEtaxInOutInvoiceDownServiceImpl
extends InvoiceDownService {
    private static Log LOGGER = LogFactory.getLog(NewEtaxInOutInvoiceDownServiceImpl.class);

    public NewEtaxInOutInvoiceDownServiceImpl(boolean login) {
        this.login = login;
        this.dkType = "4";
    }

    @Override
    public JSONObject invoiceDown(DynamicObject downLog, RequestContext requestContext, Long orgId, String taxNo) {
        JSONObject resultJson;
        block31: {
            LOGGER.info("\u5f00\u59cb\u4e0b\u8f7d\u8fdb\u9500\u9879\u53d1\u7968{}-{}", (Object)taxNo, downLog.get("batch_no"));
            Long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue(downLog.get("invoice_type"));
            if (orgId == 0L) {
                orgId = requestContext.getOrgId();
            }
            if (this.checkOffFlag(this.dkType, taxNo)) {
                return ResultContant.createJSONObject(ErrorType.NEED_LOGIN.getCode(), ResManager.loadKDString((String)"\u4e0b\u8f7d\u5df2\u914d\u7f6e\u5173\u95ed,\u8bf7\u91cd\u65b0\u914d\u7f6e", (String)"NewEtaxInOutInvoiceDownServiceImpl_0", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            String taskNo = downLog.getString("taskno");
            Date startDate = downLog.getDate("invoice_startdate");
            Date endDate = downLog.getDate("invoice_enddate");
            String inout = downLog.getString("inout");
            String syncType = downLog.getString("sync_type");
            int applyStep = downLog.getInt("apply_step");
            JSONObject param = new JSONObject();
            param.put("taxNo", (Object)taxNo);
            param.put("batchNo", (Object)taskNo);
            String awsType = InputInvoiceTypeEnum.getAwsType(invoiceType);
            String startTime = DateUtils.format(startDate);
            String endTime = DateUtils.format(endDate);
            int pageSize = InvoiceDownloadConstant.getPageSizeFromConfig(500, "all_etax_inout_down_pagesize");
            param.put("currentPage", (Object)1);
            if (applyStep > 0) {
                param.put("currentPage", (Object)applyStep);
            }
            param.put("pageSize", (Object)pageSize);
            String key = this.getLockKey(downLog.get("id"));
            resultJson = ResultContant.createSuccessJSONObject();
            String preGovStatus = downLog.getString("gov_status");
            try (DLock lock = LockUtils.createDLockByMd5(key, "NewEtaxInOutInvoiceDownServiceImpl.lock");){
                if (lock.tryLock()) {
                    block30: {
                        if (!StringUtils.isEmpty((CharSequence)taskNo) && !taskNo.startsWith(taxNo)) break block30;
                        this.handleOldTask(downLog, inout, awsType, orgId, taxNo);
                        JSONObject jSONObject = ResultContant.createJSONObject(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u65e7\u4efb\u52a1\u53f7\uff0c\u91cd\u65b0\u7533\u8bf7\u4e2d", (String)"NewEtaxInOutInvoiceDownServiceImpl_4", (String)"imc-rim-common", (Object[])new Object[0]));
                        return jSONObject;
                    }
                    try {
                        resultJson = this.downLoadInvoices(param, orgId);
                        if (resultJson != null && ResultContant.isSuccess(resultJson).booleanValue()) {
                            boolean isCanDeduction;
                            int totalElement;
                            if (applyStep < 2) {
                                downLog.set("total_num", (Object)0);
                            }
                            int totalPages = (totalElement = resultJson.getIntValue("totalElement")) % pageSize == 0 ? totalElement / pageSize : totalElement / pageSize + 1;
                            LOGGER.info("taskNo:{},totalElement:{},totalPages:{},pageSize:{}", new Object[]{taskNo, totalElement, totalPages, pageSize});
                            downLog.set("gov_status", (Object)"8");
                            downLog.set("download_errcode", (Object)"3");
                            boolean bl = isCanDeduction = "1".equals(inout) && InputInvoiceTypeEnum.canDeduction(invoiceType) != false;
                            if (!CollectionUtils.isEmpty((Collection)resultJson.getJSONArray("data"))) {
                                this.applyInputTable(requestContext, orgId, taxNo, startDate, endDate, isCanDeduction, syncType);
                                this.addExtInfoAndSave(downLog, resultJson, inout);
                                boolean downSurplusInvoice = this.downSurplusInvoice(downLog, param, param.getIntValue("currentPage") + 1, totalPages, orgId, inout);
                                if (applyStep == 1) {
                                    this.applyTaxperiod(requestContext, orgId, taxNo, invoiceType, startDate, syncType, isCanDeduction);
                                }
                                this.applyInvoiceFile(downLog, inout, taxNo, orgId);
                                if (downSurplusInvoice) {
                                    this.setDescription(downLog, "");
                                    downLog.set("apply_step", (Object)1);
                                } else {
                                    downLog.set("gov_status", (Object)"6");
                                }
                            } else {
                                downLog.set("gov_status", (Object)"9");
                                downLog.set("download_errcode", (Object)"4");
                                this.setDescription(downLog, "");
                                if (applyStep == 1) {
                                    this.applyTaxperiod(requestContext, orgId, taxNo, invoiceType, startDate, syncType, isCanDeduction);
                                }
                            }
                            this.setDescription(downLog, "");
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{downLog});
                            break block31;
                        }
                        this.saveFailStatus(downLog, resultJson);
                    }
                    catch (Exception e) {
                        LOGGER.error(downLog.get("batch_no") + "\u4e0b\u8f7d\u5931\u8d25", (Throwable)e);
                        resultJson = this.saveFailByException(downLog, preGovStatus, e);
                    }
                    break block31;
                }
                resultJson = ResultContant.createJSONObject(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u8be5\u6279\u6b21\u6b63\u5728\u5728\u4e0b\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"NewEtaxInOutInvoiceDownServiceImpl_2", (String)"imc-rim-common", (Object[])new Object[0]));
            }
        }
        return resultJson;
    }

    public JSONObject saveFailByException(DynamicObject downLog, String preGovStatus, Exception e) {
        JSONObject resultJson;
        if (e instanceof MsgException) {
            resultJson = ResultContant.createJSONObject(((MsgException)e).getErrorCode(), ((MsgException)e).getErrorMsg());
        } else if (e instanceof KDException) {
            KDException kdException = (KDException)e;
            resultJson = ResultContant.createJSONObject(kdException.getErrorCode().getCode(), kdException.getErrorCode().getMessage());
        } else {
            resultJson = ResultContant.createJSONObject(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u4e0b\u8f7d\u5931\u8d25", (String)"NewEtaxInOutInvoiceDownServiceImpl_1", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        this.setDescription(downLog, e.getMessage());
        downLog.set("gov_status", (Object)preGovStatus);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{downLog});
        return resultJson;
    }

    protected void addExtInfoAndSave(DynamicObject downLog, JSONObject resultJson, String inout) {
        int totalNum = downLog.getInt("total_num");
        JSONArray data = resultJson.getJSONArray("data");
        this.addTypeAndDiscountType(data);
        this.insertInputOutDataToTmp(downLog, resultJson, inout, totalNum);
    }

    private boolean downSurplusInvoice(DynamicObject downLog, JSONObject paramJson, int startPage, int totalPage, Long orgId, String inout) {
        if (totalPage <= 1) {
            return true;
        }
        JSONObject resultJson = null;
        for (int currentPage = startPage; currentPage <= totalPage; ++currentPage) {
            paramJson.put("currentPage", (Object)currentPage);
            resultJson = this.downLoadInvoices(paramJson, orgId);
            if (resultJson != null && ResultContant.isSuccess(resultJson).booleanValue()) {
                if (CollectionUtils.isEmpty((Collection)resultJson.getJSONArray("data"))) continue;
                this.addExtInfoAndSave(downLog, resultJson, inout);
                continue;
            }
            downLog.set("apply_step", (Object)currentPage);
            this.setDescription(downLog, resultJson);
            return false;
        }
        return true;
    }

    protected void addTypeAndDiscountType(JSONArray fullInvoices) {
        for (int i = 0; i < fullInvoices.size(); ++i) {
            JSONArray items;
            JSONObject invoiceJson = fullInvoices.getJSONObject(i);
            invoiceJson.remove((Object)"checkFlag");
            invoiceJson.remove((Object)"authenticateFlag");
            invoiceJson.remove((Object)"checkAuthenticateFlag");
            invoiceJson.remove((Object)"scanAuthenticateFlag");
            String type = invoiceJson.getString("type");
            if (StringUtils.isEmpty((CharSequence)type)) {
                BigDecimal totalAmount = invoiceJson.getBigDecimal("totalAmount");
                type = "0";
                if (totalAmount != null && totalAmount.compareTo(BigDecimal.ZERO) < 0) {
                    type = "1";
                }
                invoiceJson.put("type", (Object)type);
            }
            if (CollectionUtils.isEmpty((Collection)(items = invoiceJson.getJSONArray("items")))) continue;
            ConvertFieldUtil.setDisCountType(items, type);
        }
    }

    protected JSONObject getDeductInfo(Long orgId, String taxNo, String awsType, String startTime, String endTime) {
        JSONObject bodyJson = new JSONObject();
        bodyJson.put("taxNo", (Object)taxNo);
        bodyJson.put("synccondition", (Object)"");
        bodyJson.put("currentOrgId", (Object)0);
        bodyJson.put("jksbz", (Object)1);
        bodyJson.put("synctype", (Object)"04");
        JSONObject searchOpt = new JSONObject();
        searchOpt.put("startTime", (Object)startTime);
        searchOpt.put("endTime", (Object)endTime);
        searchOpt.put("authenticateFlags", (Object)"");
        searchOpt.put("invoiceType", (Object)awsType);
        searchOpt.put("salerTaxNo", (Object)"");
        searchOpt.put("invoiceNo", (Object)"");
        searchOpt.put("invoiceCode", (Object)"");
        bodyJson.put("searchOpt", (Object)searchOpt);
        NewEtaxDeductService deductService = new NewEtaxDeductService(orgId);
        return ((DeductService)deductService).queryInvoices(bodyJson);
    }

    private void handleOldTask(DynamicObject downLog, String inout, String invoiceType, Long orgId, String taxNo) {
        NewEtaxInputOutInvoiceApplyServiceImpl applyService = new NewEtaxInputOutInvoiceApplyServiceImpl();
        applyService.applyInputOutDownInvoice(downLog.getLong("id"), null, invoiceType, inout, orgId, taxNo, downLog.getDate("invoice_startdate"), downLog.getDate("invoice_enddate"));
    }

    protected void applyTaxperiod(RequestContext requestContext, Long orgId, String taxNo, Long invoiceType, Date startDate, String syncType, boolean isCanDeduction) {
        if (isCanDeduction && "3".equals(syncType)) {
            NewEtaxTaxperiodInvoiceDownServiceImpl taxperiodDownService = new NewEtaxTaxperiodInvoiceDownServiceImpl();
            JSONObject taxperiodParam = new JSONObject();
            taxperiodParam.put("taxNo", (Object)taxNo);
            taxperiodParam.put("taxPeriod", (Object)DateUtils.format(startDate, "yyyyMM"));
            taxperiodDownService.downByParam(taxNo, orgId, null, requestContext, taxperiodParam);
        }
    }

    protected void applyInputTable(RequestContext requestContext, Long orgId, String taxNo, Date startDate, Date endDate, boolean isCanDeduction, String syncType) {
        if (isCanDeduction && ("2".equals(syncType) || "3".equals(syncType))) {
            NewEtaxTaxperiodInvoiceDownServiceImpl taxperiodDownService = new NewEtaxTaxperiodInvoiceDownServiceImpl();
            if (taxperiodDownService.existTask(taxNo, startDate, endDate, 0L, "1")) {
                return;
            }
            DynamicObject downLog = taxperiodDownService.getDownLogDynamicObject(this.getDownBatchNo(), null, orgId, taxNo, 0, "1");
            downLog.set("invoice_startdate", (Object)startDate);
            downLog.set("invoice_enddate", (Object)endDate);
            downLog.set("gov_status", (Object)"6");
            ImcSaveServiceHelper.save(downLog);
        }
    }

    @Override
    public JSONObject downLoadInvoices(JSONObject bodyParam, Long orgId) {
        String taxNo = bodyParam.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject("0201", ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u5f53\u524d\u4f01\u4e1a\u7a0e\u53f7\u8f6f\u8bc1\u4e66\u914d\u7f6e\u662f\u5426\u6b63\u786e", (String)"NewEtaxInOutInvoiceDownServiceImpl_3", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        NewEtaxDeductService deductService = new NewEtaxDeductService(orgId);
        return deductService.downFullInvoice(bodyParam);
    }
}

