/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.download.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dlock.DLock;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.deduction.impl.NewEtaxDeductService;
import kd.imc.rim.common.invoice.download.InputOutInvoiceApplyService;
import kd.imc.rim.common.invoice.download.InvoiceApplyLogService;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.LockUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.UUID;
import org.apache.commons.lang3.tuple.Pair;

public class NewEtaxInputOutInvoiceApplyServiceImpl
extends InputOutInvoiceApplyService {
    private static final Log LOGGER = LogFactory.getLog(NewEtaxInputOutInvoiceApplyServiceImpl.class);

    @Override
    public void divideObject(DynamicObject initDynamicObject, Long orgId, String taxNo, List<Map<String, Date>> initDateList) {
        String lockKey = "InvoiceDownApplyLock-" + taxNo;
        try (DLock lock = LockUtils.createDLockByMd5(lockKey, "NewEtaxInputOutInvoiceApply-lock");){
            if (lock.tryLock()) {
                LOGGER.info("\u8fdb\u9500\u9879\u7533\u8bf7:{}", (Object)taxNo);
                List<String> dataTypes = CommonUtils.getMultiValues(initDynamicObject.getString("output_download"));
                List<String> invoiceTypes = CommonUtils.getMultiValues(initDynamicObject.getString("invoice_type"));
                for (String dataType : dataTypes) {
                    this.batchApplyInitHistoryData(initDynamicObject, invoiceTypes, dataType, orgId, taxNo, initDateList);
                    this.batchApplyBeforeHistoryData(initDynamicObject, invoiceTypes, dataType, orgId, taxNo);
                    this.batchApplyCurrentData(initDynamicObject, invoiceTypes, dataType, orgId, taxNo);
                    this.batchApplyTodayData(initDynamicObject, invoiceTypes, dataType, orgId, taxNo);
                }
            } else {
                LOGGER.info("InvoiceDownApplyLock-tryLock");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u8fdb\u9500\u9879\u7533\u5931\u8d25:" + taxNo, (Throwable)e);
        }
    }

    private void batchApplyBeforeHistoryData(DynamicObject initDynamicObject, List<String> invoiceTypes, String dataType, Long orgId, String taxNo) {
        Calendar cal = Calendar.getInstance();
        Date dateNow = new Date();
        String downDate = RimConfigUtils.getConfig("down_date");
        if (StringUtil.isNotEmpty((CharSequence)downDate)) {
            dateNow = DateUtils.stringToDate(downDate);
        }
        cal.setTime(dateNow);
        Date firstDay = DateUtils.getFirstDateOfMonth(dateNow);
        int day = cal.get(5);
        Date startDate = null;
        Date endDate = null;
        int outputApplyDate = InvoiceDownloadConstant.getPageSizeFromConfig(2, "new_output_apply_date");
        int inputApplyDate = InvoiceDownloadConstant.getPageSizeFromConfig(6, "new_input_apply_date");
        int before2MonthApplyDate = InvoiceDownloadConstant.getPageSizeFromConfig(12, "before2_month_apply_date");
        int tryDays = InvoiceDownloadConstant.getPageSizeFromConfig(3, "try_apply_days");
        String appointDaysStr = RimConfigUtils.getConfig("rim_deduction", "appoint_days");
        List<String> appointDays = CommonUtils.getMultiValues(appointDaysStr);
        ArrayList<JSONObject> applyList = new ArrayList<JSONObject>(invoiceTypes.size());
        for (String invoiceType : invoiceTypes) {
            Date behind2Month;
            JSONObject applyJson;
            Date behindMonth;
            Pair<Boolean, Long> applyHistoryPair;
            if (!this.checkDownCustom(dataType, invoiceType, taxNo)) continue;
            if ("2".equals(dataType) && this.checkDays(day, outputApplyDate, tryDays, appointDays) && ((Boolean)(applyHistoryPair = this.isApplyHistory(initDynamicObject, invoiceType, dataType, taxNo, startDate = DateUtils.getFirstDateOfMonth(behindMonth = DateUtils.addMonth(firstDay, -1)), endDate = DateUtils.getLastDateOfMonthZero(behindMonth))).getLeft()).booleanValue()) {
                applyJson = this.newApplyParam(dataType, invoiceType, startDate, endDate);
                applyJson.put("logId", applyHistoryPair.getRight());
                applyList.add(applyJson);
            }
            if ("1".equals(dataType) && this.checkDays(day, inputApplyDate, tryDays, appointDays) && ((Boolean)(applyHistoryPair = this.isApplyHistory(initDynamicObject, invoiceType, dataType, taxNo, startDate = DateUtils.getFirstDateOfMonth(behindMonth = DateUtils.addMonth(firstDay, -1)), endDate = DateUtils.getLastDateOfMonthZero(behindMonth))).getLeft()).booleanValue()) {
                applyJson = this.newApplyParam(dataType, invoiceType, startDate, endDate);
                applyJson.put("logId", applyHistoryPair.getRight());
                applyList.add(applyJson);
            }
            if (!this.checkDays(day, before2MonthApplyDate, tryDays, appointDays) || !((Boolean)(applyHistoryPair = this.isApplyHistory(initDynamicObject, invoiceType, dataType, taxNo, startDate = DateUtils.getFirstDateOfMonth(behind2Month = DateUtils.addMonth(firstDay, -2)), endDate = DateUtils.getLastDateOfMonthZero(behind2Month))).getLeft()).booleanValue()) continue;
            applyJson = this.newApplyParam(dataType, invoiceType, startDate, endDate);
            applyJson.put("logId", applyHistoryPair.getRight());
            applyList.add(applyJson);
        }
        if (CollectionUtils.isEmpty(applyList)) {
            return;
        }
        Map<String, List<JSONObject>> groupMap = applyList.stream().collect(Collectors.groupingBy(s -> s.getString("startTime") + s.getString("endTime")));
        for (Map.Entry<String, List<JSONObject>> entry : groupMap.entrySet()) {
            this.batchApply(entry.getValue(), initDynamicObject, orgId, taxNo);
        }
    }

    private void batchApplyInitHistoryData(DynamicObject initDynamicObject, List<String> invoiceTypes, String dataType, Long orgId, String taxNo, List<Map<String, Date>> initDateList) {
        if (CollectionUtils.isEmpty(initDateList)) {
            return;
        }
        InvoiceApplyLogService service = new InvoiceApplyLogService();
        for (Map<String, Date> stringDateMap : initDateList) {
            Date begin = stringDateMap.get("begin");
            Date end = stringDateMap.get("end");
            ArrayList<JSONObject> applyList = new ArrayList<JSONObject>(invoiceTypes.size());
            for (String invoiceType : invoiceTypes) {
                if (!this.checkDownCustom(dataType, invoiceType, taxNo)) continue;
                LOGGER.info("\u5f00\u59cb\u7533\u8bf7\u5386\u53f2\u53d1\u7968,{};invoiceType:{};downType:{};{}-{}", new Object[]{taxNo, invoiceType, dataType, DateUtils.format(begin), DateUtils.format(end)});
                String asyncFlag = RimConfigUtils.getConfig("rim_deduction", "init_down_async");
                if (!"0".equals(asyncFlag)) {
                    service.saveInitApplyLog(orgId, taxNo, dataType, invoiceType, initDateList);
                    continue;
                }
                Pair<Boolean, Long> applyHistoryPair = this.isApplyHistory(initDynamicObject, invoiceType, dataType, taxNo, begin, end);
                if (!((Boolean)applyHistoryPair.getLeft()).booleanValue()) continue;
                JSONObject applyJson = this.newApplyParam(dataType, invoiceType, begin, end);
                applyJson.put("logId", applyHistoryPair.getRight());
                applyList.add(applyJson);
            }
            this.batchApply(applyList, initDynamicObject, orgId, taxNo);
        }
    }

    public void batchApplyTodayData(DynamicObject initDynamicObject, List<String> invoiceTypes, String dataType, Long orgId, String taxNo) {
        String asyncFlag = RimConfigUtils.getConfig("rim_deduction", "down_today");
        if ("1".equals(asyncFlag)) {
            Date startDate;
            Date endDate = startDate = DateUtils.trunc(new Date());
            ArrayList<JSONObject> applyList = new ArrayList<JSONObject>(invoiceTypes.size());
            QFilter startFilter = new QFilter("invoice_startdate", ">=", (Object)startDate);
            QFilter endFilter = new QFilter("invoice_enddate", "<=", (Object)endDate);
            QFilter syncTypeFilter = new QFilter("sync_type", "=", (Object)"7");
            QFilter taxNoFilter = new QFilter("tax_no", "=", (Object)taxNo);
            QFilter dataTypeFilter = new QFilter("inout", "=", (Object)dataType);
            QFilter statusFilter = new QFilter("gov_status", "=", (Object)"6");
            DeleteServiceHelper.delete((String)"rim_down_log", (QFilter[])new QFilter[]{taxNoFilter, syncTypeFilter, dataTypeFilter, startFilter, endFilter, statusFilter});
            for (String invoiceType : invoiceTypes) {
                if (!this.checkDownCustom(dataType, invoiceType, taxNo)) continue;
                JSONObject applyJson = this.newApplyParam(dataType, invoiceType, startDate, endDate);
                applyJson.put("syncType", (Object)"7");
                applyList.add(applyJson);
            }
            if (CollectionUtils.isEmpty(applyList)) {
                return;
            }
            Map<String, List<JSONObject>> groupMap = applyList.stream().collect(Collectors.groupingBy(s -> s.getString("startTime") + s.getString("endTime")));
            for (Map.Entry<String, List<JSONObject>> entry : groupMap.entrySet()) {
                this.batchApply(entry.getValue(), initDynamicObject, orgId, taxNo);
            }
        }
    }

    public void batchApplyCurrentData(DynamicObject initDynamicObject, List<String> invoiceTypes, String dataType, Long orgId, String taxNo) {
        Date startDay;
        ArrayList<JSONObject> applyList = new ArrayList<JSONObject>(invoiceTypes.size());
        int days = InvoiceDownloadConstant.getPageSizeFromConfig(3, "newetax_inputout_days");
        if (days < 1) {
            days = 3;
        }
        Calendar cal = Calendar.getInstance();
        Date dateNow = new Date();
        String downDate = RimConfigUtils.getConfig("down_date");
        if (StringUtil.isNotEmpty((CharSequence)downDate)) {
            dateNow = DateUtils.stringToDate(downDate);
        }
        cal.setTime(dateNow);
        Date lastDate = DateUtils.getLastDateOfMonthZero(dateNow);
        String lastDateApply = RimConfigUtils.getConfig("rim_deduction", "rpa_last_date_apply");
        boolean isLastDate = "1".equals(lastDateApply) && DateUtils.format(lastDate).equals(DateUtils.format(dateNow));
        int day = cal.get(5);
        if (days > 1 && day % days != 0 && day != 1 && !isLastDate) {
            return;
        }
        if (days > 31) {
            return;
        }
        Date endDate = DateUtils.trunc(dateNow);
        endDate = DateUtils.addDay(endDate, -1);
        Date firstMonthDate = DateUtils.getFirstDateOfMonth(endDate);
        int repeatDays = InvoiceDownloadConstant.getPageSizeFromConfig(3, "newetax_repeat_days");
        if (repeatDays < 0) {
            repeatDays = 2;
        }
        if (isLastDate) {
            startDay = firstMonthDate;
            endDate = lastDate;
        }
        for (String invoiceType : invoiceTypes) {
            JSONObject applyJson;
            if (!this.checkDownCustom(dataType, invoiceType, taxNo)) continue;
            Pair<DynamicObject, Integer> logDynamicObjectPair = this.getLogDynamicObject(taxNo, invoiceType, dataType, "2", firstMonthDate, endDate);
            DynamicObject logDynamicObject = (DynamicObject)logDynamicObjectPair.getLeft();
            if (logDynamicObject == null) {
                applyJson = this.newApplyParam(dataType, invoiceType, firstMonthDate, endDate);
                applyList.add(applyJson);
                continue;
            }
            Date lastEndDate = logDynamicObject.getDate("invoice_enddate");
            String govStatus = logDynamicObject.getString("gov_status");
            if (!lastEndDate.before(endDate)) continue;
            startDay = "7".equals(govStatus) ? logDynamicObject.getDate("invoice_startdate") : DateUtils.addDay(lastEndDate, 1 - repeatDays);
            if (startDay.before(firstMonthDate) || isLastDate) {
                startDay = firstMonthDate;
            }
            applyJson = this.newApplyParam(dataType, invoiceType, startDay, endDate);
            if ("7".equals(govStatus)) {
                applyJson.put("logId", (Object)logDynamicObject.getLong("id"));
            }
            applyList.add(applyJson);
        }
        if (CollectionUtils.isEmpty(applyList)) {
            return;
        }
        Map<String, List<JSONObject>> groupMap = applyList.stream().collect(Collectors.groupingBy(s -> s.getString("startTime") + s.getString("endTime")));
        for (Map.Entry<String, List<JSONObject>> entry : groupMap.entrySet()) {
            this.batchApply(entry.getValue(), initDynamicObject, orgId, taxNo);
        }
    }

    public void batchApply(List<JSONObject> batchParams, DynamicObject initDynamicObject, Long orgId, String taxNo) {
        if (CollectionUtils.isEmpty(batchParams)) {
            return;
        }
        int totalNum = batchParams.size();
        int currentNo = 1;
        String requuid = UUID.randomUUID();
        for (JSONObject applyJson : batchParams) {
            applyJson.put("currentNo", (Object)currentNo);
            applyJson.put("totalNum", (Object)totalNum);
            applyJson.put("serialNo", (Object)requuid);
            this.applyInputOutDownInvoiceNew(initDynamicObject, orgId, taxNo, applyJson);
            ++currentNo;
        }
    }

    private JSONObject newApplyParam(String dataType, String invoiceType, Date startTime, Date endTime) {
        JSONObject applyJson = new JSONObject();
        applyJson.put("account", (Object)"");
        applyJson.put("currentNo", (Object)"1");
        applyJson.put("totalNum", (Object)"1");
        applyJson.put("dataType", (Object)dataType);
        applyJson.put("invoiceType", (Object)invoiceType);
        applyJson.put("startTime", (Object)DateUtils.format(startTime));
        applyJson.put("endTime", (Object)DateUtils.format(endTime));
        return applyJson;
    }

    protected JSONObject applyInputOutDownInvoiceNew(DynamicObject initDynamicObject, Long orgId, String taxNo, JSONObject param) {
        JSONObject data;
        JSONObject result;
        NewEtaxDeductService deductService = new NewEtaxDeductService(orgId);
        param.put("taxNo", (Object)taxNo);
        if (InvoiceDownloadConstant.isAsyncDown(taxNo)) {
            result = deductService.applyFullInvoice(param);
        } else {
            data = new JSONObject();
            data.put("batchNo", (Object)UUID.getBatchNoByTaxNo(taxNo));
            result = ResultContant.createSuccessJSONObject(data);
        }
        if (result != null && ResultContant.isSuccess(result).booleanValue()) {
            data = result.getJSONObject("data");
            String rwh = data.getString("batchNo");
            Date startTime = Optional.ofNullable(param.getDate("startTime")).orElseGet(() -> DateUtils.stringToDate(param.getString("startTaxPeriod"), "yyyyMM"));
            Date endTime = Optional.ofNullable(param.getDate("endTime")).orElseGet(() -> DateUtils.stringToDate(param.getString("endTaxPeriod"), "yyyyMM"));
            JSONObject resultJson = this.convertApplyResult(rwh, param.getString("dataType"), param.getString("invoiceType"), startTime, endTime, param.getString("serialNo"));
            this.dealResult(resultJson, initDynamicObject, param.getLong("logId"), orgId, taxNo, param.getString("invoiceType"), param.getString("syncType"));
            result.put("batchNo", (Object)resultJson.getString("batchNo"));
        }
        return result;
    }

    @Override
    public JSONObject applyInputOutDownInvoice(Long logId, DynamicObject initDynamicObject, String invoiceType, String dataType, Long orgId, String taxNo, Date begin, Date end) {
        JSONObject applyJson = this.newApplyParam(dataType, invoiceType, begin, end);
        applyJson.put("logId", (Object)logId);
        applyJson.put("currentNo", (Object)1);
        applyJson.put("totalNum", (Object)1);
        applyJson.put("serialNo", (Object)UUID.randomUUID());
        return this.applyInputOutDownInvoiceNew(initDynamicObject, orgId, taxNo, applyJson);
    }

    @Override
    public boolean checkDownCustom(String inout, String invoiceType, String taxNo) {
        if (InvoiceDownloadConstant.isElectricPaper(invoiceType) || InputInvoiceTypeEnum.WITHHOLDING.getAwsType().equals(invoiceType)) {
            return false;
        }
        String downHg = RimConfigUtils.getConfig("rim_deduction", "newtax_async_down_hg");
        if (InputInvoiceTypeEnum.HGJKS.getAwsType().equals(invoiceType) && "1".equals(inout) && InvoiceDownloadConstant.isAsyncDown(taxNo)) {
            return "1".equals(downHg);
        }
        return super.checkDownCustom(inout, invoiceType, taxNo);
    }
}

