/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.download.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.deduction.DeductService;
import kd.imc.rim.common.invoice.deduction.impl.ShuipanNewDeductService;
import kd.imc.rim.common.invoice.download.impl.NewEtaxInOutInvoiceDownServiceImpl;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.LockUtils;

public class ShuipanNewInOutInvoiceDownServiceImpl
extends NewEtaxInOutInvoiceDownServiceImpl {
    private static Log LOGGER = LogFactory.getLog(ShuipanNewInOutInvoiceDownServiceImpl.class);

    public ShuipanNewInOutInvoiceDownServiceImpl(boolean login) {
        super(login);
        this.dkType = "1";
    }

    @Override
    public JSONObject invoiceDown(DynamicObject downLog, RequestContext requestContext, Long orgId, String taxNo) {
        JSONObject resultJson;
        block22: {
            LOGGER.info("\u5f00\u59cb\u4e0b\u8f7d\u8fdb\u9500\u9879\u53d1\u7968{}-{}", (Object)taxNo, downLog.get("batch_no"));
            Long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue(downLog.get("invoice_type"));
            if (orgId == 0L) {
                orgId = requestContext.getOrgId();
            }
            if (this.checkOffFlag(this.dkType, taxNo)) {
                return ResultContant.createJSONObject(ErrorType.NEED_LOGIN.getCode(), ResManager.loadKDString((String)"\u4e0b\u8f7d\u5df2\u914d\u7f6e\u5173\u95ed,\u8bf7\u91cd\u65b0\u914d\u7f6e", (String)"NewEtaxInOutInvoiceDownServiceImpl_0", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            Date startDate = downLog.getDate("invoice_startdate");
            Date endDate = downLog.getDate("invoice_enddate");
            String inout = downLog.getString("inout");
            String syncType = downLog.getString("sync_type");
            JSONObject param = new JSONObject();
            param.put("taxNo", (Object)taxNo);
            JSONObject searchOpt = new JSONObject();
            String awsType = InputInvoiceTypeEnum.getAwsType(invoiceType);
            searchOpt.put("invoiceType", (Object)awsType);
            searchOpt.put("dataType", (Object)inout);
            searchOpt.put("invoiceCode", (Object)"");
            searchOpt.put("invoiceNo", (Object)"");
            searchOpt.put("invoiceStatus", (Object)"");
            String startTime = DateUtils.format(startDate);
            String endTime = DateUtils.format(endDate);
            searchOpt.put("startTime", (Object)startTime);
            searchOpt.put("endTime", (Object)endTime);
            int pageSize = InvoiceDownloadConstant.getPageSizeFromConfig(500, "all_e_inout_down_pagesize");
            searchOpt.put("pageNo", (Object)1);
            searchOpt.put("pageSize", (Object)pageSize);
            param.put("searchOpt", (Object)searchOpt);
            String key = this.getLockKey(downLog.get("id"));
            resultJson = ResultContant.createSuccessJSONObject();
            String preGovStatus = downLog.getString("gov_status");
            try (DLock lock = LockUtils.createDLockByMd5(key, "ShuipanNewInOutInvoiceDownServiceImpl.lock");){
                if (lock.tryLock()) {
                    try {
                        resultJson = this.downLoadInvoices(param, orgId);
                        if (resultJson != null && ResultContant.isSuccess(resultJson).booleanValue()) {
                            boolean isCanDeduction;
                            downLog.set("total_num", (Object)0);
                            int totalElement = resultJson.getIntValue("totalElement");
                            int totalPages = totalElement % pageSize == 0 ? totalElement / pageSize : totalElement / pageSize + 1;
                            LOGGER.info("totalElement:{},totalPages:{},pageSize:{}", new Object[]{totalElement, totalPages, pageSize});
                            downLog.set("gov_status", (Object)"8");
                            downLog.set("download_errcode", (Object)"3");
                            boolean bl = isCanDeduction = "1".equals(inout) && InputInvoiceTypeEnum.canDeduction(invoiceType) != false;
                            if (!CollectionUtils.isEmpty((Collection)resultJson.getJSONArray("data"))) {
                                this.applyInputTable(requestContext, orgId, taxNo, startDate, endDate, isCanDeduction, syncType);
                                this.addExtInfoAndSave(downLog, resultJson, inout);
                                boolean downSurplusInvoice = this.downSurplusInvoice(downLog, param, totalPages, orgId, inout);
                                this.applyTaxperiod(requestContext, orgId, taxNo, invoiceType, startDate, syncType, isCanDeduction);
                                this.applyInvoiceFile(downLog, inout, taxNo, orgId);
                                if (downSurplusInvoice) {
                                    this.setDescription(downLog, "");
                                    downLog.set("apply_step", (Object)1);
                                } else {
                                    downLog.set("gov_status", (Object)"6");
                                }
                            } else {
                                downLog.set("gov_status", (Object)"9");
                                downLog.set("download_errcode", (Object)"4");
                                this.applyTaxperiod(requestContext, orgId, taxNo, invoiceType, startDate, syncType, isCanDeduction);
                            }
                            this.setDescription(downLog, "");
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{downLog});
                            break block22;
                        }
                        this.saveFailStatus(downLog, resultJson);
                    }
                    catch (Exception e) {
                        LOGGER.error(downLog.get("batch_no") + "\u4e0b\u8f7d\u5931\u8d25", (Throwable)e);
                        resultJson = this.saveFailByException(downLog, preGovStatus, e);
                    }
                    break block22;
                }
                resultJson = ResultContant.createJSONObject(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u8be5\u6279\u6b21\u6b63\u5728\u5728\u4e0b\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"NewEtaxInOutInvoiceDownServiceImpl_2", (String)"imc-rim-common", (Object[])new Object[0]));
            }
        }
        return resultJson;
    }

    private boolean downSurplusInvoice(DynamicObject downLog, JSONObject paramJson, int page, Long orgId, String inout) {
        if (page <= 1) {
            return true;
        }
        JSONObject resultJson = null;
        boolean flag = true;
        for (int currentPage = 2; currentPage <= page; ++currentPage) {
            JSONObject searchOpt = paramJson.getJSONObject("searchOpt");
            searchOpt.put("pageNo", (Object)currentPage);
            resultJson = this.downLoadInvoices(paramJson, orgId);
            if (resultJson != null && ResultContant.isSuccess(resultJson).booleanValue()) {
                if (CollectionUtils.isEmpty((Collection)resultJson.getJSONArray("data"))) continue;
                this.addExtInfoAndSave(downLog, resultJson, inout);
                continue;
            }
            flag = false;
        }
        return flag;
    }

    @Override
    public JSONObject downLoadInvoices(JSONObject bodyParam, Long orgId) {
        ShuipanNewDeductService deductService = new ShuipanNewDeductService(orgId);
        return ((DeductService)deductService).downFullInvoice(bodyParam);
    }
}

