/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.fpzs;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.expense.domain.ExpenseDTO;
import kd.imc.rim.common.expense.domain.ExpenseInvoiceDTO;
import kd.imc.rim.common.expense.service.ExpenseService;
import kd.imc.rim.common.invoice.collector.InvoiceHisDataSyncService;
import kd.imc.rim.common.invoice.query.AttachQueryService;
import kd.imc.rim.common.invoice.verify.VerifyUtil;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.service.InvoiceLog;
import kd.imc.rim.common.utils.AwsFpyService;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.HttpUtil;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.UUID;

public class ExpenseRelationService {
    private static Log LOGGER = LogFactory.getLog(ExpenseRelationService.class);
    private static final String mainFields = "expense_id, expense_num, create_time, status";
    private static final String statusField = "status";
    private static final String Base_Columns = "id, expense_num, expense_id, status, serial_no, create_time, entry_id";
    private static final String cover_field = "id,cover_no,cover_type,resource,cover_url,snapshot_url,create_time";
    private static final String INVOICE_INFO_CACHE = "invoice_info_cache";

    public JSONObject queryExpenseMessage(String expenseId, String resurce, String entityId, List<Object> serialList, Map<String, Object> param, String pageId) {
        JSONObject result = new JSONObject();
        result.put("errcode", (Object)"0000");
        result.put("description", (Object)ResManager.loadKDString((String)"\u6210\u529f", (String)"ExpenseRelationService_0", (String)"imc-rim-common", (Object[])new Object[0]));
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal totalTaxAmount = BigDecimal.ZERO;
        int invoiceCount = 0;
        JSONArray cover = new JSONArray();
        JSONArray electronicInvoice = new JSONArray();
        JSONArray paperInvoice = new JSONArray();
        JSONArray overSeaInvoice = new JSONArray();
        JSONArray attachment = new JSONArray();
        List serialNoList = JSON.parseArray((String)SerializationUtils.toJsonString(serialList), String.class);
        JSONArray invoices = this.queryInvoice(expenseId, resurce, entityId, serialNoList, param);
        if (!CollectionUtils.isEmpty((Collection)invoices)) {
            for (int i = 0; i < invoices.size(); ++i) {
                ++invoiceCount;
                JSONObject invoiceJson = invoices.getJSONObject(i);
                invoiceJson.put("viewIndex", (Object)StringUtils.lowerCase((String)invoiceJson.getString("serialNo")));
                if (StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("totalAmount"))) {
                    totalAmount = totalAmount.add(invoiceJson.getBigDecimal("totalAmount"));
                }
                if (StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("taxAmount"))) {
                    totalTaxAmount = totalTaxAmount.add(invoiceJson.getBigDecimal("taxAmount"));
                } else if (StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("totalTaxAmount"))) {
                    totalTaxAmount = totalTaxAmount.add(invoiceJson.getBigDecimal("totalTaxAmount"));
                }
                String invoiceType = invoiceJson.getString("invoiceType");
                Long invoice_type = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(invoiceType);
                invoiceJson.put("invoice_type", (Object)invoice_type);
                if (InputInvoiceTypeEnum.isElectricInvoice(invoice_type)) {
                    invoiceJson.put("type", (Object)"2");
                    electronicInvoice.add((Object)invoiceJson);
                    continue;
                }
                if (InputInvoiceTypeEnum.OVERSEA_INVOICE.getCode().equals(invoice_type)) {
                    invoiceJson.put("type", (Object)"3");
                    overSeaInvoice.add((Object)invoiceJson);
                    continue;
                }
                invoiceJson.put("type", (Object)"3");
                paperInvoice.add((Object)invoiceJson);
            }
        }
        cover = this.queryCover(expenseId);
        attachment = this.queryAttach(expenseId, entityId, resurce, serialList);
        result.put("totalAmount", (Object)totalAmount);
        result.put("totalTaxAmount", (Object)totalTaxAmount);
        result.put("invoiceCount", (Object)invoiceCount);
        result.put("attachmentCount", (Object)attachment.size());
        result.put("coverCount", (Object)cover.size());
        JSONObject data = new JSONObject();
        data.put("cover", (Object)cover);
        data.put("electronicInvoice", (Object)electronicInvoice);
        data.put("paperInvoice", (Object)paperInvoice);
        data.put("overSeaInvoice", (Object)overSeaInvoice);
        data.put("allInvoice", (Object)invoices);
        data.put("attachment", (Object)attachment);
        result.put("data", (Object)data);
        LOGGER.info("\u67e5\u8be2\u62a5\u9500\u5355\u8fd4\u56de:{}", (Object)result);
        return result;
    }

    public JSONArray queryCover(String expenseId) {
        JSONArray coverArray = new JSONArray();
        if (!StringUtils.isEmpty((CharSequence)expenseId)) {
            QFilter filter = new QFilter("expense_id", "=", (Object)expenseId);
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_cover_relation", (String)"cover_id", (QFilter[])new QFilter[]{filter});
            LOGGER.info("\u67e5\u8be2\u5c01\u9762\uff0c\u53c2\u6570\uff1a{}\uff0c\u8fd4\u56de\uff1a{}", (Object)filter, (Object)collection);
            if (!CollectionUtils.isEmpty((Collection)collection)) {
                List serialNoList = collection.stream().map(s -> s.getLong("cover_id")).collect(Collectors.toList());
                filter = new QFilter("id", "in", (Object)serialNoList.toArray());
                collection = QueryServiceHelper.query((String)"rim_cover", (String)cover_field, (QFilter[])new QFilter[]{filter});
                LOGGER.info("\u67e5\u8be2\u5c01\u9762\uff0c\u53c2\u6570\uff1a{}\uff0c\u8fd4\u56de\uff1a{}", (Object)filter, (Object)collection);
                JSONObject json = null;
                for (DynamicObject dynamicObject : collection) {
                    json = new JSONObject();
                    String serialNo = UUID.randomUUID();
                    json.put("serialNo", (Object)serialNo);
                    json.put("viewIndex", (Object)serialNo);
                    json.put("coverNo", (Object)this.fieldToString(dynamicObject.get("cover_no")));
                    json.put("fileType", (Object)this.fieldToString(dynamicObject.get("cover_type")));
                    json.put("resource", (Object)this.fieldToString(dynamicObject.get("resource")));
                    json.put("localUrl", (Object)this.fieldToString(dynamicObject.get("cover_url")));
                    json.put("snapshotUrl", (Object)this.fieldToString(dynamicObject.get("snapshot_url")));
                    json.put("createTime", (Object)this.fieldToString(dynamicObject.get("create_time"), "yyyy-MM-dd"));
                    json.put("type", (Object)"1");
                    json.put("coverId", (Object)this.fieldToString(dynamicObject.get("id")));
                    coverArray.add((Object)json);
                }
            }
        }
        return coverArray;
    }

    public JSONObject queryCoverAndAttach(String expenseId, String entityId, String resurce, List<Object> serialList) {
        JSONObject info = new JSONObject();
        JSONArray cover = this.queryCover(expenseId);
        if (cover == null || cover.isEmpty()) {
            cover = this.queryCover(entityId + "_" + expenseId);
        }
        JSONArray attachment = this.queryAttach(expenseId, entityId, resurce, serialList);
        JSONArray attachment2 = this.queryAttach(entityId + "_" + expenseId, entityId, resurce, serialList);
        if (!attachment2.isEmpty()) {
            attachment.addAll((Collection)attachment2);
        }
        info.put("cover", (Object)cover);
        info.put("attachment", (Object)attachment);
        return info;
    }

    private JSONArray queryAttach(String expenseId, String entityId, String resurce, List<Object> serialList) {
        AttachQueryService attachQueryService;
        JSONArray attachs;
        JSONArray attachArray = new JSONArray();
        if (!StringUtils.isEmpty((CharSequence)expenseId) && !CollectionUtils.isEmpty((Collection)(attachs = (attachQueryService = new AttachQueryService()).queryFpzsAttach(expenseId, entityId, resurce, true)))) {
            JSONObject attJson = null;
            for (int i = 0; i < attachs.size(); ++i) {
                JSONObject att = attachs.getJSONObject(i);
                attJson = new JSONObject();
                attJson.put("type", (Object)"4");
                attJson.put("relationType", (Object)1);
                if (StringUtils.isNotEmpty((CharSequence)att.getString("serialNo"))) {
                    String relationId = att.getString("serialNo");
                    attJson.put("relationType", (Object)2);
                    attJson.put("relationId", (Object)relationId);
                    if (!CollectionUtils.isEmpty(serialList) && !serialList.contains(relationId)) continue;
                }
                attJson.put("serialNo", (Object)att.getString("attachNo"));
                attJson.put("viewIndex", (Object)StringUtils.lowerCase((String)att.getString("attachNo")));
                attJson.put("fileType", (Object)att.getString("attachType"));
                attJson.put("attachName", (Object)this.fieldToString(att.getString("attachName")));
                attJson.put("localUrl", (Object)this.fieldToString(att.getString("attachUrl")));
                attJson.put("snapshotUrl", (Object)this.fieldToString(att.get((Object)"snapshotUrl")));
                if (StringUtils.isEmpty((CharSequence)attJson.getString("snapshotUrl"))) {
                    attJson.put("snapshotUrl", (Object)this.fieldToString(att.get((Object)"attachIcon")));
                }
                attJson.put("attachIcon", (Object)this.fieldToString(att.get((Object)"attachIcon")));
                Long attachCategory = DynamicObjectUtil.getDynamicObjectLongValue(att.get((Object)"attachCategory"));
                attJson.put("attachCategory", (Object)attachCategory);
                if (attachCategory > 0L) {
                    try {
                        QFilter filte = new QFilter("id", "=", (Object)attachCategory);
                        DynamicObject obj = QueryServiceHelper.queryOne((String)"bdm_attach_type", (String)"name,number", (QFilter[])new QFilter[]{filte});
                        if (obj != null) {
                            attJson.put("attachCategoryNo", (Object)obj.getString("number"));
                            attJson.put("attachCategoryName", (Object)obj.getString("name"));
                        }
                    }
                    catch (Exception filte) {
                        // empty catch block
                    }
                }
                attJson.put("remark", (Object)this.fieldToString(att.getString("remark")));
                attJson.put("originalFileName", (Object)this.fieldToString(att.getString("originalFileName")));
                attJson.put("fileExtension", (Object)this.fieldToString(att.getString("fileExtension")));
                String createTime = att.getString("createTime");
                if (StringUtils.isEmpty((CharSequence)createTime)) {
                    createTime = DateUtils.format(new Date());
                }
                attJson.put("createTime", (Object)createTime);
                attJson.put("expenseId", (Object)expenseId);
                attachArray.add((Object)attJson);
            }
        }
        return attachArray;
    }

    private JSONArray queryInvoice(String expenseId, String resource, String entityId, List<String> serialList, Map<String, Object> param) {
        DynamicObjectCollection serialCollection = null;
        Date expenseDate = DateUtils.stringToDate("1970-01-01");
        if (StringUtils.isNotEmpty((CharSequence)expenseId)) {
            QFilter filter = new QFilter("expense_id", "=", (Object)expenseId);
            QFilter filter2 = null;
            QFilter resourceFilter = null;
            QFilter entityidFilter = null;
            if (StringUtils.isNotEmpty((CharSequence)resource)) {
                resourceFilter = new QFilter("resource", "=", (Object)resource);
            }
            if (StringUtils.isNotEmpty((CharSequence)entityId)) {
                entityidFilter = new QFilter("entityid", "=", (Object)entityId);
                if (!expenseId.startsWith(entityId)) {
                    filter2 = new QFilter("expense_id", "=", (Object)(entityId + '_' + expenseId));
                }
            }
            if (CollectionUtils.isEmpty((Collection)(serialCollection = QueryServiceHelper.query((String)"rim_expense_relation", (String)"serial_no,create_time", (QFilter[])new QFilter[]{filter, resourceFilter, entityidFilter}))) && filter2 != null) {
                serialCollection = QueryServiceHelper.query((String)"rim_expense_relation", (String)"serial_no,create_time", (QFilter[])new QFilter[]{filter2, resourceFilter, entityidFilter});
            }
            if (!CollectionUtils.isEmpty((Collection)serialCollection)) {
                boolean addSerialNo = CollectionUtils.isEmpty(serialList);
                if (serialList == null) {
                    serialList = new ArrayList<String>(8);
                }
                for (DynamicObject obj : serialCollection) {
                    Date date = obj.getDate("create_time");
                    if (date != null) {
                        expenseDate = date;
                    }
                    if (!addSerialNo) continue;
                    serialList.add(obj.getString("serial_no"));
                }
            }
        }
        JSONArray invoiceArray = new JSONArray();
        if (!CollectionUtils.isEmpty(serialList)) {
            serialList = this.getInvoiceAwsSerial(serialList);
            HashMap<String, JSONObject> serialMap = new HashMap<String, JSONObject>(serialList.size());
            param.put("expenseDate", expenseDate);
            JSONArray verifyResult = VerifyUtil.verifyBySerialNos(param, serialList, true);
            for (int i = 0; i < verifyResult.size(); ++i) {
                JSONObject invoice = verifyResult.getJSONObject(i);
                serialMap.put(invoice.getString("serialNo"), invoice);
            }
            HashSet<String> existsNoSet = new HashSet<String>(serialList.size());
            for (String serial : serialList) {
                JSONObject invoice;
                if (!existsNoSet.add(serial) || (invoice = (JSONObject)serialMap.get(serial)) == null) continue;
                invoiceArray.add((Object)invoice);
            }
        }
        return invoiceArray;
    }

    private List<String> getInvoiceAwsSerial(List<String> serialList) {
        HashMap<String, String> serialMap = new HashMap<String, String>(serialList.size());
        QFilter filter = new QFilter("aws_serial_no", "in", serialList);
        DynamicObjectCollection collect = QueryServiceHelper.query((String)"rim_invoice_serial", (String)"serial_no,aws_serial_no", (QFilter[])new QFilter[]{filter});
        if (collect == null || collect.isEmpty()) {
            return serialList;
        }
        ArrayList<String> list = new ArrayList<String>(serialList.size());
        for (DynamicObject obj : collect) {
            String awsSerialNo = obj.getString("aws_serial_no");
            String serialNo = obj.getString("serial_no");
            if (StringUtils.isEmpty((CharSequence)serialNo)) continue;
            serialMap.put(awsSerialNo, obj.getString("serial_no"));
        }
        for (String str : serialList) {
            String serial_no = (String)serialMap.get(str);
            if (!StringUtils.isEmpty((CharSequence)serial_no)) {
                list.add(serial_no);
                continue;
            }
            list.add(str);
        }
        return list;
    }

    public List<Map<String, Object>> queryExpenseRelationData(String expenseNum, String serialNo) {
        if (StringUtils.isBlank((CharSequence)expenseNum) && StringUtils.isBlank((CharSequence)serialNo)) {
            return Collections.emptyList();
        }
        LinkedList qFilters = Lists.newLinkedList();
        if (StringUtils.isNotBlank((CharSequence)serialNo)) {
            qFilters.add(new QFilter("serial_no", "=", (Object)serialNo));
        }
        if (StringUtils.isNotBlank((CharSequence)expenseNum)) {
            if (expenseNum.contains(",")) {
                List expenseNums = Arrays.stream(expenseNum.split(",")).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
                qFilters.add(new QFilter("expense_num", "in", expenseNums));
            } else {
                qFilters.add(new QFilter("expense_num", "=", (Object)expenseNum));
            }
        }
        DynamicObjectCollection mainCollection = this.queryMainExpenseRelation((QFilter[])qFilters.stream().toArray(QFilter[]::new));
        return DynamicObjectUtil.dynamicObjectColletction2ListMap(mainCollection);
    }

    public DynamicObjectCollection queryMainExpenseRelation(QFilter[] qFilters) {
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_expense_relation", (String)mainFields, (QFilter[])qFilters);
        return collection;
    }

    public List<Map<String, Object>> querySerialNoByExpenseNum(String expenseNum) {
        QFilter expenseNumFilter = new QFilter("expense_num", "=", (Object)expenseNum);
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"rim_expense_relation", (String)"serial_no", (QFilter[])new QFilter[]{expenseNumFilter});
        return DynamicObjectUtil.dynamicObjectColletction2ListMap(dynamicObjectCollection);
    }

    public List<Map<String, Object>> querySerialNoByExpenseNums(List<String> expenseNums) {
        QFilter expenseNumFilter = new QFilter("expense_num", "in", expenseNums);
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"rim_expense_relation", (String)"serial_no", (QFilter[])new QFilter[]{expenseNumFilter});
        return DynamicObjectUtil.dynamicObjectColletction2ListMap(dynamicObjectCollection);
    }

    public JSONArray queryByExpenseNumAndSerialNo(List<String> expenseNums, List<String> serialNos) {
        JSONArray expenseRelationArray = new JSONArray();
        if (CollectionUtils.isEmpty(expenseNums) && CollectionUtils.isEmpty(serialNos)) {
            return expenseRelationArray;
        }
        QFilter expenseNumFilter = null;
        QFilter serialNoFilter = null;
        if (!CollectionUtils.isEmpty(expenseNums)) {
            expenseNumFilter = new QFilter("expense_num", "in", expenseNums);
        }
        if (!CollectionUtils.isEmpty(serialNos)) {
            serialNoFilter = new QFilter("serial_no", "in", serialNos);
        }
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"rim_expense_relation", (String)"expense_id, expense_num, serial_no, status, entry_id", (QFilter[])new QFilter[]{expenseNumFilter, serialNoFilter});
        JSONObject json = null;
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            json = new JSONObject();
            json.put("expense_id", dynamicObject.get("expense_id"));
            json.put("expense_num", dynamicObject.get("expense_num"));
            json.put("serial_no", dynamicObject.get("serial_no"));
            json.put("prev_status", dynamicObject.get(statusField));
            json.put("entry_id", dynamicObject.get("entry_id"));
            expenseRelationArray.add((Object)json);
        }
        return expenseRelationArray;
    }

    public List<Map<String, Object>> queryByExpenseId(String expenseId) {
        if (StringUtils.isBlank((CharSequence)expenseId)) {
            return Collections.emptyList();
        }
        QFilter expenseIdFilter = new QFilter("expense_id", "=", (Object)expenseId);
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"rim_expense_relation", (String)Base_Columns, (QFilter[])new QFilter[]{expenseIdFilter});
        return DynamicObjectUtil.dynamicObjectColletction2ListMap(dynamicObjectCollection);
    }

    public String queryExpenseNumByExpenseId(String expenseId) {
        if (StringUtils.isBlank((CharSequence)expenseId)) {
            return "";
        }
        QFilter expenseIdFilter = new QFilter("expense_id", "=", (Object)expenseId);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"rim_expense", (String)"expense_num", (QFilter[])expenseIdFilter.toArray());
        if (!ObjectUtils.isEmpty((Object)dynamicObject)) {
            return dynamicObject.getString("expense_num");
        }
        return "";
    }

    public JSONObject queryExpenseInfo(String expenseId, String entityId, String resurce) {
        String fields;
        DynamicObject dynamicObject;
        QFilter expenseIdFilter = new QFilter("expense_id", "=", (Object)expenseId);
        if (StringUtils.isEmpty((CharSequence)entityId)) {
            expenseIdFilter = expenseIdFilter.and(new QFilter("entityid", "=", (Object)entityId));
        }
        if (StringUtils.isEmpty((CharSequence)resurce)) {
            expenseIdFilter = expenseIdFilter.and(new QFilter("resource", "=", (Object)resurce));
        }
        if ((dynamicObject = QueryServiceHelper.queryOne((String)"rim_expense", (String)(fields = "expense_num,expense_id,status,expense_type,invoice_amount,expense_amount,approve_amount,creator_id,creator_name,creator_phone,creator_email,remark,create_time"), (QFilter[])expenseIdFilter.toArray())) != null) {
            JSONObject result = new JSONObject();
            result.put("expenseNum", (Object)dynamicObject.getString("expense_num"));
            result.put("expenseId", (Object)dynamicObject.getString("expense_id"));
            result.put("expenseType", (Object)dynamicObject.getString("expense_type"));
            result.put("creatorId", (Object)dynamicObject.getString("creator_id"));
            result.put("creatorName", (Object)dynamicObject.getString("creator_name"));
            result.put("creatorPhone", (Object)dynamicObject.getString("creator_phone"));
            result.put("creatorEmail", (Object)dynamicObject.getString("creator_email"));
            result.put("remark", (Object)dynamicObject.getString("remark"));
            result.put("createTime", (Object)DateUtils.format(dynamicObject.getDate("create_time"), "yyyy-MM-dd HH:mm:ss"));
            return result;
        }
        return null;
    }

    public void batchUpdateStatus(List<String> serialNos, Integer expenseStatus, String expenseId) {
        DynamicObject[] mainDynamicObjectsTemp;
        QFilter serialFilter = new QFilter("serial_no", "in", serialNos);
        QFilter expenseIdFilter = new QFilter("expense_id", "=", (Object)expenseId);
        DynamicObjectCollection billList = QueryServiceHelper.query((String)"rim_expense_relation", (String)"id", (QFilter[])new QFilter[]{serialFilter, expenseIdFilter});
        List pkList = billList.stream().map(obj -> obj.get("id")).collect(Collectors.toList());
        for (DynamicObject obj2 : mainDynamicObjectsTemp = BusinessDataServiceHelper.load((Object[])pkList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"rim_expense_relation"))) {
            obj2.set(statusField, (Object)expenseStatus);
        }
        SaveServiceHelper.save((DynamicObject[])mainDynamicObjectsTemp);
    }

    public void deleteBySerialNoAndExpenseId(List<String> serialList, List<String> expenseIdList) {
        if (CollectionUtils.isEmpty(serialList) || CollectionUtils.isEmpty(expenseIdList)) {
            return;
        }
        QFilter serialNoFlilter = new QFilter("serial_no", "in", serialList);
        QFilter expenseIdFlilter = new QFilter("expense_id", "in", expenseIdList);
        DynamicObjectCollection billList = QueryServiceHelper.query((String)"rim_expense_relation", (String)"id", (QFilter[])new QFilter[]{serialNoFlilter, expenseIdFlilter});
        List pkList = billList.stream().map(obj -> obj.get("id")).collect(Collectors.toList());
        QFilter deleteFlilter = new QFilter("id", "in", pkList);
        DeleteServiceHelper.delete((String)"rim_expense_relation", (QFilter[])deleteFlilter.toArray());
    }

    private String fieldToString(Object value) {
        return this.fieldToString(value, null);
    }

    private String fieldToString(Object value, String format) {
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return value.toString();
        }
        if (value instanceof Date) {
            if (StringUtils.isEmpty((CharSequence)format)) {
                format = "yyyy-MM-dd";
            }
            return DateUtils.format((Date)value, format);
        }
        if (value instanceof BigDecimal) {
            if (StringUtils.isEmpty((CharSequence)format)) {
                format = "#0.##";
            }
            DecimalFormat decimalFormat = new DecimalFormat(format);
            return decimalFormat.format(value);
        }
        return value.toString();
    }

    public DynamicObjectCollection findByFilter(String mainFields, QFilter qFilter) {
        return QueryServiceHelper.query((String)"rim_expense_relation", (String)mainFields, (QFilter[])new QFilter[]{qFilter});
    }

    public DynamicObject[] findByFilter2(String mainFields, QFilter qFilter) {
        return BusinessDataServiceHelper.load((String)"rim_expense_relation", (String)mainFields, (QFilter[])new QFilter[]{qFilter});
    }

    public Boolean canEdit(String expenseNum) {
        String status;
        if (StringUtils.isEmpty((CharSequence)expenseNum)) {
            return Boolean.TRUE;
        }
        QFilter expenseRelationFilters = new QFilter("expense_num", "=", (Object)expenseNum);
        DynamicObjectCollection collection = this.findByFilter(statusField, expenseRelationFilters);
        if (!CollectionUtils.isEmpty((Collection)collection) && StringUtils.isNotEmpty((CharSequence)(status = ((DynamicObject)collection.get(0)).getString(statusField))) && Integer.parseInt(status) > 1) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public void saveExpenseInfo(Map<String, Object> param, String serials) {
        if (param != null) {
            ExpenseDTO dto = new ExpenseDTO();
            dto.setExpenseId((String)param.get("expense_id"));
            dto.setExpenseNum((String)param.get("expense_num"));
            dto.setRemark((String)param.get("remark"));
            dto.setCreatorName((String)param.get("creator_name"));
            dto.setExpenseTime((Date)param.get("create_time"));
            dto.setResource("1");
            dto.setStatus("60");
            dto.setExpenseType("invoice_pool_enter");
            List<String> serialList = CommonUtils.getMultiValues(serials);
            ArrayList<ExpenseInvoiceDTO> list = new ArrayList<ExpenseInvoiceDTO>(serialList.size());
            for (String serialNo : serialList) {
                ExpenseInvoiceDTO invoiceDto = new ExpenseInvoiceDTO();
                invoiceDto.setSerialNo(serialNo);
                list.add(invoiceDto);
            }
            InvoiceLog.insert("expense", serialList, dto.getExpenseNum());
            dto.setInvoiceList(list);
            ExpenseService service = new ExpenseService();
            String oldExpenseId = (String)param.get("old_expense_id");
            if (StringUtils.isNotEmpty((CharSequence)oldExpenseId) && !oldExpenseId.equals(dto.getExpenseId())) {
                ArrayList<String> expenseIdList = new ArrayList<String>(2);
                expenseIdList.add(oldExpenseId);
                this.deleteBySerialNoAndExpenseId(serialList, expenseIdList);
                dto.setAllowRepeat(true);
                service.save(dto);
            } else {
                String flag;
                if (StringUtils.isNotEmpty((CharSequence)oldExpenseId)) {
                    QFilter idfilter = new QFilter("expense_id", "=", (Object)oldExpenseId).and("resource", "=", (Object)dto.getResource());
                    DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_expense_relation", (String)"serial_no", (QFilter[])new QFilter[]{idfilter});
                    for (DynamicObject dynamicObject : collection) {
                        String serialNo = dynamicObject.getString("serial_no");
                        if (serialList.contains(serialNo)) continue;
                        ExpenseInvoiceDTO invoiceDto = new ExpenseInvoiceDTO();
                        invoiceDto.setSerialNo(serialNo);
                        list.add(invoiceDto);
                    }
                }
                dto.setAllowRepeat(!"0".equals(flag = RimConfigUtils.getConfig("rim_fpzs", "pool_not_allow_repeat")));
                service.save(dto);
            }
            if (StringUtils.isNotEmpty((CharSequence)oldExpenseId) && !oldExpenseId.equals(dto.getExpenseId())) {
                this.syncAwsExpense(oldExpenseId, (String)param.get("old_expense_num"), "1", String.join((CharSequence)",", serialList));
            }
            this.syncAwsExpense(dto.getExpenseId(), dto.getExpenseNum(), dto.getStatus(), String.join((CharSequence)",", serialList));
        }
    }

    public void updateEnterExpense(Map<String, Object> returnData, String serialNo) {
        if (returnData == null) {
            return;
        }
        String oldExpenseId = (String)returnData.get("old_expense_id");
        String expenseId = (String)returnData.get("expense_id");
        if (StringUtils.isNotEmpty((CharSequence)oldExpenseId) && oldExpenseId.equals(expenseId)) {
            QFilter filter = new QFilter("expense_id", "=", (Object)expenseId);
            DynamicObject expenseInfo = BusinessDataServiceHelper.loadSingle((String)"rim_expense", (String)"id,expense_id,expense_num,creator_name,expense_time,remark,update_time", (QFilter[])filter.toArray());
            if (expenseInfo == null) {
                throw new MsgException("0101", ResManager.loadKDString((String)"\u62a5\u9500\u5355\u4fe1\u606f\u6570\u636e\u4e3a\u7a7a", (String)"ExpenseRelationService_1", (String)"imc-rim-common-rim-common", (Object[])new Object[0]));
            }
            expenseInfo.set("update_time", (Object)new Date());
            expenseInfo.set("creator_name", (Object)((String)returnData.get("creator_name")));
            expenseInfo.set("remark", (Object)((String)returnData.get("remark")));
            expenseInfo.set("expense_time", (Object)((Date)returnData.get("create_time")));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{expenseInfo});
            return;
        }
        this.saveExpenseInfo(returnData, serialNo);
    }

    public void syncAwsExpense(String expenseId, String expenseNum, String status, String serials) {
        if (StringUtils.isEmpty((CharSequence)expenseId)) {
            return;
        }
        try {
            this.updateInvoiceToAWS(expenseId, expenseNum, status, serials);
        }
        catch (MsgException e) {
            LOGGER.info("\u5168\u7968\u6c60\u66f4\u65b0\u53d1\u7968\u72b6\u6001\u5931\u8d25\uff1a{}", (Object)e);
        }
        catch (Exception e) {
            LOGGER.info("\u5168\u7968\u6c60\u66f4\u65b0\u53d1\u7968\u72b6\u6001\u5931\u8d25\uff1a{}", (Object)e);
        }
    }

    private void updateInvoiceToAWS(String expenseId, String expenseNum, String status, String serials) throws IOException, MsgException {
        if (!InvoiceHisDataSyncService.needSync()) {
            return;
        }
        LOGGER.info("\u5168\u7968\u6c60\u66f4\u65b0\u53d1\u7968\u72b6\u6001\uff0cexpenseId\uff1a{}\uff0cexpenseNum:{},status:{},serials:{}", new Object[]{expenseId, expenseNum, status, serials});
        List<String> serialnos = CommonUtils.getMultiValues(serials);
        QFilter serialFilter = new QFilter("serial_no", "in", serialnos);
        DynamicObjectCollection mainCollection = QueryServiceHelper.query((String)"rim_invoice", (String)"aws_serial_no", (QFilter[])new QFilter[]{serialFilter});
        JSONArray invoiceDates = new JSONArray();
        mainCollection.forEach(v -> {
            String awsSerialNo = v.getString("aws_serial_no");
            if (StringUtils.isNotBlank((CharSequence)awsSerialNo)) {
                JSONObject invoiceDate = new JSONObject();
                invoiceDate.put("serialNo", (Object)awsSerialNo);
                invoiceDates.add((Object)invoiceDate);
            }
        });
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        Map userInfoByID = UserServiceHelper.getUserInfoByID((long)userId);
        JSONObject data = new JSONObject();
        data.put("billNumber", (Object)expenseNum);
        data.put("bxd_key", (Object)expenseId);
        data.put("creatorEmail", userInfoByID.get("email"));
        data.put("creatorId", (Object)userId.toString());
        data.put("creatorName", userInfoByID.get("name"));
        data.put("creatorPhone", userInfoByID.get("phone"));
        data.put("invoiceData", (Object)invoiceDates);
        data.put("resource", (Object)"4");
        data.put("ticketParam", (Object)"11111");
        data.put("invoiceStatus", (Object)status);
        this.post(JSONObject.toJSONString((Object)data));
    }

    private void post(String data) throws IOException, MsgException {
        long orgId = RequestContext.get().getOrgId();
        String token = AwsFpyService.newInstance().getAccessToken(orgId);
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            String url = AwsFpyService.newInstance().getUrl("msg_status_update", token);
            String result = HttpUtil.doPostJson(url, AwsFpyService.newInstance().getProxy(), null, data);
            JSONObject resultJson = JSONObject.parseObject((String)result);
            LOGGER.info("\u5168\u7968\u6c60\u66f4\u65b0\u53d1\u7968\u72b6\u6001\uff0cURL\uff1a{}\uff0cjson:{}\uff0cresult\uff1a{}", new Object[]{url, data, resultJson});
        }
    }
}

