/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.fpzs;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.ExpenseConstant;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.expense.domain.ExpenseDTO;
import kd.imc.rim.common.expense.domain.ExpenseInvoiceDTO;
import kd.imc.rim.common.expense.service.ExpenseService;
import kd.imc.rim.common.expense.service.VoucherService;
import kd.imc.rim.common.invoice.save.InvoiceSaveCallable;
import kd.imc.rim.common.invoice.save.InvoiceSaveResult;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.AwsFpyService;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.ImcConfigUtil;
import kd.imc.rim.common.utils.TenantUtils;

public class FpzsAwsService {
    private static final Log logger = LogFactory.getLog(FpzsAwsService.class);
    private static ThreadPool saveThreadPool = ThreadPools.newFixedThreadPool((String)"InvoiceSaveService", (int)6);

    public Map<String, Object> update(Map<String, Object> param) {
        if (param == null || param.isEmpty()) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL.getCode(), ErrorType.PARAM_NULL.getName());
        }
        JSONObject result = ResultContant.createSuccessJSONObject();
        String errorMsg = "";
        String json = SerializationUtils.toJsonString(param);
        JSONObject reqParamJSON = JSONObject.parseObject((String)json);
        String coverBase64 = reqParamJSON.getString("coverBase64");
        reqParamJSON.remove((Object)"coverBase64");
        logger.info("FpzsAwsService-update:" + reqParamJSON);
        String ticketParam = reqParamJSON.getString("ticketParam");
        String billNumber = reqParamJSON.getString("billNumber");
        String bxdKey = reqParamJSON.getString("bxd_key");
        String status = reqParamJSON.getString("invoiceStatus");
        String invoiceData = reqParamJSON.getString("invoiceData");
        String coverFileType = reqParamJSON.getString("coverFileType");
        String coverNumber = reqParamJSON.getString("coverNumber");
        String reimbursingId = reqParamJSON.getString("reimbursingId");
        Long orgId = reqParamJSON.getLong("orgId");
        RequestContext req = RequestContext.get();
        ExpenseDTO dto = new ExpenseDTO();
        dto.setExpenseId(bxdKey);
        dto.setExpenseNum(billNumber);
        dto.setResource("4");
        String entityId = ExpenseConstant.getExpenseEntityId(bxdKey, null);
        String expense_type = "";
        expense_type = "ap_invoice".equals(entityId) ? "1" : ("ap_finapbill".equals(entityId) ? "4" : entityId);
        dto.setExpenseType(expense_type);
        dto.setEntityId(entityId);
        dto.setStatus(status);
        dto.setOrgId(orgId);
        dto.setReimbursingId(reimbursingId);
        if (!StringUtils.isEmpty((String)entityId) && StringUtils.isEmpty((String)reimbursingId)) {
            reimbursingId = ExpenseConstant.getExpenseReimbursingid(bxdKey, entityId);
            dto.setReimbursingId(reimbursingId);
        }
        if (dto.getOrgId() == null || dto.getOrgId() < 0L) {
            dto.setOrgId(RequestContext.get().getOrgId());
        }
        ArrayList<ExpenseInvoiceDTO> invoiceList = new ArrayList<ExpenseInvoiceDTO>(8);
        ArrayList<String> serialList = new ArrayList<String>(8);
        if (invoiceData.indexOf("serialNo") > 0) {
            JSONArray array = JSONArray.parseArray((String)invoiceData);
            for (int i = 0; i < array.size(); ++i) {
                JSONObject invoice = array.getJSONObject(i);
                String serialNo = invoice.getString("serialNo");
                serialList.add(serialNo);
                ExpenseInvoiceDTO invoiceDto = new ExpenseInvoiceDTO();
                invoiceDto.setSerialNo(serialNo);
                invoiceDto.setDeductionPurpose(invoice.getString("deductionPurpose"));
                invoiceDto.setDeductionFlag(invoice.getString("deductionFlag"));
                invoiceDto.setDeductionAmount(invoice.getBigDecimal("deductionTaxAmount"));
                invoiceDto.setOutputAmount(invoice.getBigDecimal("outputAmount"));
                invoiceDto.setRemark(invoice.getString("remark"));
                invoiceDto.setEntryId(invoice.getString("entryId"));
                if (null == invoiceDto.getDeductionFlag()) {
                    invoiceDto.setDeductionFlag(invoice.getString("canBeDeduction"));
                }
                if (null == invoiceDto.getDeductionAmount()) {
                    invoiceDto.setDeductionAmount(invoice.getBigDecimal("entryAmount"));
                }
                if (null == invoiceDto.getOutputAmount()) {
                    invoiceDto.setOutputAmount(invoice.getBigDecimal("outputAmount"));
                }
                if (null == invoiceDto.getRemark()) {
                    invoiceDto.setRemark(invoice.getString("outputReason"));
                }
                invoiceDto.setOrgId(orgId);
                invoiceDto.setExtInfo(invoice.getJSONObject("extInfo"));
                invoiceList.add(invoiceDto);
            }
        } else {
            String[] serialNos;
            for (String str : serialNos = invoiceData.split(",")) {
                ExpenseInvoiceDTO invoiceDto = new ExpenseInvoiceDTO();
                invoiceDto.setSerialNo(str);
                invoiceDto.setOrgId(orgId);
                invoiceList.add(invoiceDto);
                serialList.add(str);
            }
        }
        try {
            Map<String, String> map = this.getInvoiceFromAws(orgId, serialList);
            for (ExpenseInvoiceDTO ivnoicedto : invoiceList) {
                ivnoicedto.setSerialNo(map.get(ivnoicedto.getSerialNo()));
            }
            dto.setInvoiceList(invoiceList);
            dto.setAllowRepeat(true);
            ExpenseService expenseService = new ExpenseService();
            expenseService.save(dto);
        }
        catch (MsgException e) {
            errorMsg = e.getErrorMsg();
            result = ResultContant.createJSONObject(e.getErrorCode(), e.getErrorMsg());
        }
        catch (IOException e) {
            errorMsg = e.getMessage();
            result = ResultContant.createJSONObject("1001", ResManager.loadKDString((String)"\u67e5\u8be2\u53d1\u7968\u9519\u8bef", (String)"FpzsAwsService_0", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        this.saveLog(billNumber, "update", reqParamJSON.toJSONString(), errorMsg);
        return result;
    }

    public Map<String, Object> delete(Map<String, Object> param) {
        if (param == null || param.isEmpty()) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL.getCode(), ErrorType.PARAM_NULL.getName());
        }
        String json = SerializationUtils.toJsonString(param);
        logger.info("FpzsAwsService-delete:" + json);
        JSONObject reqParamJSON = JSONObject.parseObject((String)json);
        String billNumber = reqParamJSON.getString("billNumber");
        if (StringUtils.isEmpty((String)billNumber)) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL.getCode(), ErrorType.PARAM_NULL.getName());
        }
        String entityId = ExpenseConstant.getExpenseEntityId(billNumber, null);
        ExpenseDTO paramDto = new ExpenseDTO();
        paramDto.setEntityId(entityId);
        if (StringUtils.isEmpty((String)entityId)) {
            paramDto.setResource("4");
        }
        paramDto.setExpenseId(billNumber);
        ExpenseService expenseService = new ExpenseService();
        expenseService.delete(paramDto);
        paramDto.setResource("aws");
        expenseService.delete(paramDto);
        this.saveLog(billNumber, "delete", reqParamJSON.toJSONString(), "");
        return ResultContant.createSuccessJSONObject();
    }

    public Map<String, Object> saveVouch(Map<String, Object> param) {
        if (param == null || param.isEmpty()) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL.getCode(), ErrorType.PARAM_NULL.getName());
        }
        String json = SerializationUtils.toJsonString(param);
        JSONObject reqParamJSON = JSONObject.parseObject((String)json);
        logger.info("FpzsAwsService-saveVouch:" + reqParamJSON);
        String billNumber = "";
        String errorMsg = "";
        JSONObject result = ResultContant.createSuccessJSONObject();
        try {
            VoucherService service = new VoucherService();
            JSONArray serialNoArray = reqParamJSON.getJSONArray("serialNoArray");
            if (serialNoArray != null && !serialNoArray.isEmpty()) {
                List list = serialNoArray.toJavaList(String.class);
                Long orgId = this.getOrgId(reqParamJSON);
                Map<String, String> serialMap = this.getInvoiceFromAws(orgId, list);
                JSONArray array = new JSONArray();
                for (Map.Entry<String, String> entry : serialMap.entrySet()) {
                    array.add((Object)entry.getValue());
                }
                reqParamJSON.put("serialNoArray", (Object)array);
            }
            billNumber = service.saveVoucher((Map<String, Object>)reqParamJSON);
        }
        catch (MsgException e) {
            errorMsg = e.getErrorCode() + e.getErrorMsg();
            result = ResultContant.createJSONObject(e.getErrorCode(), e.getErrorMsg());
        }
        catch (IOException e) {
            errorMsg = e.getMessage();
            result = ResultContant.createJSONObject("1001", ResManager.loadKDString((String)"\u67e5\u8be2\u53d1\u7968\u9519\u8bef", (String)"FpzsAwsService_0", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        this.saveLog(billNumber, "saveVouch", reqParamJSON.toJSONString(), errorMsg);
        return result;
    }

    private Long getOrgId(JSONObject param) {
        Long orgId = null;
        JSONObject voucherInfo = param.getJSONObject("voucherInfo");
        if (voucherInfo != null) {
            String taxNo;
            QFilter qFilter;
            DynamicObject voucher;
            String vouchId = voucherInfo.getString("vouchId");
            if (!ObjectUtils.isEmpty((Object)vouchId) && StringUtils.isNumeric((String)vouchId) && (voucher = QueryServiceHelper.queryOne((String)"gl_voucher", (String)"id,org_id", (QFilter[])new QFilter[]{qFilter = new QFilter("id", "=", (Object)Long.parseLong(vouchId))})) != null) {
                return voucher.getLong("org_id");
            }
            String orgNumber = voucherInfo.getString("orgNumber");
            Long orgByNumberOrTaxNo = TenantUtils.getOrgByNumberOrTaxNo(orgNumber, taxNo = voucherInfo.getString("taxNo"));
            if (orgByNumberOrTaxNo != null && orgByNumberOrTaxNo > 0L) {
                orgId = orgByNumberOrTaxNo;
            }
        }
        return orgId;
    }

    public Map<String, Object> deleteVouch(Map<String, Object> param) {
        if (param == null || param.isEmpty()) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL.getCode(), ErrorType.PARAM_NULL.getName());
        }
        String vouchId = "";
        String errorMsg = "";
        JSONObject result = ResultContant.createSuccessJSONObject();
        String json = SerializationUtils.toJsonString(param);
        JSONObject reqParamJSON = JSONObject.parseObject((String)json);
        logger.info("FpzsAwsService-deleteVouch:" + reqParamJSON);
        try {
            VoucherService service = new VoucherService();
            Object resource = param.get("resource");
            if (null == resource) {
                param.put("resource", "4");
            }
            vouchId = service.deleteVoucher(param);
            param.put("resource", "aws");
            vouchId = service.deleteVoucher(param);
        }
        catch (MsgException e) {
            errorMsg = e.getErrorMsg();
            result = ResultContant.createJSONObject(e.getErrorCode(), e.getErrorMsg());
        }
        this.saveLog(vouchId, "deleteVouch", reqParamJSON.toJSONString(), errorMsg);
        return result;
    }

    private Map<String, String> getInvoiceFromAws(Long orgId, List<String> serialList) throws IOException {
        HashMap<String, String> serialMap = new HashMap<String, String>(serialList.size());
        QFilter filter = new QFilter("aws_serial_no", "in", serialList);
        DynamicObjectCollection collect = QueryServiceHelper.query((String)"rim_invoice_serial", (String)"serial_no,aws_serial_no", (QFilter[])new QFilter[]{filter});
        ArrayList<String> list = new ArrayList<String>(serialList.size());
        for (DynamicObject obj : collect) {
            String awsSerialNo = obj.getString("aws_serial_no");
            String serialNo = obj.getString("serial_no");
            if (StringUtils.isEmpty((String)serialNo)) continue;
            serialMap.put(obj.getString("aws_serial_no"), obj.getString("serial_no"));
            list.add(awsSerialNo);
        }
        serialList.removeAll(list);
        if (!serialList.isEmpty()) {
            Map<String, InvoiceSaveResult> syncResult = this.syncInvoiceFromAws(orgId, serialList, null);
            this.saveSerialNoSync(syncResult);
            for (Map.Entry<String, InvoiceSaveResult> entry : syncResult.entrySet()) {
                InvoiceSaveResult result = entry.getValue();
                serialMap.put(entry.getKey(), result.getSerialNo());
            }
        }
        return serialMap;
    }

    public Map<String, InvoiceSaveResult> syncInvoiceFromAws(Long orgId, List<String> awsSerialList, JSONObject businessParam) throws IOException {
        if (!CollectionUtils.isEmpty(awsSerialList)) {
            HashMap<String, InvoiceSaveResult> serialMap = new HashMap<String, InvoiceSaveResult>(awsSerialList.size());
            AwsFpyService service = AwsFpyService.newInstance();
            String token = this.getToken(orgId);
            JSONObject param = new JSONObject();
            param.put("serialNo", awsSerialList);
            RequestContext request = RequestContext.get();
            String url = service.getUrl("msg_query_serial", token);
            JSONObject result = service.postAppJson(url, param.toJSONString());
            if (ResultContant.isSuccess(result).booleanValue()) {
                JSONArray data = result.getJSONArray("data");
                ArrayList<Future<InvoiceSaveResult>> futureList = new ArrayList<Future<InvoiceSaveResult>>(8);
                for (int i = 0; i < data.size(); ++i) {
                    JSONObject invoice = data.getJSONObject(i);
                    if (orgId != null) {
                        invoice.put("org_id", (Object)orgId);
                        invoice.put("overrideOrg", (Object)"1");
                    } else {
                        invoice.put("overrideOrg", (Object)"0");
                    }
                    if (businessParam != null) {
                        invoice.putAll((Map)businessParam);
                    }
                    invoice.put("override", (Object)"1");
                    InvoiceSaveCallable callable = new InvoiceSaveCallable(request, invoice);
                    futureList.add(saveThreadPool.submit((Callable)callable));
                    this.wait(futureList, serialMap, i);
                }
                this.wait(futureList, serialMap, 6);
                CacheHelper.put("rim.fpzs.token", token, 3600);
            }
            return serialMap;
        }
        return null;
    }

    private String getToken(Long orgId) throws IOException {
        Map<String, String> configMap = this.getConfig(orgId);
        AwsFpyService service = AwsFpyService.newInstance();
        if (configMap != null && !configMap.isEmpty()) {
            try {
                return service.getAccessToken(configMap.get("client_id"), configMap.get("client_secret"));
            }
            catch (MsgException e) {
                logger.info("FpzsAwsService\u7ec4\u7ec7\u6ca1\u6709\u914d\u7f6e\u6388\u6743\u4fe1\u606f{}", (Object)orgId);
                String token = this.getTokenCache();
                if (!StringUtils.isEmpty((String)token)) {
                    return token;
                }
                throw e;
            }
        }
        return this.getTokenCache();
    }

    private String getTokenCache() {
        return CacheHelper.get("rim.fpzs.token");
    }

    private Map<String, String> getConfig(Long orgId) {
        HashMap<String, String> map = new HashMap<String, String>(4);
        Map<String, String> cachemap = ImcConfigUtil.getValue("dim_imc_config_fpy");
        if (cachemap != null && !cachemap.isEmpty()) {
            map.put("client_id", AwsFpyService.getValue(cachemap, "dim_imc_config_fpy_clientid", "clientid"));
            map.put("client_secret", AwsFpyService.getValue(cachemap, "dim_imc_config_fpy_clientsecret", "clientsecret"));
            return map;
        }
        QFilter[] filters = new QFilter[]{new QFilter("org.id", "=", (Object)orgId), new QFilter("enable", "=", (Object)Boolean.TRUE)};
        DynamicObject config = BusinessDataServiceHelper.loadSingleFromCache((String)"er_bd_kdinvoicecloudcfg", (QFilter[])filters);
        if (config != null) {
            map.put("client_id", config.getString("client_id"));
            map.put("client_secret", config.getString("client_secret"));
            return map;
        }
        return map;
    }

    static int dateCompare(Date d1, Date d2) {
        if (d1 == null && d2 == null) {
            return 0;
        }
        if (d1 == null) {
            return -1;
        }
        if (d2 == null) {
            return 1;
        }
        return d1.compareTo(d2);
    }

    private void wait(List<Future<InvoiceSaveResult>> futureList, Map<String, InvoiceSaveResult> serialMap, int index) {
        if (index > 0 && index % 6 == 0 && !futureList.isEmpty()) {
            for (Future<InvoiceSaveResult> future : futureList) {
                try {
                    InvoiceSaveResult result = future.get();
                    serialMap.put(result.getAwsSerialNo(), result);
                }
                catch (Exception exception) {}
            }
            futureList.clear();
        }
    }

    private void saveSerialNoSync(Map<String, InvoiceSaveResult> serialMap) {
        ThreadPools.executeOnceIncludeRequestContext((String)"FpzsAwsService.saveSerialNoSync", () -> {
            ArrayList list = new ArrayList(serialMap.size());
            ArrayList<DynamicObject> listObject = new ArrayList<DynamicObject>(serialMap.size());
            for (Map.Entry entry : serialMap.entrySet()) {
                list.add(entry.getKey());
                InvoiceSaveResult result = (InvoiceSaveResult)entry.getValue();
                DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"rim_invoice_serial");
                obj.set("aws_serial_no", entry.getKey());
                obj.set("serial_no", (Object)result.getSerialNo());
                obj.set("create_time", (Object)new Date());
                listObject.add(obj);
            }
            QFilter filter = new QFilter("aws_serial_no", "in", list);
            DeleteServiceHelper.delete((String)"rim_invoice_serial", (QFilter[])new QFilter[]{filter});
            SaveServiceHelper.save((DynamicObject[])listObject.toArray(new DynamicObject[0]));
        });
    }

    private void saveLog(String bizId, String method, String msg, String errorMsg) {
        try {
            RequestContext req = RequestContext.get();
            Long userId = Long.valueOf(req.getUserId());
            DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"rim_receive_message");
            obj.set("class", (Object)"FpzsAwsService");
            obj.set("method", (Object)method);
            obj.set("bizid", (Object)bizId);
            obj.set("createtime", (Object)new Date());
            obj.set("modifytime", (Object)new Date());
            if (StringUtils.isEmpty((String)errorMsg)) {
                obj.set("state", (Object)"1");
            } else {
                obj.set("state", (Object)"0");
                if (errorMsg.length() > 500) {
                    obj.set("error_msg", (Object)errorMsg.substring(450));
                }
            }
            obj.set("modifier", (Object)userId);
            obj.set("creater", (Object)userId);
            obj.set("req_msg_tag", (Object)msg);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u65e5\u5fd7\u5931\u8d25");
        }
    }
}

