/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.fpzs;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.invoice.fpzs.InvoiceClassService;
import kd.imc.rim.common.invoice.recognitionnew.task.FileGenerateTask;
import kd.imc.rim.common.invoice.verify.VerifyUtil;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.TenantUtils;

public class FpzsInvoiceCollectService {
    public Map<String, Map<String, Object>> queryInvoiceDynamicObjectBySerialNo(String serialNo) {
        Map<String, DynamicObject> map = VerifyUtil.queryInvoiceDynamicObjectBySerialNo(serialNo);
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>(10);
        for (Map.Entry<String, DynamicObject> entry : map.entrySet()) {
            result.put(entry.getKey(), DynamicObjectUtil.dynamicObjectToMap(entry.getValue()));
        }
        return result;
    }

    public boolean exsitAttachExpenseRelation(String serialNo) {
        QFilter attachFilter = new QFilter("relation_id", "=", (Object)serialNo);
        QFilter typeFilter = new QFilter("relation_type", "=", (Object)"3");
        return QueryServiceHelper.exists((String)"rim_attach_relation", (QFilter[])new QFilter[]{attachFilter, typeFilter});
    }

    public Map<String, Object> loadMainInvoice(String serialNo) {
        DynamicObject invoiceMulClassInfo = BusinessDataServiceHelper.loadSingle((String)"rim_invoice", (String)"id,mul_class,mul_class.name", (QFilter[])new QFilter[]{new QFilter("serial_no", "=", (Object)serialNo)});
        HashMap<String, Object> mainMap = new HashMap<String, Object>(10);
        InvoiceClassService.getInstance().dealClassName(mainMap, invoiceMulClassInfo, false);
        return mainMap;
    }

    public Map<String, Object> queryMainInvoice(Long invoiceType, String invoiceCode, String invoiceNo) {
        QFilter noFilter;
        QFilter typeFilter;
        DynamicObject idObject;
        QFilter codeFilter = new QFilter("invoice_code", "=", (Object)invoiceCode);
        if (InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(invoiceType) || InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode().equals(invoiceType) || InputInvoiceTypeEnum.isAirEleTrainEleType(invoiceType)) {
            codeFilter = null;
        }
        if ((idObject = QueryServiceHelper.queryOne((String)"rim_invoice", (String)"id,serial_no,delete", (QFilter[])new QFilter[]{codeFilter, typeFilter = new QFilter("invoice_type", "=", (Object)invoiceType), noFilter = new QFilter("invoice_no", "=", (Object)invoiceNo)})) == null) {
            return null;
        }
        return DynamicObjectUtil.dynamicObject2Map(idObject);
    }

    public Map<String, Object> queryAirInvoice(String serialNo) {
        DynamicObject result = QueryServiceHelper.queryOne((String)"rim_inv_air", (String)"invoice_amount", (QFilter[])new QFilter[]{new QFilter("serial_no", "=", (Object)serialNo)});
        if (result == null) {
            return null;
        }
        return DynamicObjectUtil.dynamicObject2Map(result);
    }

    public JSONObject createImage(String invoice) {
        JSONObject invoiceJson = JSONObject.parseObject((String)invoice);
        FileGenerateTask fileGenerateTask = new FileGenerateTask(RequestContext.get(), invoiceJson.getString("serialNo"), invoiceJson);
        JSONObject result = fileGenerateTask.call();
        return result;
    }

    public JSONObject getFileBySerial(String serialNo) {
        QFilter serialNoFilter;
        String tenantNo;
        QFilter tenantFilter;
        List idList;
        DynamicObject mainDynamicObject = null;
        if (kd.bos.util.StringUtils.isNotEmpty((String)serialNo) && !CollectionUtils.isEmpty((Collection)(idList = QueryServiceHelper.queryPrimaryKeys((String)"rim_invoice_file", (QFilter[])new QFilter[]{tenantFilter = new QFilter("tenant_no", "=", (Object)(tenantNo = TenantUtils.getTenantNo())), serialNoFilter = new QFilter("serial_no", "=", (Object)serialNo)}, null, (int)1))) && (mainDynamicObject = BusinessDataServiceHelper.loadSingle(idList.get(0), (String)"rim_invoice_file")) != null) {
            JSONObject fileInfo = new JSONObject();
            fileInfo.put("snapshotUrl", (Object)mainDynamicObject.getString("snapshot_url"));
            fileInfo.put("pdfUrl", (Object)mainDynamicObject.getString("pdf_url"));
            fileInfo.put("ofdUrl", (Object)mainDynamicObject.getString("ofd_url"));
            fileInfo.put("fileHash", (Object)mainDynamicObject.getString("file_hash"));
            return fileInfo;
        }
        return null;
    }

    public void insertModifyHisInfo(JSONObject beforeInvoiceInfo, JSONObject afterInvoiceInfo, String finalSerialNo) {
        if (beforeInvoiceInfo == null || afterInvoiceInfo == null) {
            return;
        }
        String beforeSerialNo = beforeInvoiceInfo.getString("serialNo");
        Long beforeInvoiceType = beforeInvoiceInfo.getLong("invoiceType");
        Long afterInvoiceType = afterInvoiceInfo.getLong("invoiceType");
        QFilter qFilter = new QFilter("serial_no", "=", (Object)beforeSerialNo);
        DeleteServiceHelper.delete((String)"rim_verify_modify_his", (QFilter[])new QFilter[]{qFilter});
        QFilter nowQFilter = new QFilter("serial_no", "=", (Object)finalSerialNo);
        DeleteServiceHelper.delete((String)"rim_verify_modify_his", (QFilter[])new QFilter[]{nowQFilter});
        if (!beforeInvoiceType.equals(afterInvoiceType)) {
            DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"rim_verify_modify_his");
            object.set("serial_no", (Object)finalSerialNo);
            object.set("modify_key", (Object)"invoice_type");
            object.set("modify_name", (Object)ResManager.loadKDString((String)"\u53d1\u7968\u7c7b\u578b", (String)"FpzsInvoiceCollectService_0", (String)"imc-rim-common", (Object[])new Object[0]));
            object.set("before_value", (Object)InputInvoiceTypeEnum.getInvoiceType(beforeInvoiceType).getName());
            object.set("after_value", (Object)InputInvoiceTypeEnum.getInvoiceType(afterInvoiceType).getName());
            object.set("create_time", (Object)new Date());
            object.set("modifier", (Object)RequestContext.get().getUserId());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
            return;
        }
        Long invoiceType = beforeInvoiceInfo.getLong("invoiceType");
        String entityName = InputInvoiceTypeEnum.getEntity(invoiceType);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        HashMap filedMap = Maps.newHashMap();
        if (dataEntityType != null) {
            DataEntityPropertyCollection properties = dataEntityType.getProperties();
            for (IDataEntityProperty property : properties) {
                if (property.getDisplayName() == null) continue;
                filedMap.put(property.getName(), property.getDisplayName().getLocaleValue());
            }
        }
        Set keySet = beforeInvoiceInfo.entrySet();
        for (Map.Entry keyValue : keySet) {
            BigDecimal d2;
            BigDecimal d1;
            String key = (String)keyValue.getKey();
            String beforeVal = beforeInvoiceInfo.getString(key);
            String afterVal = afterInvoiceInfo.getString(key);
            boolean isModify = this.isNum(beforeVal) && this.isNum(afterVal) ? (d1 = new BigDecimal(beforeVal)).compareTo(d2 = new BigDecimal(afterVal)) != 0 : !StringUtils.equals((CharSequence)beforeVal, (CharSequence)afterVal);
            String convertKey = this.getConvertKey(key);
            if (!isModify) continue;
            DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"rim_verify_modify_his");
            object.set("serial_no", (Object)finalSerialNo);
            object.set("modify_key", (Object)key);
            if (convertKey != null) {
                object.set("modify_name", filedMap.get(convertKey));
            } else {
                object.set("modify_name", filedMap.get(this.humpToLine(key)));
            }
            if (StringUtils.isEmpty((CharSequence)object.getString("modify_name"))) continue;
            Object beforeValue = keyValue.getValue();
            object.set("before_value", ObjectUtils.isEmpty(beforeValue) ? ResManager.loadKDString((String)"\u7a7a", (String)"FpzsInvoiceCollectService_1", (String)"imc-rim-common", (Object[])new Object[0]) : beforeValue);
            object.set("after_value", afterInvoiceInfo.get((Object)key));
            object.set("create_time", (Object)new Date());
            object.set("modifier", (Object)RequestContext.get().getUserId());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
        }
    }

    private String getConvertKey(String key) {
        HashMap map = Maps.newHashMap();
        map.put("electronicTicketNum", "eticket_no");
        map.put("otherTotalTaxAmount", "other_amount");
        map.put("customerIdentityNum", "customer_id_no");
        map.put("buyerIdNo", "buyer_cardno");
        map.put("certificateNo", "certificate_num");
        map.put("commodityInspectionNo", "commodity_inspection_num");
        map.put("engineNo", "engine_num");
        map.put("amount", "invoice_amount");
        map.put("limitedCount", "limite_people");
        map.put("ftime", "time");
        map.put("produceArea", "producing_area");
        map.put("vehicleIdentificationNo", "vehicle_identification_code");
        map.put("seat", "seat_grade");
        map.put("printingSequenceNo", "sequence_no");
        map.put("seatNo", "seat_grade");
        if (map.keySet().contains(key)) {
            return (String)map.get(key);
        }
        return null;
    }

    private boolean isNum(String val) {
        if (StringUtils.isEmpty((CharSequence)val)) {
            return false;
        }
        String check = "-?(0|[1-9]\\d*)(\\.\\d+)?";
        return Pattern.matches(check, val);
    }

    private String humpToLine(String str) {
        Pattern humpPattern = Pattern.compile("[A-Z]");
        Matcher matcher = humpPattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

