/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.fpzs;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.MulComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.mvc.form.ClientViewProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.constant.FpzsConstant;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.InvoiceSaveConstant;
import kd.imc.rim.common.constant.VerifyConstant;
import kd.imc.rim.common.datagrid.Column;
import kd.imc.rim.common.invoice.collector.ScannerService;
import kd.imc.rim.common.invoice.fpzs.InvoiceClassService;
import kd.imc.rim.common.invoice.verify.VerifyService;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.multitenant.service.AbstractFpzsPluginService;
import kd.imc.rim.common.service.InvoiceLog;
import kd.imc.rim.common.service.RecognitionCheckService;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.InvoiceConfigUtils;
import kd.imc.rim.common.utils.InvoiceConvertUtils;
import kd.imc.rim.common.utils.MD5;
import kd.imc.rim.common.utils.PropertieUtil;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.RimUserService;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.common.utils.UUID;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class FpzsMainService {
    private static Log logger = LogFactory.getLog(FpzsMainService.class);
    private AbstractFormPlugin plugin;
    private static String CACHE_INVOICE_DATA = "fpzsinvoicecache";
    private static String CACHE_ATTACH_DATA = "fpzsattachcache";
    private static Map<String, ValueMapItem> imgMap = null;
    public static final String CAHCE_CUSTOM_PARAM = "fpzs_param_cache";
    private static final String format = "###,##0.00";
    private static final String OPERATE_ENTRY = "operate_entry";
    private static final String OPERATE_ENTRY1 = "operate_entry1";
    private static final String OPERATE_TYPE = "operate_type";
    public static final String FPZS_SOURCESYS = "\u53d1\u7968\u52a9\u624b";
    public static final String MOBILE_SOURCESYS = "\u79fb\u52a8\u7aef\u91c7\u96c6";

    public FpzsMainService(AbstractFormPlugin plugin) {
        this.plugin = plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pair<JSONObject, Boolean> cacheInvoiceList(String pageId, Map<String, Object> customParam, JSONArray invoiceArray, JSONArray attachArray) {
        boolean repeatFlag = false;
        if (CollectionUtils.isEmpty((Collection)invoiceArray) && CollectionUtils.isEmpty((Collection)attachArray)) {
            return Pair.of(null, (Object)repeatFlag);
        }
        String listCacheKey = "listsinvoice_" + pageId;
        try (DLock lock = DLock.create((String)("showSelectInvoice" + pageId), (String)ResManager.loadKDString((String)"\u5237\u65b0\u5361\u7247\u9501", (String)"FpzsMainService_0", (String)"imc-rim-common", (Object[])new Object[0]));){
            int maxTimes = RimConfigUtils.getPageSizeFromConfig(40, "rim_fpzs", "cache_invoicelist_times");
            for (int times = 0; times < maxTimes; ++times) {
                if (lock.tryLock(500L)) {
                    long starttime = System.currentTimeMillis();
                    try {
                        Map<String, List<Map<String, Object>>> attachMap;
                        String rpop;
                        if (invoiceArray == null) {
                            invoiceArray = new JSONArray();
                        }
                        if (attachArray == null) {
                            attachArray = new JSONArray();
                        }
                        while (StringUtils.isNotEmpty((CharSequence)(rpop = CacheHelper.rpop(listCacheKey)))) {
                            JSONObject json = JSON.parseObject((String)rpop);
                            JSONArray invoiceArray1 = json.getJSONArray("invoiceArray");
                            JSONArray attachArray1 = json.getJSONArray("attachArray");
                            if (!CollectionUtils.isEmpty((Collection)invoiceArray1)) {
                                invoiceArray.addAll((Collection)invoiceArray1);
                            }
                            if (CollectionUtils.isEmpty((Collection)attachArray1)) continue;
                            attachArray.addAll((Collection)attachArray1);
                        }
                        ArrayList<Long> invoiceIds = new ArrayList<Long>(8);
                        ArrayList<Long> uncheckInvoiceIds = new ArrayList<Long>(8);
                        ArrayList<Object> showInvoiceArray = new ArrayList<Object>(16);
                        HashMap<String, Long> invoiceSeqMap = new HashMap<String, Long>(16);
                        String uploadIndex = String.valueOf(System.currentTimeMillis());
                        for (int index = 0; index < invoiceArray.size(); ++index) {
                            JSONObject invoice = invoiceArray.getJSONObject(index);
                            String mainId = invoice.getString("mainId");
                            String unCheckId = invoice.getString("unCheckId");
                            if (StringUtils.isNotEmpty((CharSequence)unCheckId)) {
                                uncheckInvoiceIds.add(Long.parseLong(unCheckId));
                            } else if (StringUtils.isNotEmpty((CharSequence)mainId)) {
                                invoiceIds.add(Long.parseLong(mainId));
                            } else {
                                FpzsMainService.dealUnSaveInvoice(invoice);
                                showInvoiceArray.add(invoice);
                            }
                            Long uploadSeq = invoice.getLong("uploadSeq");
                            String seqMapKey = invoice.getString("serialNo");
                            if (StringUtils.isEmpty((CharSequence)seqMapKey)) {
                                seqMapKey = mainId;
                            }
                            if (uploadSeq == null) {
                                invoiceSeqMap.put(seqMapKey, RecognitionCheckService.getInvoiceSeq(uploadIndex, 0, index));
                                continue;
                            }
                            invoiceSeqMap.put(seqMapKey, uploadSeq);
                        }
                        logger.info("cacheInvoiceList dealUnSaveInvoice or getInvoiceSeq \u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - starttime));
                        long starttime2 = System.currentTimeMillis();
                        JSONObject cacheJson = FpzsMainService.getInvoiceDataCache(pageId);
                        logger.info("\u5df2\u7ecf\u5b58\u5728\u7684\u6570\u636e:{}-{}-{}", new Object[]{pageId, cacheJson.size(), cacheJson});
                        if (!cacheJson.isEmpty()) {
                            for (Map.Entry obj : cacheJson.entrySet()) {
                                Map invoice = (Map)obj.getValue();
                                Object uploadSeq = invoice.get("uploadSeq");
                                if (uploadSeq == null) continue;
                                invoiceSeqMap.put((String)obj.getKey(), BigDecimalUtil.transDecimal(uploadSeq).longValue());
                            }
                        }
                        AbstractFpzsPluginService service = AbstractFpzsPluginService.newInstance();
                        logger.info("cacheInvoiceList getInvoiceDataCache deal \u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - starttime2));
                        if (!CollectionUtils.isEmpty(invoiceIds) || !CollectionUtils.isEmpty(uncheckInvoiceIds)) {
                            JSONArray list = service.verifyByMainIds(customParam, invoiceIds, uncheckInvoiceIds);
                            for (int i = 0; i < list.size(); ++i) {
                                Object seq;
                                JSONObject invoice = list.getJSONObject(i);
                                String serialNo = invoice.getString("serialNo");
                                if (null != cacheJson.get((Object)serialNo)) {
                                    repeatFlag = true;
                                    cacheJson.remove((Object)serialNo);
                                }
                                if ((seq = (Long)invoiceSeqMap.get(serialNo)) == null) {
                                    seq = (Long)invoiceSeqMap.get(invoice.getString("mainId"));
                                }
                                invoice.remove((Object)"mainId");
                                invoice.put("uploadSeq", seq);
                                showInvoiceArray.add(invoice);
                            }
                        }
                        if (!cacheJson.isEmpty()) {
                            for (Map.Entry obj : cacheJson.entrySet()) {
                                showInvoiceArray.add((Map)obj.getValue());
                            }
                        }
                        long start3 = System.currentTimeMillis();
                        Collections.sort(showInvoiceArray, (o1, o2) -> {
                            Long uploadSeq1 = BigDecimalUtil.transDecimal(o1.get("uploadSeq")).longValue();
                            Long uploadSeq2 = BigDecimalUtil.transDecimal(o2.get("uploadSeq")).longValue();
                            return uploadSeq1.compareTo(uploadSeq2);
                        });
                        JSONObject dataJson = new JSONObject(true);
                        ArrayList serialList = Lists.newArrayList();
                        for (Map map : showInvoiceArray) {
                            String string = String.valueOf(map.get("serialNo"));
                            serialList.add(string);
                            dataJson.put(string, (Object)map);
                        }
                        if (!serialList.isEmpty() && (attachMap = service.queryAttachBySerialNosCondition(serialList)) != null) {
                            for (Map map : showInvoiceArray) {
                                String serialNo = String.valueOf(map.get("serialNo"));
                                map.put("attachList", attachMap.get(serialNo));
                            }
                        }
                        logger.info("\u6392\u5e8f\u540e\u7684\u53d1\u7968\u6570\u636e\u7ed3\u6784:{}-{}-{}", new Object[]{pageId, dataJson.size(), dataJson});
                        logger.info("cacheInvoiceList sort \u91cd\u65b0\u6392\u5e8f\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start3));
                        long start4 = System.currentTimeMillis();
                        dataJson = service.verifySequenceNoCondition(customParam, dataJson);
                        FpzsMainService.setInvoiceDataCache(pageId, SerializationUtils.toJsonString((Object)dataJson));
                        if (!CollectionUtils.isEmpty((Collection)attachArray)) {
                            FpzsMainService.cacheAttach(pageId, attachArray);
                        }
                        logger.info("cacheInvoiceList verifySequenceNo setInvoiceDataCache \u8017\u65f6\uff1a{}-{}", (Object)pageId, (Object)(System.currentTimeMillis() - start4));
                        logger.info("cacheInvoiceList\u603b\u8017\u65f6:{}-{}", (Object)pageId, (Object)(System.currentTimeMillis() - starttime));
                        Pair pair = Pair.of((Object)dataJson, (Object)repeatFlag);
                        return pair;
                    }
                    finally {
                        lock.unlock();
                    }
                }
                logger.info("cacheInvoiceList no get lock times :{}-{}", (Object)pageId, (Object)times);
            }
        }
        JSONObject json = new JSONObject();
        json.put("invoiceArray", (Object)invoiceArray);
        json.put("attachArray", (Object)attachArray);
        logger.info("cacheInvoiceList no get lock to list:{}-{}", (Object)pageId, (Object)json.toJSONString());
        CacheHelper.lpush(listCacheKey, json.toJSONString());
        CacheHelper.lpush("rim_cache_list_keys", pageId);
        return Pair.of(null, (Object)repeatFlag);
    }

    public static List<Map<String, Object>> queryAttachBySerialNo(String serialNo) {
        if (StringUtils.isEmpty((CharSequence)serialNo)) {
            return null;
        }
        QFilter qFilters = new QFilter("relation_id", "=", (Object)serialNo);
        qFilters.and(new QFilter("relation_type", "=", (Object)"3"));
        DynamicObjectCollection attach = QueryServiceHelper.query((String)"rim_attach_relation", (String)"relation_id,attach_id", (QFilter[])new QFilter[]{qFilters});
        ArrayList attIdList = Lists.newArrayList();
        attach.stream().forEach(c -> {
            Long attId = c.getLong("attach_id");
            attIdList.add(attId);
        });
        MainEntityType attachEntityType = EntityMetadataCache.getDataEntityType((String)"rim_attach");
        DynamicObject[] attachList = BusinessDataServiceHelper.load((Object[])attIdList.toArray(), (DynamicObjectType)attachEntityType);
        List<Map<String, Object>> result = DynamicObjectUtil.dynamicObjects2ListMap(attachList, true);
        logger.info("\u53d1\u7968serialNo:{}, \u9644\u4ef6\uff1a{}", (Object)serialNo, result);
        return result;
    }

    public static Map<String, List<Map<String, Object>>> queryAttachBySerialNos(List<String> serialNos) {
        if (serialNos.isEmpty()) {
            return null;
        }
        HashMap result = Maps.newHashMap();
        QFilter qFilters = new QFilter("relation_id", "in", serialNos);
        qFilters.and(new QFilter("relation_type", "=", (Object)"3"));
        DynamicObjectCollection attach = QueryServiceHelper.query((String)"rim_attach_relation", (String)"relation_id,attach_id", (QFilter[])new QFilter[]{qFilters});
        if (!CollectionUtils.isEmpty((Collection)attach)) {
            String relationId;
            HashMap map = Maps.newHashMap();
            for (DynamicObject att : attach) {
                relationId = att.getString("relation_id");
                StringBuilder attachId = new StringBuilder(att.getString("attach_id"));
                StringBuilder savedValue = (StringBuilder)map.get(relationId);
                if (savedValue != null) {
                    map.put(relationId, savedValue.append(',').append((CharSequence)attachId));
                    continue;
                }
                map.put(relationId, attachId);
            }
            for (Map.Entry entry : map.entrySet()) {
                relationId = (String)entry.getKey();
                MainEntityType attachEntityType = EntityMetadataCache.getDataEntityType((String)"rim_attach");
                String[] attachIds = ((StringBuilder)entry.getValue()).toString().split(",");
                DynamicObject[] attachList = BusinessDataServiceHelper.load((Object[])Arrays.stream(attachIds).map(s -> Long.parseLong(s.trim())).toArray(), (DynamicObjectType)attachEntityType);
                List<Map<String, Object>> attachs = DynamicObjectUtil.dynamicObjects2ListMap(attachList, true);
                result.put(relationId, attachs);
            }
        }
        return result;
    }

    private static void dealUnSaveInvoice(JSONObject invoiceJson) {
        invoiceJson.put("errorLevel", (Object)"0");
        invoiceJson.put("validateMessage_html", (Object)VerifyConstant.getForbidHtml());
        if (StringUtils.isNotBlank((CharSequence)invoiceJson.getString("errorMsg"))) {
            invoiceJson.put("validateMessage_html", (Object)VerifyConstant.getForbidHtml(invoiceJson.getString("errorMsg")));
        }
        String awsType = InputInvoiceTypeEnum.getAwsType(invoiceJson.getLong("invoiceType"));
        StringBuilder invoice_info = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)awsType)) {
            invoice_info.append("ty_").append(awsType).append(',');
        }
        if (InvoiceConvertUtils.isVatInvoiceType(invoiceJson.getLong("invoiceType"))) {
            invoice_info.append("ch_3").append(',');
        }
        if (StringUtils.isEmpty((CharSequence)invoiceJson.getString("serialNo"))) {
            invoiceJson.put("serialNo", (Object)UUID.randomUUIDZero());
        }
        invoiceJson.put("invoice_info", (Object)invoice_info);
        invoiceJson.put("notInDB", (Object)"1");
    }

    public static void updateInvoiceGrid(AbstractFormPlugin plugin, JSONObject invoiceArray) {
        FpzsMainService.updateInvoiceGrid(plugin, invoiceArray, Boolean.TRUE);
    }

    public static void updateInvoiceGrid(AbstractFormPlugin plugin, JSONObject invoiceArray, Boolean showFilter) {
        logger.info("\u53d1\u7968\u7f16\u8f91\u4fee\u6539\u7ed3\u679c\uff1a" + invoiceArray);
        Object billType = plugin.getView().getFormShowParameter().getCustomParam("billType");
        Long orgId = BigDecimalUtil.transDecimal(plugin.getView().getFormShowParameter().getCustomParam("orgId")).longValue();
        String showOversea = plugin.getPageCache().get("showOversea");
        ArrayList<Column> columnList = new ArrayList<Column>(8);
        columnList.add(new Column(ResManager.loadKDString((String)"\u63d0\u793a", (String)"FpzsMainService_3", (String)"imc-rim-common", (Object[])new Object[0]), "status", "text-align:left;width:50px;position: sticky;z-index: 2;left: 50px", 0));
        columnList.add(new Column(ResManager.loadKDString((String)"\u9500\u65b9\u540d\u79f0", (String)"FpzsMainService_4", (String)"imc-rim-common", (Object[])new Object[0]), "salerName", "text-align:left;min-width:100px;overflow:hidden;", 1));
        columnList.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801", (String)"FpzsMainService_5", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceNo", "text-align:left;min-width:100px;"));
        columnList.add(new Column(ResManager.loadKDString((String)"\u5f00\u7968\u65e5\u671f", (String)"FpzsMainService_6", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceDate", "text-align:left;min-width:100px;"));
        columnList.add(new Column(ResManager.loadKDString((String)"\u7a0e\u989d", (String)"FpzsMainService_7", (String)"imc-rim-common", (Object[])new Object[0]), "totalTaxAmount", "text-align:left;min-width:70px;"));
        columnList.add(new Column(ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1", (String)"FpzsMainService_8", (String)"imc-rim-common", (Object[])new Object[0]), "totalAmount", "text-align:left;min-width:70px;"));
        if ("true".equals(showOversea)) {
            columnList.add(new Column(ResManager.loadKDString((String)"\u5e01\u522b", (String)"FpzsMainService_23", (String)"imc-rim-common", (Object[])new Object[0]), "currencyName", "text-align:left;width:70px;"));
        }
        if ("personTicket".equals(billType + "")) {
            columnList.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u6807\u7b7e", (String)"FpzsMainService_22", (String)"imc-rim-common", (Object[])new Object[0]), "invoiceClass", "text-align:left;width:70px;"));
        }
        if (InvoiceConfigUtils.showInvoiceInfo()) {
            columnList.add(new Column(ResManager.loadKDString((String)"\u53d1\u7968\u4fe1\u606f", (String)"FpzsMainService_9", (String)"imc-rim-common", (Object[])new Object[0]), "invoice_info", "text-align:left;width:230px;"));
        }
        columnList.add(new Column(ResManager.loadKDString((String)"\u64cd\u4f5c\u5217", (String)"FpzsMainService_10", (String)"imc-rim-common", (Object[])new Object[0]), "operate", "text-align:left;width:70px;position: sticky;z-index: 2;right: 0"));
        String contextPath = RequestContext.get().getClientFullContextPath();
        ArrayList dataImportList = new ArrayList(16);
        ArrayList dataErrorList = new ArrayList(16);
        int i = 0;
        if (!ObjectUtils.isEmpty((Object)invoiceArray)) {
            for (Map.Entry entry : invoiceArray.entrySet()) {
                ++i;
                JSONObject obj = (JSONObject)entry.getValue();
                String invoiceType = obj.getString("invoiceType");
                String level = (String)obj.get((Object)"errorLevel");
                String validateMessage = obj.getString("validateMessage_html");
                ArrayList<Column> data = new ArrayList<Column>(8);
                data.add(new Column("rowkey", "rowkey", null, obj.getString("serialNo")));
                for (Column column : columnList) {
                    Object value;
                    boolean typeFlag = "11".equals(invoiceType) || "14".equals(invoiceType);
                    boolean fieldFlag = "invoiceDate".equals(column.getField());
                    if (typeFlag && fieldFlag) {
                        data.add(column.clone(""));
                        continue;
                    }
                    StringBuilder text = new StringBuilder();
                    if ("operate".equals(column.getField())) {
                        String showAttachUpload = plugin.getPageCache().get("showAttachUpload");
                        if (!(!StringUtils.isEmpty((CharSequence)showAttachUpload) && "false".equals(showAttachUpload) || !StringUtils.isEmpty((CharSequence)validateMessage) && validateMessage.contains(ResManager.loadKDString((String)"\u53d1\u7968\u5fc5\u8981\u5b57\u6bb5\u7f3a\u5931", (String)"FpzsMainService_11", (String)"imc-rim-common", (Object[])new Object[0])) || !showFilter.booleanValue())) {
                            text.append("<span class=\"_2fitdDwA unukSyOk kdfont kdfont-fujian3 kd-hover-color click_class\" clickkey=\"addAttach\" title=\"").append(ResManager.loadKDString((String)"\u4e0a\u4f20\u9644\u4ef6", (String)"FpzsMainService_12", (String)"imc-rim-common", (Object[])new Object[0])).append("\">&nbsp;</span>");
                        }
                        if (FpzsMainService.canEdit(obj).booleanValue() && showFilter.booleanValue()) {
                            text.append("<span class=\"_2fitdDwA unukSyOk kdfont kdfont-bianji kd-hover-color click_class\" clickkey=\"viewInvoice\" title=\"").append(ResManager.loadKDString((String)"\u7f16\u8f91", (String)"FpzsMainService_13", (String)"imc-rim-common", (Object[])new Object[0])).append("\"></span>");
                        } else {
                            text.append("<span class=\"_2fitdDwA unukSyOk kdfont kdfont-yanjing kd-hover-color click_class\" clickkey=\"viewInvoice\" title=\"").append(ResManager.loadKDString((String)"\u9884\u89c8", (String)"FpzsMainService_14", (String)"imc-rim-common", (Object[])new Object[0])).append("\"></span>");
                        }
                    } else if ("status".equals(column.getField())) {
                        String icons = null;
                        if ("0".equals(level) || "1".equals(level)) {
                            icons = "icons/pc/state/fail_28_28.png";
                        } else if ("2".equals(level)) {
                            icons = "icons/pc/state/remind_28_28.png";
                        }
                        if (icons != null) {
                            if (i > 4) {
                                text.append("<a class=\"outTipsText topTip\"><img class=\"tipIcon\" src=\"");
                            } else {
                                text.append("<a class=\"outTipsText bottomTip\"><img class=\"tipIcon\" src=\"");
                            }
                            text.append(contextPath);
                            text.append(icons).append("\"/><div class=\"tipsText\" style=\"display:block;\">");
                            text.append(obj.getString("validateMessage_html"));
                            text.append("</div></a>&nbsp;");
                        } else {
                            text.append("");
                        }
                    } else if ("invoice_info".equals(column.getField())) {
                        text.append(FpzsMainService.getImageKey(contextPath, obj.getString(column.getField())));
                    } else if ("invoiceClass".equals(column.getField())) {
                        HashMap mainMap = Maps.newHashMap();
                        String serialNo = obj.getString("serialNo");
                        DynamicObject invoiceMulClassInfo = BusinessDataServiceHelper.loadSingle((String)"rim_invoice", (String)"id,mul_class,mul_class.name", (QFilter[])new QFilter[]{new QFilter("serial_no", "=", (Object)serialNo)});
                        InvoiceClassService.getInstance().initInvoiceClass(mainMap, invoiceMulClassInfo);
                        Object invoiceClassName = mainMap.get("invoiceClassName");
                        String className = "";
                        if (invoiceClassName != null) {
                            className = invoiceClassName.toString();
                        }
                        text.append(className);
                    } else if ("currencyName".equals(column.getField())) {
                        if (!"30".equals(invoiceType) && !InputInvoiceTypeEnum.OVERSEA_INVOICE.getCode().toString().equals(invoiceType)) {
                            text.append("\u4eba\u6c11\u5e01");
                        } else {
                            value = obj.get((Object)column.getField());
                            if (value == null) {
                                text.append("");
                            } else {
                                text.append(value);
                            }
                        }
                    } else {
                        value = obj.get((Object)column.getField());
                        if (value == null) {
                            text.append("");
                        } else if ("totalTaxAmount".equals(column.getField()) || "totalAmount".equals(column.getField())) {
                            text.append(BigDecimalUtil.format(BigDecimalUtil.transDecimal(value), format));
                        } else {
                            text.append(DynamicObjectUtil.htmlEncode(value));
                        }
                    }
                    data.add(column.clone(text.toString()));
                }
                if (FpzsMainService.isFilter(obj).booleanValue()) {
                    dataErrorList.add(data);
                    continue;
                }
                dataImportList.add(data);
            }
        }
        String pageId = plugin.getView().getPageId();
        if (!showFilter.booleanValue()) {
            dataImportList.addAll(dataErrorList);
            dataErrorList.clear();
        }
        CustomControl control = (CustomControl)plugin.getControl("customcontrol_import");
        JSONObject map = new JSONObject();
        map.put("clomuns", columnList);
        map.put("data", dataImportList);
        map.put("tableId", (Object)(pageId + "import"));
        map.put("operate", (Object)"loadData");
        map.put("time", (Object)System.currentTimeMillis());
        control.setData((Object)map);
        if (showFilter.booleanValue()) {
            CustomControl control2 = (CustomControl)plugin.getControl("customcontrol_error");
            map = new JSONObject();
            map.put("clomuns", columnList);
            map.put("data", dataErrorList);
            map.put("tableId", (Object)(pageId + "error"));
            map.put("operate", (Object)"loadData");
            map.put("time", (Object)System.currentTimeMillis());
            control2.setData((Object)map);
        }
    }

    private static String getImageKey(String contextPath, String invoiceInfo) {
        if (invoiceInfo == null) {
            return "";
        }
        if (null == imgMap) {
            imgMap = FpzsMainService.getImgMap();
        }
        String[] items = invoiceInfo.split(",");
        StringBuilder sb = new StringBuilder();
        for (String item : items) {
            ValueMapItem img;
            if (MapUtils.isEmpty(imgMap) || (img = imgMap.get(item)) == null || !StringUtils.isNotEmpty((CharSequence)img.getImageKey())) continue;
            sb.append("<img src=\"").append(contextPath).append(img.getImageKey().substring(1));
            sb.append("\" title=\"").append(img.getName()).append("\"/>&nbsp;");
        }
        return sb.toString();
    }

    private static Map<String, ValueMapItem> getImgMap() {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"rim_invoice");
        DataEntityPropertyCollection mainPros = mainEntityType.getProperties();
        HashMap<String, ValueMapItem> map = new HashMap<String, ValueMapItem>(mainPros.size());
        for (IDataEntityProperty property : mainPros) {
            if (!property.getName().equals("invoice_info")) continue;
            MulComboProp prop = (MulComboProp)property;
            List items = prop.getComboItems();
            for (ValueMapItem item : items) {
                map.put(item.getValue(), item);
            }
            return map;
        }
        return new HashMap<String, ValueMapItem>(1);
    }

    public static Boolean isFilter(JSONObject obj) {
        if (obj == null) {
            return Boolean.TRUE;
        }
        String level = (String)obj.get((Object)"errorLevel");
        return "0".equals(level);
    }

    public static Boolean canEdit(JSONObject invoiceJson) {
        String expenseStatus = invoiceJson.getString("expenseStatus");
        if (StringUtils.isNotEmpty((CharSequence)expenseStatus) && !"1".equals(expenseStatus)) {
            return Boolean.FALSE;
        }
        String invoiceType = invoiceJson.getString("invoiceType");
        String checkStatus = invoiceJson.getString("checkStatus");
        Long type = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(invoiceType);
        if (InputInvoiceTypeEnum.needCheck(type).booleanValue() && "1".equals(checkStatus)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static JSONObject getInvoiceDataCache(String pageId) {
        String cache = CacheHelper.get(CACHE_INVOICE_DATA + pageId);
        if (StringUtils.isNotEmpty((CharSequence)cache)) {
            return new JSONObject((Map)JSONObject.parseObject((String)cache, LinkedHashMap.class));
        }
        return new JSONObject();
    }

    public static void getListCache(String pageId) {
        String listCacheKey = "listsinvoice_" + pageId;
        String rpop = CacheHelper.rpop(listCacheKey);
        if (StringUtils.isNotEmpty((CharSequence)rpop)) {
            JSONObject json = JSON.parseObject((String)rpop);
            JSONArray invoiceArray = json.getJSONArray("invoiceArray");
            JSONArray attachArray = json.getJSONArray("attachArray");
            Map<String, Object> customParam = FpzsMainService.getCustomParam(pageId);
            FpzsMainService.cacheInvoiceList(pageId, customParam, invoiceArray, attachArray);
        }
    }

    public static void deleteListCache(String pageId) {
        CacheHelper.remove("listsinvoice_" + pageId);
        CacheHelper.remove("listscaner_" + pageId);
        ThreadPools.executeOnceIncludeRequestContext((String)"AsyncFpzsDeleteListCache", () -> CommonUtils.deleteCache(1000));
    }

    public static void cacheCustomParam(AbstractFormPlugin plugin, String content) {
        plugin.getPageCache().put(CAHCE_CUSTOM_PARAM, content);
    }

    public static JSONObject cacheCustomParam(AbstractFormPlugin plugin) {
        Map customParams = plugin.getView().getFormShowParameter().getCustomParams();
        return FpzsMainService.cacheCustomParam(plugin, customParams);
    }

    public static JSONObject cacheCustomParam(AbstractFormPlugin plugin, Map<String, Object> customParams) {
        Long orgId;
        String sourceSys;
        String jsonStr = SerializationUtils.toJsonString(customParams);
        logger.info("cacheCustomParam:" + jsonStr);
        JSONObject jsonObj = JSON.parseObject((String)jsonStr);
        String eventCode = jsonObj.getString("eventCode");
        RequestContext requestContext = RequestContext.get();
        if (StringUtils.isNotEmpty((CharSequence)eventCode)) {
            String pushType;
            JSONObject json = new JSONObject();
            String body = CacheHelper.get("rim_event_code:" + eventCode);
            if (body == null) {
                plugin.getView().showErrorNotification(ResManager.loadKDString((String)"eventCode\u5df2\u5931\u6548", (String)"FpzsMainService_15", (String)"imc-rim-common", (Object[])new Object[0]));
                return json;
            }
            JSONObject bodyJson = JSON.parseObject((String)body);
            String resource = bodyJson.getString("resource");
            json.put("resource", (Object)resource);
            String sourceSys2 = bodyJson.getString("sourceSys");
            if (StringUtils.isEmpty((CharSequence)sourceSys2)) {
                sourceSys2 = resource;
            }
            if (StringUtils.isEmpty((CharSequence)sourceSys2)) {
                sourceSys2 = FPZS_SOURCESYS;
            }
            json.put("sourceSys", (Object)sourceSys2);
            json.put("billType", (Object)bodyJson.getString("billType"));
            json.put("billNo", (Object)bodyJson.getString("billNo"));
            json.put("billId", (Object)bodyJson.getString("billId"));
            if (StringUtils.isNotEmpty((CharSequence)bodyJson.getString("multiTenant"))) {
                json.put("multiTenant", (Object)bodyJson.getString("multiTenant"));
            }
            if (StringUtils.isEmpty((CharSequence)(pushType = bodyJson.getString("pushType")))) {
                pushType = "socket";
            }
            json.put("pushType", (Object)pushType);
            json.put("linkKey", (Object)bodyJson.getString("linkKey"));
            json.put("indexPageId", (Object)bodyJson.getString("linkKey"));
            json.put("entityId", (Object)bodyJson.getString("billType"));
            json.put("viewPage", (Object)"");
            json.put("billTaxNo", (Object)bodyJson.getString("billTaxNo"));
            json.put("rim_user", bodyJson.get((Object)"rim_user"));
            json.put("openId", (Object)bodyJson.getString("openId"));
            json.put(InvoiceSaveConstant.OPERATE_USER_ID, (Object)bodyJson.getString(InvoiceSaveConstant.OPERATE_USER_ID));
            Long orgId2 = BigDecimalUtil.transDecimal(bodyJson.get((Object)"orgId")).longValue();
            if (orgId2 < 1L) {
                orgId2 = RequestContext.get().getOrgId();
            }
            json.put("taxNo", (Object)TenantUtils.getTaxNoByOrgId(orgId2));
            json.put("orgId", (Object)orgId2);
            json.put("org_id", (Object)orgId2);
            if (StringUtils.isNotEmpty((CharSequence)bodyJson.getString("baseUrl"))) {
                json.put("baseurl", (Object)bodyJson.getString("baseUrl"));
            }
            VerifyService.convertBuyerInfo(bodyJson, json);
            VerifyService.convertSalerInfo(bodyJson, json);
            FpzsMainService.addCustomFields(jsonObj, json);
            logger.info("cacheCustomParam:" + json);
            InvoiceLog.insertExpenseLog(ResManager.loadKDString((String)"\u5916\u90e8\u7cfb\u7edf\u63a5\u5165\u53d1\u7968\u52a9\u624b", (String)"FpzsMainService_16", (String)"imc-rim-common", (Object[])new Object[0]), json.getString("billId"), json.getString("billNo"), json.toJSONString());
            plugin.getPageCache().put(CAHCE_CUSTOM_PARAM, json.toJSONString());
            return json;
        }
        JSONObject json = new JSONObject();
        String resource = jsonObj.getString("resource");
        json.put("billType", (Object)jsonObj.getString("billType"));
        json.put("billNo", (Object)jsonObj.getString("billNo"));
        json.put("billId", (Object)jsonObj.getString("billId"));
        json.put("entityId", (Object)jsonObj.getString("entityId"));
        json.put("viewPage", (Object)jsonObj.getString("viewPage"));
        json.put("linkKey", (Object)jsonObj.getString("linkKey"));
        json.put("resource", (Object)resource);
        String userDelete = jsonObj.getString("delete");
        if ("2".equals(userDelete)) {
            json.put("delete", (Object)"2");
        }
        if (StringUtils.isEmpty((CharSequence)(sourceSys = jsonObj.getString("sourceSys")))) {
            json.put("sourceSys", (Object)FPZS_SOURCESYS);
        } else {
            json.put("sourceSys", (Object)jsonObj.getString("sourceSys"));
        }
        String invoiceBox = jsonObj.getString("invoiceBox");
        if (StringUtils.isEmpty((CharSequence)sourceSys)) {
            json.put("invoiceBox", (Object)invoiceBox);
        }
        if ((orgId = Long.valueOf(BigDecimalUtil.transDecimal(jsonObj.get((Object)"orgId")).longValue())) < 1L) {
            orgId = RequestContext.get().getOrgId();
        }
        json.put("orgId", (Object)orgId);
        json.put("org_id", (Object)orgId);
        if ("expense_mobile".equals(resource) || "expense_pc".equals(resource)) {
            json.put("rim_user", jsonObj.get((Object)"rim_user"));
            json.put("bill_user", (Object)jsonObj.getString("bill_user"));
            json.put("reimburser", jsonObj.get((Object)"reimburser"));
            json.put("reimburserName", jsonObj.get((Object)"reimburserName"));
        } else {
            json.put("rim_user", (Object)0L);
        }
        json.put("openId", (Object)MD5.md5Hex(requestContext.getTenantId() + requestContext.getUserId()));
        JSONArray companyInfo = jsonObj.getJSONArray("companyInfo");
        json.put("companyInfo", (Object)companyInfo);
        String taxNo = TenantUtils.getTaxNoByOrgId(orgId);
        if (companyInfo != null) {
            VerifyService.convertBuyerInfo(jsonObj, json);
        } else {
            JSONObject invoiceCfg;
            boolean isOperation = jsonObj.getBooleanValue("isOperation");
            if (isOperation && (invoiceCfg = InvoiceConfigUtils.getInvoiceConfig(orgId)) != null) {
                json.put("buyer_tax_no", invoiceCfg.get((Object)"buyer_tax_no"));
                json.put("buyer_name", invoiceCfg.get((Object)"buyer_name"));
            }
        }
        VerifyService.convertSalerInfo(jsonObj, json);
        json.put("taxNo", (Object)taxNo);
        String fpzsPageId = jsonObj.getString("fpzsPageId");
        if (StringUtils.isEmpty((CharSequence)fpzsPageId)) {
            json.put("indexPageId", (Object)plugin.getView().getPageId());
        } else {
            json.put("indexPageId", (Object)fpzsPageId);
        }
        FpzsMainService.addCustomFields(jsonObj, json);
        logger.info("cacheCustomParam:" + json);
        logger.info("\u79fb\u52a8\u7aef\u9996\u9875pageId\uff1a", (Object)plugin.getView().getPageId());
        InvoiceLog.insertExpenseLog(ResManager.loadKDString((String)"\u8fdb\u5165\u53d1\u7968\u52a9\u624b", (String)"FpzsMainService_17", (String)"imc-rim-common", (Object[])new Object[0]), json.getString("billId"), json.getString("billNo"), json.toJSONString());
        plugin.getPageCache().put(CAHCE_CUSTOM_PARAM, json.toJSONString());
        return json;
    }

    private static void addCustomFields(JSONObject json, JSONObject returnJson) {
        try {
            JSONObject customFields = json.getJSONObject("customFields");
            if (customFields != null) {
                returnJson.putAll((Map)customFields);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Map<String, Object> getCustomParam(AbstractFormPlugin plugin) {
        return FpzsMainService.getCustomParam(plugin.getView().getPageId());
    }

    public static Map<String, Object> getCustomParam(String pageId) {
        PageCache pageCache = new PageCache(pageId);
        String cache = pageCache.get(CAHCE_CUSTOM_PARAM);
        if (StringUtils.isNotEmpty((CharSequence)cache)) {
            return JSON.parseObject((String)cache);
        }
        return new HashMap<String, Object>(16);
    }

    public static JSONObject getBusinessParam(String pageId, String collectType) {
        JSONObject businessParam = new JSONObject();
        logger.info("\u79fb\u52a8\u7aef\u9996\u9875pageId2\uff1a" + pageId);
        PageCache cache = new PageCache(pageId);
        String jsonStr = new PageCache(pageId).get(CAHCE_CUSTOM_PARAM);
        String tabSelect = cache.get("tabSelect");
        businessParam.put("collect_type", (Object)collectType);
        if (!StringUtils.isEmpty((CharSequence)jsonStr)) {
            JSONObject paramObj = JSON.parseObject((String)jsonStr);
            String sourceSys = paramObj.getString("sourceSys");
            businessParam.put("org_id", paramObj.get((Object)"orgId"));
            businessParam.put("tax_no", paramObj.get((Object)"taxNo"));
            Object rim_user = paramObj.get((Object)"rim_user");
            if (rim_user != null) {
                businessParam.put("rim_user", rim_user);
            } else {
                businessParam.put("rim_user", (Object)0L);
            }
            String userDelete = paramObj.getString("delete");
            if ("2".equals(userDelete)) {
                businessParam.put("delete", (Object)"2");
            }
            if (!StringUtils.isEmpty((CharSequence)sourceSys)) {
                businessParam.put("resource", (Object)sourceSys);
            } else {
                businessParam.put("resource", (Object)paramObj.getString("resource"));
            }
            if ("tab_oversea".equals(tabSelect)) {
                businessParam.put("recogType", (Object)"2");
            }
            businessParam.put(InvoiceSaveConstant.OPERATE_USER_ID, (Object)paramObj.getString(InvoiceSaveConstant.OPERATE_USER_ID));
        }
        logger.info("\u53d1\u7968\u52a9\u624b\u4e1a\u52a1\u53c2\u6570\uff1a" + businessParam);
        return businessParam;
    }

    public static JSONObject getOperateConfigMap(String billType, String configKey, Long orgId) {
        JSONObject configMap = new JSONObject();
        if (StringUtils.isEmpty((CharSequence)billType)) {
            return FpzsMainService.defaultOperateConfig(configKey, "1");
        }
        DynamicObject fpzsConfigObj = FpzsMainService.getConfigObj(billType, orgId);
        if (fpzsConfigObj != null) {
            String pcConfigStr = fpzsConfigObj.getString(configKey);
            if (StringUtils.isNotEmpty((CharSequence)pcConfigStr)) {
                configMap = JSONObject.parseObject((String)pcConfigStr);
            }
        } else {
            configMap = FpzsMainService.defaultOperateConfig(configKey, "1");
        }
        return configMap;
    }

    public static DynamicObject getConfigObj(String billType, Long orgId) {
        if (orgId == null || orgId <= 0L) {
            orgId = RequestContext.get().getOrgId();
        }
        QFilter fpzsConfigFilter = new QFilter("status", "=", (Object)"1");
        QFilter scopeFilter = new QFilter("scope", "=", (Object)true).or("rim_fpzs_config_org.org", "=", (Object)orgId);
        String fields = PropertieUtil.getAllPropertiesSplitByComma("rim_fpzs_config", true);
        Object config = null;
        Object[] fpzsConfigObjs = BusinessDataServiceHelper.load((String)"rim_fpzs_config", (String)fields, (QFilter[])new QFilter[]{fpzsConfigFilter, scopeFilter}, (String)"modifydate desc");
        if (!ObjectUtils.isEmpty((Object[])fpzsConfigObjs)) {
            Integer level = 0;
            for (Object obj : fpzsConfigObjs) {
                Integer templevel = FpzsMainService.getLevel((DynamicObject)obj, billType, orgId);
                if (templevel <= level) continue;
                config = obj;
                level = templevel;
            }
        }
        if (config != null) {
            logger.info("\u914d\u7f6eid:{},number:{},billType:{},org:{}", new Object[]{config.get("id"), config.get("schema_number"), billType, orgId});
        }
        return config;
    }

    private static Integer getLevel(DynamicObject object, String paramBillType, Long paramOrg) {
        boolean scope = object.getBoolean("scope");
        String suitableBillTypes = object.getString("suitable_bill_types");
        DynamicObjectCollection billTypes = object.getDynamicObjectCollection("rim_fpzs_config_entry");
        DynamicObjectCollection orgs = object.getDynamicObjectCollection("rim_fpzs_config_org");
        Set orgSet = orgs.stream().map(s -> DynamicObjectUtil.getDynamicObjectLongValue(s.get("org"))).collect(Collectors.toSet());
        Set billTypeSet = billTypes.stream().map(s -> s.getString("bill_number")).collect(Collectors.toSet());
        if (scope) {
            if (CollectionUtils.isEmpty(billTypeSet)) {
                return 13;
            }
            if (StringUtils.isNotEmpty((CharSequence)paramBillType) && billTypeSet.contains(paramBillType)) {
                return 15;
            }
            if ("1".equals(suitableBillTypes)) {
                return 14;
            }
            return 10;
        }
        if (orgSet.contains(paramOrg)) {
            if (CollectionUtils.isEmpty(billTypeSet)) {
                return 23;
            }
            if (StringUtils.isNotEmpty((CharSequence)paramBillType) && billTypeSet.contains(paramBillType)) {
                return 25;
            }
            if ("1".equals(suitableBillTypes)) {
                return 24;
            }
            return 20;
        }
        if (billTypeSet.contains(paramBillType)) {
            return 8;
        }
        return 1;
    }

    public static Boolean showOperateFpzs(AbstractFormPlugin formPlugin, String billType, String tab, Long orgId) {
        String invoiceShowType;
        if (StringUtils.isEmpty((CharSequence)tab)) {
            throw new KDBizException(ResManager.loadKDString((String)"FpzsMainService-showOperateFpzs\u4e0d\u80fd\u4f20\u5165\u7a7a\u7684tab\u9875\u7b7e\u540d", (String)"FpzsMainService_18", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        JSONObject pcConfigMap = FpzsMainService.getOperateConfigMap(billType, "pc_config_tag", orgId);
        IFormView view = formPlugin.getView();
        IDataModel model = view.getModel();
        String operateSuffix = "";
        String[] defaultOperate = new String[]{};
        Boolean showTab = Boolean.TRUE;
        String entityId = view.getEntityId();
        if (tab.endsWith("invoice")) {
            defaultOperate = FpzsConstant.default_operate;
            invoiceShowType = (String)pcConfigMap.get((Object)"pc_invoice");
            if (StringUtils.isNotEmpty((CharSequence)billType)) {
                showTab = FpzsMainService.getPermissionResult(invoiceShowType, "2V028XVEL=BE", entityId);
            }
        } else if (tab.endsWith("attach")) {
            defaultOperate = FpzsConstant.default_attach_operate;
            operateSuffix = "_attach";
            invoiceShowType = (String)pcConfigMap.get((Object)"pc_attach");
            if (StringUtils.isNotEmpty((CharSequence)billType)) {
                showTab = FpzsMainService.getPermissionResult(invoiceShowType, "2V02Q0K5CRVZ", entityId);
            }
        } else if (tab.endsWith("oversea")) {
            defaultOperate = FpzsConstant.default_oversea_operate;
            invoiceShowType = (String)pcConfigMap.get((Object)"pc_oversea");
            if (StringUtils.isNotEmpty((CharSequence)billType)) {
                showTab = FpzsMainService.getPermissionResult(invoiceShowType, "2V023RWTG3GO", entityId);
            }
        } else if (tab.endsWith("contract")) {
            defaultOperate = FpzsConstant.default_contract_operate;
            operateSuffix = "_contract";
            invoiceShowType = (String)pcConfigMap.get((Object)"pc_contract");
            showTab = FpzsMainService.getPermissionResult(invoiceShowType, "2V02J5HYVQMX", entityId);
        }
        if (!showTab.booleanValue()) {
            return showTab;
        }
        model.deleteEntryData(OPERATE_ENTRY.concat(operateSuffix));
        DynamicObjectCollection entryEntity = model.getEntryEntity(OPERATE_ENTRY1);
        if (entryEntity != null) {
            model.deleteEntryData(OPERATE_ENTRY1);
        }
        int tabCount = 0;
        for (String name : defaultOperate) {
            String permItem;
            String showType = FpzsMainService.getShowType((Map<String, Object>)pcConfigMap, name);
            Boolean showCurrentItem = FpzsMainService.getPermissionResult(showType, permItem = FpzsConstant.createPermMap().get(name), entityId);
            if (!showCurrentItem.booleanValue()) {
                if (!"operate_attach_upload".equals(name)) continue;
                formPlugin.getPageCache().put("showAttachUpload", "false");
                continue;
            }
            if ("operate_upload".equals(name) || "pc_oversea_file_upload".equals(name)) {
                CustomControl uploadControl = (CustomControl)formPlugin.getControl("custom_upload");
                String title = "";
                title = "operate_upload".equals(name) ? FpzsConstant.getOperateTip(ResManager.loadKDString((String)"\u4ece\u7535\u8111\u672c\u5730\u9009\u62e9\u53d1\u7968\uff08\u589e\u503c\u7a0e\u7535\u5b50/\u7eb8\u8d28\u53d1\u7968\u3001\u706b\u8f66\u6c7d\u8f66\u98de\u673a\u7968\u3001\u5b9a\u989d\u53d1\u7968\u7b49\uff09\u4e0a\u4f20\uff0c\u652f\u6301\u6587\u4ef6\u683c\u5f0fPDF\u3001OFD\u3001\u56fe\u7247\u3001EXCEL", (String)"FpzsMainService_19", (String)"imc-rim-common", (Object[])new Object[0]), "operate_upload") : FpzsConstant.getOperateTip(ResManager.loadKDString((String)"\u9009\u53d6\u672c\u5730\u6587\u4ef6\uff0c\u652f\u6301\u4e0a\u4f20\u56fe\u7247\u3001PDF\u683c\u5f0f\u7684\u53d1\u7968", (String)"FpzsConstant_19", (String)"imc-rim-common", (Object[])new Object[0]), "pc_oversea_file_upload");
                String excelImportType = FpzsMainService.getShowType((Map<String, Object>)pcConfigMap, "operate_excel_import");
                ScannerService.initUpload(uploadControl, "1".equals(excelImportType), title, name);
                if ("0".equals(excelImportType)) {
                    formPlugin.getView().setVisible(Boolean.FALSE, new String[]{"excel_download"});
                }
            }
            FpzsMainService.showOperateInfo(view, name, operateSuffix);
            ++tabCount;
        }
        if (tabCount == 0) {
            return Boolean.FALSE;
        }
        return showTab;
    }

    public static Boolean getPermissionResult(String configShowType, String permItem, String formId) {
        RequestContext request = RequestContext.get();
        if ("1".equals(configShowType)) {
            return Boolean.TRUE;
        }
        if ("2".equals(configShowType) || StringUtils.isEmpty((CharSequence)configShowType)) {
            int checkPerm = PermissionServiceHelper.checkPermission((Long)Long.parseLong(request.getUserId()), (Long)request.getOrgId(), (String)"rim", (String)formId, (String)permItem);
            if (checkPerm <= 0) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private static void showOperateInfo(IFormView view, String operateType, String operateSuffix) {
        IDataModel model = view.getModel();
        ClientViewProxy client = (ClientViewProxy)view.getService(IClientViewProxy.class);
        int index = 0;
        String opreateName = FpzsConstant.getOperateName(operateType);
        HashMap pmap = new HashMap(2);
        Map<String, String> iconMap = FpzsConstant.createIconMap();
        HashMap<String, String> operateIconPropMap = new HashMap<String, String>(2);
        operateIconPropMap.put("bgik", iconMap.get(operateType));
        HashMap<String, Object> operateHoverPropMap = new HashMap<String, Object>(4);
        String operateIconKey = "operate_icon";
        String operateTypeKey = "operate_type_name";
        String methodKey = OPERATE_ENTRY.concat(operateSuffix);
        if (operateType.contains("oversea")) {
            operateIconKey = "operate_icon1";
            operateTypeKey = "operate_type_name1";
            methodKey = OPERATE_ENTRY1.concat(operateSuffix);
            index = model.createNewEntryRow(OPERATE_ENTRY1.concat(operateSuffix));
            model.setValue("operate_type1".concat(operateSuffix), (Object)operateType, index);
        } else {
            index = model.createNewEntryRow(OPERATE_ENTRY.concat(operateSuffix));
            model.setValue(OPERATE_TYPE.concat(operateSuffix), (Object)operateType, index);
        }
        String tip = FpzsConstant.getOperateTips(operateType);
        HashMap<String, String> tips = new HashMap<String, String>(2);
        tips.put("type", "text");
        tips.put("content", (String)new LocaleString(tip));
        operateHoverPropMap.put("tips", tips);
        operateHoverPropMap.put("text", opreateName);
        pmap.put(operateIconKey.concat(operateSuffix), operateIconPropMap);
        pmap.put(operateTypeKey.concat(operateSuffix), operateHoverPropMap);
        client.invokeControlMethod(methodKey, "setCustomProperties", new Object[]{index, pmap});
    }

    public static JSONObject defaultOperateConfig(String configKey, String showType) {
        if (StringUtils.isEmpty((CharSequence)configKey) || configKey.contains("pc")) {
            int i;
            JSONObject pcConfig = new JSONObject();
            for (i = 0; i < FpzsConstant.default_operate.length; ++i) {
                pcConfig.put(FpzsConstant.default_operate[i], (Object)showType);
            }
            pcConfig.put("operate_excel_import", (Object)showType);
            for (i = 0; i < FpzsConstant.default_attach_operate.length; ++i) {
                pcConfig.put(FpzsConstant.default_attach_operate[i], (Object)showType);
            }
            pcConfig.put("pc_invoice", (Object)"1");
            pcConfig.put("pc_oversea", (Object)"0");
            pcConfig.put("pc_contract", (Object)"1");
            pcConfig.put("pc_attach", (Object)"1");
            return pcConfig;
        }
        JSONObject mobileConfig = new JSONObject();
        for (int i = 0; i < FpzsConstant.default_mob_invoice_operate.length; ++i) {
            mobileConfig.put(FpzsConstant.default_mob_invoice_operate[i], (Object)showType);
        }
        for (int j = 0; j < FpzsConstant.default_mob_attach_operate.length; ++j) {
            mobileConfig.put(FpzsConstant.default_mob_attach_operate[j], (Object)showType);
        }
        mobileConfig.put("mob_invoice_pocket", (Object)showType);
        mobileConfig.put("mob_attach_pocket", (Object)showType);
        mobileConfig.put("mobile_invoice", (Object)"1");
        mobileConfig.put("mobile_attach", (Object)"1");
        mobileConfig.put("mobile_oversea", (Object)"1");
        return mobileConfig;
    }

    private static String getShowType(Map<String, Object> typeObject, String type) {
        if (typeObject == null) {
            return "2";
        }
        String show = (String)typeObject.get(type);
        if (StringUtils.isEmpty((CharSequence)show)) {
            return "2";
        }
        return show;
    }

    public static void setInvoiceDataCache(String pageId, String data) {
        CacheHelper.put(CACHE_INVOICE_DATA + pageId, data, 3600);
    }

    public static void setAttachDataCache(String pageId, String data) {
        CacheHelper.put(CACHE_ATTACH_DATA + pageId, data, 3600);
    }

    public static JSONArray getAttachDataCache(String pageId) {
        String cache = CacheHelper.get(CACHE_ATTACH_DATA + pageId);
        if (StringUtils.isNotEmpty((CharSequence)cache)) {
            return JSONArray.parseArray((String)cache);
        }
        return new JSONArray();
    }

    public static void removeAttachDataCache(String pageId) {
        CacheHelper.remove(CACHE_ATTACH_DATA + pageId);
    }

    private static void cacheAttach(String pageId, JSONArray attachArray) {
        JSONArray result = new JSONArray();
        JSONArray attachDataCache = FpzsMainService.getAttachDataCache(pageId);
        ArrayList existIds = Lists.newArrayList();
        if (!attachDataCache.isEmpty()) {
            for (int k = 0; k < attachDataCache.size(); ++k) {
                JSONObject attachCacheInfo = attachDataCache.getJSONObject(k);
                Long attachCacheId = attachCacheInfo.getLong("id");
                if (existIds.contains(attachCacheId)) continue;
                existIds.add(attachCacheId);
            }
            for (int i = 0; i < attachArray.size(); ++i) {
                JSONObject attachInfo = attachArray.getJSONObject(i);
                Long attachId = attachInfo.getLong("id");
                if (existIds.contains(attachId)) continue;
                result.add((Object)attachInfo);
            }
            attachDataCache.addAll((Collection)result);
            FpzsMainService.setAttachDataCache(pageId, attachDataCache.toJSONString());
        } else {
            FpzsMainService.setAttachDataCache(pageId, SerializationUtils.toJsonString((Object)attachArray));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void cacheAttachList(String pageId, String attachArrayStr) {
        try (DLock lock = DLock.create((String)("cacheAttach" + pageId), (String)ResManager.loadKDString((String)"\u5237\u65b0\u5361\u7247\u9501", (String)"FpzsMainService_0", (String)"imc-rim-common", (Object[])new Object[0]));){
            for (int times = 0; times < 30; ++times) {
                if (!lock.tryLock(500L)) continue;
                try {
                    times = 200;
                    FpzsMainService.cacheAttach(pageId, JSON.parseArray((String)attachArrayStr));
                    logger.info("\u53d1\u7968\u52a9\u624b\u7f13\u5b58\u9644\u4ef6\u4fe1\u606f:{}", (Object)attachArrayStr);
                    return;
                }
                finally {
                    lock.unlock();
                    return;
                }
            }
        }
    }

    public AbstractFormPlugin getPlugin() {
        return this.plugin;
    }

    public void setPlugin(AbstractFormPlugin plugin) {
        this.plugin = plugin;
    }

    public static JSONObject getViewCustomParam(Map<String, Object> customParams) {
        String jsonStr = SerializationUtils.toJsonString(customParams);
        JSONObject jsonObj = JSONObject.parseObject((String)jsonStr);
        String eventCode = jsonObj.getString("eventCode");
        JSONObject json = new JSONObject();
        if (StringUtils.isNotEmpty((CharSequence)eventCode)) {
            String body = CacheHelper.get("rim_event_code:" + eventCode);
            if (body == null) {
                return json;
            }
            JSONObject bodyJson = JSONObject.parseObject((String)body);
            json.put("resource", (Object)bodyJson.getString("resource"));
            json.put("billType", (Object)bodyJson.getString("billType"));
            json.put("billNo", (Object)bodyJson.getString("billNo"));
            json.put("billId", (Object)bodyJson.getString("billId"));
            json.put("pushType", (Object)bodyJson.getString("pushType"));
            json.put("linkKey", (Object)bodyJson.getString("linkKey"));
            json.put("entityId", (Object)bodyJson.getString("billType"));
            json.put("viewPage", (Object)bodyJson.getString("viewPage"));
            json.put("billTaxNo", (Object)bodyJson.getString("billTaxNo"));
            JSONArray serialNos = bodyJson.getJSONArray("serialNos");
            if (serialNos == null) {
                serialNos = bodyJson.getJSONArray("serialList");
            }
            json.put("serialNos", (Object)serialNos);
            Object relevanceExpenseId = jsonObj.get((Object)"relevanceExpenseId");
            if (relevanceExpenseId instanceof String) {
                String[] relevanceExpenseIdArr = ((String)relevanceExpenseId).split(",");
                json.put("relevanceExpenseId", Arrays.stream(relevanceExpenseIdArr).collect(Collectors.toList()));
            } else if (relevanceExpenseId instanceof JSONArray) {
                json.put("relevanceExpenseId", relevanceExpenseId);
            }
            Long orgId = BigDecimalUtil.transDecimal(bodyJson.get((Object)"orgId")).longValue();
            if (orgId < 1L) {
                orgId = RequestContext.get().getOrgId();
            }
            json.put("orgId", (Object)orgId);
            json.put("org_id", (Object)orgId);
            VerifyService.convertBuyerInfo(bodyJson, json);
            VerifyService.convertSalerInfo(bodyJson, json);
        } else {
            json.put("billType", (Object)jsonObj.getString("billType"));
            json.put("billNo", (Object)jsonObj.getString("billNo"));
            json.put("billId", (Object)jsonObj.getString("billId"));
            if (StringUtils.isEmpty((CharSequence)jsonObj.getString("billId"))) {
                json.put("billId", (Object)jsonObj.getString("expenseId"));
            }
            json.put("entityId", (Object)jsonObj.getString("entityId"));
            json.put("viewPage", (Object)jsonObj.getString("viewPage"));
            Long orgId = BigDecimalUtil.transDecimal(jsonObj.get((Object)"orgId")).longValue();
            if (orgId < 1L) {
                orgId = RequestContext.get().getOrgId();
            }
            json.put("orgId", (Object)orgId);
            json.put("org_id", (Object)orgId);
            JSONArray serialNos = jsonObj.getJSONArray("serialNos");
            if (serialNos == null) {
                serialNos = jsonObj.getJSONArray("serialList");
            }
            json.put("serialNos", (Object)serialNos);
            Object relevanceExpenseId = jsonObj.get((Object)"relevanceExpenseId");
            if (relevanceExpenseId instanceof String) {
                String[] relevanceExpenseIdArr = ((String)relevanceExpenseId).split(",");
                json.put("relevanceExpenseId", Arrays.stream(relevanceExpenseIdArr).collect(Collectors.toList()));
            } else if (relevanceExpenseId instanceof JSONArray) {
                json.put("relevanceExpenseId", relevanceExpenseId);
            }
            VerifyService.convertBuyerInfo(jsonObj, json);
            VerifyService.convertSalerInfo(jsonObj, json);
        }
        logger.info("\u67e5\u770b\u53d1\u7968\u53c2\u6570:{}", (Object)json);
        return json;
    }

    public static Long getRimUser(Map<String, Object> param) {
        if (param == null) {
            return 0L;
        }
        Object rimUser = param.get("rim_user");
        if (rimUser != null) {
            return BigDecimalUtil.transDecimal(rimUser).longValue();
        }
        return 0L;
    }

    public static String createEventCode(JSONObject json) {
        RequestContext context = RequestContext.get();
        json.put("UserName", (Object)context.getUserName());
        String extenduserId = json.getString("userId");
        String userType = json.getString("userType");
        String resource = json.getString("resource");
        Pair<String, String> userInfo = FpzsMainService.getUser(extenduserId, userType);
        Long rimUser = 0L;
        String openId = null;
        String userId = null;
        if (userInfo == null) {
            openId = MD5.md5Hex(context.getTenantId() + resource + extenduserId);
            if (!StringUtils.isEmpty((CharSequence)extenduserId)) {
                rimUser = RimUserService.createRimUser(extenduserId, resource, "third", openId, "");
            }
            userId = context.getUserId();
        } else {
            userId = (String)userInfo.getLeft();
            json.put("UserName", userInfo.getRight());
            openId = MD5.md5Hex(context.getTenantId() + userId);
        }
        json.put("rim_user", (Object)rimUser);
        json.put("openId", (Object)openId);
        json.put(InvoiceSaveConstant.OPERATE_USER_ID, (Object)userId);
        String thirdOrg = json.getString("thirdOrg");
        Long orgId = TenantUtils.getOrgByThirdOrgNo(thirdOrg);
        if (orgId <= 0L) {
            orgId = TenantUtils.getOrgByNumberOrTaxNo(json.getString("orgNumber"), json.getString("billTaxNo"));
        }
        if (orgId > 0L) {
            json.put("orgId", (Object)orgId);
        } else {
            json.put("orgId", (Object)context.getOrgId());
        }
        String eventCode = UUID.randomUUIDZero();
        CacheHelper.put("rim_event_code:" + eventCode, json.toJSONString(), 7200);
        return eventCode;
    }

    private static Pair<String, String> getUser(String userId, String userType) {
        if (StringUtils.isNotEmpty((CharSequence)userType) && StringUtils.isNotEmpty((CharSequence)userId)) {
            QFilter filter = null;
            if ("1".equals(userType)) {
                filter = new QFilter("number", "=", (Object)userId);
            } else if ("2".equals(userType)) {
                Long id = BigDecimalUtil.transDecimal(userId).longValue();
                if (id > 0L) {
                    filter = new QFilter("id", "=", (Object)id);
                } else {
                    throw new MsgException("0001", ResManager.loadKDString((String)"userId\u53c2\u6570\u9519\u8bef", (String)"FpzsMainService_24", (String)"imc-rim-common", (Object[])new Object[0]));
                }
            }
            if (filter == null) {
                throw new MsgException("0002", ResManager.loadKDString((String)"userType\u53c2\u6570\u9519\u8bef", (String)"FpzsMainService_25", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            DynamicObject receiverObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (String)"id,name", (QFilter[])filter.toArray());
            if (receiverObj == null) {
                return null;
            }
            ILocaleString localeString = receiverObj.getLocaleString("name");
            String name = "";
            if (localeString != null) {
                name = localeString.getLocaleValue();
            }
            return Pair.of((Object)String.valueOf(receiverObj.getLong("id")), (Object)name);
        }
        return null;
    }
}

