/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.fpzs;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.CollectTypeEnum;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.expense.service.VoucherService;
import kd.imc.rim.common.invoice.recognitionnew.task.handle.FileHandleService;
import kd.imc.rim.common.invoice.save.InvoiceSaveResult;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.multitenant.service.AbstractFpzsService;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.common.utils.itextpdf.UrlServiceUtils;
import org.apache.commons.lang.StringUtils;

public class FpzsService {
    private static final Log logger = LogFactory.getLog(FpzsService.class);

    public Map<String, Object> save(Map<String, Object> param) {
        return AbstractFpzsService.newInstance().save(param);
    }

    public Map<String, Object> delete(Map<String, Object> param) {
        return AbstractFpzsService.newInstance().delete(param);
    }

    public Map<String, Object> deleteAttach(Map<String, Object> param) {
        return AbstractFpzsService.newInstance().deleteAttach(param);
    }

    public Map<String, Object> deleteInvoice(List<String> serialList) {
        return AbstractFpzsService.newInstance().deleteInvoice(serialList);
    }

    public Map<String, Object> query(List<String> param, String resource) {
        return this.query(param, resource, null);
    }

    public Map<String, Object> query(List<String> param, String resource, String orgType) {
        return AbstractFpzsService.newInstance().query(param, resource, orgType);
    }

    public void convertDateLong(Map<String, Object> bodyMap, String ... timeKeys) {
        if (bodyMap == null) {
            return;
        }
        for (String timeKey : timeKeys) {
            String pattern = "yyyy-MM-dd HH:mm:ss";
            if ("invoice_date".equals(timeKey) || "invoiceDate".equals(timeKey)) {
                pattern = "yyyy-MM-dd";
            }
            try {
                Long time = (Long)bodyMap.get(timeKey);
                Date date = new Date(time);
                SimpleDateFormat formatter = new SimpleDateFormat(pattern);
                String dateString = formatter.format(date);
                bodyMap.put(timeKey, dateString);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Map<String, Object> query(List<String> param) {
        return this.query(param, null);
    }

    public Map<String, Object> queryVerify(Map<String, Object> param) {
        return AbstractFpzsService.newInstance().queryVerify(param);
    }

    public Map<String, Object> check(Map<String, Object> param) {
        return AbstractFpzsService.newInstance().check(param);
    }

    public Map<String, Object> checkNew(Map<String, Object> param) {
        return AbstractFpzsService.newInstance().checkNew(param);
    }

    public Map<String, Object> saveVoucherCover(Map<String, Object> param) {
        if (param == null || param.isEmpty()) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL.getCode(), ErrorType.PARAM_NULL.getName());
        }
        try {
            VoucherService service = new VoucherService();
            service.saveVoucherCover(param);
        }
        catch (MsgException e) {
            return ResultContant.createJSONObject(e.getErrorCode(), e.getErrorMsg());
        }
        return ResultContant.createSuccessJSONObject();
    }

    public Map<String, Object> saveVoucher(Map<String, Object> param) {
        return AbstractFpzsService.newInstance().saveVoucher(param);
    }

    public Map<String, Object> queryInvoiceAndFile(Map<String, Object> param) {
        return AbstractFpzsService.newInstance().queryInvoiceAndFile(param);
    }

    public Map<String, Object> queryInvoice(Map<String, Object> param) {
        return AbstractFpzsService.newInstance().queryInvoice(param);
    }

    public Map<String, Object> queryAttach(Map<String, Object> param) {
        return AbstractFpzsService.newInstance().queryAttach(param);
    }

    public Map<String, Object> queryCover(Map<String, Object> param) {
        return AbstractFpzsService.newInstance().queryCover(param);
    }

    public Map<String, Object> deleteVoucher(Map<String, Object> param) {
        return AbstractFpzsService.newInstance().deleteVoucher(param);
    }

    public Map<String, Object> syncSimInvoice(Map<String, Object> param) {
        if (param == null || param.isEmpty()) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL.getCode(), ErrorType.PARAM_NULL.getName());
        }
        try {
            String originalState;
            String json = SerializationUtils.toJsonString(param);
            logger.info("syncSimInvoice-param:" + json);
            JSONObject jsonObj = JSONObject.parseObject((String)json);
            String orgId = jsonObj.getString("orgId");
            String buyerOrgId = jsonObj.getString("buyerOrgId");
            String serialNo = jsonObj.getString("serialNo");
            QFilter filter = new QFilter("orderno", "=", (Object)serialNo);
            DynamicObject idObject = QueryServiceHelper.queryOne((String)"sim_vatinvoice", (String)"id", (QFilter[])new QFilter[]{filter});
            if (idObject == null) {
                logger.info("syncSimInvoice\u9500\u9879\u53d1\u7968\u4e0d\u5b58\u5728{}", (Object)serialNo);
                return ResultContant.createJSONObject(ErrorType.PARAM_NULL.getCode(), ResManager.loadKDString((String)"\u53d1\u7968\u4e0d\u5b58\u5728", (String)"FpzsService_6", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            DynamicObject invoiceObject = BusinessDataServiceHelper.loadSingle((Object)idObject.get("id"), (String)"sim_vatinvoice");
            JSONObject invoiceObj = new JSONObject();
            invoiceObj.put("originalParam", (Object)jsonObj);
            invoiceObj.put("dataSource", (Object)"simInvoice");
            if (StringUtils.isEmpty((String)orgId) && StringUtils.isNotEmpty((String)buyerOrgId)) {
                QFilter filter1 = new QFilter("serial_no", "=", (Object)serialNo);
                DynamicObject obj = QueryServiceHelper.queryOne((String)"rim_invoice", (String)"org_id as org", (QFilter[])new QFilter[]{filter1});
                if (obj == null) {
                    invoiceObj.put("org_id", (Object)buyerOrgId);
                } else {
                    invoiceObj.put("org_id", (Object)obj.getLong("org"));
                }
            } else {
                invoiceObj.put("org_id", (Object)orgId);
            }
            invoiceObj.put("serialNo", (Object)serialNo);
            String invoicetype = invoiceObject.getString("invoicetype");
            String inputType = "";
            if ("026".equals(invoicetype)) {
                inputType = "1";
            } else if ("028".equals(invoicetype)) {
                inputType = "2";
            } else if ("007".equals(invoicetype)) {
                inputType = "3";
            } else if ("004".equals(invoicetype)) {
                inputType = "4";
            } else if ("08xdp".equals(invoicetype)) {
                inputType = "27";
            } else if ("10xdp".equals(invoicetype)) {
                inputType = "26";
            } else if ("025".equals(invoicetype)) {
                inputType = "5";
            }
            invoiceObj.put("invoiceType", (Object)inputType);
            invoiceObj.put("invoiceAmount", invoiceObject.get("invoiceamount"));
            invoiceObj.put("type", invoiceObject.get("issuetype"));
            invoiceObj.put("payee", invoiceObject.get("payee"));
            invoiceObj.put("salerTaxNo", invoiceObject.get("salertaxno"));
            invoiceObj.put("machineNo", invoiceObject.get("jqbh"));
            invoiceObj.put("invoiceNo", invoiceObject.get("invoiceno"));
            invoiceObj.put("buyerTaxNo", invoiceObject.get("buyertaxno"));
            invoiceObj.put("originalInvoiceNo", invoiceObject.get("originalinvoiceno"));
            invoiceObj.put("invoiceCode", invoiceObject.get("invoicecode"));
            invoiceObj.put("serialNo", (Object)serialNo);
            invoiceObj.put("checkCode", invoiceObject.get("checkcode"));
            invoiceObj.put("totalAmount", invoiceObject.get("totalamount"));
            invoiceObj.put("salerAddressPhone", invoiceObject.get("saleraddr"));
            invoiceObj.put("totalTaxAmount", invoiceObject.get("totaltax"));
            invoiceObj.put("originalInvoiceCode", invoiceObject.get("originalinvoicecode"));
            invoiceObj.put("salerName", invoiceObject.get("salername"));
            invoiceObj.put("remark", invoiceObject.get("remark"));
            invoiceObj.put("checkStatus", (Object)"1");
            invoiceObj.put("buyerAddressPhone", invoiceObject.get("buyeraddr"));
            invoiceObj.put("drawer", invoiceObject.get("drawer"));
            invoiceObj.put("reviewer", invoiceObject.get("reviewer"));
            invoiceObj.put("invoiceDate", invoiceObject.get("issuetime"));
            invoiceObj.put("buyerName", invoiceObject.get("buyername"));
            String issueSource = invoiceObject.getString("issuesource");
            invoiceObj.put("invalidDate", invoiceObject.get("invaliddate"));
            String pdfFileurl = (String)invoiceObject.get("pdffileurl");
            String fileType = "1";
            String fileUrl = null;
            String xmlFileUrl = null;
            boolean electricFlag = false;
            if ("26".equals(inputType) || "27".equals(inputType)) {
                fileUrl = (String)invoiceObject.get("fileurl");
                if (StringUtils.isNotEmpty((String)fileUrl)) {
                    electricFlag = true;
                    fileType = "4";
                }
                if (StringUtils.isNotEmpty((String)pdfFileurl)) {
                    electricFlag = true;
                }
                xmlFileUrl = (String)invoiceObject.get("xmlfileurl");
            } else if (StringUtils.isEmpty((String)pdfFileurl)) {
                pdfFileurl = (String)invoiceObject.get("fileurl");
                if ("2".equals(inputType)) {
                    fileType = "4";
                }
            }
            if (!StringUtils.isEmpty((String)pdfFileurl) || electricFlag) {
                invoiceObj.put("generatePdf", (Object)"0");
                FileHandleService service = FileHandleService.newInstance(FileHandleService.DOWN_TYPE_IMG2);
                JSONObject object = new JSONObject();
                if ("26".equals(inputType) || "27".equals(inputType)) {
                    object.put("sim_down_file", (Object)"1");
                    object.put("snapshot_url", (Object)xmlFileUrl);
                    if ("1".equals(fileType)) {
                        object.put("fileUrl", (Object)pdfFileurl);
                    } else {
                        object.put("fileUrl", (Object)fileUrl);
                        object.put("ofd_url", (Object)pdfFileurl);
                    }
                } else {
                    object.put("fileUrl", (Object)pdfFileurl);
                }
                object.put("fileType", (Object)fileType);
                object.put("invoiceType", (Object)inputType);
                object.put("serialNo", (Object)serialNo);
                service.insert(serialNo, object);
            }
            if ("1".equals(originalState = jsonObj.getString("originalState"))) {
                invoiceObj.put("originalState", (Object)"1");
            }
            invoiceObj.put("buyerAccount", invoiceObject.get("buyerbank"));
            String invoicestatus = invoiceObject.getString("invoicestatus");
            if ("6".equals(invoicestatus)) {
                invoiceObj.put("invoiceStatus", (Object)"2");
            } else {
                invoiceObj.put("invoiceStatus", (Object)invoicestatus);
            }
            DynamicObjectCollection items = invoiceObject.getDynamicObjectCollection("items");
            JSONArray itemArray = new JSONArray();
            for (DynamicObject item : items) {
                JSONObject itemObj = new JSONObject();
                itemObj.put("unitPrice", item.get("unitprice"));
                itemObj.put("num", item.get("num"));
                itemObj.put("preferentialPolicy", item.get("taxpremark"));
                itemObj.put("zeroTaxRateFlag", item.get("zerotaxmark"));
                itemObj.put("taxRate", item.get("taxrate"));
                itemObj.put("unit", item.get("unit"));
                itemObj.put("specModel", item.get("specification"));
                itemObj.put("detailAmount", item.get("amount"));
                itemObj.put("vatException", item.get("zzstsgl"));
                itemObj.put("goodsCode", item.get("goodscode"));
                itemObj.put("taxAmount", item.get("tax"));
                itemObj.put("goodsName", item.get("goodsname"));
                itemObj.put("discountType", item.get("rowtype"));
                itemArray.add((Object)itemObj);
            }
            invoiceObj.put("items", (Object)itemArray);
            invoiceObj.put("resource", (Object)"\u5f00\u7968\u7ba1\u7406");
            invoiceObj.put("collect_type", (Object)CollectTypeEnum.PC_SIM.getCode());
            invoiceObj.put("needUserRelation", (Object)"0");
            InvoiceSaveService saveService = InvoiceSaveService.newInstance(inputType);
            InvoiceSaveResult saveResult = saveService.save(invoiceObj);
            Object voucher = jsonObj.get((Object)"voucherInfo");
            if (voucher != null) {
                JSONObject voucherInfo = null;
                JSONArray serialNoArray = new JSONArray();
                serialNoArray.add((Object)saveResult.getSerialNo());
                if (voucher instanceof List) {
                    JSONArray voucherInfoArray = jsonObj.getJSONArray("voucherInfo");
                    HashMap<String, Object> voucherParam = new HashMap<String, Object>(8);
                    VoucherService voucherService = new VoucherService();
                    for (int i = 0; i < voucherInfoArray.size(); ++i) {
                        JSONObject vouch = voucherInfoArray.getJSONObject(i);
                        String vouchId = vouch.getString("vouchId");
                        String resource = vouch.getString("resource");
                        if (!StringUtils.isNotEmpty((String)vouchId) || !StringUtils.isNotEmpty((String)resource)) continue;
                        voucherParam.put("voucherInfo", vouch);
                        voucherParam.put("serialNoArray", serialNoArray);
                        voucherService.saveVoucher(voucherParam);
                    }
                } else {
                    voucherInfo = jsonObj.getJSONObject("voucherInfo");
                    HashMap<String, Object> voucherParam = new HashMap<String, Object>(8);
                    String vouchId = voucherInfo.getString("vouchId");
                    String resource = voucherInfo.getString("resource");
                    if (StringUtils.isNotEmpty((String)vouchId) && StringUtils.isNotEmpty((String)resource)) {
                        VoucherService voucherService = new VoucherService();
                        voucherParam.put("voucherInfo", voucherInfo);
                        voucherParam.put("serialNoArray", serialNoArray);
                        voucherService.saveVoucher(voucherParam);
                    }
                }
            }
            if (!StringUtils.isEmpty((String)pdfFileurl) || electricFlag) {
                FileHandleService.startDownAwsFile("0");
            }
        }
        catch (Exception e) {
            logger.error("syncSimInvoice-error:", (Throwable)e);
            return ResultContant.createJSONObject(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u5904\u7406\u5931\u8d25", (String)"FpzsService_7", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        return ResultContant.createSuccessJSONObject();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean fileExists(String url) {
        try (InputStream fileInputStream = UrlServiceUtils.getAttachmentDecodedStream(FileServiceFactory.getAttachmentFileService().getInputStream(url));){
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.info("syncSimInvoice-\u6587\u4ef6\u4e0d\u5b58\u5728{}", (Object)url);
            return false;
        }
    }

    public List<Map<String, String>> queryFile(List<String> serialList) {
        return AbstractFpzsService.newInstance().queryFile(serialList);
    }

    public Map<String, Object> queryPermissionByOrgId(Long orgId) {
        if (orgId == null) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL);
        }
        String taxNo = TenantUtils.getTaxNoByOrgId(orgId);
        if (StringUtils.isEmpty((String)taxNo)) {
            logger.info("\u8bb8\u53ef\u63a7\u5236\u5f53\u524d\u7ec4\u7ec7{}\u7a0e\u53f7\u4e3a\u7a7a", (Object)orgId);
            return ResultContant.createJSONObject(ErrorType.NO_ACCESS);
        }
        QFilter taxFilter = new QFilter("epinfo.number", "=", (Object)taxNo);
        QFilter groupFilter = new QFilter("servergroup", "=", (Object)"1");
        QFilter stateFilter = new QFilter("authstate", "=", (Object)"1");
        DynamicObjectCollection collect = QueryServiceHelper.query((String)"bdm_invoice_permission", (String)"id,orginfo.id as org_id,authstate", (QFilter[])new QFilter[]{taxFilter, groupFilter, stateFilter});
        if (collect == null || collect.isEmpty()) {
            logger.info("\u8bb8\u53ef\u63a7\u5236\u5f53\u524d\u7ec4\u7ec7{}\u7a0e\u53f7{}\u672a\u6388\u6743", (Object)orgId, (Object)taxNo);
            return ResultContant.createJSONObject(ErrorType.NO_ACCESS);
        }
        JSONObject returnResult = ResultContant.createSuccessJSONObject();
        return returnResult;
    }

    public Map<String, Object> signInvoice(List<String> serialNos) {
        return AbstractFpzsService.newInstance().signInvoice(serialNos);
    }

    public Map<String, Object> unSignInvoice(List<String> serialNos) {
        return AbstractFpzsService.newInstance().unSignInvoice(serialNos);
    }

    public Map<String, Object> dapVoucherWriteBack(Map<String, Object> param) {
        return AbstractFpzsService.newInstance().dapVoucherWriteBack(param);
    }

    public Map<String, Object> recognitionCheck(Map<String, Object> param) throws InterruptedException {
        return AbstractFpzsService.newInstance().recognitionCheck(param);
    }

    public Map<String, Object> editInvoice(Map<String, Object> param) {
        return AbstractFpzsService.newInstance().editInvoice(param);
    }

    public Map<String, Object> outInvoiceApply(Map<String, Object> param) {
        return AbstractFpzsService.newInstance().outInvoiceApply(param);
    }

    public Map<String, Object> outInvoiceDownloadResult(Map<String, Object> param) {
        return AbstractFpzsService.newInstance().outInvoiceDownloadResult(param);
    }

    public Map<String, Object> stopInvoiceDownload(Map<String, Object> param) {
        return AbstractFpzsService.newInstance().stopInvoiceDownload(param);
    }
}

