/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.fpzs;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.imc.rim.common.invoice.fpzs.FpzsMainService;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.CommonUtils;

public class InvoiceClassService {
    private static Log logger = LogFactory.getLog(InvoiceClassService.class);
    public static final String PRO_BAR_UPDATE_CLASS = "probarupdateclass";
    public static final String INVOICE_CLASS = "invoice_class";
    public static final String INVOICE_CLASS_SHOW = "invoice_class_show";
    public static final String MAIN_ID_KEY = "id";
    private static final String RIM_INVOICE_CLASS = "rim_invoice_class";
    private static final String RIM_INVOICE_CLASS_CUSTOM = "rim_invoice_class_custom";
    private static final String CLASS_CHECK_TYPE = "custom";
    public static final String ACTION_SELECT_CLASS = "select_class";
    public static final long OTHER_CLASS_ID = 10L;
    private static InvoiceClassService service;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InvoiceClassService getInstance() {
        Class<InvoiceClassService> clazz = InvoiceClassService.class;
        synchronized (InvoiceClassService.class) {
            if (service == null) {
                service = new InvoiceClassService();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    public JSONArray getUserAllInvoiceUesedClass(Map<String, Object> customParams) {
        QFilter qFilters = new QFilter("delete", "=", (Object)"1");
        Long rim_user = BigDecimalUtil.transDecimal(customParams.get("rim_user")).longValue();
        if (rim_user > 0L) {
            qFilters.and(new QFilter("collect_user_entry.rim_user", "=", (Object)rim_user));
        } else {
            qFilters.and(new QFilter("collect_user_entry.collect_user", "=", (Object)Long.valueOf(RequestContext.get().getUserId())));
        }
        qFilters.and(QFilter.isNotNull((String)"mul_class.fbasedataid_id"));
        DataSet invoiceRows = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"rim_invoice", (String)"id,mul_class.fbasedataid_id", (QFilter[])new QFilter[]{qFilters}, (String)MAIN_ID_KEY);
        DataSet countClassUsed = invoiceRows.groupBy(new String[]{"mul_class.fbasedataid_id"}).count().finish().orderBy(new String[]{"count desc"});
        DynamicObjectCollection invoiceClassInfos = ORMUtil.toDynamicObjectCollection((DataSet)countClassUsed, (String)"rim_invoice");
        List invoiceClassIds = invoiceClassInfos.stream().map(v -> v.getLong("mul_class.fbasedataid_id")).collect(Collectors.toList());
        DynamicObject[] load = BusinessDataServiceHelper.load((Object[])invoiceClassIds.toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)RIM_INVOICE_CLASS).getDynamicObjectType());
        Map<Object, DynamicObject> objectDynamicObjectMap = Arrays.stream(load).collect(Collectors.toMap(v -> v.getPkValue(), v -> v));
        ArrayList invoiceClassInfoSortList = Lists.newArrayListWithExpectedSize((int)load.length);
        for (DynamicObject invoiceClassInfo : invoiceClassInfos) {
            invoiceClassInfoSortList.add(objectDynamicObjectMap.get(invoiceClassInfo.getLong("mul_class.fbasedataid_id")));
        }
        return this.convertJson(invoiceClassInfoSortList);
    }

    public JSONArray getCommonClassList(Long userId) {
        QFilter userQF = new QFilter("user", "=", (Object)(userId + ""));
        QFilter countQf = new QFilter("custom_count", ">", (Object)0);
        QFilter delQF = QFilter.isNull((String)"delete_date");
        DynamicObjectCollection sortList = QueryServiceHelper.query((String)this.getClass().getName(), (String)RIM_INVOICE_CLASS_CUSTOM, (String)"invoice_classid", (QFilter[])new QFilter[]{userQF, countQf, delQF}, (String)"custom_count desc, id desc");
        ArrayList invoiceClassInfoIdList = Lists.newArrayList();
        invoiceClassInfoIdList.addAll(sortList.stream().map(v -> v.getLong("invoice_classid")).collect(Collectors.toList()));
        if (sortList.isEmpty() || sortList.size() < 5) {
            QFilter qf = new QFilter("isdefault", "=", (Object)"1");
            QFilter excludeQf = new QFilter(MAIN_ID_KEY, "not in", (Object)invoiceClassInfoIdList);
            DynamicObject[] defaultClass = BusinessDataServiceHelper.load((String)RIM_INVOICE_CLASS, (String)"id, name, custom_count", (QFilter[])new QFilter[]{qf, excludeQf}, (String)"custom_count desc, id desc", (int)(5 - sortList.size()));
            invoiceClassInfoIdList.addAll(Arrays.stream(defaultClass).map(v -> v.getLong(MAIN_ID_KEY)).collect(Collectors.toList()));
        }
        DynamicObject[] load = BusinessDataServiceHelper.load((Object[])invoiceClassInfoIdList.toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)RIM_INVOICE_CLASS).getDynamicObjectType());
        Map<Object, DynamicObject> objectDynamicObjectMap = Arrays.stream(load).collect(Collectors.toMap(v -> v.getPkValue(), v -> v));
        ArrayList invoiceClassInfoList = Lists.newArrayListWithExpectedSize((int)invoiceClassInfoIdList.size());
        for (int i = 0; i < invoiceClassInfoIdList.size(); ++i) {
            DynamicObject dynamicObject = objectDynamicObjectMap.get(invoiceClassInfoIdList.get(i));
            invoiceClassInfoList.add(dynamicObject);
        }
        return this.convertJson(invoiceClassInfoList);
    }

    public JSONArray getCustomClassList(Long userId) {
        return this.sortAndConvert(new QFilter("creator.id", "=", (Object)userId).and(new QFilter("isdefault", "!=", (Object)"1")));
    }

    public JSONArray getDefaultClassList(Long userId) {
        return this.sortAndConvert(new QFilter("isdefault", "=", (Object)"1"));
    }

    private JSONArray sortAndConvert(QFilter qf) {
        DynamicObject[] invoiceClassInfoArr = BusinessDataServiceHelper.load((String)RIM_INVOICE_CLASS, (String)"id,name", (QFilter[])new QFilter[]{qf}, (String)"id desc");
        List<DynamicObject> invoiceClassInfoList = Arrays.stream(invoiceClassInfoArr).collect(Collectors.toList());
        return this.convertJson(invoiceClassInfoList);
    }

    public void sort(List<DynamicObject> classList) {
        Map<Long, DynamicObject> idToMap = classList.stream().collect(Collectors.toMap(v -> v.getLong(MAIN_ID_KEY), v -> v));
        QFilter userQF = new QFilter("invoice_classid", "in", idToMap.keySet());
        DynamicObjectCollection sortList = QueryServiceHelper.query((String)this.getClass().getName(), (String)RIM_INVOICE_CLASS_CUSTOM, (String)"invoice_classid", (QFilter[])new QFilter[]{userQF}, (String)"custom_count desc, id desc");
        classList.clear();
        for (DynamicObject sortInfo : sortList) {
            classList.add(idToMap.get(sortInfo.getLong("invoice_classid")));
        }
    }

    private JSONArray convertJson(List<DynamicObject> classInfos) {
        JSONArray classArr = new JSONArray();
        for (int index = 0; index < classInfos.size(); ++index) {
            DynamicObject classInfo = classInfos.get(index);
            if (classInfo == null) continue;
            Long id = classInfo.getLong(MAIN_ID_KEY);
            String name = classInfo.getString("name");
            JSONObject classJson = new JSONObject();
            classArr.add((Object)classJson);
            classJson.put(MAIN_ID_KEY, (Object)id);
            classJson.put("name", (Object)name);
        }
        return classArr;
    }

    public JSONObject getClassInfoJson(Long id) {
        JSONArray classInfoJsons = this.getClassInfoJson(Lists.newArrayList((Object[])new Long[]{id}));
        if (classInfoJsons.size() > 0) {
            return classInfoJsons.getJSONObject(0);
        }
        return null;
    }

    public JSONArray getClassInfoJson(List<Long> ids) {
        DynamicObject[] classInfos = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)RIM_INVOICE_CLASS).getDynamicObjectType());
        JSONArray classInfoJosns = new JSONArray();
        if (classInfos != null) {
            for (DynamicObject classInfo : classInfos) {
                JSONObject classInfoJson = new JSONObject();
                classInfoJson.put("class_name", (Object)classInfo.getString("name"));
                classInfoJson.put("class_isedit", (Object)classInfo.getString("isedit"));
                classInfoJson.put("class_id", (Object)classInfo.getLong(MAIN_ID_KEY));
                classInfoJosns.add((Object)classInfoJson);
            }
        }
        return classInfoJosns;
    }

    public JSONObject getClassInfoJson(String name, Long userId, Long excludeId) {
        QFilter nameQF = new QFilter("name", "=", (Object)name);
        QFilter userQF = new QFilter("user", "=", (Object)(userId + "")).or(new QFilter("isdefault", "=", (Object)"1"));
        QFilter excludeIdqf = new QFilter(MAIN_ID_KEY, "!=", (Object)excludeId);
        DynamicObject updateClassInfo = CommonUtils.loadSingle(RIM_INVOICE_CLASS, new QFilter[]{nameQF, userQF, excludeIdqf});
        if (updateClassInfo == null) {
            return null;
        }
        JSONObject classInfo = new JSONObject();
        classInfo.put("class_name", (Object)updateClassInfo.getString("name"));
        classInfo.put("class_isedit", (Object)updateClassInfo.getString("isedit"));
        classInfo.put("class_id", (Object)updateClassInfo.getLong(MAIN_ID_KEY));
        return classInfo;
    }

    public void updateInvoiceClass(String className, Long id, Long userId) {
        boolean enable = UserServiceHelper.isUserEnable((long)userId);
        DynamicObject updateClassInfo = BusinessDataServiceHelper.loadSingle((Object)id, (String)RIM_INVOICE_CLASS);
        updateClassInfo.set("name", (Object)className);
        if (enable) {
            updateClassInfo.set("modifier_id", (Object)userId);
        } else {
            updateClassInfo.set("modifier_id", (Object)Long.parseLong(RequestContext.get().getUserId()));
        }
        updateClassInfo.set("modifytime", (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{updateClassInfo});
        DynamicObject customInfo = BusinessDataServiceHelper.loadSingle((String)RIM_INVOICE_CLASS_CUSTOM, (String)"class_text,operateid,operate", (QFilter[])new QFilter[]{new QFilter("invoice_classid", "=", (Object)id)});
        customInfo.set("class_text", updateClassInfo.get("name"));
        if (enable) {
            customInfo.set("operateid", (Object)userId);
        }
        customInfo.set("operate", (Object)userId);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{customInfo});
    }

    public void addInvoiceClass(String className, Long userId) {
        DynamicObject classInfo = BusinessDataServiceHelper.newDynamicObject((String)RIM_INVOICE_CLASS);
        int index = this.getMaxIndex();
        classInfo.set("name", (Object)className);
        classInfo.set("number", (Object)("class_" + index));
        Long currentUser = Long.parseLong(RequestContext.get().getUserId());
        classInfo.set("creator_id", (Object)currentUser);
        classInfo.set("modifier_id", (Object)currentUser);
        boolean enable = UserServiceHelper.isUserEnable((long)userId);
        if (enable) {
            classInfo.set("inner_user_id", (Object)userId);
        }
        classInfo.set("user", (Object)("" + userId));
        Date date = new Date();
        classInfo.set("createtime", (Object)date);
        classInfo.set("modifytime", (Object)date);
        classInfo.set("isedit", (Object)"1");
        classInfo.set("isdefault", (Object)"0");
        classInfo.set("index", (Object)index);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{classInfo});
        this.saveNewCountRecord(classInfo);
    }

    public void addInvoiceClass(String className, String classNum, String isEnable, Long userId) {
        DynamicObject classInfo = BusinessDataServiceHelper.newDynamicObject((String)RIM_INVOICE_CLASS);
        int index = this.getMaxIndex();
        classInfo.set("name", (Object)className);
        classInfo.set("number", (Object)classNum);
        Long currentUser = Long.parseLong(RequestContext.get().getUserId());
        classInfo.set("creator_id", (Object)currentUser);
        classInfo.set("modifier_id", (Object)currentUser);
        boolean enable = UserServiceHelper.isUserEnable((long)userId);
        if (enable) {
            classInfo.set("inner_user_id", (Object)userId);
        }
        classInfo.set("user", (Object)("" + userId));
        Date date = new Date();
        classInfo.set("createtime", (Object)date);
        classInfo.set("modifytime", (Object)date);
        classInfo.set("enable", (Object)(org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)isEnable) ? "1" : isEnable));
        classInfo.set("isedit", (Object)"1");
        classInfo.set("isdefault", (Object)"0");
        classInfo.set("index", (Object)index);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{classInfo});
        this.saveNewCountRecord(classInfo);
    }

    private void saveNewCountRecord(DynamicObject classInfo) {
        this.saveNewCountRecord(Long.parseLong(classInfo.getString("user")));
    }

    private void saveNewCountRecord(Long userId) {
        QFilter qf = new QFilter("isdefault", "=", (Object)"1");
        QFilter userQF = new QFilter("user", "=", (Object)(userId + ""));
        DynamicObject[] allClass = BusinessDataServiceHelper.load((String)RIM_INVOICE_CLASS, (String)"id, name", (QFilter[])new QFilter[]{qf.or(userQF)});
        DynamicObject[] customUsedClass = BusinessDataServiceHelper.load((String)RIM_INVOICE_CLASS_CUSTOM, (String)"invoice_classid", (QFilter[])new QFilter[]{userQF});
        List usedClassId = Arrays.stream(customUsedClass).map(v -> v.getLong("invoice_classid")).collect(Collectors.toList());
        List customNeedAdd = Arrays.stream(allClass).filter(v -> !usedClassId.contains(v.getLong(MAIN_ID_KEY))).collect(Collectors.toList());
        ArrayList customList = Lists.newArrayListWithExpectedSize((int)customNeedAdd.size());
        for (DynamicObject newClassInfo : customNeedAdd) {
            DynamicObject customInfo = BusinessDataServiceHelper.newDynamicObject((String)RIM_INVOICE_CLASS_CUSTOM);
            customInfo.set("invoice_classid", (Object)newClassInfo.getLong(MAIN_ID_KEY));
            customInfo.set("class_text", (Object)newClassInfo.getString("name"));
            customInfo.set("custom_count", (Object)0);
            boolean enable = UserServiceHelper.isUserEnable((long)userId);
            if (enable) {
                customInfo.set("userid", (Object)userId);
            }
            customInfo.set("user", (Object)(userId + ""));
            customList.add(customInfo);
        }
        SaveServiceHelper.save((DynamicObject[])customList.toArray(new DynamicObject[0]));
    }

    private void updateCount(List<Long> classIds, Long userId) {
        DynamicObject[] classInfos;
        this.saveNewCountRecord(userId);
        DynamicObject[] classCustomInfos = BusinessDataServiceHelper.load((String)RIM_INVOICE_CLASS_CUSTOM, (String)"id,invoice_classid,custom_count,new_date,first_date", (QFilter[])new QFilter[]{new QFilter("invoice_classid", "in", classIds), new QFilter("user", "=", (Object)(userId + ""))});
        HashMap idCount = Maps.newHashMapWithExpectedSize((int)classCustomInfos.length);
        for (DynamicObject classCustomInfo : classCustomInfos) {
            int count = classCustomInfo.getInt("custom_count") + 1;
            classCustomInfo.set("custom_count", (Object)count);
            idCount.put(classCustomInfo.getLong("invoice_classid"), count);
            Date curDate = new Date();
            if (classCustomInfo.get("first_date") == null) {
                classCustomInfo.set("first_date", (Object)curDate);
            }
            classCustomInfo.set("new_date", (Object)curDate);
        }
        SaveServiceHelper.save((DynamicObject[])classCustomInfos);
        for (DynamicObject classInfo : classInfos = BusinessDataServiceHelper.load((Object[])classIds.toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)RIM_INVOICE_CLASS).getDynamicObjectType())) {
            if (org.apache.commons.lang3.StringUtils.equals((CharSequence)classInfo.getString("isdefault"), (CharSequence)"1")) {
                classInfo.set("custom_count", (Object)(classInfo.getInt("custom_count") + 1));
                continue;
            }
            if (idCount.get(classInfo.getLong(MAIN_ID_KEY)) != null) {
                classInfo.set("custom_count", idCount.get(classInfo.getLong(MAIN_ID_KEY)));
                continue;
            }
            logger.info("\u3010\u53d1\u7968\u5206\u7c7b\u3011\u6570\u636e\u6709\u8bef");
        }
        SaveServiceHelper.save((DynamicObject[])classInfos);
    }

    private static long inc(String key) {
        String numKey = key + "_num";
        String num = CacheHelper.get(numKey);
        long incNumCount = CacheHelper.inc(key, 300);
        long numLong = Long.parseLong(num);
        return numLong + incNumCount;
    }

    private static long incIndexNum(String key) {
        String numKey = key + "_num";
        String num = CacheHelper.get(numKey);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)num)) {
            DynamicObjectCollection queryNumberIndex = QueryServiceHelper.query((String)InvoiceClassService.class.getName(), (String)RIM_INVOICE_CLASS, (String)"index", null, (String)"index desc", (int)1);
            num = !queryNumberIndex.isEmpty() ? ((DynamicObject)queryNumberIndex.get(0)).getInt("index") + "" : "0";
            CacheHelper.put(numKey, num, 300);
            CacheHelper.remove(key);
        }
        return InvoiceClassService.inc(key);
    }

    private int getMaxIndex() {
        return (int)InvoiceClassService.incIndexNum("rim_class_max_index_num");
    }

    public void delInvoiceClass(Long classId, Long userId) {
        try (TXHandle h = TX.requiresNew();){
            try {
                DynamicObject[] classCustom;
                DynamicObject[] needUpdateInvoice;
                QFilter qf = new QFilter("mul_class.fbasedataid_id", "=", (Object)classId);
                for (DynamicObject invoice : needUpdateInvoice = BusinessDataServiceHelper.load((String)"rim_invoice", (String)"id,mul_class", (QFilter[])new QFilter[]{qf})) {
                    DynamicObjectCollection mulClass = invoice.getDynamicObjectCollection("mul_class");
                    for (DynamicObject invoiceClass : mulClass) {
                        invoiceClass.set("fbasedataid_id", (Object)10L);
                    }
                }
                SaveServiceHelper.save((DynamicObject[])needUpdateInvoice);
                DeleteServiceHelper.delete((String)RIM_INVOICE_CLASS, (QFilter[])new QFilter[]{new QFilter(MAIN_ID_KEY, "=", (Object)classId)});
                for (DynamicObject classCustomInfo : classCustom = BusinessDataServiceHelper.load((String)RIM_INVOICE_CLASS_CUSTOM, (String)"delete_date,operateid,operate", (QFilter[])new QFilter[]{new QFilter("invoice_classid", "=", (Object)classId)})) {
                    classCustomInfo.set("delete_date", (Object)new Date());
                    classCustomInfo.set("operate", (Object)userId);
                    boolean enable = UserServiceHelper.isUserEnable((long)userId);
                    if (!enable) continue;
                    classCustomInfo.set("operateid", (Object)userId);
                }
                SaveServiceHelper.save((DynamicObject[])classCustom);
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    public void openSelect(AbstractFormPlugin plugin) {
        MobileFormShowParameter mfsp = new MobileFormShowParameter();
        mfsp.setShowTitle(false);
        mfsp.setShowClose(false);
        mfsp.setFormId("rim_inv_class_select_mb");
        mfsp.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, ACTION_SELECT_CLASS));
        mfsp.getOpenStyle().setShowType(ShowType.Floating);
        HashMap customParams = Maps.newHashMapWithExpectedSize((int)2);
        customParams.put("classId", this.getClassId(plugin));
        customParams.put("rim_user", this.getUserIdCache(plugin));
        mfsp.setCustomParams((Map)customParams);
        plugin.getView().showForm((FormShowParameter)mfsp);
    }

    public void openSelectAll(AbstractFormPlugin plugin) {
        MobileFormShowParameter mfsp = new MobileFormShowParameter();
        mfsp.setShowTitle(false);
        mfsp.setShowClose(false);
        mfsp.setFormId("rim_inv_class_select_mb");
        mfsp.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, ACTION_SELECT_CLASS));
        mfsp.getOpenStyle().setShowType(ShowType.Floating);
        HashMap customParams = Maps.newHashMapWithExpectedSize((int)2);
        customParams.put("rim_user", this.getUserIdCache(plugin));
        mfsp.setCustomParams((Map)customParams);
        plugin.getView().showForm((FormShowParameter)mfsp);
    }

    private String getClassId(AbstractFormPlugin plugin) {
        String value;
        block6: {
            value = "";
            try {
                value = (String)plugin.getView().getModel().getValue("mul_class_type");
            }
            catch (Exception e) {
                DynamicObjectCollection mulClass;
                Object id = plugin.getView().getModel().getValue(MAIN_ID_KEY);
                DynamicObject invoice = BusinessDataServiceHelper.loadSingle((Object)id, (String)"rim_invoice");
                if (invoice == null || CollectionUtils.isEmpty((Collection)(mulClass = invoice.getDynamicObjectCollection("mul_class")))) break block6;
                StringBuilder sb = new StringBuilder();
                for (DynamicObject obj : mulClass) {
                    Object fbasedataid = obj.getDynamicObject("fbasedataid").getPkValue();
                    sb.append(fbasedataid).append(",");
                }
                value = sb.substring(0, sb.length() - 1);
            }
        }
        List<Object> classIds = Lists.newArrayListWithExpectedSize((int)1);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)value)) {
            if (value.contains(",")) {
                classIds = Arrays.stream(value.split(",")).filter(v -> org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)v)).collect(Collectors.toList());
            } else {
                classIds.add(value);
            }
        }
        return JSONArray.toJSONString((Object)classIds);
    }

    private void putClassId(AbstractFormPlugin plugin, List<Long> classIds) {
        JSONArray classInfoJsons = this.getClassInfoJson(classIds);
        StringBuilder idSB = new StringBuilder();
        StringBuilder nameSB = new StringBuilder();
        for (int i = 0; i < classInfoJsons.size(); ++i) {
            JSONObject classInfoJson = classInfoJsons.getJSONObject(i);
            String className = classInfoJson.getString("class_name");
            Long classId = classInfoJson.getLong("class_id");
            idSB.append(classId);
            idSB.append(",");
            nameSB.append(className);
            nameSB.append(",");
        }
        if (idSB.length() > 0) {
            idSB.delete(idSB.length() - 1, idSB.length());
        }
        if (nameSB.length() > 0) {
            nameSB.delete(nameSB.length() - 1, nameSB.length());
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)idSB.toString()) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)nameSB.toString())) {
            nameSB.append("- -");
        }
        plugin.getView().getModel().setValue("mul_class_type", (Object)idSB.toString());
        String nameStr = nameSB.toString();
        if (nameStr.length() > 12) {
            nameStr = nameStr.substring(0, 12) + "...";
        }
        plugin.getView().getModel().setValue("mul_class_type_name", (Object)nameStr);
    }

    private Object getUserIdCache(AbstractFormPlugin plugin) {
        IFormView view = plugin.getView();
        String pageId = plugin.getView().getPageId();
        Map<String, Object> customParam = FpzsMainService.getCustomParam(pageId);
        Object rim_user = customParam.get("rim_user");
        while (rim_user == null && org.apache.commons.lang3.StringUtils.contains((CharSequence)view.getFormShowParameter().getFormId(), (CharSequence)"rim_") && !org.apache.commons.lang3.StringUtils.isBlank((CharSequence)(pageId = view.getFormShowParameter().getParentPageId()))) {
            view = plugin.getView().getViewNoPlugin(pageId);
            customParam = FpzsMainService.getCustomParam(pageId);
            rim_user = customParam.get("rim_user");
        }
        return rim_user;
    }

    public void openEditView(String className, Long classId, String action, String classUser, AbstractFormPlugin plugin) {
        MobileFormShowParameter mfsp = new MobileFormShowParameter();
        mfsp.setShowTitle(false);
        mfsp.setShowClose(false);
        mfsp.setFormId("rim_inv_class_edit_mb");
        mfsp.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, action));
        mfsp.getOpenStyle().setShowType(ShowType.Floating);
        HashMap customParams = Maps.newHashMapWithExpectedSize((int)3);
        customParams.put("className", className);
        customParams.put("classId", classId + "");
        customParams.put("classUser", classUser);
        mfsp.setCustomParams((Map)customParams);
        plugin.getView().showForm((FormShowParameter)mfsp);
    }

    public void callBackProBar(AbstractFormPlugin plugin) {
        if (plugin.getView().getParentView() == null) {
            return;
        }
        ProgressBar pb = (ProgressBar)plugin.getView().getParentView().getControl(PRO_BAR_UPDATE_CLASS);
        if (pb != null) {
            Object row = plugin.getView().getFormShowParameter().getCustomParam("row");
            if (row instanceof String) {
                row = Integer.parseInt(row.toString());
            }
            plugin.getView().getParentView().getModel().setValue("updateclassrow", row);
            pb.start();
            plugin.getView().sendFormAction(plugin.getView().getParentView());
        }
    }

    public void selectCloseCallBack(AbstractFormPlugin plugin, ClosedCallBackEvent evt, Long mainId) {
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)ACTION_SELECT_CLASS, (CharSequence)evt.getActionId())) {
            JSONObject returnData = JSONObject.parseObject((String)((String)evt.getReturnData()));
            if (returnData == null) {
                return;
            }
            List classId = returnData.getJSONArray("classId").toJavaList(Long.class);
            Long classUser = returnData.getLong("classUser");
            this.putClassId(plugin, classId);
            if (mainId != null && mainId != 0L) {
                DynamicObject invoiceMulClassUpdate = BusinessDataServiceHelper.loadSingle((Object)mainId, (String)"rim_invoice", (String)"id,mul_class");
                DynamicObjectCollection mulClassColl = invoiceMulClassUpdate.getDynamicObjectCollection("mul_class");
                mulClassColl.clear();
                HashSet set = Sets.newHashSetWithExpectedSize((int)classId.size());
                for (Long classid : classId) {
                    if (!set.add(classid)) continue;
                    DynamicObject classInfo = mulClassColl.addNew();
                    classInfo.set("fbasedataid_id", (Object)classid);
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invoiceMulClassUpdate});
            }
            this.updateCount(classId, classUser);
        }
    }

    public void initInvoiceClass(Map<String, Object> mainMap) {
        Object mainId = mainMap.get("mainId");
        if (mainId == null) {
            mainId = mainMap.get(MAIN_ID_KEY);
        }
        if (mainId == null) {
            return;
        }
        DynamicObject invoiceMulClassInfo = BusinessDataServiceHelper.loadSingle((Object)mainId, (String)"rim_invoice", (String)"id,mul_class,mul_class.name");
        this.initInvoiceClass(mainMap, invoiceMulClassInfo);
    }

    public void initInvoiceClass(Map<String, Object> mainMap, DynamicObject invoiceMulClassInfo) {
        if (invoiceMulClassInfo == null) {
            return;
        }
        this.dealClassName(mainMap, invoiceMulClassInfo, true);
    }

    public void dealClassName(Map<String, Object> mainMap, DynamicObject invoiceMulClassInfo, boolean isOmit) {
        if (invoiceMulClassInfo == null) {
            return;
        }
        DynamicObjectCollection mul_class = invoiceMulClassInfo.getDynamicObjectCollection("mul_class");
        String classIds = mul_class.stream().map(v -> v.getLong("fbasedataid_id") + "").collect(Collectors.joining(","));
        String classNames = mul_class.stream().map(v -> v.getString("fbasedataid.name")).collect(Collectors.joining(","));
        mainMap.put("invoiceClass", classIds);
        if (classNames.length() > 12 && isOmit) {
            classNames = classNames.substring(0, 12) + "...";
        }
        mainMap.put("invoiceClassName", classNames);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)classIds)) {
            mainMap.put("invoiceClassName_show", "1");
        } else {
            mainMap.put("invoiceClassName_show", "0");
        }
    }

    public void initInvoiceClass(List<Map<String, Object>> invoiceArr) {
        List mainIdList = invoiceArr.stream().map(v -> {
            Object id = v.get("mainId");
            if (id == null) {
                id = v.get(MAIN_ID_KEY);
            }
            return id;
        }).filter(v -> v != null).collect(Collectors.toList());
        DynamicObject[] invoiceClass = BusinessDataServiceHelper.load((String)"rim_invoice", (String)"id,mul_class,mul_class.name", (QFilter[])new QFilter[]{new QFilter(MAIN_ID_KEY, "in", mainIdList)});
        Map<Object, DynamicObject> idInvoiceMap = Arrays.stream(invoiceClass).collect(Collectors.toMap(v -> v.get(MAIN_ID_KEY), v -> v));
        for (int i = 0; i < invoiceArr.size(); ++i) {
            Map<String, Object> invoiceResultInfo = invoiceArr.get(i);
            Object id = invoiceResultInfo.get("mainId");
            if (id == null) {
                id = invoiceResultInfo.get(MAIN_ID_KEY);
            }
            this.initInvoiceClass(invoiceResultInfo, idInvoiceMap.get(id));
        }
    }

    public void setValueInvoiceClass(AbstractFormPlugin plugin, JSONObject invoice) {
        String classIds = invoice.getString("invoiceClass");
        List<Object> classIdsLong = Lists.newArrayListWithExpectedSize((int)0);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)classIds)) {
            classIdsLong = Arrays.stream(classIds.split(",")).filter(v -> org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)v)).map(v -> Long.parseLong(v)).collect(Collectors.toList());
        }
        this.putClassId(plugin, classIdsLong);
    }

    public List<String> getCheckList(AbstractFormPlugin plugin, String typeKey) {
        return this.getFieldKeyList(plugin, typeKey, "check_", v -> v instanceof FieldEdit && v.getKey() != null);
    }

    public List<String> getFieldKeyList(AbstractFormPlugin plugin, String typeKey, String fieldPreKey, Predicate<? super Control> predicate) {
        ArrayList checkList = Lists.newArrayList();
        Container flexContainer = (Container)plugin.getControl("lbl_select_" + typeKey);
        String containsKey = fieldPreKey + typeKey;
        if (flexContainer != null) {
            List items = flexContainer.getItems();
            for (int i = 0; i < items.size(); ++i) {
                if (!(items.get(i) instanceof Container) || items.get(i) == null) continue;
                Container container = (Container)items.get(i);
                checkList.addAll(container.getItems().stream().filter(predicate).map(v -> v.getKey()).filter(v -> StringUtils.contains((CharSequence)v, (CharSequence)containsKey)).collect(Collectors.toList()));
            }
        }
        return checkList;
    }

    public void initCheck(AbstractFormPlugin plugin, JSONArray classList, List<String> checkList, String classType) {
        int classSize = classList.size();
        int checkSize = checkList.size();
        ArrayList showKey = Lists.newArrayListWithExpectedSize((int)checkSize);
        for (int i = 0; i < checkSize; ++i) {
            showKey.add(checkList.get(i).replace("check_", "flex_check_"));
        }
        plugin.getView().setVisible(Boolean.TRUE, showKey.toArray(new String[0]));
        if (checkSize > classSize) {
            ArrayList hideKey = Lists.newArrayListWithExpectedSize((int)(checkSize - classSize));
            for (int i = classSize; i < checkSize; ++i) {
                hideKey.add(checkList.get(i).replace("check_", "flex_check_"));
            }
            plugin.getView().setVisible(Boolean.FALSE, hideKey.toArray(new String[0]));
        }
        if (classSize > checkSize) {
            classSize = checkSize;
        }
        DynamicObjectCollection entity = plugin.getView().getModel().getEntryEntity("entity");
        ArrayList list = Lists.newArrayListWithExpectedSize((int)entity.size());
        for (int i = 0; i < entity.size(); ++i) {
            if (!StringUtils.equals((CharSequence)((DynamicObject)entity.get(i)).getString("classtype"), (CharSequence)classType)) continue;
            list.add(i);
        }
        plugin.getView().getModel().deleteEntryRows("entity", list.stream().mapToInt(Integer::valueOf).toArray());
        if (classSize <= 0) {
            return;
        }
        int[] addIndex = plugin.getView().getModel().batchCreateNewEntryRow("entity", classSize);
        for (int i = 0; i < classSize; ++i) {
            JSONObject classInfo = classList.getJSONObject(i);
            String checkKey = checkList.get(i);
            FieldEdit fieldEdit = (FieldEdit)plugin.getControl(checkKey);
            fieldEdit.setCaption(new LocaleString(classInfo.getString("name")));
            plugin.getView().getModel().setValue("check_key", (Object)checkKey, addIndex[i]);
            plugin.getView().getModel().setValue("classid", (Object)classInfo.getLong(MAIN_ID_KEY), addIndex[i]);
            plugin.getView().getModel().setValue("classtype", (Object)classType, addIndex[i]);
        }
    }

    public void refreshListRow(AbstractFormPlugin plugin, String invoiceClassKey, String showKey, String mainIdKey) {
        IFormView view = plugin.getView();
        IDataModel model = view.getModel();
        ProgressBar pb = (ProgressBar)view.getControl(PRO_BAR_UPDATE_CLASS);
        if (pb != null) {
            pb.stop();
            int row = (Integer)model.getValue("updateclassrow");
            String mainId = (String)model.getValue(mainIdKey, row);
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)mainId)) {
                HashMap classInfo = Maps.newHashMapWithExpectedSize((int)2);
                classInfo.put("mainId", mainId);
                this.initInvoiceClass(classInfo);
                model.setValue(invoiceClassKey, classInfo.get("invoiceClassName"));
                model.setValue(showKey, classInfo.get("invoiceClassName_show"));
            }
        }
    }
}

