/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.input;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.invoice.query.InvoiceQueryService;
import kd.imc.rim.common.service.InvoiceLog;
import kd.imc.rim.common.utils.DBUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.TenantUtils;
import org.apache.commons.lang3.StringUtils;

public class InputInvoiceDataService {
    private static Log LOGGER = LogFactory.getLog(InputInvoiceDataService.class);
    public static final String CREATE_TIME = "fcreatetime";
    public static final String INVOICE_DATE = "finvoice_date";
    public static final String AUTH_TIME = "fauthenticate_time";
    private Set<String> paramSet;

    public List<JSONObject> queryTaskParam() {
        QFilter filter1 = new QFilter("id", ">", (Object)1L);
        DynamicObjectCollection collect = QueryServiceHelper.query((String)"rim_idb_task_param", (String)"query_type,data_date,org_id", (QFilter[])new QFilter[]{filter1});
        ArrayList<JSONObject> list = new ArrayList<JSONObject>(collect.size());
        HashSet<String> keySet = new HashSet<String>(16);
        for (DynamicObject obj : collect) {
            String queryType = obj.getString("query_type");
            Date dataDate = obj.getDate("data_date");
            String datestr = DateUtils.format(dataDate);
            Long org_id = obj.getLong("org_id");
            if (StringUtils.isEmpty((CharSequence)queryType) || StringUtils.isEmpty((CharSequence)datestr) || !keySet.add(queryType + datestr)) continue;
            JSONObject map = new JSONObject();
            map.put("queryType", (Object)queryType);
            map.put("dataDate", (Object)datestr);
            map.put("orgId", (Object)org_id);
            list.add(map);
        }
        return list;
    }

    public void deleteTaskParam(String queryType, Date dayStart, Date dayEnd, Long org) {
        if (dayStart != null && dayEnd != null) {
            QFilter filter1 = new QFilter("query_type", "=", (Object)queryType);
            QFilter filter2 = new QFilter("data_date", ">=", (Object)dayStart);
            QFilter filter4 = new QFilter("data_date", "<", (Object)dayEnd);
            QFilter filter3 = null;
            if (org > 0L) {
                filter3 = new QFilter("org", "=", (Object)org);
            }
            DeleteServiceHelper.delete((String)"rim_idb_task_param", (QFilter[])new QFilter[]{filter1, filter2, filter3, filter4});
        }
    }

    public void createParam(String queryType, Date createDate) {
        if (this.paramSet == null) {
            this.paramSet = new HashSet<String>(16);
        }
        if (createDate != null) {
            this.paramSet.add(queryType + '|' + DateUtils.format(createDate) + "|0");
        }
    }

    public void createParam(DynamicObject obj) {
        if (obj != null) {
            if (this.paramSet == null) {
                this.paramSet = new HashSet<String>(16);
            }
            Date createDate = obj.getDate("createtime");
            Date invoiceDate = obj.getDate("invoice_date");
            if (createDate != null) {
                this.paramSet.add("fcreatetime|" + DateUtils.format(createDate) + "|0");
            }
            if (invoiceDate != null) {
                this.paramSet.add("finvoice_date|" + DateUtils.format(invoiceDate) + "|0");
            }
        }
    }

    public void saveParam() {
        if (this.paramSet != null) {
            Iterator<String> it = this.paramSet.iterator();
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(this.paramSet.size());
            while (it.hasNext()) {
                String str = it.next();
                String[] ss = str.split("\\|");
                DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"rim_idb_task_param");
                obj.set("query_type", (Object)ss[0]);
                obj.set("data_date", (Object)DateUtils.stringToDate(ss[1]));
                obj.set("org_id", (Object)DynamicObjectUtil.getDynamicObjectLongValue(ss[2]));
                list.add(obj);
            }
            if (!list.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
                this.paramSet.clear();
            }
        }
    }

    public void init(Date startDate, Date endDate) {
        this.createParam(CREATE_TIME, startDate);
        String sql = "select distinct finvoice_date ,fauthenticate_time  from t_rim_invoice where fdelete ='1' and fcreatetime >=? and fcreatetime <?";
        Object[] authParam = new Object[]{startDate, endDate};
        JSONArray timeArray = DBUtils.queryJSONArray(sql, authParam);
        for (int i = 0; i < timeArray.size(); ++i) {
            JSONObject obj = timeArray.getJSONObject(i);
            if (obj.getDate("FINVOICE_DATE") != null) {
                this.createParam(INVOICE_DATE, obj.getDate("FINVOICE_DATE"));
            }
            if (obj.getDate("FAUTHENTICATE_TIME") == null) continue;
            this.createParam(AUTH_TIME, obj.getDate("FAUTHENTICATE_TIME"));
        }
        this.saveParam();
    }

    public void deleteInvoice(Object[] pks) {
        if (pks != null && pks.length > 0) {
            try (TXHandle h = TX.requiresNew();){
                String userId = RequestContext.get().getUserId();
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"rim_invoice");
                JSONArray condition = this.getDeleteCondition(mainEntityType);
                DynamicObject[] objectList = BusinessDataServiceHelper.load((Object[])pks, (DynamicObjectType)mainEntityType);
                HashMap<String, ArrayList<String>> typeSerialMap = new HashMap<String, ArrayList<String>>(8);
                InputInvoiceDataService inputInvoiceDataService = new InputInvoiceDataService();
                for (DynamicObject obj : objectList) {
                    Long invoiceType;
                    String entity;
                    ArrayList<String> list;
                    DynamicObjectCollection orgEntry;
                    for (int i = 0; i < condition.size(); ++i) {
                        JSONObject valueMap;
                        JSONObject field = condition.getJSONObject(i);
                        Object value = obj.get(field.getString("fieldId"));
                        if (value == null || (valueMap = field.getJSONObject("value")).getString(value.toString()) == null) continue;
                        throw new KDException(new ErrorCode("0011", String.format(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25:%1$s\u4e3a%2$s\u4e0d\u80fd\u5220\u9664", (String)"InputInvoiceDataService_0", (String)"imc-rim-common", (Object[])new Object[0]), field.getString("fieldName"), field.getString("valueMsg"))), new Object[0]);
                    }
                    inputInvoiceDataService.createParam(obj);
                    obj.set("delete", (Object)"3");
                    obj.set("modifier", (Object)userId);
                    obj.set("tax_org", (Object)0L);
                    obj.set("org", (Object)0L);
                    obj.set("modifytime", (Object)new Date());
                    obj.set("modifier", (Object)userId);
                    obj.set("creator", (Object)0L);
                    obj.set("resource", (Object)"");
                    obj.set("original_state", (Object)"0");
                    obj.set("original_time", null);
                    obj.set("receiver", (Object)0);
                    obj.set("is_revise", (Object)"0");
                    DynamicObjectCollection userEntry = obj.getDynamicObjectCollection("collect_user_entry");
                    if (userEntry != null) {
                        userEntry.clear();
                    }
                    if ((orgEntry = obj.getDynamicObjectCollection("collect_org_entry")) != null) {
                        orgEntry.clear();
                    }
                    if ((list = (ArrayList<String>)typeSerialMap.get(entity = InputInvoiceTypeEnum.getEntity(invoiceType = Long.valueOf(DynamicObjectUtil.getDynamicObjectLongValue(obj.get("invoice_type")))))) == null) {
                        list = new ArrayList<String>(8);
                    }
                    list.add(obj.getString("serial_no"));
                    typeSerialMap.put(entity, list);
                }
                try {
                    String tenantNo = TenantUtils.getTenantNo();
                    ArrayList<String> serialList = new ArrayList<String>(pks.length);
                    for (Map.Entry entry : typeSerialMap.entrySet()) {
                        DynamicObject[] objList = InvoiceQueryService.loadBySerialNo((String)entry.getKey(), tenantNo, (List)entry.getValue());
                        if (objList != null && objList.length > 0) {
                            for (DynamicObject obj : objList) {
                                obj.set("delete", (Object)"3");
                                obj.set("tax_org", (Object)0L);
                                obj.set("org", (Object)0L);
                                obj.set("modifytime", (Object)new Date());
                                obj.set("modifier", (Object)userId);
                                obj.set("creator", (Object)0L);
                                obj.set("resource", (Object)"");
                                obj.set("original_state", (Object)"0");
                            }
                            SaveServiceHelper.save((DynamicObject[])objList);
                        }
                        serialList.addAll((Collection)entry.getValue());
                    }
                    QFilter qFilter = new QFilter("serial_no", "in", serialList);
                    DeleteServiceHelper.delete((String)"rim_verify_modify_his", (QFilter[])new QFilter[]{qFilter});
                    InvoiceLog.insert("delete", serialList, ResManager.loadKDString((String)"\u53d1\u7968\u5220\u9664", (String)"InputInvoiceDataService_1", (String)"imc-rim-common", (Object[])new Object[0]));
                    SaveServiceHelper.save((DynamicObject[])objectList);
                    inputInvoiceDataService.saveParam();
                }
                catch (Throwable e) {
                    h.markRollback();
                    throw e;
                }
            }
        }
    }

    private JSONArray getDeleteCondition(MainEntityType mainEntityType) {
        JSONArray returnArray = new JSONArray();
        try {
            String deletefilter = RimConfigUtils.getConfig("deletefilter");
            JSONObject json = JSONObject.parseObject((String)deletefilter);
            Map fieldMap = mainEntityType.getFields();
            for (Map.Entry entry : json.entrySet()) {
                JSONObject result = new JSONObject();
                IDataEntityProperty property = (IDataEntityProperty)fieldMap.get(entry.getKey());
                if (property == null) continue;
                StringBuilder sb = new StringBuilder();
                JSONArray array = json.getJSONArray((String)entry.getKey());
                JSONObject valueMap = new JSONObject();
                if (!(property instanceof ComboProp)) continue;
                ComboProp combo = (ComboProp)property;
                for (int i = 0; i < array.size(); ++i) {
                    if (sb.length() > 0) {
                        sb.append('|');
                    }
                    valueMap.put(array.getString(i), (Object)array.getString(i));
                    sb.append(combo.getItemByName(array.getString(i)));
                }
                result.put("fieldId", (Object)property.getName());
                LocaleString localeString = property.getDisplayName();
                if (localeString != null) {
                    result.put("fieldName", (Object)localeString.getLocaleValue());
                } else {
                    result.put("fieldName", (Object)property.getName());
                }
                result.put("value", (Object)valueMap);
                result.put("valueMsg", (Object)sb.toString());
                returnArray.add((Object)result);
            }
        }
        catch (Exception e) {
            LOGGER.info("\u83b7\u53d6\u5220\u9664\u6761\u4ef6\u914d\u7f6e\u9519\u8bef");
        }
        return returnArray;
    }
}

