/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.query;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.expense.domain.ExpenseAttachDTO;
import kd.imc.rim.common.expense.domain.ExpenseDTO;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.common.utils.UUID;
import org.apache.commons.collections4.CollectionUtils;

public class AttachSaveService {
    private static Log LOGGER = LogFactory.getLog(AttachSaveService.class);

    public static void deleteAttach(Long attachId) {
        if (ObjectUtils.isEmpty((Object)attachId)) {
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>(1);
        ids.add(attachId);
        AttachSaveService.deleteAttach(ids);
    }

    public static void deleteAttach(List<Long> attachIds) {
        if (ObjectUtils.isEmpty(attachIds)) {
            return;
        }
        Object[] attachs = BusinessDataServiceHelper.load((Object[])attachIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"rim_attach"));
        if (ObjectUtils.isEmpty((Object[])attachs)) {
            return;
        }
        for (Object attach : attachs) {
            attach.set("update_time", (Object)new Date());
            attach.set("rim_user", (Object)0L);
            attach.set("user", (Object)0L);
        }
        SaveServiceHelper.save((DynamicObject[])attachs);
    }

    public static void deleteAttach(Long attachId, String serialNo) {
        AttachSaveService.deleteAttach(attachId, serialNo, null);
    }

    public static void deleteAttach(Long attachId, String serialNo, String relationType) {
        if (StringUtils.isEmpty((CharSequence)serialNo) && attachId != null) {
            AttachSaveService.deleteAttach(attachId);
        } else if (!StringUtils.isEmpty((CharSequence)serialNo) && attachId != null) {
            QFilter attachFilter = new QFilter("attach_id", "=", (Object)attachId.toString());
            DynamicObjectCollection collect = QueryServiceHelper.query((String)"rim_attach_relation", (String)"id,relation_id,relation_type", (QFilter[])new QFilter[]{attachFilter});
            ArrayList<Object> deleteRelation = new ArrayList<Object>(2);
            Boolean hasOther = Boolean.FALSE;
            if (StringUtils.isEmpty((CharSequence)relationType)) {
                relationType = "3";
            }
            for (DynamicObject obj : collect) {
                if (StringUtils.equals((CharSequence)serialNo, (CharSequence)obj.getString("relation_id")) && StringUtils.equals((CharSequence)relationType, (CharSequence)obj.getString("relation_type"))) {
                    deleteRelation.add(obj.get("id"));
                    continue;
                }
                hasOther = Boolean.TRUE;
            }
            if (!deleteRelation.isEmpty()) {
                DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"rim_attach_relation"), (Object[])deleteRelation.toArray());
            }
            if (!hasOther.booleanValue()) {
                AttachSaveService.deleteAttach(attachId);
            }
        }
    }

    public void save(ExpenseDTO billExpense) {
        List<ExpenseAttachDTO> attachDTOList = billExpense.getAttachDTOList();
        if (CollectionUtils.isEmpty(attachDTOList)) {
            LOGGER.info("\u9644\u4ef6\u6570\u636e\u5185\u5bb9\u4e3a\u7a7a\uff0c\u4e0d\u9700\u8981\u4fdd\u5b58");
            return;
        }
        Object[] needSaveAttachs = new DynamicObject[attachDTOList.size()];
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        int i = 0;
        HashMap<String, Integer> rowIndexMap = new HashMap<String, Integer>(2);
        for (ExpenseAttachDTO attachDTO : attachDTOList) {
            DynamicObject needSaveAttach;
            DynamicObject existsSaveAttach;
            Long attachId = BigDecimalUtil.transDecimal(attachDTO.getAttachId()).longValue();
            if (attachId > 0L && (existsSaveAttach = BusinessDataServiceHelper.loadSingle((Object)attachId, (String)"rim_attach")) != null) {
                List pks = QueryServiceHelper.queryPrimaryKeys((String)"rim_attach", (QFilter[])new QFilter[]{new QFilter("attach_no", "=", (Object)attachDTO.getSerialNo())}, (String)"id", (int)1);
                needSaveAttach = CollectionUtils.isEmpty((Collection)pks) ? BusinessDataServiceHelper.newDynamicObject((String)"rim_attach") : BusinessDataServiceHelper.loadSingle(pks.get(0), (String)"rim_attach");
                needSaveAttach.set("attach_no", (Object)attachDTO.getSerialNo());
                rowIndexMap.put(attachDTO.getSerialNo(), attachDTO.getRowIndex());
                needSaveAttach.set("attach_url", (Object)existsSaveAttach.getString("attach_url"));
                needSaveAttach.set("attach_name", (Object)existsSaveAttach.getString("attach_name"));
                needSaveAttach.set("attach_type", (Object)existsSaveAttach.getString("attach_type"));
                needSaveAttach.set("remark", (Object)existsSaveAttach.getString("remark"));
                needSaveAttach.set("attach_hash_value", (Object)existsSaveAttach.getString("attach_hash_value"));
                needSaveAttach.set("user", (Object)userId);
                needSaveAttach.set("attach_category", existsSaveAttach.get("attach_category_id"));
                needSaveAttach.set("file_extension", (Object)existsSaveAttach.getString("file_extension"));
                needSaveAttach.set("snapshot_url", (Object)existsSaveAttach.getString("snapshot_url"));
                needSaveAttach.set("create_time", (Object)new Date());
                needSaveAttach.set("update_time", (Object)new Date());
                needSaveAttachs[i++] = needSaveAttach;
                continue;
            }
            needSaveAttach = BusinessDataServiceHelper.newDynamicObject((String)"rim_attach");
            String attachNo = UUID.randomUUID();
            needSaveAttach.set("attach_no", (Object)attachNo);
            rowIndexMap.put(attachNo, attachDTO.getRowIndex());
            needSaveAttach.set("attach_url", (Object)attachDTO.getAttachUrl());
            needSaveAttach.set("attach_name", (Object)attachDTO.getAttachName());
            needSaveAttach.set("attach_type", (Object)attachDTO.getAttachType());
            needSaveAttach.set("remark", (Object)attachDTO.getAttachRemark());
            FileService service = FileServiceFactory.getAttachmentFileService();
            InputStream fileInputStream = service.getInputStream(attachDTO.getAttachUrl());
            String attachHash = FileUtils.getSHA256(fileInputStream);
            needSaveAttach.set("attach_hash_value", (Object)attachHash);
            needSaveAttach.set("user", (Object)userId);
            needSaveAttach.set("create_time", (Object)new Date());
            needSaveAttach.set("update_time", (Object)new Date());
            needSaveAttachs[i++] = needSaveAttach;
        }
        if (ArrayUtils.isEmpty((Object[])needSaveAttachs)) {
            LOGGER.info("\u9644\u4ef6\u6570\u636e\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fdd\u5b58");
            return;
        }
        DynamicObject[] attachSaveResult = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])needSaveAttachs);
        ArrayList<ExpenseAttachDTO> attachCacheArray = new ArrayList<ExpenseAttachDTO>(attachSaveResult.length);
        for (DynamicObject att : attachSaveResult) {
            ExpenseAttachDTO expenseAttachDTO = new ExpenseAttachDTO();
            expenseAttachDTO.setAttachId(att.getString("id"));
            expenseAttachDTO.setAttachUrl(att.getString("attach_url"));
            expenseAttachDTO.setAttachType(att.getString("attach_type"));
            expenseAttachDTO.setAttachNo(att.getString("attach_no"));
            expenseAttachDTO.setAttachName(att.getString("attach_name"));
            expenseAttachDTO.setAttachRemark(att.getString("remark"));
            expenseAttachDTO.setRowIndex((Integer)rowIndexMap.get(att.getString("attach_no")));
            attachCacheArray.add(expenseAttachDTO);
        }
        billExpense.setAttachDTOList(attachCacheArray);
    }
}

