/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.query;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class GoodsCodeQueryService {
    public static String getGoodsCodeByName(String goodsName) {
        if (StringUtils.isEmpty((String)goodsName)) {
            return null;
        }
        HashMap<String, String> goodsMap = GoodsCodeQueryService.getSimpleGoodsName(goodsName);
        String simpleGoodsName = goodsMap.get("simpleGoodsName");
        String name = goodsMap.get("name");
        if (StringUtils.isEmpty((String)simpleGoodsName) && StringUtils.isEmpty((String)name)) {
            return null;
        }
        QFilter goodsNameFilter = StringUtils.isNotEmpty((String)simpleGoodsName) ? new QFilter("simplename", "=", (Object)simpleGoodsName) : new QFilter("simplename", "=", (Object)name);
        DynamicObjectCollection taxRateCodeCollection = QueryServiceHelper.query((String)"er_taxclasscode", (String)"id, simplename, name, number, mergecode, taxrate, key", (QFilter[])new QFilter[]{goodsNameFilter});
        if (CollectionUtils.isEmpty((Collection)taxRateCodeCollection)) {
            return null;
        }
        String returnStr = "";
        String[] subGoodsNames = GoodsCodeQueryService.getSubGoodsName(name);
        String minGoodsCode = null;
        String startGoodsCode = null;
        int keyFlag = 0;
        for (DynamicObject taxRateCode : taxRateCodeCollection) {
            int tempFlag;
            String itemName = taxRateCode.getString("name");
            String taxRate = taxRateCode.getString("taxRate");
            if (StringUtils.isNotEmpty((String)taxRate)) {
                if (StringUtils.isEmpty((String)name)) {
                    return taxRateCode.getString("mergecode");
                }
                if (name.equals(itemName)) {
                    return taxRateCode.getString("mergecode");
                }
            }
            if (name.equals(itemName)) {
                if (StringUtils.isNotEmpty((String)taxRate)) {
                    return taxRateCode.getString("mergecode");
                }
                returnStr = taxRateCode.getString("mergecode");
                startGoodsCode = taxRateCode.getString("mergecode").replaceAll("0+?$", "");
            }
            if ((tempFlag = GoodsCodeQueryService.findKeyWord(taxRateCode, startGoodsCode, subGoodsNames, itemName)) <= keyFlag) continue;
            minGoodsCode = taxRateCode.getString("mergecode");
            returnStr = taxRateCode.getString("mergecode");
            keyFlag = tempFlag;
        }
        if (minGoodsCode == null) {
            return ((DynamicObject)taxRateCodeCollection.get(0)).getString("mergecode");
        }
        return returnStr;
    }

    private static int findKeyWord(DynamicObject taxRateCode, String startGoodsCode, String[] subGoodsNames, String itemName) {
        String key = StringUtils.trim((String)taxRateCode.getString("key"));
        if (subGoodsNames != null && StringUtils.isNotEmpty((String)key) && StringUtils.isNotEmpty((String)taxRateCode.getString("taxrate"))) {
            int index = 10;
            for (String subName : subGoodsNames) {
                if (key.indexOf(subName) >= 0) {
                    if (StringUtils.isNotEmpty((String)startGoodsCode) && taxRateCode.getString("number").startsWith(startGoodsCode)) {
                        return index + 1;
                    }
                    return index;
                }
                --index;
            }
        }
        if (StringUtils.isNotEmpty((String)taxRateCode.getString("taxrate"))) {
            if (StringUtils.isNotEmpty((String)startGoodsCode) && taxRateCode.getString("number").startsWith(startGoodsCode)) {
                if (StringUtils.isNotEmpty((String)itemName) && itemName.indexOf("\u5176\u4ed6") >= 0) {
                    return 4;
                }
                return 3;
            }
            if (StringUtils.isNotEmpty((String)itemName) && itemName.indexOf("\u5176\u4ed6") >= 0) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    private static String[] getSubGoodsName(String name) {
        if (StringUtils.isEmpty((String)name)) {
            return null;
        }
        if (name.length() <= 2) {
            return new String[]{name};
        }
        int index = 0;
        String[] subGoodsNames = null;
        for (int times = 0; times < 3; ++times) {
            int end = 4 - times;
            if (end > name.length()) continue;
            if (index == 0) {
                subGoodsNames = new String[3 - times];
            }
            if (subGoodsNames == null || name == null) continue;
            subGoodsNames[index++] = name.substring(0, 4 - times);
        }
        return subGoodsNames;
    }

    private static HashMap<String, String> getSimpleGoodsName(String goodsName) {
        HashMap result = Maps.newHashMap();
        if (goodsName.startsWith("*")) {
            String[] names = goodsName.split("\\*");
            if (names.length == 0) {
                result.put("name", "");
                result.put("simpleGoodsName", "");
            } else {
                result.put("simpleGoodsName", names[1]);
                if (names.length > 2) {
                    result.put("name", names[2]);
                } else {
                    result.put("name", "");
                }
            }
        } else if (goodsName.contains("-")) {
            String[] names = goodsName.split("-");
            if (names.length == 1) {
                result.put("simpleGoodsName", names[0]);
            } else if (names.length > 1) {
                result.put("simpleGoodsName", names[0]);
                result.put("name", names[1]);
            }
        } else if (goodsName.contains("*")) {
            String[] names = goodsName.split("\\*");
            if (names.length == 1) {
                result.put("subGoodsName", names[0]);
            } else if (names.length > 1) {
                result.put("simpleGoodsName", names[0]);
                result.put("name", names[1]);
            }
        } else {
            result.put("name", goodsName);
        }
        return result;
    }
}

