/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.query.config;

import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.filter.CommonDateFilterColumn;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.field.ComboItem;
import kd.bos.list.ComboListColumn;
import kd.bos.list.DateListColumn;
import kd.bos.list.DecimalListColumn;
import kd.bos.list.DynamicTextListColumn;
import kd.bos.list.IListColumn;
import kd.bos.list.ListColumn;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.ek.EkServiceFactory;
import kd.imc.rim.common.ek.service.InvoiceQueryEkService;
import kd.imc.rim.common.invoice.query.config.ColumnConfig;
import kd.imc.rim.common.invoice.query.config.ListConfig;
import kd.imc.rim.common.invoice.query.config.ListFieldNameSevice;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.MetadataUtil;
import kd.imc.rim.common.utils.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class ListConfigUtil {
    private static Log LOGGER = LogFactory.getLog(ListConfigUtil.class);
    private static String uuid = UUID.randomUUIDZero();

    public static List<IListColumn> getListColumn(String fileName, String listMetaId) {
        ListConfig config = ListConfigUtil.getListConfig(fileName, listMetaId);
        return ListConfigUtil.getListColumn(config);
    }

    public static List<IListColumn> getListColumn(ListConfig config, List<String> hideList) {
        if (config != null && CollectionUtils.isNotEmpty(config.getListColumn())) {
            List<ColumnConfig> listColumn = config.getListColumn();
            ArrayList<IListColumn> list = new ArrayList<IListColumn>(16);
            for (ColumnConfig column : listColumn) {
                if (null != hideList && hideList.contains(column.getFieldKey())) continue;
                list.add(ListConfigUtil.createListColumn(column));
            }
            return list;
        }
        return null;
    }

    public static List<IListColumn> getListColumn(ListConfig config) {
        return ListConfigUtil.getListColumn(config, null);
    }

    public static ListConfig getListConfig(String fileName, String listMetaId, Long userId) {
        ListConfig config = ListConfigUtil.getExportConfigFromDb(fileName, listMetaId, userId);
        if (config != null) {
            return config;
        }
        return ListConfigUtil.getListDefConfig(fileName, listMetaId);
    }

    public static ListConfig getListConfig(String fileName, String listMetaId) {
        String userId = RequestContext.get().getUserId();
        return ListConfigUtil.getListConfig(fileName, listMetaId, Long.valueOf(userId));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ListConfig getListDefConfig(String fileName, String listMetaId) {
        String key = uuid + fileName;
        String content = CacheHelper.get(key);
        if (content == null) {
            content = ListConfigUtil.loadFile(fileName);
        }
        InvoiceQueryEkService ekService = EkServiceFactory.getInvoiceQueryEkService();
        if (content == null) {
            return ekService.getListConfig(fileName, listMetaId, null);
        }
        try (ByteArrayInputStream in = new ByteArrayInputStream(content.getBytes("utf-8"));){
            SAXReader sax = new SAXReader();
            Document document = sax.read((InputStream)in);
            Element root = document.getRootElement();
            List listMeta = root.elements("ListMeta");
            Element element1 = ListConfigUtil.getElement(listMetaId, listMeta);
            if (element1 == null) return null;
            ListConfig listConfig2 = new ListConfig();
            ListConfigUtil.loadItems(element1, listConfig2, fileName, listMetaId);
            ListConfigUtil.loadCommonFilters(element1, listConfig2, fileName, listMetaId);
            ListConfig listConfig = ekService.getListConfig(fileName, listMetaId, listConfig2);
            return listConfig;
        }
        catch (Exception e) {
            LOGGER.error(String.format("\u89e3\u6790\u6587\u4ef6[%s]\u5931\u8d25", fileName), (Throwable)e);
        }
        return null;
    }

    private static Element getElement(String listMetaId, List<Element> listMeta) {
        Element e;
        HashMap<String, Element> map = new HashMap<String, Element>(listMeta.size());
        String ref = null;
        Element element1 = null;
        for (Element element : listMeta) {
            String id = element.attributeValue("id");
            map.put(id, element);
            if (!listMetaId.equals(id)) continue;
            element1 = element;
            ref = element.attributeValue("ref");
            if (StringUtils.isEmpty((String)ref)) {
                return element;
            }
            Element e2 = (Element)map.get(ref);
            if (null == e2) continue;
            return e2;
        }
        if (!StringUtils.isEmpty(ref) && null != (e = (Element)map.get(ref))) {
            return e;
        }
        return element1;
    }

    private static void loadCommonFilters(Element element, ListConfig listConfig, String fileName, String listMetaId) {
        Element commonFilters = element.element("CommonFilters");
        if (commonFilters != null) {
            List itemList = commonFilters.elements();
            ListFieldNameSevice nameService = new ListFieldNameSevice();
            Map<String, String> nameMap = nameService.getFileNameMap(fileName, listMetaId);
            for (Element filters : itemList) {
                CommonFilterColumn filterColumn;
                String type = filters.getName();
                String name = filters.attributeValue("name");
                String fieldId = filters.attributeValue("key");
                String localNameKey = "fname-" + fieldId;
                if (nameMap != null && nameMap.get(localNameKey) != null) {
                    name = nameMap.get(localNameKey);
                }
                if (!ListConfigUtil.canUse(filters, listMetaId)) continue;
                List items = filters.elements("item");
                ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
                ArrayList<String> defaultValues = new ArrayList<String>();
                for (Element item : items) {
                    String itemVal = item.attributeValue("value");
                    ComboItem comboItem = new ComboItem();
                    comboItem.setValue(itemVal);
                    String localValKey = "fval-" + fieldId + itemVal;
                    if (nameMap != null && nameMap.get(localValKey) != null) {
                        comboItem.setCaption(new LocaleString(nameMap.get(localValKey)));
                    } else {
                        comboItem.setCaption(new LocaleString(item.attributeValue("name")));
                    }
                    if ("true".equals(item.attributeValue("default"))) {
                        defaultValues.add(item.attributeValue("value"));
                    }
                    comboItems.add(comboItem);
                }
                if ("CommonFilter".equals(type)) {
                    Boolean multi = Boolean.TRUE;
                    filterColumn = new CommonFilterColumn();
                    filterColumn.setFieldName(fieldId);
                    filterColumn.setCaption(new LocaleString(name));
                    filterColumn.setComboItems(comboItems);
                    filterColumn.setMulti(multi.booleanValue());
                    if (!CollectionUtils.isEmpty(defaultValues)) {
                        filterColumn.setDefaultValues(defaultValues);
                    }
                    listConfig.addFilterColumn((FilterColumn)filterColumn);
                }
                if (!"CommonDate".equals(type)) continue;
                Boolean custom = Boolean.TRUE;
                filterColumn = new CommonDateFilterColumn();
                filterColumn.setFieldName(fieldId);
                filterColumn.setCaption(new LocaleString(name));
                filterColumn.setComboItems(comboItems);
                filterColumn.setCustom(custom.booleanValue());
                if (!CollectionUtils.isEmpty(defaultValues)) {
                    filterColumn.setDefaultValue(defaultValues.get(0).toString());
                }
                listConfig.addFilterColumn((FilterColumn)filterColumn);
            }
        }
    }

    private static void loadItems(Element element, ListConfig listConfig, String fileName, String listMeta) {
        Element items = element.element("Items");
        List itemList = items.elements();
        int seq = 1;
        ListFieldNameSevice nameService = new ListFieldNameSevice();
        Map<String, String> nameMap = nameService.getFileNameMap(fileName, listMeta);
        for (Element item : itemList) {
            String type = item.getName();
            String name = item.attributeValue("name");
            String fieldId = item.attributeValue("key");
            if (nameMap != null && nameMap.get(fieldId) != null) {
                name = nameMap.get(fieldId);
            }
            if (!ListConfigUtil.canUse(item, listMeta) || "audit_result".equals(fieldId) && !MetadataUtil.exists("irew_audit_result").booleanValue()) continue;
            String format = item.attributeValue("format");
            String hyper = item.attributeValue("hyperlink");
            String visible = item.attributeValue("visible");
            String width = item.attributeValue("width");
            String parentId = item.attributeValue("parentId");
            String textAlign = item.attributeValue("textAlign");
            String encrypt = item.attributeValue("encrypt");
            String refField = item.attributeValue("refField");
            String showStyle = item.attributeValue("showStyle");
            String columnOrderAndFilter = item.attributeValue("columnOrderAndFilter");
            ColumnConfig config = new ColumnConfig();
            config.setColumnType(type);
            config.setName(name);
            config.setFieldKey(fieldId);
            config.setHyperlink("true".equals(hyper));
            config.setWidth(width);
            config.setVisible(11);
            config.setEncrypt("true".equals(encrypt));
            config.setColumnOrderAndFilter(true);
            if ("false".equals(columnOrderAndFilter)) {
                config.setColumnOrderAndFilter(false);
            }
            if ("false".equals(visible)) {
                config.setVisible(0);
            }
            if ("DateListColumn".equals(type) && StringUtils.isEmpty((String)format)) {
                format = "yyyy-MM-dd";
            }
            config.setDisplayFormatString(format);
            config.setParentId(parentId);
            config.setTextAlign(textAlign);
            config.setSeq(seq++);
            config.setRefField(refField);
            config.setShowStyle(1);
            if (StringUtils.isNotEmpty((String)showStyle)) {
                config.setShowStyle(Integer.parseInt(showStyle));
            }
            listConfig.addListColumn(config);
            if (StringUtils.isNotEmpty((String)refField)) {
                listConfig.addRef(fieldId, refField);
            }
            if (!config.isEncrypt()) continue;
            listConfig.addEncryptField(config.getFieldKey());
        }
    }

    public static IListColumn createListColumn(ColumnConfig config) {
        DynamicTextListColumn listColumn = null;
        if ("DynamicTextListColumn".equals(config.getColumnType())) {
            listColumn = new DynamicTextListColumn();
        } else if ("DecimalListColumn".equals(config.getColumnType())) {
            DecimalListColumn decimalListColumn = new DecimalListColumn();
            Boolean showZero = Boolean.TRUE;
            decimalListColumn.setZeroShow(showZero.booleanValue());
            if (StringUtils.isNotEmpty((String)config.getDisplayFormatString())) {
                decimalListColumn.setDisplayFormatString(config.getDisplayFormatString());
            }
            decimalListColumn.setSummary(1);
            listColumn = decimalListColumn;
        } else if ("DateListColumn".equals(config.getColumnType())) {
            DateListColumn dateColumn = new DateListColumn();
            if (StringUtils.isNotEmpty((String)config.getDisplayFormatString())) {
                dateColumn.setDisplayFormatString(config.getDisplayFormatString());
            }
            listColumn = dateColumn;
        } else if ("ComboListColumn".equals(config.getColumnType())) {
            ComboListColumn dateColumn = new ComboListColumn();
            dateColumn.setShowStyle(config.getShowStyle());
            listColumn = dateColumn;
        } else {
            listColumn = new ListColumn();
        }
        listColumn.setCaption(new LocaleString(config.getName()));
        listColumn.setClassName("className");
        listColumn.setFieldName(config.getFieldKey());
        listColumn.setHyperlink(false);
        listColumn.setKey(config.getFieldKey());
        if (StringUtils.isNotEmpty((String)config.getTextAlign())) {
            listColumn.setTextAlign(config.getTextAlign());
        } else {
            listColumn.setTextAlign("left");
        }
        if (StringUtils.isNotEmpty((String)config.getParentId())) {
            listColumn.setParentViewKey(config.getParentId());
        } else {
            listColumn.setParentViewKey("gridview");
        }
        if ("fseq".equals(config.getFieldKey())) {
            listColumn.setSeqColumnType("EntitySeq");
        }
        listColumn.setListFieldKey(config.getFieldKey());
        listColumn.setSeq(config.getSeq());
        listColumn.setFieldName(config.getName());
        if (StringUtils.isNotEmpty((String)config.getWidth())) {
            listColumn.setWidth(new LocaleString(config.getWidth()));
        } else {
            listColumn.setWidth(new LocaleString("100px"));
        }
        listColumn.setHyperlink(config.isHyperlink());
        listColumn.setVisible(config.getVisible());
        listColumn.setColumnOrderAndFilter(config.isColumnOrderAndFilter());
        return listColumn;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static synchronized String loadFile(String template) {
        try (InputStream inStream = ListConfigUtil.class.getClassLoader().getResourceAsStream("invoice_list/" + template + ".xml");){
            if (null == inStream) return null;
            String content = IOUtils.toString((InputStream)inStream, (String)"utf-8");
            CacheHelper.put(uuid + template, content, 86400);
            String string = content;
            return string;
        }
        catch (IOException e) {
            LOGGER.error("\u52a0\u8f7dinvoice_list/{}.xml\u5931\u8d25", (Object)template, (Object)e);
            return null;
        }
    }

    private static ListConfig getExportConfigFromDb(String fileName, String listMetaId, Long userId) {
        int index = fileName.indexOf("_export");
        if (index > 1 && userId != null && userId > 0L) {
            QFilter filter3;
            QFilter filter2;
            String queryType = fileName.substring(0, index);
            QFilter filter1 = new QFilter("query_type", "=", (Object)queryType);
            DynamicObjectCollection collect = QueryServiceHelper.query((String)"rim_export_config", (String)"item.entity_key,item.field_key,item.field_name,item.colwidth,item.exportpropkey", (QFilter[])new QFilter[]{filter1, filter2 = new QFilter("invoice_type", "=", (Object)listMetaId), filter3 = new QFilter("creater", "=", (Object)userId)});
            if (CollectionUtils.isEmpty((Collection)collect)) {
                return null;
            }
            HashMap<String, MainEntityType> entityTypeMap = new HashMap<String, MainEntityType>(2);
            ListConfig listConfig = new ListConfig();
            int count = 0;
            for (DynamicObject configObject : collect) {
                DynamicProperty dynamicProperty;
                String entity_key = configObject.getString("item.entity_key");
                if (StringUtils.isEmpty((String)entity_key)) continue;
                MainEntityType entityType = (MainEntityType)entityTypeMap.get(entity_key);
                if (entityType == null) {
                    entityType = EntityMetadataCache.getDataEntityType((String)entity_key);
                    entityTypeMap.put(entity_key, entityType);
                }
                if (entityType == null) continue;
                ++count;
                List<ColumnConfig> baseConfigs = ListConfigUtil.createBaseDataColumn(configObject);
                if (!baseConfigs.isEmpty()) {
                    listConfig.getListColumn().addAll(baseConfigs);
                    continue;
                }
                ColumnConfig config = new ColumnConfig();
                String fieldKey = null;
                String field = configObject.getString("item.field_key");
                if (!"rim_invoice".equals(entity_key)) {
                    config.setColumnType("DynamicTextListColumn");
                    fieldKey = "dynamictext_" + field;
                    config.setRefField(field);
                    dynamicProperty = entityType.getProperty(field);
                    ListConfigUtil.setValueMap(dynamicProperty, config);
                } else {
                    dynamicProperty = entityType.getProperty(field);
                    if (dynamicProperty instanceof ComboProp) {
                        config.setColumnType("ComboListColumn");
                        ListConfigUtil.setValueMap(dynamicProperty, config);
                    } else if (dynamicProperty instanceof DateTimeProp) {
                        config.setColumnType("DateListColumn");
                    } else {
                        config.setColumnType("ListColumn");
                    }
                    fieldKey = configObject.getString("item.field_key");
                }
                String fieldName = configObject.getString("item.field_name");
                config.setName(fieldName);
                config.setFieldKey(fieldKey);
                config.setHyperlink(false);
                config.setWidth("" + configObject.getInt("item.colwidth"));
                config.setVisible(11);
                listConfig.addListColumn(config);
            }
            if (count > 0) {
                return listConfig;
            }
        }
        return null;
    }

    private static List<ColumnConfig> createBaseDataColumn(DynamicObject configObject) {
        ArrayList<ColumnConfig> list = new ArrayList<ColumnConfig>(4);
        String exportpropkey = configObject.getString("item.exportpropkey");
        if (!StringUtils.isEmpty((String)exportpropkey)) {
            JSONObject json = JSONObject.parseObject((String)exportpropkey);
            for (Map.Entry entry : json.entrySet()) {
                ColumnConfig config = new ColumnConfig();
                String entity_key = configObject.getString("item.entity_key");
                if (!"rim_invoice".equals(entity_key)) {
                    config.setColumnType("DynamicTextListColumn");
                } else {
                    config.setColumnType("ListColumn");
                }
                String fieldName = configObject.getString("item.field_name");
                String fieldKey = configObject.getString("item.field_key");
                String fkey = fieldKey + '.' + (String)entry.getKey();
                String fname = "" + entry.getValue();
                config.setName(fname);
                config.setFieldKey(fkey);
                config.setHyperlink(false);
                config.setWidth("" + configObject.getInt("item.colwidth"));
                config.setVisible(11);
                list.add(config);
            }
        }
        return list;
    }

    private static void setValueMap(DynamicProperty dynamicProperty, ColumnConfig config) {
        List comboItems;
        if (dynamicProperty instanceof ComboProp && (comboItems = ((ComboProp)dynamicProperty).getComboItems()) != null) {
            LinkedHashMap<String, String> items = new LinkedHashMap<String, String>(8);
            for (ValueMapItem item : comboItems) {
                items.put(item.getValue(), item.getName().getLocaleValue());
            }
            config.setValueMap(items);
        }
    }

    private static boolean canUse(Element item, String listMetaId) {
        String invoiceType = item.attributeValue("invoiceType");
        return !StringUtils.isNotEmpty((String)invoiceType) || (invoiceType = ',' + invoiceType + ',').indexOf(',' + listMetaId + ',') >= 0;
    }
}

