/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.query.convert;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.InvoiceSaveConstant;
import kd.imc.rim.common.ek.EkServiceFactory;
import kd.imc.rim.common.invoice.query.convert.impl.AirConvertService;
import kd.imc.rim.common.invoice.query.convert.impl.AirEleConvertService;
import kd.imc.rim.common.invoice.query.convert.impl.CustomConvertService;
import kd.imc.rim.common.invoice.query.convert.impl.ElectricConvertService;
import kd.imc.rim.common.invoice.query.convert.impl.FinancialConvertService;
import kd.imc.rim.common.invoice.query.convert.impl.GeneralConvertService;
import kd.imc.rim.common.invoice.query.convert.impl.MotorConvertService;
import kd.imc.rim.common.invoice.query.convert.impl.OrdinaryConvertService;
import kd.imc.rim.common.invoice.query.convert.impl.OtherConvertService;
import kd.imc.rim.common.invoice.query.convert.impl.OverSeaConverService;
import kd.imc.rim.common.invoice.query.convert.impl.QuotaConvertService;
import kd.imc.rim.common.invoice.query.convert.impl.SpecialConvertService;
import kd.imc.rim.common.invoice.query.convert.impl.TaxProofConvertService;
import kd.imc.rim.common.invoice.query.convert.impl.TaxiConvertService;
import kd.imc.rim.common.invoice.query.convert.impl.TollConvertService;
import kd.imc.rim.common.invoice.query.convert.impl.TrainConvertService;
import kd.imc.rim.common.invoice.query.convert.impl.TrainEleConvertService;
import kd.imc.rim.common.invoice.query.convert.impl.TrainRefundConvertService;
import kd.imc.rim.common.invoice.query.convert.impl.TransportProofConvertService;
import kd.imc.rim.common.invoice.query.convert.impl.UsedCarConvertService;
import kd.imc.rim.common.invoice.query.convert.impl.WithHoldConvertService;
import kd.imc.rim.common.invoice.verify.VerifyUtil;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.RimConfigUtils;
import org.apache.commons.lang3.StringUtils;

public class InvoiceConvertService {
    protected String resource;
    protected Long invoiceType;
    protected String orgType;
    protected String cusFields;
    private static BigDecimal maxAmount = new BigDecimal("9999999999999.9999999999");

    public static InvoiceConvertService newInstance(Long type, String resource) {
        InvoiceConvertService invoiceConvertService = InvoiceConvertService.newInstance(type);
        if (invoiceConvertService != null) {
            invoiceConvertService.setResource(resource);
            String cusFields = RimConfigUtils.getConfig("rim_invoice_convert", "cus_fields");
            if (StringUtils.isNotEmpty((CharSequence)cusFields)) {
                invoiceConvertService.setCusFields(cusFields);
            }
        }
        return invoiceConvertService;
    }

    public static InvoiceConvertService newInstance(Long type) {
        if (type == null) {
            return null;
        }
        InvoiceConvertService saveService = null;
        if (InputInvoiceTypeEnum.ORDINARY_PAPER.getCode().equals(type) || InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode().equals(type) || InputInvoiceTypeEnum.ORDINARY_ROLL.getCode().equals(type)) {
            saveService = new OrdinaryConvertService();
        } else if (InputInvoiceTypeEnum.SPECIAL_ELECTRON.getCode().equals(type) || InputInvoiceTypeEnum.SPECIAL_PAPER.getCode().equals(type)) {
            saveService = new SpecialConvertService();
        } else if (InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(type) || InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode().equals(type)) {
            saveService = new ElectricConvertService(type);
        } else if (InputInvoiceTypeEnum.AIR_INVOICE.getCode().equals(type)) {
            saveService = new AirConvertService();
        } else if (InputInvoiceTypeEnum.TOLL_ELECTRON.getCode().equals(type)) {
            saveService = new TollConvertService();
        } else if (InputInvoiceTypeEnum.GENERAL_PAPER.getCode().equals(type) || InputInvoiceTypeEnum.GENERAL_ELECTRON.getCode().equals(type) || InputInvoiceTypeEnum.ROAD_BRIDGE.getCode().equals(type)) {
            saveService = new GeneralConvertService();
        } else if (InputInvoiceTypeEnum.TRAIN_INVOICE.getCode().equals(type)) {
            saveService = new TrainConvertService();
        } else if (InputInvoiceTypeEnum.TRANSPORT_INVOICE.getCode().equals(type) || InputInvoiceTypeEnum.BOAT_INVOICE.getCode().equals(type)) {
            saveService = new TransportProofConvertService();
        } else if (InputInvoiceTypeEnum.TAXI_INVOICE.getCode().equals(type)) {
            saveService = new TaxiConvertService();
        } else if (InputInvoiceTypeEnum.QUOTA_INVOICE.getCode().equals(type)) {
            saveService = new QuotaConvertService();
        } else if (InputInvoiceTypeEnum.TAX_PROOF.getCode().equals(type)) {
            saveService = new TaxProofConvertService();
        } else if (InputInvoiceTypeEnum.OTHER_INVOICE.getCode().equals(type)) {
            saveService = new OtherConvertService();
        } else if (InputInvoiceTypeEnum.MOTOR_INVOICE.getCode().equals(type)) {
            saveService = new MotorConvertService();
        } else if (InputInvoiceTypeEnum.USEDCAR_INVOICE.getCode().equals(type)) {
            saveService = new UsedCarConvertService();
        } else if (InputInvoiceTypeEnum.HGJKS.getCode().equals(type)) {
            saveService = new CustomConvertService();
        } else if (InputInvoiceTypeEnum.TRAIN_REFUND.getCode().equals(type)) {
            saveService = new TrainRefundConvertService();
        } else if (InputInvoiceTypeEnum.FINANCIAL_INVOICE.getCode().equals(type)) {
            saveService = new FinancialConvertService();
        } else if (InputInvoiceTypeEnum.OVERSEA_INVOICE.getCode().equals(type)) {
            saveService = new OverSeaConverService();
        } else if (InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(type)) {
            saveService = new AirEleConvertService();
        } else if (InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode().equals(type)) {
            saveService = new TrainEleConvertService();
        } else if (InputInvoiceTypeEnum.WITHHOLDING.getCode().equals(type)) {
            saveService = new WithHoldConvertService();
        }
        return saveService;
    }

    public JSONObject convert(DynamicObject mainObject, DynamicObject bodyObject, DynamicObject fileObject) {
        JSONObject result = new JSONObject();
        Map<String, Object> fileMap = DynamicObjectUtil.dynamicObjectToMap(fileObject);
        this.setFileField(result, fileMap);
        this.setCustomField(result, fileMap);
        Map<String, Object> mainMap = DynamicObjectUtil.dynamicObjectToMap(mainObject);
        this.setMainField(result, mainMap);
        this.setCustomField(result, mainMap);
        Map<String, Object> bodyMap = DynamicObjectUtil.dynamicObjectToMap(bodyObject);
        this.setDetailField(result, bodyMap);
        this.setCustomField(result, bodyMap);
        return result;
    }

    public JSONObject convert(Map<String, Object> fileObject) {
        JSONObject result = new JSONObject();
        this.setMainField(result, fileObject);
        this.setFileField(result, fileObject);
        this.setDetailField(result, fileObject);
        if ("4".equals(this.resource)) {
            if (StringUtils.isNotEmpty((CharSequence)result.getString("authenticateFlag")) && ("1".equals(result.getString("authenticateFlag")) || "2".equals(result.getString("authenticateFlag")))) {
                result.put("checkFlag", (Object)2);
                result.put("checkTime", (Object)result.getString("selectTime"));
            } else {
                result.put("checkFlag", (Object)1);
                result.put("checkTime", (Object)"");
            }
            if (StringUtils.isNotEmpty((CharSequence)result.getString("authenticateFlag")) && "3".equals(result.getString("authenticateFlag"))) {
                result.put("authenticateFlag", (Object)3);
                result.put("authenticateTime", (Object)result.getString("authenticateTime"));
            } else if (StringUtils.isNotEmpty((CharSequence)result.getString("authenticateFlag")) && "2".equals(result.getString("authenticateFlag"))) {
                result.put("authenticateFlag", (Object)2);
                result.put("authenticateTime", (Object)result.getString("authenticateTime"));
            } else {
                result.put("authenticateFlag", (Object)1);
                result.put("authenticateTime", (Object)"");
            }
        }
        this.setCustomField(result, fileObject);
        EkServiceFactory.getInvoiceQueryEkService().convert(fileObject, result);
        return result;
    }

    public static Map<String, Object> putAll(Map<String, Object> map1, Map<String, Object> map2) {
        if (CollectionUtils.isEmpty(map2)) {
            return map1;
        }
        if (CollectionUtils.isEmpty(map1)) {
            map1 = new HashMap<String, Object>(map2.size());
            map1.putAll(map2);
            return map1;
        }
        for (Map.Entry<String, Object> entry : map2.entrySet()) {
            Object value1 = map1.get(entry.getKey());
            Object value2 = entry.getValue();
            if (value1 == null || "".equals(value1.toString().trim())) {
                map1.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (!(value2 instanceof Long) || (Long)value2 <= 0L) continue;
            map1.put(entry.getKey(), entry.getValue());
        }
        return map1;
    }

    public void setMainField(JSONObject result, Map<String, Object> fileObject) {
        String serialNo;
        DynamicObject obj;
        result.put("invoiceStatus", fileObject.get("invoice_status"));
        result.put("invoiceType", (Object)InputInvoiceTypeEnum.getAwsType(fileObject.get("invoice_type")));
        result.put("salelistSum", fileObject.get("salelist_sum"));
        String salelist_complete = (String)fileObject.get("salelist_complete");
        if (StringUtils.isNotEmpty((CharSequence)salelist_complete)) {
            result.put("salelistComplete", (Object)salelist_complete);
        }
        result.put("serialNo", (Object)DynamicObjectUtil.fieldToString(fileObject.get("serial_no")));
        result.put("delete", (Object)DynamicObjectUtil.fieldToString(fileObject.get("delete")));
        result.put("specialTypeMark", fileObject.get("special_type_mark"));
        result.put("resource", (Object)DynamicObjectUtil.fieldToString(fileObject.get("resource")));
        result.put("expenseStatus", (Object)DynamicObjectUtil.fieldToString(fileObject.get("expense_status")));
        result.put("expendStatus", (Object)DynamicObjectUtil.fieldToString(fileObject.get("expense_status")));
        result.put("billCreateTime", (Object)DynamicObjectUtil.fieldToString(fileObject.get("createtime"), "yyyy-MM-dd HH:mm:ss"));
        result.put("updateTime", (Object)DynamicObjectUtil.fieldToString(fileObject.get("modifytime"), "yyyy-MM-dd HH:mm:ss"));
        result.put("originalState", (Object)DynamicObjectUtil.fieldToString(fileObject.get("original_state")));
        if ("1".equals(result.getString("originalState"))) {
            result.put("originalTime", (Object)DynamicObjectUtil.fieldToString(fileObject.get("original_time"), "yyyy-MM-dd HH:mm:ss"));
            this.setReceiverInfo(result, BigDecimalUtil.transDecimal(fileObject.get("receiver")).longValue());
        }
        if ((InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode().equals(fileObject.get("invoice_type")) || InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(fileObject.get("invoice_type"))) && !"1".equals(fileObject.get("check_status")) && (obj = QueryServiceHelper.queryOne((String)"rim_invoice", (String)"source_area, dest_area", (QFilter[])new QFilter[]{new QFilter("serial_no", "=", (Object)(serialNo = DynamicObjectUtil.fieldToString(fileObject.get("serial_no"))))})) != null) {
            fileObject.put("source_area", obj.get("source_area"));
            fileObject.put("dest_area", obj.get("dest_area"));
        }
        result.put("sourceArea", (Object)DynamicObjectUtil.fieldToString(fileObject.get("source_area")));
        result.put("destArea", (Object)DynamicObjectUtil.fieldToString(fileObject.get("dest_area")));
        result.put("companySeal", (Object)DynamicObjectUtil.fieldToString(fileObject.get("company_seal")));
        Long orgId = DynamicObjectUtil.getDynamicObjectLongValue(fileObject.get("org_id"));
        result.put("orgNumber", (Object)this.getOrgNumber(orgId));
        String isRevise = DynamicObjectUtil.fieldToString(fileObject.get("is_revise"));
        if ("1".equals(isRevise)) {
            result.put("isRevise", (Object)"1");
            result.put("isModify", (Object)"1");
        } else {
            result.put("isRevise", (Object)"0");
            result.put("isModify", (Object)"0");
        }
        this.setInfoFromExtInfo(result, fileObject);
        if ("4".equals(this.resource)) {
            if ("1".equals(isRevise)) {
                result.put("isRevise", (Object)"2");
            } else {
                result.put("isRevise", (Object)"1");
            }
            long invoice_type = DynamicObjectUtil.getDynamicObjectLongValue(fileObject.get("invoice_type"));
            if (InputInvoiceTypeEnum.needCheck(invoice_type).booleanValue() && !InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(invoice_type) && !InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode().equals(invoice_type)) {
                JSONObject sourceObj = this.getAreaObject(fileObject, "source_area");
                if (sourceObj != null) {
                    result.putAll((Map)sourceObj);
                }
            } else {
                JSONObject destObj;
                JSONObject sourceObj = this.getAreaObject(fileObject, "source_area");
                if (sourceObj != null) {
                    result.put("departurePosition", (Object)sourceObj);
                }
                if ((destObj = this.getAreaObject(fileObject, "dest_area")) != null) {
                    result.put("destinationPosition", (Object)destObj);
                }
            }
        }
    }

    public String getOrgNumber(Long orgId) {
        if (orgId == null || orgId < 1L) {
            return "";
        }
        try {
            QFilter filter;
            DynamicObject obj;
            if ("1".equals(this.orgType) && (obj = QueryServiceHelper.queryOne((String)"bdm_third_org", (String)"org_no,third_org_no", (QFilter[])new QFilter[]{filter = new QFilter("orgid", "=", (Object)orgId)})) != null) {
                return obj.getString("third_org_no");
            }
            filter = new QFilter("id", "=", (Object)orgId);
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org", (String)"number");
            if (dynamicObject == null) {
                dynamicObject = QueryServiceHelper.queryOne((String)"bos_org", (String)"number", (QFilter[])new QFilter[]{filter});
            }
            if (dynamicObject != null) {
                return dynamicObject.getString("number");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    private JSONObject getAreaObject(Map<String, Object> invoiceObject, String key) {
        String areaStr = DynamicObjectUtil.fieldToString(invoiceObject.get(key));
        if (StringUtils.isEmpty((CharSequence)areaStr)) {
            return null;
        }
        String[] areas = areaStr.split("_");
        JSONObject obj = null;
        if (areas.length > 0) {
            obj = new JSONObject();
            obj.put("province", (Object)areas[0]);
            if (areas.length > 1) {
                obj.put("city", (Object)areas[1]);
            }
            if (areas.length > 2) {
                obj.put("area", (Object)areas[2]);
            }
        }
        return obj;
    }

    private void setInfoFromExtInfo(JSONObject result, Map<String, Object> fileObject) {
        Object ext_info = fileObject.get("ext_info");
        if (ext_info != null) {
            String invoiceResource;
            JSONObject extObject = null;
            try {
                extObject = JSONObject.parseObject((String)ext_info.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (extObject != null && StringUtils.isNotEmpty((CharSequence)(invoiceResource = extObject.getString(InvoiceSaveConstant.EXT_INVOICE_RESOURCE)))) {
                result.put("invoiceResource", (Object)invoiceResource);
            }
        }
    }

    public void setDetailField(JSONObject result, Map<String, Object> fileObject) {
        DynamicObject voucherObject;
        result.put("totalTaxAmount", (Object)DynamicObjectUtil.fieldToString(fileObject.get("total_tax_amount")));
        result.put("personFlag", (Object)VerifyUtil.isPersonInvoice(fileObject));
        String serialNo = result.getString("serialNo");
        String xbrlName = "";
        String xbrlUrl = "";
        String xbrlType = "";
        if (StringUtils.isNotEmpty((CharSequence)serialNo) && Objects.nonNull(voucherObject = QueryServiceHelper.queryOne((String)"rim_invoice_voucher", (String)"xbrl_name, xbrl_url, xbrl_type", (QFilter[])new QFilter[]{new QFilter("serial_no", "=", (Object)serialNo)}))) {
            xbrlName = voucherObject.getString("xbrl_name");
            xbrlUrl = voucherObject.getString("xbrl_url");
            xbrlType = voucherObject.getString("xbrl_type");
        }
        result.put("xbrlName", (Object)xbrlName);
        result.put("xbrlUrl", (Object)xbrlUrl);
        result.put("xbrlType", (Object)xbrlType);
    }

    public void setFileField(JSONObject result, Map<String, Object> fileObject) {
        if (fileObject != null) {
            String type = DynamicObjectUtil.fieldToString(fileObject.get("original_type"));
            result.put("fileType", (Object)type);
            String pdfUrl = "";
            String original_filename = DynamicObjectUtil.fieldToString(fileObject.get("original_filename"));
            String filepix = ".jpg";
            if ("1".equals(type)) {
                result.put("downloadUrl", fileObject.get("pdf_url"));
                pdfUrl = (String)fileObject.get("pdf_url");
                filepix = ".pdf";
            } else if ("4".equals(type)) {
                result.put("downloadUrl", fileObject.get("ofd_url"));
                pdfUrl = (String)fileObject.get("pdf_url");
                filepix = ".ofd";
            } else if ("2".equals(type)) {
                result.put("downloadUrl", fileObject.get("image_url"));
            } else if ("9".equals(type) || "xml".equals(type)) {
                result.put("downloadUrl", fileObject.get("xml_url"));
            }
            if (StringUtils.isBlank((CharSequence)original_filename)) {
                original_filename = DynamicObjectUtil.fieldToString(fileObject.get("serial_no")) + filepix;
            }
            if (StringUtils.isNotBlank((CharSequence)original_filename) && !original_filename.endsWith(filepix)) {
                int pointIndex = original_filename.lastIndexOf(".");
                original_filename = pointIndex != -1 ? original_filename.substring(0, pointIndex) + filepix : original_filename + filepix;
            }
            result.put("originalFileName", (Object)original_filename);
            if (StringUtils.isNotBlank((CharSequence)pdfUrl)) {
                result.put("pdfurl", (Object)pdfUrl);
            }
            result.put("xmlUrl", (Object)DynamicObjectUtil.fieldToString(fileObject.get("xml_url")));
            result.put("imageUrl", (Object)DynamicObjectUtil.fieldToString(fileObject.get("image_url")));
            result.put("snapshotUrl", (Object)DynamicObjectUtil.fieldToString(fileObject.get("snapshot_url")));
            result.put("pixel", (Object)DynamicObjectUtil.fieldToString(fileObject.get("pixel")));
            result.put("area", (Object)DynamicObjectUtil.fieldToString(fileObject.get("area")));
            result.put("region", (Object)DynamicObjectUtil.fieldToString(fileObject.get("region")));
            result.put("taxPdfUrl", (Object)DynamicObjectUtil.fieldToString(fileObject.get("tax_pdf_url")));
            result.put("taxOfdUrl", (Object)DynamicObjectUtil.fieldToString(fileObject.get("tax_ofd_url")));
            result.put("taxXmlUrl", (Object)DynamicObjectUtil.fieldToString(fileObject.get("tax_xml_url")));
            result.put("rotationAngle", (Object)DynamicObjectUtil.fieldToString(fileObject.get("rotation_angle")));
            if ("4".equals(this.resource)) {
                result.put("originalGraphUrl", (Object)result.getString("downloadUrl"));
            }
        }
    }

    private void setCustomField(JSONObject result, Map<String, Object> fileObject) {
        if (!StringUtils.isEmpty((CharSequence)this.cusFields)) {
            String[] fields;
            for (String fieldInfo : fields = this.cusFields.split(",")) {
                String[] field = fieldInfo.split(":");
                if (field.length <= 1) continue;
                Object newVal = fileObject.get(field[0]);
                Object oldVal = result.get((Object)field[1]);
                if (newVal == null || oldVal != null && !"".equals(oldVal.toString())) continue;
                if (newVal instanceof Date) {
                    result.put(field[1], (Object)DynamicObjectUtil.fieldToString(newVal, "yyyy-MM-dd HH:mm:ss"));
                    continue;
                }
                result.put(field[1], (Object)DynamicObjectUtil.fieldToString(newVal));
            }
        }
    }

    public static Object encrypt(Object value) {
        if (value instanceof String) {
            String str = (String)value;
            int length = str.length();
            if (length > 4 && length <= 12) {
                int avg = length / 3;
                if (avg > 0) {
                    return str.replaceAll("(.{" + avg + "}).{" + (str.length() - avg * 2) + "}(.{" + avg + "})", "$1****$2");
                }
            } else if (length > 12) {
                return str.replaceAll("(.{" + (length - 12) + "}).{8}(.{4})", "$1******$2");
            }
        }
        return value;
    }

    public static JSONObject convertInviceMainInfo(DynamicObject mainObject) {
        JSONObject result = new JSONObject();
        result.put("invoiceCode", (Object)DynamicObjectUtil.fieldToString(mainObject.get("invoice_code")));
        result.put("serialNo", (Object)DynamicObjectUtil.fieldToString(mainObject.get("serial_no")));
        result.put("invoiceNo", (Object)DynamicObjectUtil.fieldToString(mainObject.get("invoice_no")));
        result.put("invoiceDate", (Object)DynamicObjectUtil.fieldToString(mainObject.get("invoice_date"), "yyyy-MM-dd HH:mm:ss"));
        result.put("invoiceAmount", (Object)DynamicObjectUtil.fieldToString(mainObject.get("invoice_amount")));
        result.put("invoiceMoney", (Object)DynamicObjectUtil.fieldToString(mainObject.get("invoice_amount")));
        result.put("effectiveTaxAmount", (Object)DynamicObjectUtil.fieldToString(mainObject.get("effective_tax_amount")));
        String total_tax_amount = DynamicObjectUtil.fieldToString(mainObject.get("total_tax_amount"));
        result.put("taxAmount", (Object)total_tax_amount);
        result.put("totalTaxAmount", (Object)total_tax_amount);
        result.put("salerName", (Object)DynamicObjectUtil.fieldToString(mainObject.get("saler_name")));
        result.put("buyerTaxNo", (Object)DynamicObjectUtil.fieldToString(mainObject.get("buyer_tax_no")));
        result.put("buyerName", (Object)DynamicObjectUtil.fieldToString(mainObject.get("buyer_name")));
        Long invoiceTypeLong = DynamicObjectUtil.getDynamicObjectLongValue(mainObject.get("invoice_type"));
        result.put("invoiceType", (Object)InputInvoiceTypeEnum.getAwsType(invoiceTypeLong));
        result.put("invoiceStatus", (Object)DynamicObjectUtil.fieldToString(mainObject.get("invoice_status")));
        result.put("manageStatus", (Object)DynamicObjectUtil.fieldToString(mainObject.get("manage_status")));
        result.put("deductionPurpose", (Object)DynamicObjectUtil.fieldToString(mainObject.get("deduction_purpose")));
        result.put("taxPeriod", (Object)DynamicObjectUtil.fieldToString(mainObject.get("tax_period"), "yyyyMM"));
        result.put("selectTime", (Object)DynamicObjectUtil.fieldToString(mainObject.get("select_time")));
        result.put("notDeductibleType", (Object)DynamicObjectUtil.fieldToString(mainObject.get("not_deductible_type")));
        result.put("invoiceRiskLevel", (Object)DynamicObjectUtil.fieldToString(mainObject.get("invoice_risk_level")));
        result.put("invoiceSource", (Object)DynamicObjectUtil.fieldToString(mainObject.get("invoice_source")));
        String checkFlag = "0";
        String checkAuthenticateFlag = "0";
        String scanAuthenticateFlag = "0";
        String selectAuthenticateTime = "";
        String scanAuthenticateTime = "";
        String authenticateTime = DynamicObjectUtil.fieldToString(mainObject.get("authenticate_time"));
        String authenticateFlag = mainObject.getString("authenticate_flag");
        if ("1".equals(authenticateFlag)) {
            checkFlag = "1";
        } else if ("2".equals(authenticateFlag)) {
            checkFlag = "1";
            checkAuthenticateFlag = "1";
            selectAuthenticateTime = authenticateTime;
        } else if ("3".equals(authenticateFlag)) {
            checkFlag = "1";
            scanAuthenticateFlag = "1";
            scanAuthenticateTime = authenticateTime;
        }
        result.put("checkFlag", (Object)checkFlag);
        result.put("authenticateFlag", (Object)authenticateFlag);
        result.put("checkAuthenticateFlag", (Object)checkAuthenticateFlag);
        result.put("selectAuthenticateTime", (Object)selectAuthenticateTime);
        result.put("scanAuthenticateFlag", (Object)scanAuthenticateFlag);
        result.put("scanAuthenticateTime", (Object)scanAuthenticateTime);
        return result;
    }

    public static void main(String[] value) {
        System.out.print("ddd:" + InvoiceConvertService.encrypt("126789088811"));
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    protected <T> T getObject(Map<String, Object> map, String fieldKey, Class<T> clazz) {
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            try {
                BigDecimal big = BigDecimalUtil.transDecimal(map.get(fieldKey));
                if (big.compareTo(maxAmount) > 0) {
                    return (T)BigDecimal.ZERO;
                }
                return (T)big;
            }
            catch (Exception e) {
                return (T)BigDecimal.ZERO;
            }
        }
        if (Date.class.isAssignableFrom(clazz)) {
            try {
                return (T)DateUtils.getStandardDate((String)map.get(fieldKey));
            }
            catch (Exception e) {
                return null;
            }
        }
        return (T)map.get(fieldKey);
    }

    public static void updateAirInvocieAmount(Long invoiceType, Map<String, Object> mainMap, Map<String, Object> bodyMap) {
        if (InputInvoiceTypeEnum.AIR_INVOICE.getCode().equals(invoiceType) && !CollectionUtils.isEmpty(mainMap)) {
            Object value;
            mainMap.put("exclude_tax_amount", mainMap.get("invoice_amount"));
            if (!CollectionUtils.isEmpty(bodyMap) && (value = bodyMap.get("invoice_amount")) != null && !"".equals(value.toString().trim())) {
                mainMap.put("invoice_amount", value);
            }
        }
    }

    public void setProxyMark(JSONObject result) {
        if (StringUtils.isNotEmpty((CharSequence)result.getString("salerName")) && (result.getString("salerName").contains("\u56fd\u5bb6\u7a0e\u52a1") || result.getString("salerName").contains("\u4ee3\u5f00"))) {
            result.put("proxyMark", (Object)"1");
        }
        if (StringUtils.isNotEmpty((CharSequence)result.getString("remark")) && result.getString("remark").contains("\u4ee3\u5f00")) {
            result.put("proxyMark", (Object)"1");
        }
    }

    public String getOrgType() {
        return this.orgType;
    }

    public void setOrgType(String orgType) {
        this.orgType = orgType;
    }

    private void setReceiverInfo(JSONObject result, Long receiverId) {
        try {
            if (receiverId == null || receiverId <= 0L) {
                return;
            }
            DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((Object)receiverId, (String)"bos_user");
            if (user != null) {
                result.put("receiver", (Object)user.getLocaleString("name").getLocaleValue());
                result.put("receiverNumber", (Object)user.getString("number"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setCusFields(String cusFields) {
        this.cusFields = cusFields;
    }
}

