/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.query.convert.impl;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.imc.rim.common.invoice.query.convert.InvoiceConvertService;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.DynamicObjectUtil;

public class AirConvertService
extends InvoiceConvertService {
    @Override
    public void setMainField(JSONObject result, Map<String, Object> fileObject) {
        super.setMainField(result, fileObject);
        result.put("transportDeduction", (Object)DynamicObjectUtil.fieldToString(fileObject.get("transport_deduction")));
        result.put("taxPeriod", (Object)DynamicObjectUtil.fieldToString(fileObject.get("tax_period"), "yyyy-MM"));
        String deduction_flag = DynamicObjectUtil.fieldToString(fileObject.get("deduction_flag"));
        if (StringUtils.isEmpty((CharSequence)deduction_flag)) {
            deduction_flag = "0";
        }
        result.put("deductionFlag", (Object)deduction_flag);
        result.put("effectiveTaxAmount", (Object)DynamicObjectUtil.fieldToString(fileObject.get("effective_tax_amount")));
    }

    @Override
    public void setDetailField(JSONObject result, Map<String, Object> fileObject) {
        super.setDetailField(result, fileObject);
        result.put("totalAmount", (Object)DynamicObjectUtil.fieldToString(fileObject.get("total_amount")));
        result.put("amount", (Object)DynamicObjectUtil.fieldToString(fileObject.get("total_amount")));
        result.put("totalTaxAmount", (Object)DynamicObjectUtil.fieldToString(fileObject.get("total_tax_amount")));
        result.put("airNum", (Object)DynamicObjectUtil.fieldToString(fileObject.get("air_num")));
        result.put("airTime", (Object)DynamicObjectUtil.fieldToString(fileObject.get("air_time")));
        result.put("airportConstructionFee", (Object)DynamicObjectUtil.fieldToString(fileObject.get("airport_construction_fee")));
        result.put("carrier", (Object)DynamicObjectUtil.fieldToString(fileObject.get("carrier")));
        String customerIdentityNum = DynamicObjectUtil.fieldToString(fileObject.get("customer_id_no"));
        result.put("customerIdentityNum", (Object)customerIdentityNum);
        result.put("passengerName", (Object)DynamicObjectUtil.fieldToString(fileObject.get("customer_name")));
        result.put("customerName", (Object)DynamicObjectUtil.fieldToString(fileObject.get("customer_name")));
        result.put("destination", (Object)DynamicObjectUtil.fieldToString(fileObject.get("destination")));
        result.put("electronicTicketNum", (Object)DynamicObjectUtil.fieldToString(fileObject.get("eticket_no")));
        result.put("endorsement", (Object)DynamicObjectUtil.fieldToString(fileObject.get("endorsement")));
        result.put("fillingUnit", (Object)DynamicObjectUtil.fieldToString(fileObject.get("filling_unit")));
        result.put("flightNum", (Object)DynamicObjectUtil.fieldToString(fileObject.get("flight_num")));
        result.put("fuelSurcharge", (Object)DynamicObjectUtil.fieldToString(fileObject.get("fuel_surcharge")));
        result.put("insurancePremium", (Object)DynamicObjectUtil.fieldToString(fileObject.get("insurance_premium")));
        result.put("invoiceAmount", (Object)DynamicObjectUtil.fieldToString(fileObject.get("invoice_amount")));
        result.put("excludeTaxAmount", (Object)DynamicObjectUtil.fieldToString(fileObject.get("exclude_tax_amount")));
        result.put("invoiceDate", (Object)DynamicObjectUtil.fieldToString(fileObject.get("invoice_date")));
        result.put("otherTotalTaxAmount", (Object)DynamicObjectUtil.fieldToString(fileObject.get("other_amount")));
        result.put("placeOfDeparture", (Object)DynamicObjectUtil.fieldToString(fileObject.get("place_of_departure")));
        result.put("printNum", (Object)DynamicObjectUtil.fieldToString(fileObject.get("print_num")));
        result.put("salesUnitCode", (Object)DynamicObjectUtil.fieldToString(fileObject.get("agent_code")));
        result.put("agentCode", (Object)DynamicObjectUtil.fieldToString(fileObject.get("agent_code")));
        result.put("seatGrade", (Object)DynamicObjectUtil.fieldToString(fileObject.get("seat_grade")));
        String seat_name = DynamicObjectUtil.fieldToString(fileObject.get("seatgrade_name"));
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)seat_name)) {
            result.put("seatGradeName", (Object)AirConvertService.convertSeatName(DynamicObjectUtil.fieldToString(fileObject.get("seat_grade"))));
        } else {
            result.put("seatGradeName", (Object)seat_name);
        }
        Object tax_rate = fileObject.get("tax_rate");
        BigDecimal raxRate = BigDecimalUtil.transDecimal(tax_rate);
        if (tax_rate != null && BigDecimal.ZERO.compareTo(raxRate) <= 0) {
            result.put("taxRate", (Object)"0.09");
        } else {
            result.put("taxRate", (Object)DynamicObjectUtil.fieldToString(fileObject.get("tax_rate")));
        }
        result.put("internationalFlag", (Object)DynamicObjectUtil.fieldToString(fileObject.get("international_flag")));
        String ticketChanges = DynamicObjectUtil.fieldToString(fileObject.get("ticket_changes"));
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)ticketChanges)) {
            ticketChanges = "1";
        }
        result.put("ticketChanges", (Object)ticketChanges);
        result.put("invoiceNo", (Object)result.getString("electronicTicketNum"));
        if ("4".equals(this.getResource())) {
            result.put("checkStatus", (Object)"3");
            result.put("totalAmountCn", (Object)"");
            String taxAmount = "0";
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)result.getString("totalTaxAmount"))) {
                result.put("taxAmount", (Object)result.getString("totalTaxAmount"));
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)result.getString("totalAmount"))) {
                    result.put("amount", (Object)result.getBigDecimal("totalAmount").subtract(result.getBigDecimal("totalTaxAmount")).setScale(2, RoundingMode.HALF_UP).toString());
                }
            } else {
                result.put("amount", (Object)result.getString("totalAmount"));
                result.put("taxAmount", (Object)taxAmount);
            }
            result.put("invoiceCode", (Object)result.getString("invoiceDate").replaceAll("-", ""));
            result.put("amount", (Object)DynamicObjectUtil.fieldToString(result.getString("invoiceAmount")));
            result.put("trip", (Object)(result.getString("placeOfDeparture") + " - " + result.getString("destination")));
        }
    }

    public static String convertSeatName(String seatGrade) {
        String seatGradeName = "";
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)seatGrade)) {
            seatGradeName = "F".equalsIgnoreCase(seatGrade) ? "\u5934\u7b49\u8231" : ("C".equalsIgnoreCase(seatGrade) ? "\u516c\u52a1\u8231" : "\u7ecf\u6d4e\u8231");
        }
        return seatGradeName;
    }
}

