/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.recognition.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.Callable;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.SpecialTypeMarkEnum;
import kd.imc.rim.common.utils.DeductionUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class ExcelResolveTask
implements Callable<JSONObject> {
    private static Log logger = LogFactory.getLog(ExcelResolveTask.class);
    private Sheet sheet;

    public ExcelResolveTask(Sheet sheet) {
        this.sheet = sheet;
    }

    @Override
    public JSONObject call() throws Exception {
        int sheetRows = this.sheet.getPhysicalNumberOfRows();
        String sheetName = this.sheet.getSheetName();
        ArrayList excelEntities = new ArrayList(sheetRows);
        Row tableRow = this.sheet.getRow(0);
        String entityNameStr = this.getStringValueFromCell(tableRow.getCell(0));
        if (entityNameStr == null || entityNameStr.split("#").length < 3) {
            throw new Exception(ResManager.loadKDString((String)"\u89e3\u6790excel\u5f02\u5e38\uff1a\u7b2c\u4e00\u884c\u8868\u540d\u89e3\u6790\u5931\u8d25", (String)"ExcelResolveTask_0", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        String entityName = entityNameStr.split("#")[1].trim();
        String sheetId = entityNameStr.split("#")[2].trim();
        Row filedNameRow = this.sheet.getRow(2);
        int lastCellNum = filedNameRow.getLastCellNum();
        ArrayList<String> fieldNameList = new ArrayList<String>(lastCellNum);
        String fieldName = null;
        for (int i = 0; i < lastCellNum; ++i) {
            fieldName = this.getStringValueFromCell(filedNameRow.getCell(i));
            fieldNameList.add(fieldName);
        }
        for (int rowIndex = 4; rowIndex < sheetRows; ++rowIndex) {
            HashMap<String, Object> filedValueMap = new HashMap<String, Object>(lastCellNum);
            Row filedValueRow = this.sheet.getRow(rowIndex);
            if (ObjectUtils.isEmpty((Object)filedValueRow)) continue;
            try {
                for (int j = 0; j < lastCellNum; ++j) {
                    String filedName = (String)fieldNameList.get(j);
                    if (StringUtils.isBlank((CharSequence)filedName)) continue;
                    fieldName = filedName.trim();
                    String fieldValue = this.getStringValueFromCell(filedValueRow.getCell(j));
                    if (StringUtils.isNotBlank((CharSequence)fieldValue)) {
                        fieldValue = fieldValue.trim();
                    }
                    if (("time".equals(fieldName) || "time_get_on".equals(fieldName) || "time_get_off".equals(fieldName)) && filedValueRow.getCell(j) != null) {
                        fieldValue = filedValueRow.getCell(j).getStringCellValue();
                    }
                    if ("check_code".equals(fieldName) && fieldValue.length() > 6) {
                        fieldValue = fieldValue.substring(fieldValue.length() - 6);
                    }
                    if ("expense_status".equals(fieldName)) {
                        switch (fieldValue) {
                            case "\u672a\u62a5\u9500": 
                            case "Unreimbursed": {
                                fieldValue = "1";
                                break;
                            }
                            case "\u5ba1\u6838\u4e2d": 
                            case "In Review": {
                                fieldValue = "30";
                                break;
                            }
                            case "\u5df2\u62a5\u9500": 
                            case "Reimbursed": {
                                fieldValue = "60";
                                break;
                            }
                            case "\u5df2\u5165\u8d26": 
                            case "Posted": {
                                fieldValue = "65";
                                break;
                            }
                            case "": {
                                break;
                            }
                            default: {
                                throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u9500\u72b6\u6001\u672a\u6309\u6307\u5b9a\u683c\u5f0f\u586b\u5165", (String)"ExcelResolveTask_1", (String)"imc-rim-common", (Object[])new Object[0]));
                            }
                        }
                    }
                    if ("authenticate_flag".equals(filedName)) {
                        switch (fieldValue) {
                            case "\u672a\u52fe\u9009": 
                            case "Not Pre-checked": {
                                fieldValue = "0";
                                break;
                            }
                            case "\u9884\u62b5\u6263": 
                            case "Pre-deduction": {
                                fieldValue = "4";
                                break;
                            }
                            case "\u52fe\u9009": 
                            case "Select": {
                                fieldValue = "1";
                                break;
                            }
                            case "\u52fe\u9009\u8ba4\u8bc1": 
                            case "Check Authentication": {
                                fieldValue = "2";
                                break;
                            }
                            case "\u626b\u63cf\u8ba4\u8bc1": 
                            case "Scanning Authentication": {
                                fieldValue = "3";
                                break;
                            }
                            case "": {
                                break;
                            }
                            default: {
                                throw new KDBizException(ResManager.loadKDString((String)"\u52fe\u9009\u72b6\u6001\u672a\u6309\u6307\u5b9a\u683c\u5f0f\u586b\u5165", (String)"ExcelResolveTask_2", (String)"imc-rim-common", (Object[])new Object[0]));
                            }
                        }
                    }
                    if ("invoice_status".equals(fieldName)) {
                        switch (fieldValue) {
                            case "\u6b63\u5e38": 
                            case "Normal": {
                                fieldValue = "0";
                                break;
                            }
                            case "\u5931\u63a7": 
                            case "Out of Control": {
                                fieldValue = "1";
                                break;
                            }
                            case "\u4f5c\u5e9f": 
                            case "Voided": {
                                fieldValue = "2";
                                break;
                            }
                            case "\u7ea2\u51b2": 
                            case "Reversal": {
                                fieldValue = "3";
                                break;
                            }
                            case "\u5f02\u5e38": 
                            case "Exception": {
                                fieldValue = "4";
                                break;
                            }
                            case "\u90e8\u5206\u7ea2\u51b2": 
                            case "Partial Reversal": {
                                fieldValue = "7";
                                break;
                            }
                            case "\u5168\u989d\u7ea2\u51b2": 
                            case "All Reversal": {
                                fieldValue = "8";
                                break;
                            }
                            case "": {
                                break;
                            }
                            default: {
                                throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u7968\u72b6\u6001\u672a\u6309\u6307\u5b9a\u683c\u5f0f\u586b\u5165", (String)"ExcelResolveTask_3", (String)"imc-rim-common", (Object[])new Object[0]));
                            }
                        }
                    }
                    if ("deduction_purpose".equals(fieldName)) {
                        switch (fieldValue) {
                            case "\u62b5\u6263": 
                            case "Deductible": {
                                fieldValue = "1";
                                break;
                            }
                            case "\u4e0d\u62b5\u6263": 
                            case "Non-deductible": {
                                fieldValue = "2";
                                break;
                            }
                            case "": {
                                break;
                            }
                            default: {
                                throw new KDBizException(ResManager.loadKDString((String)"\u62b5\u6263\u7528\u9014\u672a\u6309\u6307\u5b9a\u683c\u5f0f\u586b\u5165", (String)"ExcelResolveTask_4", (String)"imc-rim-common", (Object[])new Object[0]));
                            }
                        }
                    }
                    if ("not_deductible_type".equals(fieldName)) {
                        switch (fieldValue) {
                            case "\u7528\u4e8e\u975e\u5e94\u7a0e\u9879\u76ee": 
                            case "For Non-taxable Project": {
                                fieldValue = "1";
                                break;
                            }
                            case "\u7528\u4e8e\u514d\u7a0e\u9879\u76ee": 
                            case "For Tax-Free Project": {
                                fieldValue = "2";
                                break;
                            }
                            case "\u7528\u4e8e\u96c6\u4f53\u798f\u5229\u6216\u8005\u4e2a\u4eba\u6d88\u8d39": 
                            case "For Company Welfare and Personal Consumption": {
                                fieldValue = "3";
                                break;
                            }
                            case "\u906d\u53d7\u975e\u6b63\u5e38\u635f\u5931": 
                            case "Suffering Abnormal Losses": {
                                fieldValue = "4";
                                break;
                            }
                            case "\u5176\u4ed6": 
                            case "Other": {
                                fieldValue = "5";
                                break;
                            }
                            case "": {
                                break;
                            }
                            default: {
                                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u62b5\u6263\u539f\u56e0\u672a\u6309\u6307\u5b9a\u683c\u5f0f\u586b\u5165", (String)"ExcelResolveTask_5", (String)"imc-rim-common", (Object[])new Object[0]));
                            }
                        }
                    }
                    if ("special_type_mark".equals(fieldName)) {
                        switch (fieldValue) {
                            case "\u6210\u54c1\u6cb9\u53d1\u7968": {
                                fieldValue = SpecialTypeMarkEnum.REFINED_OIL.getCode();
                                break;
                            }
                            case "\u7a00\u571f\u53d1\u7968": {
                                fieldValue = SpecialTypeMarkEnum.RARE_EARTH_ELEMENTS.getCode();
                                break;
                            }
                            case "\u673a\u52a8\u8f66\u53d1\u7968": {
                                fieldValue = SpecialTypeMarkEnum.MOTOR_VEHICLE.getCode();
                                break;
                            }
                            case "\u519c\u4ea7\u54c1\u6536\u8d2d\u53d1\u7968": {
                                fieldValue = SpecialTypeMarkEnum.AGRICULTURAL_PRODUCTS_PURCHASE.getCode();
                                break;
                            }
                            case "\u77f3\u8111\u6cb9\u53d1\u7968": {
                                fieldValue = SpecialTypeMarkEnum.NAPHTHA.getCode();
                                break;
                            }
                            case "\u5377\u70df\u53d1\u7968": {
                                fieldValue = SpecialTypeMarkEnum.CIGARETTE.getCode();
                                break;
                            }
                            case "\u5efa\u7b51\u670d\u52a1\u53d1\u7968": {
                                fieldValue = SpecialTypeMarkEnum.CONSTRUCTION_SERVICE.getCode();
                                break;
                            }
                            case "\u8d27\u7269\u8fd0\u8f93\u670d\u52a1\u53d1\u7968": {
                                fieldValue = SpecialTypeMarkEnum.FREIGHT_SERVICE.getCode();
                                break;
                            }
                            case "\u4e0d\u52a8\u4ea7\u9500\u552e\u670d\u52a1\u53d1\u7968": {
                                fieldValue = SpecialTypeMarkEnum.REAL_ESTATE_SALES_SERVICE.getCode();
                                break;
                            }
                            case "\u4e0d\u52a8\u4ea7\u7ecf\u8425\u79df\u8d41\u670d\u52a1": {
                                fieldValue = SpecialTypeMarkEnum.REAL_ESTATE_MANAGEMENT_LEASING_SERVICE.getCode();
                                break;
                            }
                            case "\u4ee3\u6536\u8f66\u8239\u7a0e\u53d1\u7968": {
                                fieldValue = SpecialTypeMarkEnum.VEHICLE_AND_VESSEL_TAX_COLLECTION.getCode();
                                break;
                            }
                            case "\u65c5\u5ba2\u8fd0\u8f93\u670d\u52a1\u53d1\u7968": {
                                fieldValue = SpecialTypeMarkEnum.PASSENGER_TRANSPORTATION_SERVICE.getCode();
                                break;
                            }
                            case "\u81ea\u4ea7\u519c\u4ea7\u54c1\u9500\u552e\u53d1\u7968": {
                                fieldValue = SpecialTypeMarkEnum.SELFPRODUCED_AGRICULTURAL_PRODUCTS_SALES.getCode();
                                break;
                            }
                            case "\u901a\u884c\u8d39\u53d1\u7968": {
                                fieldValue = SpecialTypeMarkEnum.TOLL_FEE.getCode();
                                break;
                            }
                            case "\u533b\u7597\u670d\u52a1\uff08\u4f4f\u9662\uff09\u53d1\u7968": {
                                fieldValue = SpecialTypeMarkEnum.INPATIENT_MEDICAL_SERVICE.getCode();
                                break;
                            }
                            case "\u533b\u7597\u670d\u52a1\uff08\u95e8\u8bca\uff09\u53d1\u7968": {
                                fieldValue = SpecialTypeMarkEnum.OUTPATIENT_MEDICAL_SERVICE.getCode();
                                break;
                            }
                            case "\u62d6\u62c9\u673a\u548c\u8054\u5408\u6536\u5272\u673a\u53d1\u7968": {
                                fieldValue = SpecialTypeMarkEnum.TRACTOR_AND_COMBINE_HARVESTER.getCode();
                                break;
                            }
                            case "\u4e8c\u624b\u8f66\u53d1\u7968": {
                                fieldValue = SpecialTypeMarkEnum.USERED_CAR.getCode();
                                break;
                            }
                            case "\u5149\u4f0f\u6536\u8d2d\u53d1\u7968": {
                                fieldValue = SpecialTypeMarkEnum.PHOTOVOLTAIC_ACQUISITION.getCode();
                                break;
                            }
                            case "\u51fa\u53e3\u53d1\u7968": {
                                fieldValue = SpecialTypeMarkEnum.EXPORT.getCode();
                                break;
                            }
                            case "\u519c\u4ea7\u54c1\u53d1\u7968": {
                                fieldValue = SpecialTypeMarkEnum.AGRICULTURAL_PRODUCTS.getCode();
                                break;
                            }
                            case "\u7a00\u571f\u77ff\u4ea7\u54c1\u53d1\u7968": {
                                fieldValue = SpecialTypeMarkEnum.RARE_EARTH_MINERAL_PRODUCTS.getCode();
                                break;
                            }
                            case "\u7a00\u571f\u4ea7\u6210\u54c1\u53d1\u7968": {
                                fieldValue = SpecialTypeMarkEnum.RARE_EARTH_PRODUCTS.getCode();
                                break;
                            }
                            case "": {
                                break;
                            }
                            default: {
                                throw new KDBizException(ResManager.loadKDString((String)"\u7279\u5b9a\u4e1a\u52a1\u7c7b\u578b\u672a\u6309\u6307\u5b9a\u683c\u5f0f\u586b\u5165", (String)"ExcelResolveTask_10", (String)"imc-rim-common", (Object[])new Object[0]));
                            }
                        }
                    }
                    if ("deduction_flag".equals(fieldName)) {
                        switch (fieldValue) {
                            case "\u4e0d\u53ef\u62b5\u6263": 
                            case "Nondeductible": {
                                fieldValue = "0";
                                break;
                            }
                            case "\u53ef\u62b5\u6263": 
                            case "Deductible": {
                                fieldValue = "1";
                                break;
                            }
                            case "": {
                                break;
                            }
                            default: {
                                throw new KDBizException(ResManager.loadKDString((String)"\u662f\u5426\u53ef\u62b5\u6263\u672a\u6309\u6307\u5b9a\u683c\u5f0f\u586b\u5165", (String)"ExcelResolveTask_6", (String)"imc-rim-common", (Object[])new Object[0]));
                            }
                        }
                    }
                    if ("transport_deduction".equals(fieldName)) {
                        switch (fieldValue) {
                            case "\u9884\u62b5\u6263": 
                            case "Pre-deduction": {
                                fieldValue = "2";
                                break;
                            }
                            case "\u5df2\u62b5\u6263": 
                            case "Deducted": {
                                fieldValue = "1";
                                break;
                            }
                            case "\u672a\u62b5\u6263": 
                            case "Not Deducted": {
                                fieldValue = "0";
                                break;
                            }
                            case "": {
                                break;
                            }
                            default: {
                                throw new KDBizException(ResManager.loadKDString((String)"\u65c5\u5ba2\u8fd0\u8f93\u62b5\u6263\u72b6\u6001\u672a\u6309\u6307\u5b9a\u683c\u5f0f\u586b\u5165", (String)"ExcelResolveTask_7", (String)"imc-rim-common", (Object[])new Object[0]));
                            }
                        }
                    }
                    if ("original_state".equals(fieldName)) {
                        switch (fieldValue) {
                            case "\u5df2\u7b7e\u6536": 
                            case "Acknowledged": {
                                fieldValue = "1";
                                break;
                            }
                            case "\u672a\u7b7e\u6536": 
                            case "Not Signed": {
                                fieldValue = "0";
                                break;
                            }
                            case "": {
                                break;
                            }
                            default: {
                                throw new KDBizException(ResManager.loadKDString((String)"\u662f\u5426\u7b7e\u6536\u672a\u6309\u6307\u5b9a\u683c\u5f0f\u586b\u5165", (String)"ExcelResolveTask_8", (String)"imc-rim-common", (Object[])new Object[0]));
                            }
                        }
                    }
                    if ("org.number".equals(fieldName)) {
                        filedValueMap.put("org", this.getOrgId(fieldValue));
                        filedValueMap.put("org_id", this.getOrgId(fieldValue));
                    }
                    if ("tax_org.number".equals(fieldName)) {
                        filedValueMap.put("tax_org", this.getOrgId(fieldValue));
                    }
                    if (("airport_construction_fee".equals(fieldName) || "fuel_surcharge".equals(fieldName) || "insurance_premium".equals(fieldName)) && ObjectUtils.isEmpty((Object)fieldValue)) {
                        fieldValue = BigDecimal.ZERO.toString();
                    }
                    if ("invoice_source".equals(fieldName)) {
                        fieldValue = DeductionUtils.convertInvoiceSource(fieldValue);
                    }
                    if ("invoice_risk_level".equals(fieldName)) {
                        fieldValue = DeductionUtils.convertInvoiceRiskLevel(fieldValue);
                    }
                    filedValueMap.put(filedName, fieldValue);
                }
            }
            catch (Exception e) {
                logger.error("ExcelResolveTask-\u89e3\u6790" + rowIndex + 1 + "\u884c\uff0c\u53c2\u6570\u540d\u4e3a\uff1a" + fieldName + "\u7684\u5b57\u6bb5\u51fa\u9519{}", (Throwable)e);
                filedValueMap.put("isResolveError", Boolean.TRUE);
                filedValueMap.put("resolveErrorMsg", String.format(ResManager.loadKDString((String)"\u89e3\u6790\u5b57\u6bb5%1$s\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u8be5\u5b57\u6bb5\u683c\u5f0f\u662f\u5426\u6b63\u786e", (String)"ExcelResolveTask_9", (String)"imc-rim-common", (Object[])new Object[0]), fieldName));
            }
            filedValueMap.put("collect_type", "10");
            excelEntities.add(filedValueMap);
        }
        JSONObject sheetDataJson = new JSONObject();
        sheetDataJson.put("sheetName", (Object)sheetName);
        sheetDataJson.put("sheetId", (Object)sheetId);
        sheetDataJson.put("table", (Object)entityName);
        sheetDataJson.put("data", (Object)JSONArray.parseArray((String)JSONObject.toJSONString(excelEntities)));
        return sheetDataJson;
    }

    public Object getOrgId(String number) {
        QFilter filter = new QFilter("number", "=", (Object)number);
        DynamicObject obj = QueryServiceHelper.queryOne((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{filter});
        if (obj != null) {
            return obj.get("id");
        }
        return null;
    }

    private String getStringValueFromCell(Cell cell) {
        SimpleDateFormat sFormat = new SimpleDateFormat("MM/dd/yyyy");
        DecimalFormat decimalFormat = new DecimalFormat("#.##");
        String cellValue = "";
        if (cell == null) {
            return cellValue;
        }
        if (cell.getCellType() == CellType.STRING) {
            cellValue = cell.getStringCellValue();
        } else if (cell.getCellType() == CellType.NUMERIC) {
            if (DateUtil.isCellDateFormatted((Cell)cell)) {
                double d = cell.getNumericCellValue();
                Date date = DateUtil.getJavaDate((double)d);
                cellValue = sFormat.format(date);
            } else {
                cellValue = decimalFormat.format(cell.getNumericCellValue());
            }
        } else if (cell.getCellType() == CellType.BLANK) {
            cellValue = "";
        } else if (cell.getCellType() == CellType.BOOLEAN) {
            cellValue = String.valueOf(cell.getBooleanCellValue());
        } else if (cell.getCellType() == CellType.ERROR) {
            cellValue = "";
        } else if (cell.getCellType() == CellType.FORMULA) {
            cellValue = cell.getCellFormula();
        }
        return cellValue;
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public void setSheet(Sheet sheet) {
        this.sheet = sheet;
    }
}

