/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.recognitionnew.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.invoice.model.ConvertFieldUtil;
import kd.imc.rim.common.invoice.query.convert.impl.AirConvertService;
import kd.imc.rim.common.invoice.recognitionnew.RecognitionService;
import kd.imc.rim.common.invoice.recognitionnew.model.RecognitionParam;
import kd.imc.rim.common.invoice.recognitionnew.model.RecognitionResult;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.AwsFpyService;
import kd.imc.rim.common.utils.HttpUtil;
import kd.imc.rim.common.utils.ImcConfigUtil;
import org.apache.commons.compress.utils.Lists;

public class AwsRecognitionService
implements RecognitionService {
    private static Log logger = LogFactory.getLog(AwsRecognitionService.class);
    private static final int connectionTimeout = 3000;
    private static final int readTimeout = 60000;

    @Override
    public RecognitionResult recognitionInvoice(RecognitionParam recognitionParam) {
        RecognitionResult recognitionResult = this.getResultFromDb(recognitionParam);
        if (recognitionResult == null) {
            recognitionResult = this.getResultFromAws(recognitionParam);
        }
        return recognitionResult;
    }

    private RecognitionResult getResultFromAws(RecognitionParam recognitionParam) {
        RecognitionResult recognitionResult;
        block11: {
            recognitionResult = new RecognitionResult();
            Map<String, Object> extMap = recognitionParam.getExtMap();
            HashMap bodyMap = Maps.newHashMap();
            bodyMap.put("eid", extMap.get("eid") + "");
            bodyMap.put("taxNo", extMap.get("taxNo") + "");
            bodyMap.put("recogType", recognitionParam.getRecogType());
            bodyMap.put("overseaAppCode", recognitionParam.getAppCode());
            try {
                String serviceType = this.getServiceType(recognitionParam);
                HashMap headers = Maps.newHashMap();
                boolean overseaFlag = false;
                String token = AwsFpyService.newInstance().getAccessToken(Long.parseLong(extMap.get("orgId") + ""));
                if (StringUtils.isNotEmpty((String)token)) {
                    Map<String, String> configMap;
                    String isOverseaRecognition;
                    long start = System.currentTimeMillis();
                    String url = AwsFpyService.newInstance().getUrl("pure_recognition", token);
                    if (StringUtils.isNotEmpty((String)recognitionParam.getAppCode()) && "1".equals(isOverseaRecognition = (configMap = ImcConfigUtil.getValue("rim_recog_check")).get("is_oversea_recognition"))) {
                        logger.info("aws\u6d77\u5916\u53d1\u7968AI\u8bc6\u522b...");
                        headers.put("client-platform", "common");
                        url = AwsFpyService.newInstance().getUrl("msg_oversea_invoice_recognition", token);
                        overseaFlag = true;
                        bodyMap.put("templateId", "1");
                    }
                    ByteArrayInputStream valueInputStream = recognitionParam.getFileByteArrayInputStream();
                    String valueFileName = recognitionParam.getFileName();
                    int retryTimes = 1;
                    for (int times = 1; times <= retryTimes; ++times) {
                        JSONArray recognitionArray;
                        logger.info("aws\u8bc6\u522bbodyMap:{}", (Object)bodyMap);
                        String result = HttpUtil.postFormData(url + "&t=" + start, AwsFpyService.newInstance().getProxy(), headers, valueInputStream, valueFileName, bodyMap, 3000, 60000);
                        logger.info("aws\u8bc6\u522b\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c{}\uff1a{}", (Object)times, (Object)result);
                        boolean reTry = false;
                        if (StringUtils.isNotEmpty((String)result) && (recognitionArray = this.getRecoginitionData(recognitionResult, result, overseaFlag)) != null) {
                            boolean saveFlag = true;
                            for (int i = 0; i < recognitionArray.size(); ++i) {
                                JSONObject invoiceInfo = recognitionArray.getJSONObject(i);
                                if ("1".equals(invoiceInfo.getString("defaultOther"))) {
                                    saveFlag = false;
                                    if (times < retryTimes) {
                                        reTry = true;
                                        throw new MsgException("0002", ResManager.loadKDString((String)"aws\u8bc6\u522b\u5f02\u5e38", (String)"AwsRecognitionService_0", (String)"imc-rim-common", (Object[])new Object[0]));
                                    }
                                }
                                this.setResultValue(invoiceInfo);
                            }
                            if (reTry) continue;
                            if (saveFlag) {
                                this.saveRecognition(recognitionParam, serviceType, result, System.currentTimeMillis() - start);
                            }
                            recognitionResult.setData(this.convertRecognition(recognitionArray));
                        }
                        break block11;
                    }
                    break block11;
                }
                recognitionResult.setData(new ArrayList(1));
            }
            catch (Throwable e) {
                logger.error("AwsRecognitionService exception:", e);
                if (e instanceof MsgException) {
                    throw new MsgException(((MsgException)e).getErrorCode(), ((MsgException)e).getErrorMsg());
                }
                throw new MsgException("0001", ResManager.loadKDString((String)"aws\u8bc6\u522b\u5f02\u5e38", (String)"AwsRecognitionService_0", (String)"imc-rim-common", (Object[])new Object[0]));
            }
        }
        return recognitionResult;
    }

    private RecognitionResult getResultFromDb(RecognitionParam recognitionParam) {
        JSONArray recognitionArray;
        RecognitionResult recognitionResult = new RecognitionResult();
        String serviceType = this.getServiceType(recognitionParam);
        String resultStr = this.getRecognitionResultFromDb(recognitionParam, serviceType);
        if (StringUtils.isEmpty((String)resultStr)) {
            return null;
        }
        boolean overseaFlag = false;
        if (!resultStr.contains("recoginitionData")) {
            overseaFlag = true;
        }
        if ((recognitionArray = this.getRecoginitionData(recognitionResult, resultStr, overseaFlag)) == null) {
            return null;
        }
        for (int i = 0; i < recognitionArray.size(); ++i) {
            JSONObject invoiceInfo = recognitionArray.getJSONObject(i);
            this.setResultValue(invoiceInfo);
        }
        recognitionResult.setData(this.convertRecognition(recognitionArray));
        return recognitionResult;
    }

    private JSONArray getRecoginitionData(RecognitionResult recognitionResult, String resultStr, boolean overseaFlag) {
        if (StringUtils.isNotEmpty((String)resultStr)) {
            JSONObject recognitionJson = JSONObject.parseObject((String)resultStr);
            recognitionResult.setErrcode(recognitionJson.getString("errcode"));
            recognitionResult.setDescription(recognitionJson.getString("description"));
            try {
                if (overseaFlag) {
                    JSONArray data = recognitionJson.getJSONArray("data");
                    if (data == null) {
                        return null;
                    }
                    JSONArray mergeResult = new JSONArray();
                    for (int i = 0; i < data.size(); ++i) {
                        JSONObject overseaInfo = this.mergeData(data.getJSONObject(i));
                        overseaInfo.put("invoiceType", (Object)InputInvoiceTypeEnum.OVERSEA_INVOICE.getAwsType());
                        mergeResult.add((Object)overseaInfo);
                    }
                    return mergeResult;
                }
                JSONObject data = recognitionJson.getJSONObject("data");
                if (data != null) {
                    return data.getJSONArray("recoginitionData");
                }
            }
            catch (Exception e) {
                logger.info("getRecoginitionData exception:", (Object)e);
            }
        }
        return null;
    }

    private JSONObject mergeData(JSONObject overseaInfo) {
        JSONObject detail;
        JSONObject header = overseaInfo.getJSONObject("header");
        JSONObject invoiceInfo = new JSONObject();
        if (!header.isEmpty()) {
            for (String key : header.keySet()) {
                Object keyInfo = header.get((Object)key);
                if (keyInfo instanceof JSONObject) {
                    invoiceInfo.putAll((Map)((JSONObject)keyInfo));
                    continue;
                }
                invoiceInfo.put(key, keyInfo);
            }
        }
        if (!(detail = overseaInfo.getJSONObject("detail")).isEmpty()) {
            JSONArray goodsInfo = detail.getJSONArray("detailOfGoodsOrServices");
            invoiceInfo.put("items", (Object)goodsInfo);
            JSONArray taxSummaryInfo = detail.getJSONArray("detailOfTaxSummary");
            if (taxSummaryInfo != null && taxSummaryInfo.size() > 0) {
                int index = Math.min(taxSummaryInfo.size(), 5);
                for (int i = 0; i < index; ++i) {
                    invoiceInfo.put("taxType" + (i + 1), (Object)taxSummaryInfo.getJSONObject(i).getString("taxCategory"));
                    invoiceInfo.put("taxRate" + (i + 1), (Object)taxSummaryInfo.getJSONObject(i).getString("taxRate"));
                    invoiceInfo.put("invoiceAmount" + (i + 1), (Object)taxSummaryInfo.getJSONObject(i).getString("netTaxableAmount"));
                    invoiceInfo.put("taxAmount" + (i + 1), (Object)taxSummaryInfo.getJSONObject(i).getString("tax"));
                }
            }
        }
        return invoiceInfo;
    }

    private void setResultValue(JSONObject invoiceInfo) {
        JSONArray items;
        invoiceInfo.put("snapshotUrl", (Object)"");
        invoiceInfo.put("kdcloudUrl", (Object)"");
        invoiceInfo.put("downloadUrl", (Object)"");
        Long invoiceType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(invoiceInfo.getString("invoiceType"));
        invoiceInfo.put("invoiceType", (Object)invoiceType);
        if (InputInvoiceTypeEnum.AIR_INVOICE.getCode().equals(invoiceType) && (items = invoiceInfo.getJSONArray("items")) != null && items.size() > 0) {
            JSONObject firstOne = items.getJSONObject(0);
            invoiceInfo.put("seatGrade", (Object)firstOne.getString("seatGrade"));
            invoiceInfo.put("flightNum", (Object)firstOne.getString("flightNum"));
            invoiceInfo.put("seatGradeName", (Object)AirConvertService.convertSeatName(firstOne.getString("seatGrade")));
        }
    }

    private List<Object> convertRecognition(JSONArray recognitionArray) {
        ArrayList entityList = Lists.newArrayList();
        ConvertFieldUtil.convertRecognitionEntity(entityList, recognitionArray, "items");
        return entityList;
    }

    @Override
    public String getServiceType(RecognitionParam recognitionParam) {
        return "aws" + recognitionParam.getRecogType();
    }
}

