/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.recognitionnew.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.invoice.model.ConvertFieldUtil;
import kd.imc.rim.common.invoice.recognitionnew.RecognitionService;
import kd.imc.rim.common.invoice.recognitionnew.model.RecognitionParam;
import kd.imc.rim.common.invoice.recognitionnew.model.RecognitionResult;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.common.utils.HttpUtil;
import kd.imc.rim.common.utils.MD5;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.file.utils.Handle;
import org.apache.commons.compress.utils.Lists;

public class RuiqiRecognitionService
implements RecognitionService {
    private static Log logger = LogFactory.getLog(RuiqiRecognitionService.class);
    private static final int connectionTimeout = 8000;
    private static final int readTimeout = 20000;

    @Override
    public RecognitionResult recognitionInvoice(RecognitionParam recognitionParam) throws Exception {
        RecognitionResult recognitionResult = new RecognitionResult();
        Map<String, String> configMap = recognitionParam.getRecogConfigMap();
        String postUrl = configMap.get("rposturl");
        ArrayList entityList = Lists.newArrayList();
        ByteArrayInputStream valueInputStream = recognitionParam.getFileByteArrayInputStream();
        byte[] streamByte = FileUtils.getByte(valueInputStream);
        ByteArrayInputStream copyInputStream = new ByteArrayInputStream(streamByte);
        String fileBase64Str = FileUtils.encodeBase64File(copyInputStream);
        Map<String, Object> map = this.getPostMap(fileBase64Str);
        String valueFileName = recognitionParam.getFileName();
        long startTime = System.currentTimeMillis();
        String resultData = null;
        int reqTimes = 0;
        try {
            ++reqTimes;
            resultData = HttpUtil.postFormData(postUrl, null, null, null, valueFileName, map, 8000, 20000);
        }
        catch (MsgException e) {
            if ("1022".equals(e.getErrorCode())) {
                ++reqTimes;
                resultData = HttpUtil.postFormData(postUrl, null, null, null, valueFileName, map, 5000, 20000);
            }
            throw e;
        }
        logger.info("\u82cd\u7a79\u777f\u742a\u8bc6\u522b\u8017\u65f6\uff1a{},\u8bf7\u6c42\u6b21\u6570{}", (Object)(System.currentTimeMillis() - startTime), (Object)reqTimes);
        logger.info("\u82cd\u7a79\u777f\u742a\u8bc6\u522b\u8fd4\u56de\u7ed3\u679c{}\uff1a{}", (Object)reqTimes, (Object)resultData);
        JSONObject recognitionJson = JSONObject.parseObject((String)resultData);
        JSONObject response = recognitionJson.getJSONObject("response");
        if (response != null) {
            JSONObject recognitionData = response.getJSONObject("data");
            recognitionResult.setErrcode("0000");
            recognitionResult.setDescription(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"RuiqiRecognitionService_0", (String)"imc-rim-common", (Object[])new Object[0]));
            if (recognitionData == null) {
                return recognitionResult;
            }
            JSONArray recognitionArray = recognitionData.getJSONArray("identify_results");
            JSONArray barcodeArray = new JSONArray();
            JSONObject extra = recognitionData.getJSONObject("extra");
            if (extra != null) {
                barcodeArray = extra.getJSONArray("barcode");
            }
            JSONArray resultArray = new JSONArray();
            for (int i = 0; i < recognitionArray.size(); ++i) {
                String invoiceTypeStr = recognitionArray.getJSONObject(i).getString("type");
                JSONObject invoiceInfo = recognitionArray.getJSONObject(i).getJSONObject("details");
                JSONArray qrcodeArray = recognitionArray.getJSONObject(i).getJSONArray("qrcode");
                int typeNum = ConvertFieldUtil.checkCustomOrFinancialByTitle(invoiceInfo);
                boolean isSuccess = false;
                if (typeNum == 21) {
                    isSuccess = this.recognizeCustomInvoice(resultArray, valueFileName, fileBase64Str, configMap);
                } else if (typeNum == 25) {
                    isSuccess = this.recognizeFinancialElectronicInvoice(invoiceInfo, resultArray, valueFileName, fileBase64Str, configMap);
                }
                if (typeNum != 0 && isSuccess) continue;
                this.normalConvert(invoiceInfo, invoiceTypeStr);
                invoiceInfo.put("barcode", (Object)barcodeArray);
                invoiceInfo.put("qrcode", (Object)qrcodeArray);
                RuiqiRecognitionService.fixInvoiceInfo(invoiceInfo, recognitionArray.getJSONObject(i));
                resultArray.add((Object)invoiceInfo);
            }
            String itemsKey = "items";
            ConvertFieldUtil.convertRecognitionEntity(entityList, resultArray, itemsKey);
        } else {
            recognitionResult.setErrcode(recognitionJson.getString("error"));
            recognitionResult.setDescription(recognitionJson.getString("message"));
        }
        recognitionResult.setData(entityList);
        return recognitionResult;
    }

    private boolean recognizeCustomInvoice(JSONArray resultArray, String valueFileName, String streamByte, Map<String, String> configMap) {
        LinkedHashMap map = Maps.newLinkedHashMap();
        String postUrl = configMap.get("customposturl");
        String appKey = configMap.get("customappkey");
        String appSecret = configMap.get("customappsecret");
        long timeStampSec = System.currentTimeMillis() / 1000L;
        String timestamp = String.format("%010d", timeStampSec);
        String token = MD5.md5Hex(appKey + "+" + timestamp + "+" + appSecret);
        map.put("app_key", appKey);
        map.put("token", token);
        map.put("timestamp", timestamp);
        map.put("image_data", streamByte);
        String resultData = null;
        try {
            resultData = HttpUtil.postFormData(postUrl, null, null, null, valueFileName, map, 8000, 20000);
            logger.info("\u777f\u742a\u6d77\u5173\u7f34\u6b3e\u4e66\u8bc6\u522b\u7ed3\u679c\uff1a" + resultData);
        }
        catch (Exception e) {
            logger.info("recognizeCustomInvoice exception:", (Object)e);
            return false;
        }
        JSONObject recognitionJson = JSONObject.parseObject((String)resultData);
        JSONArray recognitionArray = this.getRecognitionArray(recognitionJson);
        if (recognitionArray == null || recognitionArray.size() == 0) {
            return false;
        }
        for (int i = 0; i < recognitionArray.size(); ++i) {
            JSONObject invoiceInfo = recognitionArray.getJSONObject(i).getJSONObject("details");
            Long invoiceType = InputInvoiceTypeEnum.HGJKS.getCode();
            invoiceInfo.put("invoiceType", (Object)invoiceType);
            if (Handle.isNotEmpty((Object)invoiceInfo.getString("company_name"))) {
                String[] splitStr = invoiceInfo.getString("company_name").split("\u516c\u53f8");
                String deptName = "";
                String secondDeptName = "";
                if (splitStr.length > 1) {
                    deptName = splitStr[0] + "\u516c\u53f8";
                    secondDeptName = splitStr[1] + "\u516c\u53f8";
                } else {
                    deptName = invoiceInfo.getString("company_name");
                }
                invoiceInfo.put("company_name", (Object)deptName);
                invoiceInfo.put("second_company_name", (Object)secondDeptName);
            }
            RuiqiRecognitionService.fixInvoiceInfo(invoiceInfo, recognitionArray.getJSONObject(i));
            resultArray.add((Object)invoiceInfo);
        }
        return true;
    }

    private boolean recognizeFinancialElectronicInvoice(JSONObject otherInvoice, JSONArray resultArray, String valueFileName, String streamByte, Map<String, String> configMap) {
        LinkedHashMap map = Maps.newLinkedHashMap();
        String postUrl = configMap.get("financialposturl");
        String appKey = configMap.get("financialappkey");
        String appSecret = configMap.get("financialappsecret");
        long timeStampSec = System.currentTimeMillis() / 1000L;
        String timestamp = String.format("%010d", timeStampSec);
        String token = MD5.md5Hex(appKey + "+" + timestamp + "+" + appSecret);
        map.put("app_key", appKey);
        map.put("token", token);
        map.put("timestamp", timestamp);
        map.put("image_data", streamByte);
        String resultData = null;
        try {
            resultData = HttpUtil.postFormData(postUrl, null, null, null, valueFileName, map, 8000, 20000);
            logger.info("\u777f\u742a\u8d22\u653f\u7535\u5b50\u7968\u636e\u8bc6\u522b\u7ed3\u679c\uff1a" + resultData);
        }
        catch (Exception e) {
            logger.info("recognizeFinancialElectronicInvoice exception:", (Object)e);
            return false;
        }
        JSONObject recognitionJson = JSONObject.parseObject((String)resultData);
        JSONArray recognitionArray = this.getRecognitionArray(recognitionJson);
        if (recognitionArray == null || recognitionArray.size() == 0) {
            return false;
        }
        for (int i = 0; i < recognitionArray.size(); ++i) {
            JSONObject invoiceInfo = recognitionArray.getJSONObject(i).getJSONObject("details");
            BigDecimal totalFina = BigDecimalUtil.transDecimal(invoiceInfo.get((Object)"total"));
            BigDecimal totalOther = BigDecimalUtil.transDecimal(otherInvoice.get((Object)"total"));
            if (BigDecimal.ZERO.compareTo(totalFina) == 0 && BigDecimal.ZERO.compareTo(totalOther) != 0) {
                invoiceInfo.put("total", otherInvoice.get((Object)"total"));
            }
            Long invoiceType = InputInvoiceTypeEnum.FINANCIAL_INVOICE.getCode();
            invoiceInfo.put("invoiceType", (Object)invoiceType);
            RuiqiRecognitionService.fixInvoiceInfo(invoiceInfo, recognitionArray.getJSONObject(i));
            resultArray.add((Object)invoiceInfo);
        }
        return true;
    }

    private JSONArray getRecognitionArray(JSONObject recognitionJson) {
        if (recognitionJson == null) {
            return null;
        }
        JSONObject response = recognitionJson.getJSONObject("response");
        if (response == null) {
            return null;
        }
        JSONObject data = response.getJSONObject("data");
        if (data == null) {
            return null;
        }
        JSONArray recognitionArray = data.getJSONArray("identify_results");
        return recognitionArray;
    }

    private void normalConvert(JSONObject invoiceInfo, String invoiceTypeStr) {
        String code = invoiceInfo.getString("code");
        String number = invoiceInfo.getString("number");
        String electronicMark = invoiceInfo.getString("electronic_mark");
        if ("10102".equals(invoiceTypeStr) && StringUtils.isEmpty((String)code) && StringUtils.isEmpty((String)number) && "1".equals(electronicMark)) {
            invoiceTypeStr = "10900";
        }
        String transitMark = invoiceInfo.getString("transit_mark");
        Long invoiceType = InputInvoiceTypeEnum.getInvoiceTypeByRuiqiType(invoiceTypeStr, electronicMark, transitMark);
        invoiceInfo.put("invoiceType", (Object)invoiceType);
        if (InputInvoiceTypeEnum.AIR_INVOICE.getCode().equals(invoiceType)) {
            BigDecimal insuranceDecimal = BigDecimal.ZERO;
            String insurance = invoiceInfo.getString("insurance");
            try {
                insuranceDecimal = new BigDecimal(insurance);
            }
            catch (Exception exception) {
                // empty catch block
            }
            invoiceInfo.put("insurance", (Object)insuranceDecimal);
            JSONArray flights = invoiceInfo.getJSONArray("flights");
            if (flights != null && flights.size() > 0) {
                JSONObject flight = flights.getJSONObject(0);
                invoiceInfo.put("placeOfDeparture", (Object)flight.getString("from"));
                invoiceInfo.put("carrier", (Object)flight.getString("carrier"));
                invoiceInfo.put("flightNum", (Object)flight.getString("flight_number"));
                invoiceInfo.put("seatGrade", (Object)flight.getString("seat"));
                invoiceInfo.put("airTime", (Object)flight.getString("time"));
                String date = flight.getString("date");
                if (StringUtils.isNotEmpty((String)date) && !"OPEN".equalsIgnoreCase(date)) {
                    invoiceInfo.put("date", (Object)date);
                }
                JSONObject flightLast = flights.getJSONObject(flights.size() - 1);
                invoiceInfo.put("destination", (Object)flightLast.getString("to"));
            }
        }
    }

    private Map<String, Object> getPostMap(String fileBase64Str) {
        LinkedHashMap map = Maps.newLinkedHashMap();
        String appKey = RimConfigUtils.getConfig("rim_recog_check", "rappkey");
        String appSecret = RimConfigUtils.getConfig("rim_recog_check", "rappsecret");
        long timeStampSec = System.currentTimeMillis() / 1000L;
        String timestamp = String.format("%010d", timeStampSec);
        String token = MD5.md5Hex(appKey + "+" + timestamp + "+" + appSecret);
        map.put("app_key", appKey);
        map.put("token", token);
        map.put("timestamp", timestamp);
        map.put("image_data", fileBase64Str);
        return map;
    }

    private static void fixInvoiceInfo(JSONObject invoice, JSONObject jsonObject) {
        String rotationAngle = jsonObject.getString("orientation");
        String region = jsonObject.getString("region");
        String pixel = jsonObject.getString("image_size");
        invoice.put("rotationAngle", (Object)rotationAngle);
        invoice.put("region", (Object)region);
        if (StringUtils.isNotEmpty((String)pixel)) {
            pixel = pixel.replace("[", "").replace("]", "");
            invoice.put("pixel", (Object)pixel);
        }
    }

    @Override
    public String getServiceType(RecognitionParam recognitionParam) {
        return "ruiqi";
    }
}

