/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.recognitionnew.task;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import java.util.concurrent.Callable;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.ImcConfigUtil;
import kd.imc.rim.file.utils.SignatureUtils;

public class FileSignatureTask
implements Callable<JSONObject> {
    private static final Log logger = LogFactory.getLog(FileSignatureTask.class);
    private byte[] streamByte;
    private String fileType;
    private Boolean signatureFlag;

    public FileSignatureTask(byte[] streamByte, String fileType, Boolean signatureFlag) {
        this.streamByte = streamByte;
        this.fileType = fileType;
        this.signatureFlag = signatureFlag;
    }

    @Override
    public JSONObject call() throws Exception {
        JSONObject result = new JSONObject();
        logger.info("\u9a8c\u7b7e\u4efb\u52a1\u5f00\u59cb");
        if (this.streamByte == null || this.streamByte.length == 0) {
            return result;
        }
        result.put("errcode", (Object)"0000");
        result.put("description", (Object)ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"FileSignatureTask_0", (String)"imc-rim-common", (Object[])new Object[0]));
        Boolean isOriginal = Boolean.FALSE;
        if (this.signatureFlag == null || this.signatureFlag.booleanValue()) {
            try {
                isOriginal = SignatureUtils.isOriginal((byte[])this.streamByte, (String)this.fileType, (int)this.getOriginType(this.fileType));
            }
            catch (Throwable t) {
                logger.info("SignatureUtils.isOriginal error:{}", (Object)t);
            }
        }
        result.put("isOriginal", (Object)isOriginal);
        return result;
    }

    private int getOriginType(String type) {
        Map<String, String> configMap;
        String recognitionImplStr;
        int originType1;
        int originType = 1;
        if ("pdf".equalsIgnoreCase(this.fileType) && (originType1 = BigDecimalUtil.transDecimal(recognitionImplStr = (configMap = ImcConfigUtil.getValue("rim_recog_check")).get("sign_type")).intValue()) != 0) {
            return originType1;
        }
        return originType;
    }
}

