/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.recognitionnew.task;

import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.common.invoice.recognitionnew.task.SnapshotService;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.common.utils.ImcConfigUtil;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.itextpdf.UrlServiceUtils;
import kd.imc.rim.file.model.FileConvertResult;
import kd.imc.rim.file.utils.FileConvertUtils;
import kd.imc.rim.file.utils.SignatureUtils;

public class FileUploadAndSignTask
implements Callable<JSONObject> {
    private static final Log logger = LogFactory.getLog(FileUploadAndSignTask.class);
    private String localUrl;
    private byte[] fileContent;
    private String fileType;
    private String fileName;
    private String fileHash;
    boolean signFlag = false;
    private RequestContext ctx;
    private int totalPage = 1;
    boolean signOnly = false;
    private String syncFlag;

    public FileUploadAndSignTask(String localUrl, byte[] fileContent, String fileName, String fileType, String fileHash, boolean signFlag, String syncFlag, RequestContext ctx) {
        this.localUrl = localUrl;
        this.fileContent = fileContent;
        this.fileType = fileType;
        this.signFlag = signFlag;
        this.syncFlag = syncFlag;
        this.ctx = ctx;
        this.fileHash = fileHash;
        this.fileName = fileName;
    }

    @Override
    public JSONObject call() throws Exception {
        JSONObject result = new JSONObject();
        boolean isOriginal = false;
        if (this.signOnly && this.signFlag) {
            if (this.fileContent == null) {
                try (InputStream fileInputStream = UrlServiceUtils.getAttachmentDecodedStream(FileServiceFactory.getAttachmentFileService().getInputStream(this.localUrl));){
                    this.fileContent = FileUtils.getByte(fileInputStream);
                }
            }
            isOriginal = this.sign();
            result.put("isOriginal", (Object)isOriginal);
            return result;
        }
        if (this.fileContent == null) {
            result.put("fileType", (Object)"2");
            result.put("imageUrl", (Object)this.localUrl);
            result.put("snapshotUrl", (Object)this.localUrl);
            return result;
        }
        if (this.fileHash == null) {
            this.fileHash = FileConvertUtils.getSHA256((byte[])this.fileContent);
        }
        if (this.signFlag) {
            isOriginal = this.sign();
        }
        result.put("isOriginal", (Object)isOriginal);
        long start = System.currentTimeMillis();
        FileConvertResult convertResult = null;
        if (this.totalPage > 1) {
            convertResult = new FileConvertResult();
            String url = FileConvertUtils.upload((byte[])this.fileContent, (String)this.fileType);
            convertResult.setImageUrl(url);
            convertResult.setSnapshotUrl(url);
            convertResult.setPdfUrl(this.localUrl);
            result.put("fileType", (Object)"1");
        } else {
            convertResult = this.convert(result);
            if ("ofd".equals(this.fileType)) {
                result.put("fileType", (Object)"4");
            } else if ("pdf".equals(this.fileType)) {
                result.put("fileType", (Object)"1");
            } else {
                result.put("fileType", (Object)"2");
            }
        }
        result.put("ofdUrl", (Object)convertResult.getOfdUrl());
        result.put("pdfUrl", (Object)convertResult.getPdfUrl());
        result.put("imageUrl", (Object)convertResult.getImageUrl());
        result.put("snapshotUrl", (Object)convertResult.getSnapshotUrl());
        logger.info("\u5feb\u7167\u751f\u6210\u8017\u65f6:{},{},{},{}", new Object[]{this.fileType, this.ctx.getTraceId(), System.currentTimeMillis() - start, result});
        return result;
    }

    private boolean sign() {
        boolean isOriginal = false;
        long start = System.currentTimeMillis();
        try {
            isOriginal = SignatureUtils.isOriginal((byte[])this.fileContent, (String)this.fileType, (int)this.getOriginType(this.fileType));
        }
        catch (Throwable t) {
            isOriginal = false;
            logger.info("SignatureUtils.isOriginal error:{}", (Object)t);
        }
        logger.info("\u9a8c\u7b7e\u8017\u65f6:{},{},{}", new Object[]{this.fileType, this.ctx.getTraceId(), System.currentTimeMillis() - start});
        return isOriginal;
    }

    private int getOriginType(String type) {
        Map<String, String> configMap;
        String recognitionImplStr;
        int originType1;
        int originType = 1;
        if ("pdf".equalsIgnoreCase(this.fileType) && (originType1 = BigDecimalUtil.transDecimal(recognitionImplStr = (configMap = ImcConfigUtil.getValue("rim_recog_check")).get("sign_type")).intValue()) != 0) {
            return originType1;
        }
        return originType;
    }

    private FileConvertResult convert(JSONObject returnResult) {
        FileConvertResult result = new FileConvertResult();
        if ("pdf".equalsIgnoreCase(this.fileType) || "ofd".equalsIgnoreCase(this.fileType)) {
            SnapshotService service = new SnapshotService();
            JSONObject obj = service.createSnapshot(this.fileContent, this.fileHash, this.localUrl, this.fileName, this.fileType, this.isSynConvert(this.syncFlag));
            if ("pdf".equalsIgnoreCase(this.fileType)) {
                result.setPdfUrl(this.localUrl);
                result.setImageUrl(obj.getString("snapshotUrl"));
                result.setSnapshotUrl(obj.getString("snapshotUrl"));
            } else {
                result.setOfdUrl(this.localUrl);
                result.setPdfUrl(obj.getString("pdfUrl"));
                result.setImageUrl(obj.getString("snapshotUrl"));
                result.setSnapshotUrl(obj.getString("snapshotUrl"));
            }
            if (StringUtils.isEmpty((CharSequence)result.getSnapshotUrl())) {
                returnResult.put("synConvert", (Object)true);
            }
            return result;
        }
        result.setImageUrl(this.localUrl);
        result.setSnapshotUrl(result.getImageUrl());
        result.setSuccess(true);
        return result;
    }

    private boolean isSynConvert(String syncFlag) {
        if (StringUtils.isEmpty((CharSequence)syncFlag)) {
            return !"2".equals(RimConfigUtils.getConfig("rim_recog_check", "synconvert"));
        }
        return true;
    }

    public String getLocalUrl() {
        return this.localUrl;
    }

    public void setLocalUrl(String localUrl) {
        this.localUrl = localUrl;
    }

    public RequestContext getCtx() {
        return this.ctx;
    }

    public void setCtx(RequestContext ctx) {
        this.ctx = ctx;
    }

    public byte[] getFileContent() {
        return this.fileContent;
    }

    public void setFileContent(byte[] fileContent) {
        this.fileContent = fileContent;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public boolean isSignFlag() {
        return this.signFlag;
    }

    public void setSignFlag(boolean signFlag) {
        this.signFlag = signFlag;
    }

    public int getTotalPage() {
        return this.totalPage;
    }

    public void setTotalPage(int totalPage) {
        this.totalPage = totalPage;
    }

    public void setSignOnly(boolean signOnly) {
        this.signOnly = signOnly;
    }
}

